/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import misc.Bundle;
import misc.Config;
import misc.ProgressState;
import misc.Util;

public class RemoteUpdate {
    static long delay = 2000L;
    static CookieManager cookieManager = new CookieManager();
    public static final String backExtention = "back";
    public static final int bufSize = 0x100000;
    public static final SimpleDateFormat dateFormat;
    public static final SimpleDateFormat timeFormat;
    public static final SimpleDateFormat displayFormat;
    public static final NumberFormat numberFormat;
    public static final List<String> excludeFileName;
    public static FilenameFilter mirrorFilter;
    public String protocol;
    public String serverName;
    public String versionName;
    public String requestModel;
    public Mirror[] mirrors;
    private static Random random;
    private static final String charset = "UTF-8";
    private static final String LINE_FEED = "\r\n";

    public RemoteUpdate(String protocol, String serverName, String versionName, String requestModel, String[] ... mirrorsParams) {
        this.protocol = protocol;
        this.serverName = serverName;
        this.versionName = versionName;
        this.requestModel = requestModel;
        File root = Config.getPWD().getParentFile();
        this.mirrors = new Mirror[mirrorsParams.length];
        int idx = 0;
        for (String[] params : mirrorsParams) {
            this.mirrors[idx++] = new Mirror(root, params);
        }
    }

    public CheckPeriod currentPeriod() {
        return CheckPeriod.valueOf(CheckPeriod.class, Config.getString("CheckPeriod", "" + (Object)((Object)CheckPeriod.Month)));
    }

    public boolean hasNewVersion() {
        CheckPeriod period = this.currentPeriod();
        Date lastCheck = new Date();
        try {
            lastCheck = dateFormat.parse(Config.getString("LastCheck", "20150401"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date today = new Date();
        long age = (today.getTime() - lastCheck.getTime()) / 86400000L;
        switch (period) {
            case NoCheck: {
                return false;
            }
            case Day: {
                if (age >= 1L) break;
                return false;
            }
            case Week: {
                if (age >= 7L) break;
                return false;
            }
            case Month: {
                if (age >= 31L) break;
                return false;
            }
            case Year: {
                if (age >= 366L) break;
                return false;
            }
        }
        Config.setString("LastCheck", dateFormat.format(today));
        for (Mirror mirror : this.mirrors) {
            if (!mirror.hasNewVersion()) continue;
            return true;
        }
        return false;
    }

    private URLConnection getUrlConnection(String cmd, String arg) throws IOException {
        return this.getUrlConnection(MessageFormat.format(this.requestModel, this.versionName, cmd, arg));
    }

    private URLConnection getUrlConnection(String uri) throws IOException {
        URL url = new URL(this.protocol + "://" + this.serverName + uri);
        URLConnection urlConnection = url.openConnection();
        urlConnection.setRequestProperty("User-Agent", "Adecwatt Agent");
        urlConnection.setUseCaches(true);
        return urlConnection;
    }

    public static String getBoundary() {
        return "=-=" + Long.toString(random.nextLong(), 36).toUpperCase() + "=-=";
    }

    public void receiveZip(URLConnection urlConnection, ZipFileReader zipFileReader, String token) {
        try {
            String entryName;
            ZipEntry zipInEntry;
            String contentType = urlConnection.getContentType();
            if (contentType == null || !contentType.startsWith("application/zip")) {
                return;
            }
            ZipInputStream zipIn = new ZipInputStream(urlConnection.getInputStream());
            while ((zipInEntry = zipIn.getNextEntry()) != null && (!(entryName = zipInEntry.getName()).startsWith(token) || zipFileReader.readEntry(zipIn, entryName, token))) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public URLConnection sendZip(String cmd, String token, ZipBuilder zipBuilder) {
        try {
            URLConnection urlConnection = this.getUrlConnection(cmd, token);
            String boundary = RemoteUpdate.getBoundary();
            urlConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            OutputStream httpStream = urlConnection.getOutputStream();
            PrintWriter httpWriter = new PrintWriter((Writer)new OutputStreamWriter(httpStream, charset), true);
            httpWriter.append("--" + boundary).append(LINE_FEED);
            httpWriter.append("Content-Disposition: form-data; name=\"" + cmd + "\"; filename=\"" + cmd + "\"").append(LINE_FEED);
            httpWriter.append("Content-Type: application/zip").append(LINE_FEED);
            httpWriter.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
            httpWriter.append(LINE_FEED).flush();
            ByteArrayOutputStream memStream = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(memStream);
            zipBuilder.writeEntry(token, zipOut);
            zipOut.flush();
            zipOut.close();
            httpWriter.flush();
            httpStream.write(memStream.toByteArray());
            httpWriter.append(LINE_FEED).flush();
            httpWriter.append("--" + boundary + "--").append(LINE_FEED);
            httpWriter.close();
            urlConnection.connect();
            return urlConnection;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TreeSet<String> localRemove(Mirror mirror, TreeSet<String> filesName, ProgressState progressState) {
        if (filesName == null) {
            filesName = new TreeSet();
        }
        if (mirror.excludeFiles != null) {
            filesName.addAll(mirror.excludeFiles);
        }
        TreeSet<String> removed = new TreeSet<String>();
        for (String fileName : filesName) {
            if (!fileName.startsWith(mirror.token)) continue;
            fileName = fileName.substring(mirror.token.length());
            File oldFile = new File(mirror.localRepository.getAbsolutePath() + fileName);
            if (!oldFile.delete()) {
                System.err.println("coucou pb delete: " + oldFile);
            }
            removed.add(fileName);
        }
        return removed;
    }

    public TreeSet<String> remoteRemove(Mirror mirror, TreeSet<String> filesName, ProgressState progressState) {
        if (filesName == null) {
            filesName = new TreeSet();
        }
        if (mirror.excludeFiles != null) {
            filesName.addAll(mirror.excludeFiles);
        }
        final TreeSet<String> removed = new TreeSet<String>();
        if (filesName.size() < 1) {
            return removed;
        }
        URLConnection urlConnection = this.sendZip("zipRemove", mirror.token, new TextZipBuilder(filesName));
        this.receiveZip(urlConnection, new ZipLineReader(){

            @Override
            public void readLine(String line) {
                removed.add(line);
            }
        }, mirror.token);
        return removed;
    }

    public TreeSet<String> getRemoteFiles(final Mirror mirror, TreeSet<String> filesName, final ProgressState progressState) {
        final TreeSet<String> downloaded = new TreeSet<String>();
        try {
            if (filesName.size() < 1) {
                return downloaded;
            }
            URLConnection urlConnection = this.sendZip("zipGets", mirror.token, new TextZipBuilder(filesName));
            final byte[] tmp = new byte[0x100000];
            this.receiveZip(urlConnection, new ZipFileReader(){

                @Override
                public boolean readEntry(ZipInputStream zipIn, String entryName, String token) throws IOException {
                    File newFile = mirror.localRepository;
                    for (String item : entryName.substring(mirror.token.length()).split("/")) {
                        if (item == null || item.isEmpty()) continue;
                        newFile = new File(newFile, item);
                    }
                    File dirFile = newFile.getParentFile();
                    dirFile.mkdirs();
                    File tmpFile = File.createTempFile("download", "tmp", dirFile);
                    tmpFile.deleteOnExit();
                    Util.copy(zipIn, new FileOutputStream(tmpFile), tmp, progressState, false, true);
                    tmpFile.setLastModified(mirror.allFiles.get((Object)entryName).remote.date);
                    if (progressState != null && progressState.isInterrupted()) {
                        return false;
                    }
                    Util.backup(newFile, Util.getExtention(newFile), RemoteUpdate.backExtention);
                    try {
                        Files.move(tmpFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (tmpFile.exists()) {
                        System.err.println("can't change open file!");
                        tmpFile.renameTo(new File("" + newFile + ".new"));
                    }
                    downloaded.add(entryName);
                    return true;
                }
            }, mirror.token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return downloaded;
    }

    public static boolean newFileExists(File file) {
        if (file.isFile() && file.exists() && "new".equals(Util.getExtention(file))) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        for (File subFile : file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file2) {
                return file2.isDirectory() || file2.isFile() && "new".equals(Util.getExtention(file2));
            }
        })) {
            if (!RemoteUpdate.newFileExists(subFile)) continue;
            return true;
        }
        return false;
    }

    public static void renameNewFile(File file) {
        if (file.isFile() && file.exists() && "new".equals(Util.getExtention(file))) {
            try {
                File newFile = new File(file.getParentFile(), Util.getBase(file));
                Files.move(file.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!file.isDirectory()) {
            return;
        }
        for (File subFile : file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file2) {
                return file2.isDirectory() || file2.isFile() && "new".equals(Util.getExtention(file2));
            }
        })) {
            RemoteUpdate.renameNewFile(subFile);
        }
    }

    public static void launch(File jarFile) {
        try {
            Runtime.getRuntime().exec("java -jar " + jarFile.getName(), null, jarFile.getParentFile());
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TreeSet<String> putRemoteFiles(final Mirror mirror, final TreeSet<String> filesName, final ProgressState progressState) {
        final TreeSet<String> uploaded = new TreeSet<String>();
        if (filesName == null || filesName.size() < 1) {
            return uploaded;
        }
        try {
            final byte[] tmp = new byte[0x100000];
            final TimeZone timeZone = TimeZone.getDefault();
            URLConnection urlConnection = this.sendZip("zipPuts", mirror.token, new ZipBuilder(){

                @Override
                public void writeEntry(String token, ZipOutputStream zipOut) throws IOException {
                    for (String fileName : filesName) {
                        if (!fileName.startsWith(token)) continue;
                        ZipEntry zipOutEntry = new ZipEntry(fileName);
                        File file = new File(mirror.localRepository, fileName.substring(token.length()));
                        long dateMs = file.lastModified();
                        dateMs -= (long)timeZone.getOffset(dateMs);
                        zipOutEntry.setTime(dateMs);
                        zipOut.putNextEntry(zipOutEntry);
                        PrintWriter entryWriter = new PrintWriter(new OutputStreamWriter(zipOut));
                        Util.copy(new FileInputStream(file), zipOut, tmp, progressState, true, false);
                        entryWriter.flush();
                        zipOut.closeEntry();
                    }
                }
            });
            this.receiveZip(urlConnection, new ZipLineReader(){

                @Override
                public void readLine(String line) {
                    uploaded.add(line);
                }
            }, mirror.token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uploaded;
    }

    public String getRoles(String login) {
        try {
            String line;
            URLConnection urlConnection = this.getUrlConnection("getRoles", login);
            urlConnection.connect();
            BufferedReader br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            String roles = br.readLine();
            while ((line = br.readLine()) != null) {
            }
            if (roles.indexOf("|") < 0) {
                return null;
            }
            return roles;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void logoutDokuwiki() {
        try {
            URLConnection urlConnection = this.getUrlConnection("?do=logout");
            urlConnection.connect();
            RemoteUpdate.forceOpenConnection(urlConnection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loginDokuwiki(String login, String password) {
        try {
            String line;
            URLConnection urlConnection = this.getUrlConnection("?do=login");
            urlConnection.connect();
            String sectok = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (line.indexOf("name=\"sectok\"") < 0) continue;
                Pattern p = Pattern.compile(".*<([^<]*name=\"sectok\"[^>]*)>.*");
                Matcher m = p.matcher(line);
                if (!m.matches()) break;
                line = m.group(1);
                p = Pattern.compile(".*value=\"([^\"]*)\".*");
                m = p.matcher(line);
                if (!m.matches()) break;
                sectok = m.group(1);
                break;
            }
            if (sectok == null) {
                return;
            }
            urlConnection = this.getUrlConnection("?do=login");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String post = "sectok=" + sectok + "&id=debut&do=login&u=" + URLEncoder.encode(login, charset) + "&p=" + URLEncoder.encode(password, charset);
            urlConnection.setRequestProperty("Content-Length", "" + post.getBytes().length);
            OutputStream httpStream = urlConnection.getOutputStream();
            PrintWriter httpWriter = new PrintWriter((Writer)new OutputStreamWriter(httpStream, charset), true);
            httpWriter.append(post).append(LINE_FEED).flush();
            urlConnection.connect();
            RemoteUpdate.forceOpenConnection(urlConnection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void forceOpenConnection(URLConnection urlConnection) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while ((line = br.readLine()) != null) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            ((CookieManager)CookieHandler.getDefault()).setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        }
        catch (Exception e) {
            cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(cookieManager);
        }
        dateFormat = new SimpleDateFormat("yyyyMMdd");
        timeFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        displayFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        numberFormat = NumberFormat.getInstance();
        excludeFileName = Arrays.asList("timestamp");
        mirrorFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !excludeFileName.contains(name) && !name.endsWith(".back") && !name.endsWith(".new");
            }
        };
        random = new Random();
    }

    public class Mirror {
        String token;
        File localRepository;
        FilenameFilter mirrorFilter = mirrorFilter;
        TreeSet<String> excludeFiles;
        TreeMap<String, FileInfo> localFiles;
        TreeMap<String, FileInfo> remoteFiles;
        TreeMap<String, FileDescriptor> allFiles;

        public Mirror(File root, String ... params) {
            this.token = params[0];
            if (params.length > 1) {
                this.localRepository = root;
                for (int i = 1; i < params.length; ++i) {
                    this.localRepository = new File(this.localRepository, params[i]);
                }
            } else {
                this.localRepository = new File(root, this.token);
            }
        }

        public String toString() {
            return this.token + ": " + this.localFiles + " " + this.remoteFiles;
        }

        public synchronized void update() {
            this.updateRemoteFiles();
            this.updateLocalFiles();
            if (this.remoteFiles == null) {
                return;
            }
            TreeSet<String> allFilesName = new TreeSet<String>();
            allFilesName.addAll(this.localFiles.keySet());
            allFilesName.addAll(this.remoteFiles.keySet());
            this.allFiles = new TreeMap();
            for (String fileName : allFilesName) {
                this.allFiles.put(fileName, new FileDescriptor());
            }
            for (String fileName : this.localFiles.keySet()) {
                this.allFiles.get((Object)fileName).local = this.localFiles.get(fileName);
            }
            for (String fileName : this.remoteFiles.keySet()) {
                this.allFiles.get((Object)fileName).remote = this.remoteFiles.get(fileName);
            }
        }

        public void updateTodo(TodoFile action) {
            if (this.allFiles == null) {
                return;
            }
            for (String fileName : this.allFiles.keySet()) {
                this.allFiles.get(fileName).updateTodo(action);
            }
        }

        public long getSize(TreeSet<String> filesName, TodoFile action) {
            long result = 0L;
            if (this.allFiles == null || action == TodoFile.NoChange) {
                return result;
            }
            boolean remote = false;
            switch (action) {
                case LocalRemove: 
                case Download: {
                    remote = true;
                }
            }
            for (String fileName : filesName) {
                FileDescriptor file = this.allFiles.get(fileName);
                if (file == null) continue;
                try {
                    if (file.todo != action) continue;
                    result += remote ? file.remote.size : file.local.size;
                }
                catch (Exception exception) {}
            }
            return result;
        }

        public TreeSet<String> getFileAction(TodoFile action) {
            TreeSet<String> result = new TreeSet<String>();
            if (this.allFiles == null) {
                return result;
            }
            for (String fileName : this.allFiles.keySet()) {
                if (this.allFiles.get((Object)fileName).todo != action) continue;
                result.add(fileName);
            }
            return result;
        }

        public synchronized boolean hasNewVersion() {
            this.update();
            return this.check(TodoFile.Download).size() > 0;
        }

        public synchronized TreeSet<String> check(TodoFile action) {
            this.updateTodo(action);
            return this.getFileAction(action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TreeSet<String> performe(TodoFile action, ProgressState progressState) {
            try {
                TreeSet<String> files = this.check(action);
                if (progressState != null) {
                    progressState.init(Bundle.getMessage((String)("" + (Object)((Object)action))), (int)this.getSize(files, action));
                }
                switch (action) {
                    case LocalRemove: {
                        TreeSet<String> treeSet = RemoteUpdate.this.localRemove(this, files, progressState);
                        return treeSet;
                    }
                    case RemoteRemove: {
                        TreeSet<String> treeSet = RemoteUpdate.this.remoteRemove(this, files, progressState);
                        return treeSet;
                    }
                    case Download: {
                        TreeSet<String> treeSet = RemoteUpdate.this.getRemoteFiles(this, files, progressState);
                        return treeSet;
                    }
                    case Upload: {
                        TreeSet<String> treeSet = RemoteUpdate.this.putRemoteFiles(this, files, progressState);
                        return treeSet;
                    }
                }
                return new TreeSet<String>();
            }
            finally {
                if (progressState != null) {
                    progressState.end();
                }
            }
        }

        public String getInfo(TreeSet<String> files, TodoFile action) {
            return MessageFormat.format(Bundle.getMessage((String)"DownloadInfo"), Bundle.getLabel((String)Util.toCapital(this.token)), this.allFiles == null ? 0 : 1, files.size(), Util.toNumIn2Units(this.getSize(files, action)));
        }

        public FileDescriptor getInfo(String fileName) {
            return this.allFiles.get(fileName);
        }

        private void updateLocalFiles() {
            this.excludeFiles = new TreeSet();
            this.localFiles = new TreeMap();
            this.updateLocalFiles(this.localRepository, this.token);
        }

        private void updateLocalFiles(File localRepository, String name) {
            if (localRepository.isFile()) {
                if (excludeFileName.contains(name) || name.endsWith(".back")) {
                    this.excludeFiles.add(name);
                    return;
                }
                this.localFiles.put(name, new FileInfo(localRepository.lastModified(), localRepository.length()));
                return;
            }
            if (!localRepository.isDirectory()) {
                return;
            }
            for (String child : localRepository.list()) {
                this.updateLocalFiles(new File(localRepository, child), name + "/" + child);
            }
        }

        private void getExcludeFiles(File localRepository, String name) {
            if (localRepository.isFile()) {
                this.localFiles.put(name, new FileInfo(localRepository.lastModified(), localRepository.length()));
                return;
            }
            if (!localRepository.isDirectory()) {
                return;
            }
            for (String child : localRepository.list(this.mirrorFilter)) {
                if (excludeFileName.contains(child)) continue;
                this.updateLocalFiles(new File(localRepository, child), name + "/" + child);
            }
        }

        private void updateRemoteFiles() {
            try {
                this.allFiles = null;
                this.remoteFiles = null;
                URLConnection urlConnection = RemoteUpdate.this.getUrlConnection("zipList", this.token);
                urlConnection.connect();
                this.remoteFiles = new TreeMap();
                RemoteUpdate.this.receiveZip(urlConnection, new ZipLineReader(){

                    @Override
                    public void readLine(String line) {
                        ParsePosition pos = new ParsePosition(0);
                        try {
                            long date = timeFormat.parse(line, pos).getTime();
                            pos.setIndex(pos.getIndex() + 1);
                            long size = numberFormat.parse(line, pos).longValue();
                            String fileName = line.substring(pos.getIndex() + 1);
                            Mirror.this.remoteFiles.put(fileName, new FileInfo(date, size));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, this.token);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public static enum CheckPeriod {
        NoCheck,
        Day,
        Week,
        Month,
        Year;

    }

    public abstract class ZipFileReader {
        public abstract boolean readEntry(ZipInputStream var1, String var2, String var3) throws IOException;
    }

    public abstract class ZipBuilder {
        public abstract void writeEntry(String var1, ZipOutputStream var2) throws IOException;
    }

    public class TextZipBuilder
    extends ZipBuilder {
        private TreeSet<String> filesName;

        public TextZipBuilder(TreeSet<String> filesName) {
            this.filesName = filesName;
        }

        @Override
        public void writeEntry(String token, ZipOutputStream zipOut) throws IOException {
            ZipEntry zipOutEntry = new ZipEntry(token);
            zipOut.putNextEntry(zipOutEntry);
            PrintWriter entryWriter = new PrintWriter(new OutputStreamWriter(zipOut));
            for (String fileName : this.filesName) {
                entryWriter.print(fileName + "\n");
            }
            entryWriter.flush();
            zipOut.closeEntry();
        }
    }

    public abstract class ZipLineReader
    extends ZipFileReader {
        @Override
        public boolean readEntry(ZipInputStream zipIn, String entryName, String token) throws IOException {
            String line;
            if (!entryName.equals(token)) {
                return true;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(zipIn));
            while ((line = in.readLine()) != null) {
                if ("".equals(line)) continue;
                this.readLine(line);
            }
            return false;
        }

        public abstract void readLine(String var1);
    }

    public static class FileDescriptor {
        public TodoFile todo = TodoFile.NoChange;
        public FileInfo local;
        public FileInfo remote;

        public String toString() {
            return "" + (Object)((Object)this.todo) + " " + this.local + " " + this.remote;
        }

        public void updateTodo(TodoFile action) {
            this.todo = TodoFile.NoChange;
            if (this.remote == null) {
                switch (action) {
                    case LocalRemove: 
                    case Upload: {
                        this.todo = action;
                    }
                }
                return;
            }
            if (this.local == null) {
                switch (action) {
                    case RemoteRemove: 
                    case Download: {
                        this.todo = action;
                    }
                }
                return;
            }
            if (this.local.size != this.remote.size) {
                switch (action) {
                    case LocalRemove: {
                        this.todo = TodoFile.Download;
                        break;
                    }
                    case RemoteRemove: {
                        this.todo = TodoFile.Upload;
                        break;
                    }
                    default: {
                        this.todo = action;
                    }
                }
                return;
            }
            if (this.local.date + delay < this.remote.date) {
                if (action == TodoFile.Download || action == TodoFile.LocalRemove) {
                    this.todo = TodoFile.Download;
                }
                return;
            }
            if (this.local.date > this.remote.date + delay) {
                if (action == TodoFile.Upload || action == TodoFile.RemoteRemove) {
                    this.todo = TodoFile.Upload;
                }
                return;
            }
        }
    }

    public static class FileInfo {
        long date;
        long size;

        public FileInfo(long date, long size) {
            this.date = date;
            this.size = size;
        }

        public String toString() {
            return "{" + displayFormat.format(new Date(this.date)) + " " + this.size + "}";
        }

        public static String getDate(FileInfo fileInfo) {
            return fileInfo == null ? "" : displayFormat.format(fileInfo.date);
        }

        public static String getSize(FileInfo fileInfo) {
            return fileInfo == null ? "" : "" + fileInfo.size;
        }
    }

    public static enum TodoFile {
        LocalRemove,
        Download,
        NoChange,
        Upload,
        RemoteRemove;

    }
}

