/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.control;

import adecWatt.control.AdecWattManager;
import adecWatt.model.AdecWatt;
import adecWatt.model.Unit;
import adecWatt.model.User;
import adecWatt.model.unit.Workspace;
import adecWatt.view.JAdecWatt;
import adecWatt.view.JAdecWattDialog;
import adecWatt.view.JAdecWattMenuBar;
import adecWatt.view.JAdecWattSearchToolBar;
import adecWatt.view.JAdecWattToolBar;
import adecWatt.view.JWorkspaceSlidersToolBar;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.text.MessageFormat;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import misc.Bundle;
import misc.Config;
import misc.Controller;
import misc.HelpManager;
import misc.HtmlDialog;
import misc.MultiToolBarBorderLayout;
import misc.ProxyManager;
import misc.RemoteUpdate;
import misc.RemoteUpdateManager;
import misc.StoryManager;
import misc.ToolBarManager;
import misc.Util;

public class AdecWattController
extends Controller<AdecWatt> {
    AdecWatt adecWatt;
    RemoteUpdate remoteUpdate;
    JAdecWatt jAdecWatt;
    JAdecWattMenuBar jAdecWattMenuBar;
    JAdecWattToolBar jAdecWattToolBar;
    JAdecWattDialog jAdecWattDialog;
    JAdecWattSearchToolBar jAdecWattSearchToolBar;
    JWorkspaceSlidersToolBar jWorkspaceSlidersToolBar;
    HtmlDialog manualDialog;
    AdecWattManager adecWattManager;
    HelpManager helpManager;
    ToolBarManager toolBarManager;
    StoryManager storyManager;
    ProxyManager proxyManager;
    RemoteUpdateManager remoteUpdateManager;

    public AdecWattController(AdecWatt adecWatt) {
        super(adecWatt);
    }

    public void restart() {
        this.adecWattManager.actionRestart();
    }

    @Override
    protected void createModel(AdecWatt adecWatt) {
        this.adecWatt = adecWatt;
        adecWatt.addUpdateObserver(this, "Title");
        adecWatt.getUser().addUpdateObserver(this, "UserChangeProfil");
        Bundle.addBundleObserver(this);
        this.remoteUpdate = new RemoteUpdate(AdecWattManager.protocol, AdecWattManager.remoteServerName, AdecWattManager.stableVersion, AdecWattManager.urlModel, {"soft"}, {"data", "data", "server"}, {"help-fr_FR", "data", "texts", "help-fr_FR"}, {"help-images", "data", "texts", "help-images"}, {"help-en_US", "data", "texts", "help-en_US"}, {"help-br_FR_breton", "data", "texts", "help-br_FR_breton"}, {"help-br_FR_gallo", "data", "texts", "help-br_FR_gallo"}, {"help-es_ES", "data", "texts", "help-es_ES"});
    }

    @Override
    protected Component createGUI() {
        this.jAdecWatt = new JAdecWatt(this.adecWatt);
        this.jAdecWattDialog = new JAdecWattDialog(this);
        this.jWorkspaceSlidersToolBar = new JWorkspaceSlidersToolBar(this.jAdecWatt);
        this.jAdecWattSearchToolBar = new JAdecWattSearchToolBar(this.jAdecWatt);
        this.manualDialog = new HtmlDialog((Frame)this.jFrame, "Manual", "data/texts/help-" + Bundle.getLocale() + "/index.html");
        Frame frame = new Frame();
        frame.setIconImage(this.getIcon());
        JPanel contentPane = new JPanel(new MultiToolBarBorderLayout());
        this.toolBarManager = new ToolBarManager(this.getIcon(), contentPane);
        this.storyManager = new StoryManager();
        this.remoteUpdateManager = new RemoteUpdateManager(this, this.remoteUpdate, new Runnable(){

            @Override
            public void run() {
                AdecWattController.this.restart();
            }
        });
        this.remoteUpdateManager.check();
        this.adecWattManager = new AdecWattManager(this.adecWatt, this.storyManager, this.remoteUpdateManager, this.jAdecWatt, this.jWorkspaceSlidersToolBar, this.jAdecWattDialog, this.manualDialog);
        this.helpManager = new HelpManager(this, "AdecWatt");
        this.proxyManager = new ProxyManager(this);
        this.jAdecWattToolBar = new JAdecWattToolBar(this, this.adecWattManager, this.storyManager, this.proxyManager, this.remoteUpdateManager, this.helpManager, this.toolBarManager, this.jAdecWattSearchToolBar, this.jWorkspaceSlidersToolBar);
        contentPane.add((Component)this.jAdecWatt, "Center");
        return contentPane;
    }

    @Override
    protected void newJFrame() {
        this.manualDialog.setJFrame(this.jFrame);
    }

    @Override
    public void updateBundle() {
        super.updateBundle();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdecWattController.this.manualDialog.changeFileName("data/texts/help-" + Bundle.getLocale() + "/index.html");
            }
        });
    }

    @Override
    public String getTitle() {
        Workspace currentWorkspace = this.jAdecWatt.getCurrentWorkspace();
        Unit<?> sharedUnitStory = this.adecWattManager.getSharedUnitStory();
        return MessageFormat.format(Bundle.getTitle("AdecWatt"), currentWorkspace == null ? Bundle.getAction("Empty") : currentWorkspace.toString(), sharedUnitStory == null ? "?" : sharedUnitStory.toString());
    }

    @Override
    public Image getIcon() {
        try {
            return Util.loadImage(Config.getString("AdecWattIcon", "data/images/adecWatt.png"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void updateTitle() {
        this.updateBundle();
    }

    public void updateUserChangeProfil() {
        User user = this.adecWatt.getUser();
        if (this.jAdecWattMenuBar != null) {
            this.jAdecWattMenuBar.changeProfil(user);
        }
        if (this.jAdecWattToolBar != null) {
            this.jAdecWattToolBar.changeProfil(user);
        }
    }

    @Override
    protected JMenuBar createMenuBar() {
        this.jAdecWattMenuBar = new JAdecWattMenuBar(this, this.adecWattManager, this.storyManager, this.proxyManager, this.remoteUpdateManager, this.helpManager, this.toolBarManager);
        return this.jAdecWattMenuBar;
    }

    @Override
    protected boolean tryClosingWindows() {
        Config.save("AdecWatt");
        if (this.adecWatt.getModified()) {
            switch (JOptionPane.showConfirmDialog(this.jFrame, Bundle.getMessage("QuitJAdecWatt"), Bundle.getTitle("AdecWattStillRunning"), 1, 2)) {
                case 0: {
                    return true;
                }
                case -1: 
                case 1: 
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }
}

