/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.control;

import adecWatt.model.Acc;
import adecWatt.model.AdecWatt;
import adecWatt.model.ImageDB;
import adecWatt.model.Item;
import adecWatt.model.PermanentDB;
import adecWatt.model.Unit;
import adecWatt.model.unit.Workspace;
import adecWatt.view.JAdecWatt;
import adecWatt.view.JAdecWattDialog;
import adecWatt.view.JWorkspaceSlidersToolBar;
import adecWatt.view.JWorkspaceView;
import adecWatt.view.PrintWorkspace;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import misc.ApplicationManager;
import misc.Bundle;
import misc.Config;
import misc.HtmlDialog;
import misc.RemoteUpdateManager;
import misc.Story;
import misc.StoryManager;
import misc.Util;

public class AdecWattManager
implements ApplicationManager,
ActionListener {
    public static String protocol = "https";
    public static String remoteServerName = "adecwatt.parlenet.org";
    public String testedServerName = "adecwatt.parlenet.local";
    public String currentServerName = remoteServerName;
    public static String stableVersion = "v3";
    public String testedVersion = "test";
    public String currentVersion = stableVersion;
    public static String urlModel = "/lib/plugins/adecwatt/adecWattBD.php?version={0}&action={1}&name={2}";
    public static final String actionChangeRole = "ChangeRole";
    public static final String actionRestart = "Restart";
    public static final String actionSave = "Save";
    public static final String actionSaveAll = "SaveAll";
    public static final String actionImport = "Import";
    public static final String actionExport = "Export";
    public static final String actionPageSetup = "PageSetup";
    public static final String actionPrint = "Print";
    public static final String actionExportPDF = "ExportPDF";
    public static final String actionClose = "Close";
    public static final String actionCloseAll = "CloseAll";
    public static final String actionSelectAll = "SelectAll";
    public static final String actionCut = "Cut";
    public static final String actionCopy = "Copy";
    public static final String actionPaste = "Paste";
    public static final String actionMagnetPolicies = "MagnetPolicies";
    public static final String actionPatch = "Patch";
    public static final String actionHorizontalLeft = "HorizontalLeft";
    public static final String actionHorizontalCenter = "HorizontalCenter";
    public static final String actionHorizontalRight = "HorizontalRight";
    public static final String actionVerticalTop = "VerticalTop";
    public static final String actionVerticalCenter = "VerticalCenter";
    public static final String actionVerticalBottom = "VerticalBottom";
    public static final String actionHorizontalSpace = "HorizontalSpace";
    public static final String actionHorizontalDistrib = "HorizontalDistrib";
    public static final String actionVerticalSpace = "VerticalSpace";
    public static final String actionVerticalDistrib = "VerticalDistrib";
    public static final String actionWizard = "Wizard";
    public static final String actionHttpServer = "HttpServer";
    public static final String actionLocalServer = "LocalServer";
    public static final String actionTestedServer = "TestedServer";
    public static final String actionServerName = "ServerName";
    public static final String actionManual = "Manual";
    public static Util.ActionControl[] actionsControl = new Util.ActionControl[]{new Util.ActionControl("Save", 83), new Util.ActionControl("SelectAll", 65), new Util.ActionControl("Cut", 88), new Util.ActionControl("Copy", 67), new Util.ActionControl("Paste", 86), new Util.ActionControl("Undo", 90), new Util.ActionControl("Redo", 89)};
    public static final String actionDisplayUnit = "DisplayUnit";
    public static final String actionModifyUnit = "ModifyUnit";
    public static final String actionRenameUnit = "RenameUnit";
    public static final String actionTransformUnit = "TransformUnit";
    public static final String actionCopyUnit = "CopyUnit";
    public static final String actionNewUnit = "NewUnit";
    public static final String actionPromoteUnit = "PromoteUnit";
    public static final String actionRemoveUnit = "RemoveUnit";
    public static final String actionRemoveImage = "RemoveImage";
    public static final String actionChangeImage = "ChangeImage";
    public static final String actionUnchange = "Unchange";
    public static final String actionDisplayItem = "DisplayItem";
    public static final String actionModifyItem = "ModifyItem";
    public static final String actionHideItem = "HideItem";
    public static final String actionShowItem = "ShowItem";
    public static final String actionTransformItem = "TransformItem";
    public static final String actionCopyItem = "CopyItem";
    public static final String actionRemoveItem = "RemoveItem";
    public static final String actionHideShowItem = "HideShowItem";
    public static final String actionDisplayAcc = "DisplayAcc";
    public static final String actionModifyAcc = "ModifyAcc";
    public static final String actionTransformAcc = "TransformAcc";
    public static final String actionRemoveAcc = "RemoveAcc";
    public static final List<String> fileActionsNames = Arrays.asList("ChangeRole", "Restart", "Save", "SaveAll", "Import", "Export", "PageSetup", "Print", "Close", "CloseAll");
    public static final List<String> editActionsNames = Arrays.asList("SelectAll", "Cut", "Copy", "Paste", "MagnetPolicies", "Patch");
    public static final List<String> placementActionsNames = Arrays.asList("HorizontalLeft", "HorizontalCenter", "HorizontalRight", "VerticalTop", "VerticalCenter", "VerticalBottom", "HorizontalSpace", "HorizontalDistrib", "VerticalSpace", "VerticalDistrib");
    public static final List<String> yodaActionsNames = Arrays.asList("HttpServer", "LocalServer", "TestedServer", "ServerName", "Wizard");
    public static final List<String> yodaNoCheckActionsNames = Arrays.asList("ServerName", "Wizard");
    public static final List<String> helpActionsNames = Arrays.asList("Manual");
    public static final Hashtable<String, Method> actionsMethod = Util.collectMethod(AdecWattManager.class, fileActionsNames, editActionsNames, placementActionsNames, yodaActionsNames, helpActionsNames);
    AdecWatt adecWatt;
    PermanentDB permanentDB;
    StoryManager storyManager;
    RemoteUpdateManager remoteUpdateManager;
    JAdecWatt jAdecWatt;
    JWorkspaceSlidersToolBar jWorkspaceSlidersToolBar;
    JAdecWattDialog jAdecWattDialog;
    HtmlDialog manualDialog;
    JCheckBoxMenuItem httpServerCB;
    JCheckBoxMenuItem localServerCB;
    JCheckBoxMenuItem testedServerCB;
    private ArrayList<AbstractButton> enabledSaveButtons = new ArrayList();
    private ArrayList<AbstractButton> enabledSaveAllButtons = new ArrayList();
    private ArrayList<AbstractButton> enabledCloseButtons = new ArrayList();
    private ArrayList<AbstractButton> enabledPasteButtons = new ArrayList();
    private ArrayList<AbstractButton> enabledSelectionButtons = new ArrayList();
    private ArrayList<AbstractButton> enabledMultiSelectionButtons = new ArrayList();
    Unit<?> sharedUnitStory;
    Vector<Item> clip = new Vector();
    private PrinterJob printer = null;
    private PageFormat page = null;

    @Override
    public void actionPerformed(ActionEvent e) {
        Util.actionPerformed(actionsMethod, e, this);
    }

    public AdecWattManager(AdecWatt adecWatt, StoryManager storyManager, RemoteUpdateManager remoteUpdateManager, JAdecWatt jAdecWatt, JWorkspaceSlidersToolBar jWorkspaceSlidersToolBar, JAdecWattDialog jAdecWattDialog, HtmlDialog manualDialog) {
        this.adecWatt = adecWatt;
        this.permanentDB = adecWatt.getPermanentDB();
        this.storyManager = storyManager;
        this.jAdecWatt = jAdecWatt;
        this.jWorkspaceSlidersToolBar = jWorkspaceSlidersToolBar;
        this.jAdecWattDialog = jAdecWattDialog;
        this.manualDialog = manualDialog;
        this.remoteUpdateManager = remoteUpdateManager;
        jAdecWatt.stateNotifier.addUpdateObserver(this, "Workspace", "Selection");
        jAdecWatt.stateNotifier.addMsgObserver(this, "UnitStory");
        adecWatt.addUpdateObserver(this, "Story");
        adecWatt.addMsgObserver(this, "UnitStory", actionClose, actionDisplayUnit, actionModifyUnit, actionRenameUnit, actionTransformUnit, actionCopyUnit, actionNewUnit, actionPromoteUnit, actionRemoveUnit, actionDisplayItem, actionModifyItem, actionHideShowItem, actionTransformItem, actionCopyItem, actionRemoveItem, "SetSelectionItems", "Connection", actionDisplayAcc, actionModifyAcc, actionTransformAcc, actionRemoveAcc);
    }

    @Override
    public void addMenuItem(JMenu ... jMenu) {
        int idx = 0;
        Util.addMenuItem(fileActionsNames, (ActionListener)this, (Container)jMenu[idx++]);
        Util.addMenuItem(editActionsNames, (ActionListener)this, (Container)jMenu[idx++]);
        Util.addMenuItem(placementActionsNames, (ActionListener)this, (Container)jMenu[idx++]);
        this.httpServerCB = Util.addCheckMenuItem(actionHttpServer, this, false, jMenu[idx]);
        this.localServerCB = Util.addCheckMenuItem(actionLocalServer, this, false, jMenu[idx]);
        this.testedServerCB = Util.addCheckMenuItem(actionTestedServer, this, false, jMenu[idx]);
        this.actionHttpServer();
        this.actionLocalServer();
        this.actionTestedServer();
        Util.addMenuItem(yodaNoCheckActionsNames, (ActionListener)this, (Container)jMenu[idx++]);
        Util.addMenuItem(helpActionsNames, (ActionListener)this, (Container)jMenu[idx++]);
    }

    @Override
    public void addIconButtons(Container ... containers) {
        int idx = 0;
        Util.addIconButton(fileActionsNames, (ActionListener)this, containers[idx++]);
        Util.addIconButton(editActionsNames, (ActionListener)this, containers[idx++]);
        Util.addIconButton(placementActionsNames, (ActionListener)this, containers[idx++]);
        ++idx;
        int n = ++idx;
        ++idx;
        Util.addIconButton(helpActionsNames, (ActionListener)this, containers[n]);
    }

    @Override
    public void addActiveButtons(Hashtable<String, AbstractButton> buttons) {
        this.enabledSaveButtons.add(buttons.get(actionSave));
        this.enabledSaveAllButtons.add(buttons.get(actionSaveAll));
        this.enabledCloseButtons.add(buttons.get(actionPrint));
        this.enabledCloseButtons.add(buttons.get(actionPatch));
        this.enabledCloseButtons.add(buttons.get(actionExport));
        this.enabledCloseButtons.add(buttons.get(actionClose));
        this.enabledCloseButtons.add(buttons.get(actionCloseAll));
        this.enabledCloseButtons.add(buttons.get(actionSelectAll));
        this.enabledPasteButtons.add(buttons.get(actionPaste));
        this.enabledSelectionButtons.add(buttons.get(actionCopy));
        this.enabledSelectionButtons.add(buttons.get(actionCut));
        for (String action : placementActionsNames) {
            this.enabledMultiSelectionButtons.add(buttons.get(action));
        }
        this.updateActiveButtons();
    }

    public void updateActiveButtons() {
        this.remoteUpdateManager.updateActiveButtons();
        this.updateStory();
        this.updateWorkspace();
        this.updatePaste();
    }

    public Unit<?> getSharedUnitStory() {
        return this.sharedUnitStory;
    }

    public void displayUnitStory(Object ... objects) {
        this.sharedUnitStory = (Unit)objects[0];
        this.adecWatt.broadcastUpdate("Title");
        this.storyManager.setStory(this.sharedUnitStory == null ? null : this.sharedUnitStory.story);
        this.updateStory();
    }

    public void updateStory() {
        boolean saveAll = this.permanentDB.isModifiedUnit();
        boolean save = false;
        if (this.sharedUnitStory != null) {
            Story story = this.sharedUnitStory.story;
            save = story.isModified();
        }
        for (AbstractButton button : this.enabledSaveButtons) {
            button.setEnabled(save);
        }
        for (AbstractButton button : this.enabledSaveAllButtons) {
            button.setEnabled(saveAll);
        }
        this.jAdecWatt.updateUnit(this.sharedUnitStory, false);
    }

    public void updateWorkspace() {
        boolean close = this.jAdecWatt.hasWorkspace();
        for (AbstractButton button : this.enabledCloseButtons) {
            button.setEnabled(close);
        }
        Workspace currentWorkspace = this.jAdecWatt.getCurrentWorkspace();
        this.displayUnitStory(currentWorkspace);
        this.updateSelection();
        JWorkspaceView<?> jWorkspaceView = this.jAdecWatt.getCurrentJWorkspace();
        this.jWorkspaceSlidersToolBar.setJWorkspaceView(jWorkspaceView);
    }

    public void updateSelection() {
        JWorkspaceView<?> jWorkspaceView = this.jAdecWatt.getCurrentJWorkspace();
        int nbSelection = jWorkspaceView == null ? 0 : jWorkspaceView.getNbSelectedItems();
        boolean selection = nbSelection > 0;
        boolean multiSelection = nbSelection > 1;
        for (AbstractButton button : this.enabledSelectionButtons) {
            button.setEnabled(selection);
        }
        for (AbstractButton button : this.enabledMultiSelectionButtons) {
            button.setEnabled(multiSelection);
        }
    }

    public void actionRestart() {
        if (this.adecWatt.getModified() && !this.jAdecWattDialog.abortModification()) {
            return;
        }
        this.actionCloseAll();
        this.adecWatt.reset();
        this.jAdecWatt.stateNotifier.broadcastDisplay("UnitStory", new Object[]{null});
    }

    public void actionSave() {
        if (this.sharedUnitStory == null) {
            return;
        }
        this.sharedUnitStory.save();
    }

    public void actionSaveAll() {
        this.adecWatt.saveAll();
    }

    public void actionSelectAll() {
        JWorkspaceView<?> jWorkspaceView = this.jAdecWatt.getCurrentJWorkspace();
        if (jWorkspaceView == null) {
            return;
        }
        jWorkspaceView.selectAllItems();
    }

    public void actionImport() {
        this.permanentDB.importFile(this.jAdecWattDialog.getChooseOpenFile(this.permanentDB.getLastExport()));
    }

    public void actionExport() {
        Workspace currentWorkspace = this.jAdecWatt.getCurrentWorkspace();
        if (currentWorkspace == null) {
            return;
        }
        this.permanentDB.exportFile(currentWorkspace, this.jAdecWattDialog.getChooseSaveFile(this.permanentDB.getLastExport()));
    }

    public void updatePaste() {
        boolean paste = this.clip.size() > 0;
        for (AbstractButton button : this.enabledPasteButtons) {
            button.setEnabled(paste);
        }
    }

    public void actionCut() {
        this.actionCopy();
        JWorkspaceView<?> jWorkspaceView = this.jAdecWatt.getCurrentJWorkspace();
        if (jWorkspaceView == null) {
            return;
        }
        ((Workspace)jWorkspaceView.getWorkspace()).storyRemoveItems(this.clip);
    }

    public void actionCopy() {
        this.clip.clear();
        try {
            this.clip.addAll(this.jAdecWatt.getCurrentJWorkspace().getSelectedItems());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updatePaste();
    }

    public void actionPaste() {
        Workspace currentWorkspace = this.jAdecWatt.getCurrentWorkspace();
        if (currentWorkspace == null) {
            return;
        }
        currentWorkspace.storyPasteItem(this.clip);
    }

    public void displayClose(Object ... objects) {
        if (objects[0] == null || !(objects[0] instanceof Workspace)) {
            return;
        }
        Workspace workspace = (Workspace)objects[0];
        this.jAdecWattDialog.removeDisplay(workspace);
        this.jAdecWatt.closeWorkspace(workspace);
    }

    public void actionClose() {
        Workspace currentWorkspace = this.jAdecWatt.getCurrentWorkspace();
        this.jAdecWattDialog.removeDisplay(currentWorkspace);
        this.jAdecWatt.closeWorkspace(currentWorkspace);
    }

    public void actionCloseAll() {
        this.jAdecWattDialog.removeAllDisplay();
        this.jAdecWatt.closeWorkspaces();
    }

    public void actionChangeRole() {
        this.jAdecWattDialog.checkAdmin(this.adecWatt.getUser(), this.remoteUpdateManager);
    }

    public void actionHorizontalLeft() {
        this.align(Workspace.Alignment.LEFT);
    }

    public void actionHorizontalCenter() {
        this.align(Workspace.Alignment.CENTER);
    }

    public void actionHorizontalRight() {
        this.align(Workspace.Alignment.RIGHT);
    }

    public void actionVerticalTop() {
        this.align(Workspace.Alignment.TOP);
    }

    public void actionVerticalCenter() {
        this.align(Workspace.Alignment.MIDDLE);
    }

    public void actionVerticalBottom() {
        this.align(Workspace.Alignment.BOTTOM);
    }

    public void actionHorizontalSpace() {
        this.distrib(true, true);
    }

    public void actionHorizontalDistrib() {
        this.distrib(true, false);
    }

    public void actionVerticalSpace() {
        this.distrib(false, true);
    }

    public void actionVerticalDistrib() {
        this.distrib(false, false);
    }

    public void distrib(boolean isHorizontal, boolean isSpace) {
        JWorkspaceView<?> jWorkspaceView = this.jAdecWatt.getCurrentJWorkspace();
        if (jWorkspaceView == null) {
            return;
        }
        Double value = this.jAdecWattDialog.getSpace();
        if (value != null && value < 0.0) {
            return;
        }
        Vector<Item> items = jWorkspaceView.getSelectedItems();
        if (items == null || items.size() < 2) {
            return;
        }
        Object workspace = jWorkspaceView.getWorkspace();
        if (isSpace) {
            ((Workspace)workspace).storySpaceItem(items, isHorizontal, value);
        } else {
            ((Workspace)workspace).storyDistributeItem(items, isHorizontal, value);
        }
    }

    public void align(Workspace.Alignment alignment) {
        JWorkspaceView<?> jWorkspaceView = this.jAdecWatt.getCurrentJWorkspace();
        if (jWorkspaceView == null) {
            return;
        }
        Vector<Item> items = jWorkspaceView.getSelectedItems();
        if (items == null || items.size() < 2) {
            return;
        }
        ((Workspace)jWorkspaceView.getWorkspace()).storyAlignItem(items, alignment);
    }

    public void actionManual() {
        try {
            Desktop.getDesktop().browse(Config.getDataUrl("data", "texts", "help-" + Bundle.getLocale(), "index.html").toURI());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.manualDialog.restart();
            this.manualDialog.setVisible(true);
        }
    }

    public void actionPageSetup() {
        if (this.printer == null) {
            this.printer = PrinterJob.getPrinterJob();
        }
        if (this.page == null) {
            this.page = this.printer.defaultPage();
        }
        this.page = this.printer.pageDialog(this.page);
        this.printer.defaultPage(this.page);
    }

    public void actionPrint() {
        Workspace currentWorkspace = this.jAdecWatt.getCurrentWorkspace();
        if (this.printer == null) {
            this.printer = PrinterJob.getPrinterJob();
        }
        if (!this.printer.printDialog()) {
            return;
        }
        PrintWorkspace.print(this.jAdecWattDialog.getOwnFrame(), this.printer, currentWorkspace);
    }

    public void actionExportPDF() {
        Workspace currentWorkspace = this.jAdecWatt.getCurrentWorkspace();
        if (this.printer == null) {
            this.printer = PrinterJob.getPrinterJob();
        }
        if (!this.printer.printDialog()) {
            return;
        }
        PrintWorkspace.print(this.jAdecWattDialog.getOwnFrame(), this.printer, currentWorkspace);
    }

    public void actionMagnetPolicies() {
        this.jAdecWattDialog.magnetPolicies(this.adecWatt);
    }

    public void actionPatch() {
        this.jAdecWattDialog.patch(this.jAdecWatt.getCurrentWorkspace());
    }

    public void actionHttpServer() {
        this.remoteUpdateManager.getRemoteUpdate().protocol = this.httpServerCB.isSelected() ? "http" : protocol;
        Config.setBoolean("HttpServerChecked", this.httpServerCB.isSelected());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    public void actionLocalServer() {
        this.remoteUpdateManager.getRemoteUpdate().serverName = this.localServerCB.isSelected() ? this.testedServerName : remoteServerName;
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    public void actionTestedServer() {
        this.remoteUpdateManager.getRemoteUpdate().versionName = this.testedServerCB.isSelected() ? this.testedVersion : stableVersion;
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    public void actionServerName() {
        String newServer = this.jAdecWattDialog.getSimpleMessage(actionServerName, this.testedServerName);
        if (newServer != null) {
            this.testedServerName = newServer;
        }
    }

    public void actionWizard() {
        try {
            System.err.println("coucou: wizard");
            URL newURL = Config.getDataUrl("data", "texts", "help-" + Bundle.getLocale(), "index.html");
            System.err.println("coucou file:" + newURL + " --- " + newURL.toURI());
            Desktop.getDesktop().browse(newURL.toURI());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void displayDisplayUnit(Object ... objects) {
        List selectedUnits = (List)objects[0];
        this.jAdecWattDialog.display(false, selectedUnits);
    }

    public void displayModifyUnit(Object ... objects) {
        List selectedUnits = (List)objects[0];
        this.jAdecWattDialog.display(true, selectedUnits);
    }

    public void displayRenameUnit(Object ... objects) {
        List selectedUnits = (List)objects[0];
        if (selectedUnits.size() != 1) {
            System.err.println("coucou pb selectedUnits:" + selectedUnits);
            return;
        }
        Unit unit = (Unit)selectedUnits.get(0);
        if (unit.getParent() == null) {
            return;
        }
        String name = this.jAdecWattDialog.getName(unit.getName());
        unit.storyTransform(null, null, name, null);
    }

    public void displayTransformUnit(Object ... objects) {
        this.jAdecWattDialog.transform((Unit)objects[0]);
    }

    public void displayCopyUnit(Object ... objects) {
        Unit unit = (Unit)objects[0];
        String name = this.jAdecWattDialog.getName(unit.getName());
        if (name == null) {
            return;
        }
        unit.getCopy(name);
    }

    public void displayNewUnit(Object ... objects) {
        Unit unit = (Unit)objects[0];
        String name = this.jAdecWattDialog.getName(unit.getName());
        if (name == null) {
            return;
        }
        unit.getNewChild(name);
    }

    public void displayPromoteUnit(Object ... objects) {
        Unit unit = (Unit)objects[0];
        ImageDB iconDB = this.adecWatt.getIconDB();
        ImageDB imageDB = this.adecWatt.getImageDB();
        HashSet units = new HashSet();
        TreeSet<String> icons = new TreeSet<String>();
        TreeSet<String> images = new TreeSet<String>();
        unit.findPromote(units, icons, images);
        iconDB.renameVisitor(icons);
        imageDB.renameVisitor(images);
        this.permanentDB.renameVisitor(units);
        if (!this.jAdecWattDialog.validation("PromoteConfirmation", unit.getLocalName(), unit.getLocation(), units, icons, images)) {
            return;
        }
        iconDB.promote(icons);
        imageDB.promote(images);
        this.permanentDB.promote(units);
    }

    public void displayRemoveUnit(Object ... objects) {
        Unit unit = (Unit)objects[0];
        if (!this.jAdecWattDialog.validation("RemoveConfirmation", unit.getLocalName(), unit.getLocation())) {
            return;
        }
        unit.remove();
    }

    public void displayConnection(Object ... objects) {
    }

    public void displayDisplayItem(Object ... objects) {
        List selectedItems = (List)objects[0];
        this.jAdecWattDialog.display(false, selectedItems);
    }

    public void displayModifyItem(Object ... objects) {
        List selectedItems = (List)objects[0];
        this.jAdecWattDialog.display(true, selectedItems);
    }

    public void displayHideShowItem(Object ... objects) {
        JWorkspaceView jWorkspaceView = (JWorkspaceView)objects[0];
        List selectedItems = (List)objects[1];
        Boolean hidden = (Boolean)objects[2];
        jWorkspaceView.hideShowItem(selectedItems, hidden);
    }

    public void displayTransformItem(Object ... objects) {
        this.jAdecWattDialog.transform((Item)objects[0]);
    }

    public void displayCopyItem(Object ... objects) {
        JWorkspaceView jWorkspaceView = (JWorkspaceView)objects[0];
        List selectedItems = (List)objects[1];
        Point pos = (Point)objects[2];
        jWorkspaceView.cloneItem((Item)selectedItems.get(0), pos);
    }

    public void displayRemoveItem(Object ... objects) {
        JWorkspaceView jWorkspaceView = (JWorkspaceView)objects[0];
        List selectedItems = (List)objects[1];
        jWorkspaceView.eraseItem(selectedItems);
    }

    public void displaySetSelectionItems(Object ... objects) {
        try {
            this.jAdecWatt.getJWorkspace((Workspace)objects[0]).setSelectedItems((List)objects[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void displayDisplayAcc(Object ... objects) {
        List selectedAccs = (List)objects[0];
        this.jAdecWattDialog.display(false, selectedAccs);
    }

    public void displayModifyAcc(Object ... objects) {
        List selectedAccs = (List)objects[0];
        this.jAdecWattDialog.display(true, selectedAccs);
    }

    public void displayTransformAcc(Object ... objects) {
        this.jAdecWattDialog.transform((Acc)objects[0]);
    }

    public void displayRemoveAcc(Object ... objects) {
        JWorkspaceView jWorkspaceView = (JWorkspaceView)objects[0];
        Acc acc = (Acc)objects[1];
        jWorkspaceView.eraseAcc(acc);
    }
}

