/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.Circuits;
import adecWatt.model.Comp;
import adecWatt.model.Editable;
import adecWatt.model.Embedded;
import adecWatt.model.Permanent;
import adecWatt.model.Prop;
import adecWatt.model.Unit;
import adecWatt.model.unit.Accessory;
import adecWatt.model.unit.Workspace;
import adecWatt.model.xml.XmlAcc;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import misc.DimensionDouble;
import misc.ScaledImage;
import misc.Story;

public class Acc
extends Embedded<XmlAcc, Permanent.AccTypeEnum, Permanent.AccAttrEnum, Editable<?, ?, ?, ?>, Acc> {
    public static final BasicStroke solidConnection = new BasicStroke(2.0f, 1, 1);
    public static final Color connectionColor = Color.GRAY;
    public static final Color boxColor = new Color(0.0f, 1.0f, 0.0f, 0.5f);
    public static final Color warningColor = new Color(1.0f, 0.5f, 0.0f, 0.7f);
    public static final Color errorColor = new Color(1.0f, 0.0f, 0.0f, 0.7f);
    public static final Color circuitColor = Color.BLACK;

    @Override
    public Collection<String> getModifiersSet() {
        return AccModifiersSet;
    }

    @Override
    public Permanent.AccTypeEnum getTypeToken() {
        return Permanent.AccTypeEnum.Accessory;
    }

    @Override
    public Permanent.AccAttrEnum getNameToken() {
        return Permanent.AccAttrEnum.Name;
    }

    @Override
    public Permanent.AccAttrEnum getModifierToken() {
        return Permanent.AccAttrEnum.Modifier;
    }

    @Override
    public Permanent.AccAttrEnum getPlaceIdToken() {
        return Permanent.AccAttrEnum.Placeid;
    }

    @Override
    public Permanent.AccAttrEnum getModelToken() {
        return Permanent.AccAttrEnum.Model;
    }

    public Workspace getStoryUnit() {
        return (Workspace)((Comp)this.container).container;
    }

    public Acc getLink(Editable<?, ?, ?, ?> support) {
        return new Acc(this.name, this.placeId, support, (Accessory)this.model);
    }

    public Acc(Editable<?, ?, ?, ?> support, XmlAcc xmlAcc) {
        super(support, xmlAcc);
    }

    public Acc(String name, String placeName, Editable<?, ?, ?, ?> support, Accessory model) {
        super(name, placeName, support, model);
    }

    public Acc(Editable<?, ?, ?, ?> support, Accessory model) {
        super(null, "", support, model);
    }

    public Acc clone(Editable<?, ?, ?, ?> support) {
        Acc result = new Acc(support, (Accessory)this.model);
        result.importFrom(this);
        return result;
    }

    public boolean search(String text) {
        return this.getName().toLowerCase().indexOf(text) >= 0 || this.getLocalName().toLowerCase().indexOf(text) >= 0 || this.getId().indexOf(text) >= 0;
    }

    public String getCircuit(Comp realContainer) {
        String result = super.getCircuit();
        if (result != null) {
            return result;
        }
        return realContainer.getCircuit();
    }

    public double getWatt(Comp realContainer) {
        double result = super.getWatt();
        if (result > 0.0) {
            return result;
        }
        return realContainer.getWatt();
    }

    @Override
    public void validateContainer(Story.Commands commands, String commandName) {
        Story story;
        this.container.validateContainer(commands, commandName);
        if (this.container.getLocalEmbedded(this.getId()) == this) {
            return;
        }
        Story story2 = story = commands.getStory();
        Objects.requireNonNull(story2);
        commands.add(new Story.Command(story2, commandName){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }

            @Override
            public void exec() {
                Acc.this.container.addEmbedded(Acc.this);
            }

            @Override
            public void undo() {
                Acc.this.container.removeEmbedded(Acc.this);
            }

            @Override
            public void display() {
                Acc.this.container.updateView();
            }
        });
    }

    @Override
    public void storyChange(Story.Commands commands, ArrayList<Prop[]> changeProps) {
        this.storyChange(commands, true, this.ownProps, changeProps);
    }

    @Override
    public void storyTransform(Story.Commands commands, Collection<String> modifiers, Unit<?> permanent, String newName, ArrayList<Prop[]> transProps) {
        this.storyTransform(commands, null, modifiers, permanent, this.ownProps, transProps);
    }

    @Override
    public void updateView() {
        ((Comp)this.container).updateView();
    }

    public void changeConnectedTo(String connectedTo) {
        this.getLocalProp("connectedTo", Permanent.PropTypeEnum.Text).setValue(connectedTo);
    }

    public void changeConnectedOn(String connectedOn) {
        this.getLocalProp("connectedOn", Permanent.PropTypeEnum.Text).setValue(connectedOn);
    }

    public String toString() {
        return this.getName();
    }

    public void print(Graphics2D printGraphics, Comp comp) {
        DimensionDouble dimensionDouble;
        Color accColor;
        ScaledImage scaledLowImage;
        Point2D.Double accPos = this.getPos();
        DimensionDouble accSize = this.getSize();
        ScaledImage accIcon = this.getIcon();
        if (comp.isLow() && (scaledLowImage = this.getLowIcon()) != null) {
            accIcon = scaledLowImage;
        }
        if ((accColor = this.getColor()) != null) {
            accIcon = comp.getAdecWatt().getIconDB().getColoredScaledImages(accIcon, accColor);
        }
        DimensionDouble compSize = comp.getSize();
        if (accSize.width < 0.0) {
            dimensionDouble = accSize;
            dimensionDouble.width = dimensionDouble.width * -compSize.width;
        }
        if (accSize.height < 0.0) {
            dimensionDouble = accSize;
            dimensionDouble.height = dimensionDouble.height * -compSize.height;
        }
        accPos.x = accPos.x < 0.0 ? (-accPos.x - 0.5) * (compSize.width - accSize.width) : accPos.x - (compSize.width - accSize.width) / 2.0;
        accPos.y = accPos.y < 0.0 ? (-accPos.y - 0.5) * (compSize.height - accSize.height) : accPos.y - (compSize.height - accSize.height) / 2.0;
        double thetaDegree = comp.getThetaDegree();
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians((int)thetaDegree));
        double[] center = new double[]{accPos.x, accPos.y};
        at.transform(center, 0, center, 0, 1);
        Point2D.Double compPos = comp.getPos();
        Point2D.Double absPos = new Point2D.Double(compPos.getX() + center[0], compPos.getY() + center[1]);
        String id = this.getId();
        comp.accCenter.put(id, absPos);
        comp.accSize.put(id, accSize);
        Workspace.printImage(printGraphics, accIcon, absPos, accSize, thetaDegree, null);
        Workspace.printText(printGraphics, this.getLabel(), this.getLabelColor(), absPos, accSize, thetaDegree);
    }

    public static void printCircuit(Graphics2D connectionGraphics, double printScale, Point2D center, Circuits.CircuitState circuitState) {
        Acc.printCircuit(connectionGraphics, center, circuitState, 20.0 / printScale);
    }

    public static void printCircuit(Graphics2D connectionGraphics, Point2D center, Circuits.CircuitState circuitState, double boxSide) {
        Ellipse2D.Double box = new Ellipse2D.Double(center.getX() - boxSide / 2.0, center.getY() - boxSide / 2.0, boxSide, boxSide);
        Color color = boxColor;
        switch (circuitState.state) {
            case PLUG: {
                break;
            }
            case LOOP: 
            case UNPLUG: {
                color = warningColor;
                break;
            }
            case SHORTCUT: {
                color = errorColor;
            }
        }
        connectionGraphics.setPaint(color);
        connectionGraphics.fill(box);
        if (circuitState.name == null) {
            return;
        }
        Workspace.printText(connectionGraphics, String.format("%2s", circuitState.name), circuitColor, center, new DimensionDouble(boxSide, boxSide));
    }

    public static void printConnection(Graphics2D connectionGraphics, double printScale, Point2D begin, Point2D end) {
        Acc.printConnection(connectionGraphics, begin, end, 20.0 / printScale, new BasicStroke((float)(2.0 / printScale), 1, 1));
    }

    public static void printConnection(Graphics2D connectionGraphics, Point2D begin, Point2D end, double boxSide) {
        Acc.printConnection(connectionGraphics, begin, end, boxSide, solidConnection);
    }

    public static void printConnection(Graphics2D connectionGraphics, Point2D begin, Point2D end, double boxSide, BasicStroke solidConnection) {
        GeneralPath gp = new GeneralPath(1);
        gp.moveTo(begin.getX(), begin.getY());
        if (Math.abs(begin.getX() - end.getX() - 1.0) < Math.abs(begin.getY() - end.getY())) {
            gp.curveTo(begin.getX(), end.getY(), end.getX(), begin.getY(), end.getX(), end.getY());
        } else {
            gp.curveTo(end.getX(), begin.getY(), begin.getX(), end.getY(), end.getX(), end.getY());
        }
        connectionGraphics.setPaint(connectionColor);
        connectionGraphics.setStroke(solidConnection);
        connectionGraphics.draw(gp);
    }
}

