/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.ImageDB;
import adecWatt.model.InseeDB;
import adecWatt.model.PermanentDB;
import adecWatt.model.Unit;
import adecWatt.model.UnitNode;
import adecWatt.model.User;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;
import misc.Bundle;
import misc.Config;
import misc.RemoteUpdate;
import misc.StateNotifier;

public class AdecWatt
extends StateNotifier {
    public static final double lowLevel = 0.3;
    public static final String BroadcastUnitRoots = "UnitRoots";
    public static final String BroadcastConsole = "Console";
    public static final String BroadcastUnitStory = "UnitStory";
    public static final String BroadcastStory = "Story";
    public static final String BroadcastTitle = "Title";
    public static final String BroadcastUpdateUnitTree = "UpdateUnitTree";
    public static final String BroadcastUpdateWorkspace = "UpdateWorkspace";
    private ImageDB iconDB = new ImageDB(this, "icon");
    private ImageDB imageDB = new ImageDB(this, "image");
    private PermanentDB permanentDB = new PermanentDB(this);
    private InseeDB inseeDB;
    private User user = new User();
    private boolean handleGlue = Config.getBoolean("HandleGlue", true);
    private boolean boundGlue = Config.getBoolean("BoundGlue", true);
    private boolean gridGlue = Config.getBoolean("GridGlue", true);
    private boolean inSegmentGlue = Config.getBoolean("InSegmentGlue", true);

    public User getUser() {
        return this.user;
    }

    public PermanentDB getPermanentDB() {
        return this.permanentDB;
    }

    public ImageDB getIconDB() {
        return this.iconDB;
    }

    public ImageDB getImageDB() {
        return this.imageDB;
    }

    public InseeDB getInseeDB() {
        return this.inseeDB;
    }

    public Hashtable<String, Unit<?>> getNamedRoots() {
        return this.permanentDB.namedRoots;
    }

    public boolean getHandleGlue() {
        return this.handleGlue;
    }

    public boolean getBoundGlue() {
        return this.boundGlue;
    }

    public boolean getGridGlue() {
        return this.gridGlue;
    }

    public boolean getInSegmentGlue() {
        return this.inSegmentGlue;
    }

    public void setHandleGlue(boolean handleGlue) {
        this.handleGlue = handleGlue;
        Config.setBoolean("HandleGlue", this.handleGlue);
    }

    public void setBoundGlue(boolean boundGlue) {
        this.boundGlue = boundGlue;
        Config.setBoolean("BoundGlue", this.boundGlue);
    }

    public void setGridGlue(boolean gridGlue) {
        this.gridGlue = gridGlue;
        Config.setBoolean("GridGlue", this.gridGlue);
    }

    public void setInSegmentGlue(boolean inSegmentGlue) {
        this.inSegmentGlue = inSegmentGlue;
        Config.setBoolean("InSegmentGlue", this.inSegmentGlue);
    }

    public AdecWatt() {
        this.reset();
    }

    public void reloadSoft() {
        if (JOptionPane.showConfirmDialog(null, Bundle.getMessage("UpdateSoft"), Bundle.getTitle("UpdateSoft"), 0, 2) == 0) {
            return;
        }
        File softDir = new File(Config.getPWD().getParentFile(), "soft");
        File jar = new File(softDir, "UpdatedAdecWatt.jar");
        RemoteUpdate.launch(jar);
    }

    public void reset() {
        File dir = Config.getPWD().getParentFile();
        RemoteUpdate.renameNewFile(dir);
        if (RemoteUpdate.newFileExists(dir)) {
            this.reloadSoft();
        }
        this.iconDB.reload();
        this.imageDB.reload();
        this.permanentDB.reload();
        new Thread(){

            @Override
            public void run() {
                AdecWatt.this.inseeDB = InseeDB.readDocument(Config.getDataUrl("data", "server", "Insee.xml"));
            }
        }.start();
        this.broadcastUpdate(BroadcastUnitRoots);
    }

    public void updateStory() {
        this.broadcastUpdate(BroadcastStory);
    }

    public void newNamePlan() {
        TreeMap<String, String> iconMap = this.iconDB.newNamePlan();
        TreeMap<String, String> imageMap = this.imageDB.newNamePlan();
        this.permanentDB.newNamePlan(iconMap, imageMap);
        this.saveAll();
    }

    public boolean getModified() {
        for (Unit<?> unit : this.permanentDB.idUnit.values()) {
            if (!unit.story.isModified()) continue;
            return true;
        }
        return false;
    }

    public void saveAll() {
        for (Unit<?> root : this.permanentDB.namedRoots.values()) {
            Enumeration<TreeNode> e = root.unitNode.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                Unit unit = ((UnitNode)e.nextElement()).getUnit();
                if (!unit.story.isModified()) continue;
                unit.save();
            }
        }
    }
}

