/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.Acc;
import adecWatt.model.Comp;
import adecWatt.model.Embedded;
import adecWatt.model.Item;
import adecWatt.model.unit.Building;
import adecWatt.model.unit.Workspace;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;

public class Circuits {
    public static String SHORTCUT = "Shortcut";
    public static String UNPLUG = "Unplug";
    public static String CIRCUITLESS = "Circuitless";
    public static Comparator<String> lineComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            if (s1 == s2) {
                return 0;
            }
            try {
                int i1 = Integer.parseInt(s1);
                int i2 = Integer.parseInt(s2);
                return i1 - i2;
            }
            catch (Exception exception) {
                return s1.compareTo(s2);
            }
        }
    };
    private HashSet<Acc> loop = new HashSet();
    private HashMap<Comp, Circuit> allCircuits = new HashMap();
    private HashSet<Comp> plugedComps;

    public Set<Comp> keySet() {
        return this.allCircuits.keySet();
    }

    public Circuit get(Comp lastComp) {
        return this.allCircuits.get(lastComp);
    }

    public HashSet<Comp> getPlugedComps() {
        return this.plugedComps;
    }

    public boolean inLoop(Acc acc) {
        return this.loop.contains(acc);
    }

    public Circuits(HashMap<Acc, Comp> linked, HashSet<Comp> plugedComps) {
        this(linked);
        this.plugedComps = plugedComps;
    }

    public Circuits(HashMap<Acc, Comp> linked) {
        block2: for (Acc beginAcc : linked.keySet()) {
            Comp nextComp;
            Comp beginComp = (Comp)beginAcc.getContainer();
            int consumption = (int)beginAcc.getWatt(beginComp);
            HashSet<Acc> nodes = new HashSet<Acc>();
            nodes.add(beginAcc);
            String name = beginAcc.getCircuit(beginComp);
            Comp lastComp = null;
            block3: while ((nextComp = linked.get(beginAcc)) != null) {
                lastComp = nextComp;
                for (String nextAccId : nextComp.getEmbeddedIds()) {
                    try {
                        Acc nextAcc = (Acc)nextComp.findEmbedded(nextAccId);
                        if (nextAcc.getConnectedTo() == null) continue;
                        if (nodes.contains(nextAcc)) {
                            this.loop.addAll(nodes);
                            continue block2;
                        }
                        nodes.add(nextAcc);
                        beginAcc = nextAcc;
                        continue block3;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            Circuit circuit = this.allCircuits.get(lastComp);
            if (circuit == null) {
                this.allCircuits.put(lastComp, new Circuit(nodes, name, consumption));
                continue;
            }
            circuit.add(nodes, name, consumption);
        }
    }

    public static Circuits getCircuits(Workspace workspace, String plugId) {
        Hashtable<String, Comp> namedComps = new Hashtable<String, Comp>();
        for (Object item : workspace.getInheritedEmbeddedValues()) {
            try {
                namedComps.put(((Embedded)item).getId(), (Comp)item);
            }
            catch (Exception exception) {}
        }
        Building building = workspace.getBuilding();
        if (building != null) {
            for (Item item : building.getInheritedEmbeddedValues()) {
                try {
                    namedComps.putIfAbsent(item.getId(), (Comp)item);
                }
                catch (Exception exception) {}
            }
        }
        HashSet<Comp> plugedComps = new HashSet<Comp>();
        HashMap<Acc, Comp> linked = new HashMap<Acc, Comp>();
        for (Comp beginComp : namedComps.values()) {
            if (beginComp.isReserved()) continue;
            for (String accId : beginComp.getEmbeddedIds()) {
                try {
                    Acc beginAcc = (Acc)beginComp.findEmbedded(accId);
                    if (beginAcc.getDirectUnit().isDescendingFrom(plugId)) {
                        plugedComps.add(beginComp);
                    }
                    Comp nextComp = (Comp)namedComps.get(beginAcc.getConnectedTo());
                    linked.put(beginAcc, nextComp);
                }
                catch (Exception exception) {}
            }
        }
        return new Circuits(linked, plugedComps);
    }

    public CircuitState getState(Comp comp, Acc acc) {
        if (acc == null) {
            return null;
        }
        String circuitName = acc.getCircuit(comp);
        if (this.loop.contains(acc)) {
            return new CircuitState(State.LOOP, circuitName);
        }
        for (Comp lastComp : this.allCircuits.keySet()) {
            Circuit circuit = this.allCircuits.get(lastComp);
            if (!circuit.nodes.contains(acc)) continue;
            switch (circuit.names.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new CircuitState(lastComp.getLine() == null ? State.UNPLUG : State.PLUG, circuit.names.first());
                }
            }
            return new CircuitState(State.SHORTCUT, circuitName);
        }
        return circuitName == null ? null : new CircuitState(State.UNPLUG, circuitName);
    }

    public static class Circuit {
        HashSet<Acc> nodes = new HashSet();
        TreeSet<String> names = new TreeSet<String>(lineComparator);
        int consumption;

        Circuit(HashSet<Acc> nodes, String name, int consumption) {
            this.add(nodes, name, consumption);
        }

        void add(HashSet<Acc> nodes, String name, int consumption) {
            this.nodes.addAll(nodes);
            this.consumption += consumption;
            if (name == null || name.isEmpty()) {
                return;
            }
            this.names.add(name);
        }
    }

    public static class CircuitState {
        public String name;
        public State state;

        public CircuitState(State state, String name) {
            this.name = name;
            this.state = state;
        }
    }

    public static enum State {
        PLUG,
        LOOP,
        SHORTCUT,
        UNPLUG;

    }
}

