/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.Acc;
import adecWatt.model.Editable;
import adecWatt.model.Item;
import adecWatt.model.Permanent;
import adecWatt.model.unit.NonWorkspace;
import adecWatt.model.unit.Workspace;
import adecWatt.model.xml.XmlComp;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import misc.DimensionDouble;
import misc.ScaledImage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Comp
extends Item<XmlComp, Permanent.CompTypeEnum, Permanent.CompAttrEnum> {
    public int available;
    public HashSet<Acc> allPlugs = new HashSet();
    public static String plugId;

    @Override
    public Collection<String> getModifiersSet() {
        return CompModifiersSet;
    }

    @Override
    public Permanent.CompTypeEnum getTypeToken() {
        return Permanent.CompTypeEnum.Component;
    }

    @Override
    public Permanent.CompAttrEnum getNameToken() {
        return Permanent.CompAttrEnum.Name;
    }

    @Override
    public Permanent.CompAttrEnum getModifierToken() {
        return Permanent.CompAttrEnum.Modifier;
    }

    @Override
    public Permanent.CompAttrEnum getPlaceIdToken() {
        return Permanent.CompAttrEnum.Placeid;
    }

    @Override
    public Permanent.CompAttrEnum getModelToken() {
        return Permanent.CompAttrEnum.Model;
    }

    public Comp getLink(Editable<?, ?, ?, ?> workspace) {
        return new Comp(this.name, this.placeId, (Workspace)workspace, this.model);
    }

    public Comp(Workspace workspace, XmlComp xmlComp) {
        super(workspace, xmlComp);
        try {
            this.available = Integer.parseInt(xmlComp.getFacet(Permanent.CompAttrEnum.Available));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Comp(String name, String placeName, Workspace workspace, NonWorkspace model) {
        super(name, placeName, workspace, model);
    }

    public Comp(Workspace workspace, NonWorkspace model) {
        super((String)null, (String)null, workspace, model);
    }

    @Override
    public Comp clone(Workspace workspace) {
        Comp result = new Comp(workspace, this.model);
        result.importFrom(this);
        return result;
    }

    @Override
    public Element getXml(Node parent, Document document) {
        Element child = super.getXml(parent, document);
        if (this.isReserved()) {
            XmlComp.putFacet(child, Permanent.CompAttrEnum.Available, "" + this.available);
        }
        return child;
    }

    @Override
    public void changeThetaDegree(double thetaDegree) {
        if (this.isSticky()) {
            return;
        }
        this.getLocalProp("rot", Permanent.PropTypeEnum.Cube).setThetaDegree(thetaDegree);
    }

    @Override
    public void changeSize(DimensionDouble size) {
        if (this.isSticky()) {
            return;
        }
        this.getLocalProp("size", Permanent.PropTypeEnum.Cube).setSize(size);
    }

    public String getLine() {
        try {
            String name = this.getPropVal((String)"line").sValue;
            if (!name.isEmpty()) {
                return name;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void print(Graphics2D printGraphics, Workspace workspace, String plugId) {
        Comp.plugId = plugId;
        this.print(printGraphics, workspace, this.getPos(), this.getSize(), this.getThetaDegree());
    }

    @Override
    public void print(Graphics2D printGraphics, Workspace workspace, Point2D pos, DimensionDouble size, double thetaDegree) {
        Color compColor;
        ScaledImage scaledLowImage;
        this.accCenter.clear();
        this.accSize.clear();
        this.allPlugs.clear();
        ScaledImage scaledImage = this.getIcon();
        if (this.isLow() && (scaledLowImage = this.getLowIcon()) != null) {
            scaledImage = scaledLowImage;
        }
        if ((compColor = this.getColor()) != null) {
            scaledImage = this.getAdecWatt().getIconDB().getColoredScaledImages(scaledImage, compColor);
        }
        Workspace.printImage(printGraphics, scaledImage, pos, size, thetaDegree, this.getTileSize());
        double minSide = Math.min(size.width, size.height);
        Workspace.printText(printGraphics, this.getLabel(), this.getLabelColor(), pos, new DimensionDouble(minSide, minSide));
        for (String accId : this.getEmbeddedIds()) {
            try {
                Acc acc = (Acc)this.findEmbedded(accId);
                acc.print(printGraphics, this);
                if (!acc.getDirectUnit().isDescendingFrom(plugId)) continue;
                workspace.addPlugedComps(this);
                this.allPlugs.add(acc);
            }
            catch (Exception exception) {}
        }
    }
}

