/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.Acc;
import adecWatt.model.AdecWatt;
import adecWatt.model.Embedded;
import adecWatt.model.LPColor;
import adecWatt.model.Permanent;
import adecWatt.model.Prop;
import adecWatt.model.Unit;
import adecWatt.model.unit.Building;
import adecWatt.model.xml.XmlAcc;
import adecWatt.model.xml.XmlPermanent;
import adecWatt.model.xml.XmlProp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import misc.DimensionDouble;
import misc.ScaledImage;
import misc.Story;
import misc.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Editable<P extends XmlPermanent<T, A>, T extends Enum<?>, A extends Enum<?>, E extends Embedded<?, ?, ?, ?, ?>>
extends Permanent<P, T, A> {
    public static final String StoryAddAcc = "AddAcc";
    public static final String StoryAddItem = "AddItem";
    public static final String StoryAddProp = "AddProp";
    public static final String StoryAddSpinProp = "AddSpinProp";
    public static final String StoryChangeBuilding = "ChangeBuilding";
    public static final String StoryChangeEnum = "ChangeEnum";
    public static final String StoryChangeLabels = "ChangeLabels";
    public static final String StoryChangeModifiers = "ChangeModifiers";
    public static final String StoryChangeName = "ChangeName";
    public static final String StoryChangeParent = "ChangeParent";
    public static final String StoryChangeSpin = "ChangeSpin";
    public static final String StoryChangeType = "ChangeType";
    public static final String StoryChangeValue = "ChangeValue";
    public static final String StoryClearProp = "ClearProp";
    public static final String StoryCloneItem = "CloneItem";
    public static final String StoryConnectAcc = "ConnectAcc";
    public static final String StoryEdit = "Edit";
    public static final String StoryHideItem = "HideItem";
    public static final String StoryLinkAcc = "LinkAcc";
    public static final String StoryLinkEmb = "LinkEmb";
    public static final String StoryLinkItem = "LinkItem";
    public static final String StoryMoveItem = "MoveItem";
    public static final String StoryOrderedProp = "OrderedProp";
    public static final String StoryPasteItem = "PasteItem";
    public static final String StoryRemoveAcc = "RemoveAcc";
    public static final String StoryRemoveEnum = "RemoveEnum";
    public static final String StoryRemoveItem = "RemoveItem";
    public static final String StoryRemoveLabels = "RemoveLabels";
    public static final String StoryRemoveProp = "RemoveProp";
    public static final String StoryRotItem = "RotItem";
    public static final String StoryRotResizeItem = "RotResizeItem";
    public static final String StorySelectItem = "SelectItem";
    public static final String StoryTransform = "Transform";
    protected Hashtable<String, Prop> ownProps = new Hashtable();
    protected String embeddedPrefix = "c";
    private int embIdCount;
    protected Hashtable<String, E> embedded;
    private ArrayList<String> reservedEmbName;
    private Double dummy;
    protected Double[] seek12 = new Double[]{null, null};
    protected Double[] seek3 = new Double[]{this.dummy, this.dummy, null};

    public abstract AdecWatt getAdecWatt();

    public abstract String getId();

    public abstract Editable<P, T, A, E> getParent();

    public abstract Unit<?> getDirectUnit();

    public abstract Unit<?> getParentUnit();

    public abstract Unit<?> getStoryUnit();

    public abstract Editable<?, ?, ?, ?> getModel();

    public Editable<?, ?, ?, ?> getContainer() {
        return null;
    }

    public E getLocalEmbedded(String id) {
        return (E)(this.embedded == null ? null : (Embedded)this.embedded.get(id));
    }

    public Hashtable<String, E> getLocalEmbedded() {
        return this.embedded;
    }

    public abstract void setParentUnit(Unit<?> var1);

    public boolean match(String text) {
        return Util.removeAccent(this.getName()).toLowerCase().indexOf(text) >= 0 || Util.removeAccent(this.getLocalName()).toLowerCase().indexOf(text) >= 0 || this.getId().indexOf(text) >= 0;
    }

    public boolean parentMatch(String text) {
        for (Unit<?> editable = this; editable != null; editable = ((Editable)editable).getParentUnit()) {
            if (!editable.match(text)) continue;
            return true;
        }
        return false;
    }

    private boolean isReservedEmbName(String name) {
        return this.reservedEmbName != null && this.reservedEmbName.contains(name);
    }

    private void reservedEmbName(String name) {
        if (this.reservedEmbName == null) {
            this.reservedEmbName = new ArrayList();
        }
        this.reservedEmbName.add(name);
    }

    private void freeEmbName(String name) {
        if (this.reservedEmbName == null) {
            return;
        }
        this.reservedEmbName.remove(name);
        if (this.reservedEmbName.size() == 0) {
            this.reservedEmbName = null;
        }
    }

    public String getUniqName() {
        String thisId = this.getId();
        while (true) {
            String embeddedName = this.embeddedPrefix + this.embIdCount;
            if (!(this.embedded != null && this.embedded.containsKey(thisId + ":" + embeddedName) || this.isReservedEmbName(embeddedName))) {
                this.reservedEmbName(embeddedName);
                return embeddedName;
            }
            ++this.embIdCount;
        }
    }

    public E getCloseEmbedded(E emb) {
        Embedded result;
        if (this.embedded == null) {
            this.embedded = new Hashtable();
        }
        if ((result = (Embedded)this.embedded.get(((Embedded)emb).getId())) == null) {
            result = ((Embedded)emb).getLink(this);
        }
        return (E)result;
    }

    public E findEmbedded(String id) {
        for (Editable<P, T, A, E> editable = this; editable != null; editable = editable.getParent()) {
            E emb = editable.getLocalEmbedded(id);
            if (emb == null) continue;
            return emb;
        }
        Editable<?, ?, ?, ?> model = this.getModel();
        if (model != null) {
            for (Editable<?, ?, ?, ?> editable = model; editable != null; editable = editable.getParent()) {
                Object emb = editable.getLocalEmbedded(id);
                if (emb == null) continue;
                return (E)emb;
            }
        }
        return null;
    }

    public E findEmbeddedRootOf(Unit<?> model) {
        for (String embId : this.getEmbeddedIds()) {
            E emb = this.findEmbedded(embId);
            if (emb == null || !model.isDescendingFrom(((Embedded)emb).getModel().getId())) continue;
            return emb;
        }
        return null;
    }

    public E findEmbeddedBaseOn(String parentId) {
        for (String embId : this.getEmbeddedIds()) {
            E emb = this.findEmbedded(embId);
            if (emb == null || !((Embedded)emb).getDirectUnit().isDescendingFrom(parentId)) continue;
            return emb;
        }
        return null;
    }

    public TreeSet<String> getEmbeddedIds() {
        TreeSet<String> result = new TreeSet<String>();
        for (Editable<P, T, A, E> editable = this; editable != null; editable = editable.getParent()) {
            if (editable.embedded == null) continue;
            result.addAll(editable.embedded.keySet());
        }
        Editable<?, ?, ?, ?> model = this.getModel();
        if (model != null) {
            for (Editable<?, ?, ?, ?> editable = model; editable != null; editable = editable.getParent()) {
                if (editable.embedded == null) continue;
                result.addAll(editable.embedded.keySet());
            }
        }
        return result;
    }

    public void addEmbedded(E emb) {
        String embId;
        if (this.embedded == null) {
            this.embedded = new Hashtable();
        }
        if (this.embedded.get(embId = ((Embedded)emb).getId()) != null) {
            System.err.println("Already embedded name recorded (" + embId + " = " + ((Permanent)emb).getName() + " in " + this.name + ").");
        }
        this.embedded.put(embId, emb);
        this.freeEmbName(embId);
    }

    public void removeEmbedded(E emb) {
        if (this.embedded == null) {
            return;
        }
        this.embedded.remove(((Embedded)emb).getId());
    }

    public Collection<E> getInheritedEmbeddedValues() {
        Hashtable<String, E> inherited = this.getInheritedEmbedded();
        if (inherited == null) {
            return new Vector();
        }
        return inherited.values();
    }

    public Hashtable<String, E> getInheritedEmbedded() {
        Editable<P, T, A, E> parent = this.getParent();
        if (parent == null) {
            return this.embedded;
        }
        Hashtable result = parent.getInheritedEmbedded();
        if (result == null) {
            return this.embedded;
        }
        if (this.embedded == null) {
            return result;
        }
        result = (Hashtable)result.clone();
        result.putAll(this.embedded);
        return result;
    }

    public Hashtable<String, E> getAllEmbedded() {
        Editable<?, ?, ?, ?> pattern = this.getModel();
        Hashtable<String, E> result = this.getInheritedEmbedded();
        if (pattern == null) {
            return result;
        }
        Hashtable resultP = pattern.getInheritedEmbedded();
        if (result == null) {
            return resultP;
        }
        if (resultP == null) {
            return result;
        }
        resultP = (Hashtable)resultP.clone();
        resultP.putAll(result);
        return resultP;
    }

    public abstract void storyChange(Story.Commands var1, ArrayList<Prop[]> var2);

    public abstract void storyTransform(Story.Commands var1, Collection<String> var2, Unit<?> var3, String var4, ArrayList<Prop[]> var5);

    public void storyTransform(Collection<String> modifiers, Unit<?> permanent, String newName, ArrayList<Prop[]> transProps) {
        Story story;
        Story story2 = story = this.getStoryUnit().story;
        Objects.requireNonNull(story2);
        Story.Commands commands = new Story.Commands(story2, StoryTransform){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }

            @Override
            public void display() {
                Editable.this.updateView();
            }
        };
        this.storyTransform(commands, modifiers, permanent, newName, transProps);
        story.add(commands);
    }

    protected Editable() {
    }

    protected Editable(P xmlPermanent) {
        super(xmlPermanent);
        this.collectOwnProps();
    }

    protected void initXml(P xmlPermanent) {
        super.initXmlAvantOwnProp(xmlPermanent);
        this.collectOwnProps();
    }

    public void collectEmbedded() {
        if (this.xmlPermanent == null) {
            return;
        }
        for (XmlAcc xmlAcc : this.xmlPermanent.getAccs()) {
            Acc acc = new Acc(this, xmlAcc);
            acc.fixName(false);
        }
    }

    public void importFrom(Editable<P, T, A, E> from) {
        super.importFrom(from);
        for (String propName : from.ownProps.keySet()) {
            this.ownProps.putIfAbsent(propName, from.ownProps.get(propName).clone());
        }
        if (from.embedded == null) {
            return;
        }
        if (this.embedded == null) {
            this.embedded = new Hashtable();
        }
        for (String embId : from.embedded.keySet()) {
            this.embedded.putIfAbsent(embId, (Embedded)from.embedded.get(embId));
        }
    }

    public void newNamePlan(HashSet<Editable<?, ?, ?, ?>> visited, TreeMap<String, String> iconMap, TreeMap<String, String> imageMap) {
        Story story;
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        if (this.embedded != null) {
            for (Embedded emb : this.embedded.values()) {
                emb.newNamePlan(visited, iconMap, imageMap);
            }
        }
        Story story2 = story = this.getStoryUnit().story;
        Objects.requireNonNull(story2);
        Story.Commands commands = new Story.Commands(story2, StoryEdit){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }

            @Override
            public void display() {
            }
        };
        block5: for (String propName : this.ownProps.keySet()) {
            final Prop prop = this.getPropVal(propName);
            if (prop == null) continue;
            TreeMap<String, String> map = null;
            switch (prop.getTypeToken()) {
                case Icon: {
                    map = iconMap;
                    break;
                }
                case Image: {
                    map = imageMap;
                    break;
                }
                default: {
                    continue block5;
                }
            }
            final String newValue = map.get(prop.sValue);
            if (newValue == null) continue;
            Story story3 = story;
            Objects.requireNonNull(story3);
            commands.add(new Story.Command(story3, "ChangeValue " + prop.name){
                String oldValue;
                {
                    Story story = x0;
                    Objects.requireNonNull(story);
                    super(story, arg0);
                    this.oldValue = prop.sValue;
                }

                @Override
                public void exec() {
                    prop.setValue(newValue);
                }

                @Override
                public void undo() {
                    prop.setValue(this.oldValue);
                }
            });
        }
        story.add(commands);
    }

    public boolean renameUnits(TreeMap<String, String> translateMap) {
        boolean result;
        Editable<P, T, A, E> parent = this.getParent();
        boolean bl = result = parent != null && translateMap.containsValue(parent.getId());
        if (this.embedded != null) {
            for (Embedded emb : this.embedded.values()) {
                result |= emb.renameUnits(translateMap);
            }
        }
        for (String propName : this.ownProps.keySet()) {
            Prop prop = this.getPropVal(propName);
            if (prop == null) continue;
            switch (prop.getTypeToken()) {
                case Text: 
                case Building: {
                    String newVal = translateMap.get(prop.sValue);
                    if (newVal != null) {
                        prop.sValue = newVal;
                        result = true;
                        break;
                    }
                    int idx = prop.sValue.indexOf(":");
                    if (idx < 0 || (newVal = translateMap.get(prop.sValue.substring(0, idx))) == null) break;
                    prop.sValue = newVal + prop.sValue.substring(idx);
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean renameImages(TreeMap<String, String> translateMap) {
        boolean result = false;
        if (this.embedded != null) {
            for (Embedded emb : this.embedded.values()) {
                result |= emb.renameImages(translateMap);
            }
        }
        for (String propName : this.ownProps.keySet()) {
            Prop prop = this.getPropVal(propName);
            if (prop == null) continue;
            switch (prop.getTypeToken()) {
                case Icon: 
                case Image: {
                    String newVal = translateMap.get(Util.getBase(prop.sValue));
                    if (newVal == null) break;
                    prop.sValue = newVal;
                    result = true;
                }
            }
        }
        return result;
    }

    public void getLocalLink(HashSet<Editable<?, ?, ?, ?>> visited, HashSet<Unit<?>> unitLinks, TreeSet<String> iconsLinks, TreeSet<String> imagesLinks) {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        if (this.embedded != null) {
            for (Embedded emb : this.embedded.values()) {
                emb.getLocalLink(visited, unitLinks, iconsLinks, imagesLinks);
            }
        }
        for (String propName : this.ownProps.keySet()) {
            Prop prop = this.getPropVal(propName);
            if (prop == null) continue;
            switch (prop.getTypeToken()) {
                case Icon: {
                    if (this.getAdecWatt().getIconDB().isRemote(prop.sValue)) break;
                    iconsLinks.add(prop.sValue);
                    break;
                }
                case Image: {
                    if (this.getAdecWatt().getImageDB().isRemote(prop.sValue)) break;
                    imagesLinks.add(prop.sValue);
                    break;
                }
                case Building: {
                    Building building = this.getBuilding();
                    if (building == null) break;
                    building.getLocalLink(visited, unitLinks, iconsLinks, imagesLinks);
                }
            }
        }
    }

    public void removeOwnProp(String propName) {
        this.ownProps.remove(propName);
    }

    public void collectOwnProps() {
        for (XmlProp xmlProp : this.xmlPermanent.getProps()) {
            Prop prop = new Prop(xmlProp);
            this.ownProps.put(prop.name, prop);
        }
    }

    public Prop getOwnProp(String propName) {
        return this.ownProps.get(propName);
    }

    public ArrayList<Prop> getOrderedOwnProps() {
        return Prop.getOrderedProps(this.ownProps.values());
    }

    public ArrayList<String> getOrderedPropsName() {
        Unit<?> parent = this.getParentUnit();
        ArrayList<String> result = parent == null ? new ArrayList<String>() : parent.getOrderedPropsName();
        for (Prop prop : this.getOrderedOwnProps()) {
            if (result.contains(prop.name)) continue;
            result.add(prop.name);
        }
        return result;
    }

    @Override
    public Element getXml(Node parent, Document document) {
        Element child = super.getXml(parent, document);
        ArrayList<Prop> tmp = new ArrayList<Prop>(this.ownProps.values());
        tmp.sort(Prop.propComparator);
        for (Prop prop : tmp) {
            prop.getXml(child, document);
        }
        if (this.embedded != null) {
            for (String embId : this.embedded.keySet()) {
                ((Embedded)this.embedded.get(embId)).getXml(child, document);
            }
        }
        return child;
    }

    public ScaledImage getIconFromFileName(String fileName, boolean horizontalSpin) {
        return this.getAdecWatt().getIconDB().getImage(fileName, horizontalSpin);
    }

    public ScaledImage getImageFromFileName(String fileName, boolean horizontalSpin) {
        return this.getAdecWatt().getImageDB().getImage(fileName, horizontalSpin);
    }

    public ImageIcon getIcon(int max) {
        ScaledImage scaledIcon = this.getIcon();
        return scaledIcon == null ? null : scaledIcon.getSide(max);
    }

    public <R> R parentWalk(String propName, ComputeProp<R> computeProp, boolean skipFirst) {
        Editable<P, T, A, E> editable;
        Editable<P, T, A, E> editable2 = editable = skipFirst ? this.getParent() : this;
        while (editable != null) {
            try {
                R result = computeProp.applyOnProp(editable.ownProps.get(propName));
                if (result != null) {
                    return result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            editable = editable.getParent();
        }
        return null;
    }

    public <R> R parentAndModelWalk(String propName, ComputeProp<R> computeProp, boolean skipFirst) {
        R result = this.parentWalk(propName, computeProp, skipFirst);
        if (result != null) {
            return result;
        }
        try {
            result = ((Editable)this.getContainer().getModel().findEmbedded(this.getId())).parentWalk(propName, computeProp, false);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result = this.getModel().parentWalk(propName, computeProp, false);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Collection<String> getPropModifiers(String propName) {
        return this.getPropModifiers(propName, false);
    }

    public Collection<String> getParentPropModifiers(String propName) {
        return this.getPropModifiers(propName, true);
    }

    public Collection<String> getPropModifiers(String propName, boolean skipFirst) {
        return this.parentAndModelWalk(propName, new ComputeProp<Collection<String>>(){

            @Override
            public Collection<String> applyOnProp(Prop prop) {
                return prop.modifiers;
            }
        }, skipFirst);
    }

    public String getPropModifiers(final String modifier, String propName) {
        return this.parentAndModelWalk(propName, new ComputeProp<String>(){

            @Override
            public String applyOnProp(Prop prop) {
                if (prop.modifiers.contains(modifier)) {
                    return modifier;
                }
                return null;
            }
        }, false);
    }

    public Collection<String> getPropEnumChoice(String propName) {
        return this.parentAndModelWalk(propName, new ComputeProp<Collection<String>>(){

            @Override
            public Collection<String> applyOnProp(Prop prop) {
                if (prop != null && prop.enumChoice != null) {
                    return prop.enumChoice;
                }
                return null;
            }
        }, false);
    }

    public List<String> getPropLabel(String propName) {
        return this.parentAndModelWalk(propName, new ComputeProp<List<String>>(){

            @Override
            public List<String> applyOnProp(Prop prop) {
                return prop.multiLabel;
            }
        }, false);
    }

    public Prop getPropVal(String propName) {
        return this.getPropVal(propName, false);
    }

    public Prop getParentPropVal(String propName) {
        return this.getPropVal(propName, true);
    }

    public Prop getPropVal(String propName, boolean skipFirst) {
        return this.parentAndModelWalk(propName, new ComputeProp<Prop>(){

            @Override
            public Prop applyOnProp(Prop prop) {
                if (prop != null && prop.sValue != null) {
                    return prop;
                }
                return null;
            }
        }, skipFirst);
    }

    public Prop getProp(String propName) {
        return this.getProp(propName, false);
    }

    public Prop getParentProp(String propName) {
        return this.getProp(propName, true);
    }

    public Prop getProp(String propName, boolean skipFirst) {
        return this.parentAndModelWalk(propName, new ComputeProp<Prop>(){

            @Override
            public Prop applyOnProp(Prop prop) {
                return prop;
            }
        }, skipFirst);
    }

    public Double[] getPartialProp(String propName, Double[] result) {
        return this.getPartialProp(propName, result, false);
    }

    public Double[] getParentPartialProp(String propName, Double[] result) {
        return this.getPartialProp(propName, result, true);
    }

    public Double[] getPartialProp(String propName, final Double[] result, boolean skipFirst) {
        return this.parentAndModelWalk(propName, new ComputeProp<Double[]>(){

            @Override
            public Double[] applyOnProp(Prop prop) {
                if (prop != null && prop.values != null) {
                    boolean complete = true;
                    for (int i = 0; i < result.length; ++i) {
                        if (result[i] != null) continue;
                        if (prop.values[i] != null) {
                            result[i] = prop.values[i];
                            continue;
                        }
                        complete = false;
                    }
                    if (complete) {
                        return result;
                    }
                }
                return null;
            }
        }, skipFirst);
    }

    public boolean parentSpinWalk(String propName, ComputeSpin computeSpin, boolean skipFirst) {
        Editable<P, T, A, E> editable;
        boolean spin = false;
        Editable<P, T, A, E> editable2 = editable = skipFirst ? this.getParent() : this;
        while (editable != null) {
            try {
                spin ^= computeSpin.getSpin(editable.ownProps.get(propName));
            }
            catch (Exception exception) {
                // empty catch block
            }
            editable = editable.getParent();
        }
        return spin;
    }

    public boolean parentAndModelSpinWalk(String propName, ComputeSpin computeSpin, boolean skipFirst) {
        boolean spin = this.parentSpinWalk(propName, computeSpin, skipFirst);
        try {
            spin ^= ((Editable)this.getContainer().getModel().findEmbedded(this.getId())).parentSpinWalk(propName, computeSpin, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            spin ^= this.getModel().parentSpinWalk(propName, computeSpin, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return spin;
    }

    public boolean getPropHorizontalSpin(String propName) {
        return this.getPropHorizontalSpin(propName, false);
    }

    public boolean getParentPropHorizontalSpin(String propName) {
        return this.getPropHorizontalSpin(propName, true);
    }

    public boolean getPropHorizontalSpin(String propName, boolean skipFirst) {
        return this.parentSpinWalk(propName, new ComputeSpin(){

            @Override
            public boolean getSpin(Prop prop) {
                return prop.horizontalSpin;
            }
        }, skipFirst);
    }

    public boolean getPropHidden(String propName) {
        return this.getPropModifiers("hidden", propName) != null;
    }

    public boolean getPropLock(String propName) {
        return this.getPropModifiers("lock", propName) != null;
    }

    public boolean getPropLocalized(String propName) {
        return this.getPropModifiers("localized", propName) != null;
    }

    public boolean getPropNoMouse(String propName) {
        return this.getPropModifiers("nomouse", propName) != null;
    }

    public ScaledImage getIcon() {
        return this.getIconImage("icon");
    }

    public ScaledImage getLowIcon() {
        return this.getIconImage("lowIcon");
    }

    public ScaledImage getBlueprint() {
        return this.getIconImage("blueprint");
    }

    public Double getBlueprintVisibility() {
        try {
            return this.getPropVal((String)"blueprintVisibility").values[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    public DimensionDouble getBlueprintSize() {
        return this.getSize("blueprintSize");
    }

    public Point2D.Double getBlueprintPos() {
        return this.getPos("blueprintPos");
    }

    public ScaledImage getIconImage(String propName) {
        return this.getIconImage(this.getPropVal(propName), this.getPropHorizontalSpin(propName));
    }

    public ScaledImage getIconImage(Prop iconImageProp, boolean horizontalSpin) {
        if (iconImageProp == null) {
            return null;
        }
        switch (iconImageProp.getTypeToken()) {
            case Icon: {
                return this.getAdecWatt().getIconDB().getImage(iconImageProp.sValue, horizontalSpin);
            }
            case Image: {
                return this.getAdecWatt().getImageDB().getImage(iconImageProp.sValue, horizontalSpin);
            }
        }
        throw new IllegalArgumentException("Bad type (" + (Object)((Object)iconImageProp.getTypeToken()) + ") for icon or image!");
    }

    public DimensionDouble getRealSize() {
        return this.getSize();
    }

    public DimensionDouble getSize() {
        return this.getSize("size");
    }

    public Double[] getTileSize() {
        Double[] seek = (Double[])this.seek12.clone();
        this.getPartialProp("tileSize", seek);
        if (seek[0] == null && seek[1] == null) {
            return null;
        }
        return seek;
    }

    public static Dimension getTile(Double[] tileSize, DimensionDouble realSize) {
        return tileSize == null ? ScaledImage.ONE_TILE : new Dimension(tileSize[0] == null ? 1 : (int)Math.max(1L, Math.round(realSize.width / tileSize[0])), tileSize[1] == null ? 1 : (int)Math.max(1L, Math.round(realSize.height / tileSize[1])));
    }

    public DimensionDouble getSize(String propName) {
        Double[] seek = (Double[])this.seek12.clone();
        this.getPartialProp(propName, seek);
        if (seek[0] == null || seek[1] == null) {
            return null;
        }
        return new DimensionDouble(seek[0], seek[1]);
    }

    public Point2D.Double getPos() {
        return this.getPos("pos");
    }

    public Point2D.Double getPos(String propName) {
        Double[] seek = (Double[])this.seek12.clone();
        this.getPartialProp(propName, seek);
        if (seek[0] == null || seek[1] == null) {
            return null;
        }
        return new Point2D.Double(seek[0], seek[1]);
    }

    public double getThetaDegree() {
        try {
            Double[] seek = (Double[])this.seek3.clone();
            this.getPartialProp("rot", seek);
            return seek[2];
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getLevel() {
        try {
            Double[] seek = (Double[])this.seek3.clone();
            this.getPartialProp("pos", seek);
            return seek[2];
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getLength() {
        try {
            return this.getPropVal((String)"length").values[0];
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getWidth() {
        try {
            return this.getPropVal((String)"width").values[0];
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getAngle() {
        try {
            return this.getPropVal((String)"angle").values[0];
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public String getStyle() {
        try {
            return this.getPropVal((String)"style").sValue;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getBegin() {
        try {
            return this.getPropVal((String)"begin").sValue;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getEnd() {
        try {
            return this.getPropVal((String)"end").sValue;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isLow() {
        return this.getLevel() <= 0.3;
    }

    public Building getBuilding() {
        try {
            return (Building)this.getAdecWatt().getPermanentDB().getUnitById(this.getProp((String)"building").sValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Color getColor() {
        try {
            return LPColor.getColor(this.getPropVal((String)"color").sValue);
        }
        catch (Exception e) {
            return Color.black;
        }
    }

    public String getConnectedTo() {
        try {
            return this.getPropVal((String)"connectedTo").sValue;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getConnectedOn() {
        try {
            return this.getPropVal((String)"connectedOn").sValue;
        }
        catch (Exception e) {
            return null;
        }
    }

    public abstract void updateView();

    public void validateContainer(Story.Commands commands, String commandName) {
    }

    protected void storyChange(Story.Commands commands, boolean comp, final Hashtable<String, Prop> ownProps, ArrayList<Prop[]> changeProps) {
        Story story = commands.getStory();
        this.validateContainer(commands, StoryLinkEmb);
        for (Prop[] changeProp : changeProps) {
            boolean changeSpin;
            boolean dstSpin;
            boolean isDstValue;
            boolean changeParentValue;
            Prop dst;
            final Prop type = changeProp[0];
            Prop parentVal = changeProp[1];
            final Prop src = changeProp[2];
            Prop prop = dst = changeProp[3] == null ? null : changeProp[3].getApplyMixProp(src, parentVal);
            if (dst != null && dst.sValue == "MIX") continue;
            boolean isParentValue = Prop.isSValue(parentVal);
            boolean bl = changeParentValue = isParentValue != (isDstValue = Prop.isSValue(dst)) || isDstValue && !dst.sValue.equals(parentVal.sValue);
            if (src == dst && changeParentValue) continue;
            boolean bl2 = dstSpin = dst != null && dst.horizontalSpin;
            if (src == null) {
                if (isDstValue && changeParentValue) {
                    Story story2 = story;
                    Objects.requireNonNull(story2);
                    commands.add(new Story.Command(story2, "AddProp " + dst.name){
                        {
                            Story story = x0;
                            Objects.requireNonNull(story);
                            super(story, arg0);
                        }

                        @Override
                        public void exec() {
                            ownProps.put(dst.name, dst);
                        }

                        @Override
                        public void undo() {
                            ownProps.remove(dst.name);
                        }
                    });
                    continue;
                }
                if (!dstSpin) continue;
                final Prop newSpin = new Prop(dst.name, dst.getTypeToken(), dst.horizontalSpin);
                Story story3 = story;
                Objects.requireNonNull(story3);
                commands.add(new Story.Command(story3, "AddSpinProp " + newSpin.name){
                    {
                        Story story = x0;
                        Objects.requireNonNull(story);
                        super(story, arg0);
                    }

                    @Override
                    public void exec() {
                        ownProps.put(newSpin.name, newSpin);
                    }

                    @Override
                    public void undo() {
                        ownProps.remove(newSpin.name);
                    }
                });
                continue;
            }
            boolean srcSpin = src != null && src.horizontalSpin;
            boolean bl3 = changeSpin = srcSpin != dstSpin || srcSpin && dstSpin && src.horizontalSpin != dst.horizontalSpin;
            if (changeSpin) {
                final boolean oldHorizontalSpin = src.horizontalSpin;
                Story story4 = story;
                Objects.requireNonNull(story4);
                commands.add(new Story.Command(story4, "ChangeSpin " + src.name){
                    {
                        Story story = x0;
                        Objects.requireNonNull(story);
                        super(story, arg0);
                    }

                    @Override
                    public void exec() {
                        src.horizontalSpin = dst.horizontalSpin;
                    }

                    @Override
                    public void undo() {
                        src.horizontalSpin = oldHorizontalSpin;
                    }
                });
            }
            if (isDstValue && changeParentValue) {
                if (dst.sValue.equals(src.sValue)) continue;
                Story story5 = story;
                Objects.requireNonNull(story5);
                commands.add(new Story.Command(story5, "ChangeValue " + dst.name + "<" + src.sValue + "," + dst.sValue + ">"){
                    String newValue;
                    String oldValue;
                    {
                        Story story = x0;
                        Objects.requireNonNull(story);
                        super(story, arg0);
                        this.newValue = dst.sValue;
                        this.oldValue = src.sValue;
                    }

                    @Override
                    public void exec() {
                        src.setValue(this.newValue);
                    }

                    @Override
                    public void undo() {
                        src.setValue(this.oldValue);
                    }
                });
            }
            if (dstSpin || isDstValue && changeParentValue) continue;
            if (comp && (type.name.equals("size") || type.name.equals("pos"))) {
                if (!isParentValue) continue;
                Double[] seek = (Double[])this.seek12.clone();
                this.getParentPartialProp(type.name, seek);
                if (seek[0] == null || seek[1] == null) continue;
            }
            if (this.getParentProp(type.name) == null || src.unknownSpin != null || src.enumChoice != null && (parentVal == null || !parentVal.getEnumString().equals(src.getEnumString())) || src.multiLabel != null && (parentVal == null || !parentVal.getLabelString().equals(src.getLabelString())) || src.getModifiersString().equals(Editable.getModifiersString(this.getPropModifiers(src.name)))) {
                final String oldValue = src.sValue;
                if (oldValue == null || oldValue.isEmpty()) continue;
                Story story6 = story;
                Objects.requireNonNull(story6);
                commands.add(new Story.Command(story6, "ClearProp " + src.name){
                    {
                        Story story = x0;
                        Objects.requireNonNull(story);
                        super(story, arg0);
                    }

                    @Override
                    public void exec() {
                        src.setValue(null);
                    }

                    @Override
                    public void undo() {
                        src.setValue(oldValue);
                    }
                });
                continue;
            }
            Story story7 = story;
            Objects.requireNonNull(story7);
            commands.add(new Story.Command(story7, "RemoveProp " + type.name){
                {
                    Story story = x0;
                    Objects.requireNonNull(story);
                    super(story, arg0);
                }

                @Override
                public void exec() {
                    ownProps.remove(type.name);
                }

                @Override
                public void undo() {
                    ownProps.put(type.name, src);
                }
            });
        }
    }

    public void storyTransform(Story.Commands commands, final String newName, final Collection<String> newModifiers, final Unit<?> permanent, final Hashtable<String, Prop> ownProps, ArrayList<Prop[]> transProps) {
        Unit<?> oldPermanent;
        String oldName;
        Story story = commands.getStory();
        this.validateContainer(commands, StoryLinkEmb);
        if (newName != null && !newName.equals(oldName = this.getName())) {
            Story story2 = story;
            Objects.requireNonNull(story2);
            commands.add(new Story.Command(story2, StoryChangeName){
                {
                    Story story = x0;
                    Objects.requireNonNull(story);
                    super(story, arg0);
                }

                @Override
                public void exec() {
                    Editable.this.name = newName;
                }

                @Override
                public void undo() {
                    Editable.this.name = oldName;
                }

                @Override
                public void display() {
                    Editable.this.getDirectUnit().updateTree();
                }
            });
        }
        if (newModifiers != null && !this.getModifiersString().equals(Editable.getModifiersString(newModifiers))) {
            final Collection<String> oldModifiers = this.getModifiers();
            Story story3 = story;
            Objects.requireNonNull(story3);
            commands.add(new Story.Command(story3, StoryChangeModifiers){
                {
                    Story story = x0;
                    Objects.requireNonNull(story);
                    super(story, arg0);
                }

                @Override
                public void exec() {
                    Editable.this.setModifiers(newModifiers);
                }

                @Override
                public void undo() {
                    Editable.this.setModifiers(oldModifiers);
                }
            });
        }
        if (permanent != null && (oldPermanent = this.getParentUnit()) != permanent && permanent != this && this.getParent() != null) {
            Story story4 = story;
            Objects.requireNonNull(story4);
            commands.add(new Story.Command(story4, StoryChangeParent){
                {
                    Story story = x0;
                    Objects.requireNonNull(story);
                    super(story, arg0);
                }

                @Override
                public void exec() {
                    Editable.this.setParentUnit(permanent);
                }

                @Override
                public void undo() {
                    Editable.this.setParentUnit(oldPermanent);
                }

                @Override
                public void display() {
                    permanent.updateTree();
                    oldPermanent.updateTree();
                    Editable.this.getDirectUnit().updateTree();
                }
            });
        }
        if (transProps != null) {
            Prop dst;
            Prop src;
            ArrayList<Prop> oldProps = new ArrayList<Prop>(ownProps.values());
            for (Prop[] transProp : transProps) {
                src = transProp[0];
                dst = transProp[1];
                if (src == null) continue;
                oldProps.remove(src);
                if (src.rank == dst.rank) continue;
                if (src.rank == null || !src.rank.equals(dst.rank)) {
                    final Integer oldRank = src.rank;
                    Story story5 = story;
                    Objects.requireNonNull(story5);
                    commands.add(new Story.Command(story5, "OrderedProp " + src.name){
                        {
                            Story story = x0;
                            Objects.requireNonNull(story);
                            super(story, arg0);
                        }

                        @Override
                        public void exec() {
                            src.rank = dst.rank;
                        }

                        @Override
                        public void undo() {
                            src.rank = oldRank;
                        }
                    });
                }
                if (!src.getModifiersString().equals(dst.getModifiersString())) {
                    final Collection<String> oldModifiers = src.getModifiers();
                    Story story6 = story;
                    Objects.requireNonNull(story6);
                    commands.add(new Story.Command(story6, "ChangeModifiers " + src.name){
                        {
                            Story story = x0;
                            Objects.requireNonNull(story);
                            super(story, arg0);
                        }

                        @Override
                        public void exec() {
                            src.setModifiers(dst.getModifiers());
                        }

                        @Override
                        public void undo() {
                            src.setModifiers(oldModifiers);
                        }
                    });
                }
                if (!src.name.equals(dst.name)) {
                    final String oldPropName = src.name;
                    final String newPropName = dst.name;
                    Story story7 = story;
                    Objects.requireNonNull(story7);
                    commands.add(new Story.Command(story7, "ChangeName " + oldPropName + " " + newPropName){
                        {
                            Story story = x0;
                            Objects.requireNonNull(story);
                            super(story, arg0);
                        }

                        @Override
                        public void exec() {
                            if (ownProps.get(oldPropName) == src) {
                                ownProps.remove(oldPropName);
                            }
                            src.name = newPropName;
                            ownProps.put(newPropName, src);
                        }

                        @Override
                        public void undo() {
                            if (ownProps.get(newPropName) == src) {
                                ownProps.remove(newPropName);
                            }
                            src.name = oldPropName;
                            ownProps.put(oldPropName, src);
                        }
                    });
                }
                if (src.getTypeToken() != dst.getTypeToken()) {
                    final Permanent.PropTypeEnum oldType = src.getTypeToken();
                    final Permanent.PropTypeEnum newType = dst.getTypeToken();
                    Story story8 = story;
                    Objects.requireNonNull(story8);
                    commands.add(new Story.Command(story8, "ChangeType " + src.name){
                        {
                            Story story = x0;
                            Objects.requireNonNull(story);
                            super(story, arg0);
                        }

                        @Override
                        public void exec() {
                            src.setType(newType);
                        }

                        @Override
                        public void undo() {
                            src.setType(oldType);
                        }
                    });
                }
                if (!src.getEnumString().equals(dst.getEnumString())) {
                    final Collection<String> oldEnum = src.enumChoice;
                    final Collection<String> newEnum = dst.enumChoice;
                    Story story9 = story;
                    Objects.requireNonNull(story9);
                    commands.add(new Story.Command(story9, "ChangeEnum " + src.name){
                        {
                            Story story = x0;
                            Objects.requireNonNull(story);
                            super(story, arg0);
                        }

                        @Override
                        public void exec() {
                            src.enumChoice = newEnum;
                        }

                        @Override
                        public void undo() {
                            src.enumChoice = oldEnum;
                        }
                    });
                }
                if (src.getLabelString().equals(dst.getLabelString())) continue;
                final List<String> oldLabels = src.multiLabel;
                final List<String> newLabels = dst.multiLabel;
                Story story10 = story;
                Objects.requireNonNull(story10);
                commands.add(new Story.Command(story10, "ChangeLabels " + src.name){
                    {
                        Story story = x0;
                        Objects.requireNonNull(story);
                        super(story, arg0);
                    }

                    @Override
                    public void exec() {
                        src.multiLabel = newLabels;
                    }

                    @Override
                    public void undo() {
                        src.multiLabel = oldLabels;
                    }
                });
            }
            for (Prop[] transProp : transProps) {
                src = transProp[0];
                dst = transProp[1];
                if (src != null) continue;
                final Prop oldSrc = ownProps.get(dst.name);
                if (oldSrc != null) {
                    oldProps.remove(oldSrc);
                    Story story11 = story;
                    Objects.requireNonNull(story11);
                    commands.add(new Story.Command(story11, "RemoveProp " + dst.name){
                        {
                            Story story = x0;
                            Objects.requireNonNull(story);
                            super(story, arg0);
                        }

                        @Override
                        public void exec() {
                            ownProps.remove(dst.name);
                        }

                        @Override
                        public void undo() {
                            ownProps.put(dst.name, oldSrc);
                        }
                    });
                }
                Story story12 = story;
                Objects.requireNonNull(story12);
                commands.add(new Story.Command(story12, "AddProp " + dst.name){
                    {
                        Story story = x0;
                        Objects.requireNonNull(story);
                        super(story, arg0);
                    }

                    @Override
                    public void exec() {
                        ownProps.put(dst.name, dst);
                    }

                    @Override
                    public void undo() {
                        ownProps.remove(dst.name);
                    }
                });
            }
            Unit<?> parent = this.getParentUnit();
            for (final Prop prop : oldProps) {
                if (prop.sValue != null || prop.horizontalSpin) {
                    List<String> multiLabel;
                    final Collection<String> enumChoice = prop.enumChoice;
                    if (enumChoice != null) {
                        Story story13 = story;
                        Objects.requireNonNull(story13);
                        commands.add(new Story.Command(story13, "RemoveEnum " + prop.name){
                            {
                                Story story = x0;
                                Objects.requireNonNull(story);
                                super(story, arg0);
                            }

                            @Override
                            public void exec() {
                                prop.enumChoice = null;
                            }

                            @Override
                            public void undo() {
                                prop.enumChoice = enumChoice;
                            }
                        });
                    }
                    if ((multiLabel = prop.multiLabel) == null) continue;
                    Story story14 = story;
                    Objects.requireNonNull(story14);
                    commands.add(new Story.Command(story14, "RemoveLabels " + prop.name){
                        {
                            Story story = x0;
                            Objects.requireNonNull(story);
                            super(story, arg0);
                        }

                        @Override
                        public void exec() {
                            prop.multiLabel = null;
                        }

                        @Override
                        public void undo() {
                            prop.multiLabel = multiLabel;
                        }
                    });
                    continue;
                }
                Story story15 = story;
                Objects.requireNonNull(story15);
                commands.add(new Story.Command(story15, "RemoveProp " + prop.name){
                    String oldPropName;
                    {
                        Story story = x0;
                        Objects.requireNonNull(story);
                        super(story, arg0);
                        this.oldPropName = prop.name;
                    }

                    @Override
                    public void exec() {
                        if (ownProps.get(this.oldPropName) == prop) {
                            ownProps.remove(prop.name);
                        }
                    }

                    @Override
                    public void undo() {
                        ownProps.put(this.oldPropName, prop);
                    }
                });
            }
        }
    }

    public static interface ComputeProp<R> {
        public R applyOnProp(Prop var1);
    }

    public static interface ComputeSpin {
        public boolean getSpin(Prop var1);
    }
}

