/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.AdecWatt;
import adecWatt.model.Editable;
import adecWatt.model.LPColor;
import adecWatt.model.Permanent;
import adecWatt.model.Prop;
import adecWatt.model.Unit;
import adecWatt.model.unit.NonWorkspace;
import adecWatt.model.xml.XmlPermanent;
import java.awt.Color;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Embedded<P extends XmlPermanent<T, A>, T extends Enum<?>, A extends Enum<?>, C extends Editable<?, ?, ?, ?>, E extends Embedded<?, ?, ?, ?, ?>>
extends Editable<P, T, A, E> {
    public static final String globalPlace = "ean";
    protected C container;
    protected C containerRef;
    protected String placeId;
    protected String id;
    protected NonWorkspace model;
    public static String labelPattern = "\\{\\{([^}]*)\\}\\}";

    public abstract A getPlaceIdToken();

    public abstract A getModelToken();

    public abstract Embedded<P, T, A, ?, E> getLink(Editable<?, ?, ?, ?> var1);

    @Override
    public AdecWatt getAdecWatt() {
        return ((Editable)this.container).getAdecWatt();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Unit<?> getDirectUnit() {
        return this.model;
    }

    @Override
    public Unit<?> getParentUnit() {
        return this.model;
    }

    public NonWorkspace getModel() {
        return this.model;
    }

    public C getContainer() {
        return this.container;
    }

    public void setModel(NonWorkspace model) {
        this.model = model;
    }

    public Embedded<P, T, A, C, E> getParent() {
        for (Editable containerParent = ((Editable)this.container).getParent(); containerParent != null; containerParent = containerParent.getParent()) {
            Object parent = containerParent.getLocalEmbedded(this.id);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    @Override
    public void setParentUnit(Unit<?> parent) {
        this.model = (NonWorkspace)parent;
    }

    protected Embedded(C container, P xmlPermanent) {
        super(xmlPermanent);
        String modelId;
        this.container = container;
        this.placeId = ((XmlPermanent)xmlPermanent).getFacet(this.getPlaceIdToken());
        if (this.placeId == null) {
            this.placeId = ((Editable)container).getId();
        }
        if (this.name != null) {
            this.updateId();
        }
        if ((modelId = ((XmlPermanent)xmlPermanent).getFacet(this.getModelToken())) == null) {
            throw new IllegalArgumentException("Unknown XML embedded has no model (" + xmlPermanent + ").");
        }
        this.model = (NonWorkspace)this.getAdecWatt().getPermanentDB().getUnitById(modelId);
    }

    protected Embedded(String name, String placeId, C container, NonWorkspace model) {
        this.name = name == null ? ((Editable)container).getUniqName() : name;
        this.placeId = placeId == null ? ((Editable)container).getId() : placeId;
        this.container = container;
        this.model = model;
        this.updateId();
    }

    protected void updateId() {
        this.id = this.placeId + ":" + this.name;
    }

    public void fixName(boolean isLocal) {
        if (this.name == null) {
            this.name = ((Editable)this.container).getUniqName();
            this.placeId = isLocal ? ((Editable)this.container).getId() : globalPlace;
        }
        this.updateId();
        ((Editable)this.container).addEmbedded((Embedded)this);
    }

    protected void importFrom(Embedded<P, T, A, ?, E> from) {
        for (Editable current = from; current != null; current = current.getParent()) {
            super.importFrom(current);
        }
        NonWorkspace model = from.getModel();
        if (model == null) {
            return;
        }
        super.importFrom(model);
    }

    public abstract Embedded clone(C var1);

    protected Embedded clone() {
        throw new IllegalArgumentException("Clone an Embedded forbidden");
    }

    @Override
    public Element getXml(Node parent, Document document) {
        Element child = super.getXml(parent, document);
        if (!((Editable)this.container).getId().equals(this.placeId)) {
            XmlPermanent.putFacet(child, this.getPlaceIdToken(), this.placeId);
        }
        XmlPermanent.putFacet(child, this.getModelToken(), this.model.getId());
        return child;
    }

    @Override
    public void getLocalLink(HashSet<Editable<?, ?, ?, ?>> visited, HashSet<Unit<?>> unitLinks, TreeSet<String> iconsLinks, TreeSet<String> imagesLinks) {
        if (visited.contains(this)) {
            return;
        }
        super.getLocalLink(visited, unitLinks, iconsLinks, imagesLinks);
        if (this.model != null) {
            this.model.getLocalLink(visited, unitLinks, iconsLinks, imagesLinks);
        }
    }

    @Override
    public boolean renameUnits(TreeMap<String, String> translateMap) {
        boolean result;
        boolean bl = result = this.model != null && translateMap.containsValue(this.model.getId());
        if (this.placeId != null && translateMap.containsKey(this.placeId)) {
            this.placeId = translateMap.get(this.placeId);
            if (this.name != null) {
                this.updateId();
            }
            result = true;
        }
        return super.renameUnits(translateMap) || result;
    }

    public Prop getLocalProp(String name, Permanent.PropTypeEnum type) {
        for (Prop prop : this.ownProps.values()) {
            if (!name.equals(prop.name)) continue;
            return prop;
        }
        Prop result = new Prop(name, type);
        this.ownProps.put(name, result);
        return result;
    }

    public String getLabel() {
        try {
            Pattern p = Pattern.compile(labelPattern);
            String mString = this.getPropVal((String)"labelProp").sValue;
            Matcher m = p.matcher(mString);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String key = mString.substring(m.start() + 2, m.end() - 2);
                String val = "";
                try {
                    val = this.getPropVal((String)key).sValue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                m.appendReplacement(sb, val);
            }
            m.appendTail(sb);
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Color getLabelColor() {
        try {
            return LPColor.getColor(this.getPropVal((String)"labelColor").sValue);
        }
        catch (Exception e) {
            return Color.black;
        }
    }

    public double getLabelSize() {
        try {
            return this.getPropVal((String)"labelSize").values[0];
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public String getCircuit() {
        try {
            String name = this.getPropVal((String)"circuit").sValue;
            if (!name.isEmpty()) {
                return name;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public double getWatt() {
        try {
            return this.getPropVal((String)"watt").values[0];
        }
        catch (Exception exception) {
            return 0.0;
        }
    }
}

