/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.AdecWatt;
import adecWatt.model.PermanentDB;
import adecWatt.model.PreviewCache;
import adecWatt.model.TagDB;
import adecWatt.model.User;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import misc.Config;
import misc.ScaledImage;
import misc.Util;

public class ImageDB {
    public static final String iconDirName = "icon";
    public static final String imageDirName = "image";
    private AdecWatt adecWatt;
    private String dir;
    private TagDB tagDB;
    public PreviewCache previewCache;
    Hashtable<ScaledImage, Hashtable<Color, ScaledImage>> coloredScaledImages = new Hashtable();
    final int toReplace = Color.BLUE.getRGB();
    private Hashtable<String, BufferedImage> bufferedImages = new Hashtable();
    private Hashtable<BufferedImage, ScaledImage> scaledImages = new Hashtable();
    public static Comparator<NameLocal> nameLocalComparator;

    private File getDir(String placeToken) {
        return new File(new File(PermanentDB.dataDir, placeToken), this.dir);
    }

    public Collection<String> getTags(String imageName) {
        return this.tagDB.getTags(imageName);
    }

    public void putTags(String imageName, Collection<String> imageTags) {
        this.tagDB.putTags(imageName, imageTags);
    }

    public ImageDB(AdecWatt adecWatt, String dir) {
        this.adecWatt = adecWatt;
        this.dir = dir;
        this.tagDB = new TagDB(dir);
        this.previewCache = new PreviewCache(new File(new File(PermanentDB.dataDir, "cache"), dir));
    }

    public ScaledImage getColoredScaledImages(ScaledImage scaledImage, Color color) {
        ScaledImage coloredScaledImage;
        Hashtable<Color, ScaledImage> colorList = this.coloredScaledImages.get(scaledImage);
        if (colorList == null) {
            colorList = new Hashtable();
            this.coloredScaledImages.put(scaledImage, colorList);
        }
        if ((coloredScaledImage = colorList.get(color)) == null) {
            int newColor = color.getRGB();
            BufferedImage reference = scaledImage.reference;
            int width = reference.getWidth();
            int height = reference.getHeight();
            BufferedImage colored = new BufferedImage(width, height, 2);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int c = reference.getRGB(x, y);
                    if (c == this.toReplace) {
                        c = newColor;
                    }
                    colored.setRGB(x, y, c);
                }
            }
            coloredScaledImage = new ScaledImage(colored);
            colorList.put(color, coloredScaledImage);
        }
        return coloredScaledImage;
    }

    public ScaledImage getImage(String imageName, boolean horizontalSpin) {
        try {
            ScaledImage result = this.getScaled(this.findBufferedImage(imageName));
            return horizontalSpin ? result.getNewSpin(horizontalSpin, false) : result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ScaledImage getScaled(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        ScaledImage scaledImage = this.scaledImages.get(bufferedImage);
        if (scaledImage != null) {
            return scaledImage;
        }
        scaledImage = new ScaledImage(bufferedImage);
        this.scaledImages.put(bufferedImage, scaledImage);
        return scaledImage;
    }

    public boolean isRemote(String imageName) {
        FileFilterImageName fileFilterImageName = new FileFilterImageName(imageName);
        boolean result = true;
        for (String srcDir : PermanentDB.localRemoteDir) {
            try {
                boolean bl = result = !result;
                if (new File(new File(PermanentDB.dataDir, srcDir), this.dir).listFiles(fileFilterImageName).length <= 0) continue;
                return result;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public File getFile(String imageName, boolean isLocal) {
        if (!PermanentDB.localRemoteDir.get(0).equals("local")) {
            isLocal = !isLocal;
        }
        String srcDir = PermanentDB.localRemoteDir.get(isLocal ? 0 : 1);
        try {
            return this.getDir(srcDir).listFiles(new FileFilterImageName(imageName))[0];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void renameLocalImage(String imageName, String newImageName) {
        File oldFile;
        if (imageName == null || newImageName == null || imageName.equals(newImageName)) {
            return;
        }
        BufferedImage image = this.bufferedImages.get(imageName);
        if (image != null) {
            this.bufferedImages.remove(imageName);
            this.bufferedImages.put(newImageName, image);
        }
        if ((oldFile = this.getFile(imageName, true)) == null) {
            return;
        }
        File newFile = new File(oldFile.getParent(), newImageName + "." + Util.getExtention(oldFile).toLowerCase());
        try {
            Files.move(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (oldFile.exists()) {
            System.err.println("coucou l'image n'a pas \u00c3\u00a9t\u00c3\u00a9 renomm\u00c3\u00a9e:" + oldFile);
        }
    }

    public void removeImage(String imageName) {
        try {
            File oldFile = this.getFile(imageName, true);
            Util.backup(oldFile, Util.getExtention(oldFile), "back");
            this.clearBufferedImage(imageName);
            this.previewCache.clean(imageName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getNewImageName(File file) {
        return this.adecWatt.getUser().getDataId() + "." + Util.getExtention(file).toLowerCase();
    }

    private String getImageName(String imageName, File file) {
        return Util.getBase(imageName) + "." + Util.getExtention(file);
    }

    public String addImage(File file) {
        String newImageName = this.getNewImageName(file);
        File dstDir = new File(new File(PermanentDB.dataDir, "local"), this.dir);
        try {
            dstDir.mkdirs();
            Util.copy(new FileInputStream(file), new FileOutputStream(new File(dstDir, newImageName)), null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newImageName;
    }

    public void renameVisitor(TreeSet<String> imageNames) {
        if (imageNames.size() == 0) {
            return;
        }
        PermanentDB permanentDB = this.adecWatt.getPermanentDB();
        TreeMap<String, String> translateMap = new TreeMap<String, String>();
        String pattern = String.format("%03d-", 1);
        User user = this.adecWatt.getUser();
        for (String imageName : imageNames) {
            if (!imageName.startsWith(pattern)) continue;
            String newImageName = user.getDataId();
            String ext = Util.getExtention(imageName);
            if (ext != null) {
                System.err.println("coucou renameVisitor has ext:" + imageName);
                imageNames.remove(imageName);
                imageName = Util.getBase(imageName);
            }
            this.renameLocalImage(imageName, newImageName);
            translateMap.put(imageName, newImageName);
        }
        permanentDB.renameImages(translateMap);
        this.tagDB.renameImages(translateMap);
        if (translateMap.size() < 1) {
            return;
        }
        imageNames.removeAll(translateMap.keySet());
        imageNames.addAll(translateMap.values());
    }

    public void promoteTag(TreeSet<String> imageNames) {
        this.tagDB.promote(imageNames);
    }

    public void promote(TreeSet<String> imageNames) {
        if (imageNames.size() == 0) {
            return;
        }
        for (String imageName : imageNames) {
            File file = this.getFile(imageName, true);
            if (file == null) continue;
            File newFile = new File(new File(new File(PermanentDB.dataDir, "server"), this.dir), file.getName());
            try {
                Files.move(file.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!file.exists()) continue;
            System.err.println("coucou l'image " + imageName + " n'a pas \u00c3\u00a9t\u00c3\u00a9 d\u00c3\u00a9plac\u00c3\u00a9e");
        }
    }

    public String updateImage(NameLocal nameLocal, File file) {
        String newImageName = this.getImageName(nameLocal.fileName, file);
        File dstDir = this.getDir("local");
        if (nameLocal.isLocal) {
            this.removeImage(nameLocal.fileName);
        }
        try {
            dstDir.mkdirs();
            Util.copy(new FileInputStream(file), new FileOutputStream(new File(dstDir, newImageName)), null, null);
            this.clearBufferedImage(newImageName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newImageName;
    }

    public boolean importFile(String dirName, String fileName, ByteArrayInputStream dataIn) {
        if (!this.dir.equals(dirName)) {
            return false;
        }
        try {
            this.bufferedImages.put(fileName, ImageIO.read(dataIn));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageZip(ZipOutputStream out, String iconName) throws IOException {
        if (iconName == null || iconName.isEmpty()) {
            return;
        }
        ZipEntry ze = new ZipEntry(this.dir + "/" + iconName);
        out.putNextEntry(ze);
        File srcDir = new File(new File(PermanentDB.dataDir, "local"), this.dir);
        File srcFile = new File(srcDir, iconName);
        int length = (int)srcFile.length();
        byte[] tmp = new byte[length];
        try (FileInputStream fileInputStream = new FileInputStream(srcFile);){
            fileInputStream.read(tmp);
        }
        out.write(tmp);
        out.closeEntry();
        out.flush();
    }

    public Vector<NameLocal> listImage() {
        Vector<NameLocal> result = new Vector<NameLocal>();
        Vector<String> filesNames = new Vector<String>();
        Boolean isLocal = PermanentDB.localRemoteDir.get(0).equals("local");
        isLocal = isLocal == false;
        for (String srcDir : PermanentDB.localRemoteDir) {
            try {
                isLocal = isLocal == false;
                File[] files = new File(PermanentDB.dataDir, srcDir + Config.FS + this.dir).listFiles(PreviewCache.fileImageFilter);
                if (files == null) continue;
                int maxSize = result.size() + filesNames.size();
                result.ensureCapacity(maxSize);
                filesNames.ensureCapacity(maxSize);
                for (File file : files) {
                    String fileName = file.getName();
                    if (filesNames.contains(fileName)) continue;
                    filesNames.add(fileName);
                    result.add(new NameLocal(fileName, isLocal));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        result.sort(nameLocalComparator);
        return result;
    }

    public TreeMap<String, String> newNamePlan() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (String srcDir : PermanentDB.localRemoteDir) {
            try {
                File[] files = new File(PermanentDB.dataDir, srcDir + Config.FS + this.dir).listFiles(PreviewCache.fileImageFilter);
                if (files == null) continue;
                for (File file : files) {
                    String fileName = file.getName();
                    if (User.splitId(fileName) != null) continue;
                    String newName = result.get(fileName);
                    if (newName == null) {
                        newName = this.getNewImageName(file);
                        result.put(fileName, newName);
                    }
                    Files.move(file.toPath(), new File(file.getParent(), newName).toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void clearBufferedImage(String imageName) {
        if (imageName == null) {
            return;
        }
        BufferedImage bufferedImage = this.bufferedImages.get(imageName = Util.getBase(imageName));
        if (bufferedImage == null) {
            return;
        }
        ScaledImage scaledImage = this.scaledImages.get(bufferedImage);
        this.bufferedImages.remove(imageName);
        if (scaledImage == null) {
            return;
        }
        this.scaledImages.remove(bufferedImage);
        this.coloredScaledImages.remove(scaledImage);
    }

    public BufferedImage findBufferedImage(String imageName) {
        if (imageName == null) {
            return null;
        }
        BufferedImage bufferedImage = this.bufferedImages.get(imageName = Util.getBase(imageName));
        if (bufferedImage != null) {
            return bufferedImage;
        }
        FileFilterImageName fileFilterImageName = new FileFilterImageName(imageName);
        for (String srcDir : PermanentDB.localRemoteDir) {
            try {
                int n = 0;
                File[] fileArray = new File(new File(PermanentDB.dataDir, srcDir), this.dir).listFiles(fileFilterImageName);
                int n2 = fileArray.length;
                if (n >= n2) continue;
                File file = fileArray[n];
                bufferedImage = ImageIO.read(file);
                this.bufferedImages.put(imageName, bufferedImage);
                return bufferedImage;
            }
            catch (Exception exception) {
            }
        }
        System.err.println("coucou not found:" + this.dir + Config.FS + imageName);
        return null;
    }

    public void updateDataId() {
        User user = this.adecWatt.getUser();
        for (String srcDir : PermanentDB.localRemoteDir) {
            try {
                for (File file : new File(PermanentDB.dataDir, srcDir + Config.FS + this.dir).listFiles(PreviewCache.fileImageFilter)) {
                    user.updateDataId(file.getName());
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public void reload() {
        new Thread(){

            @Override
            public void run() {
                ImageDB.this.tagDB.reload();
                ImageDB.this.bufferedImages.clear();
                ImageDB.this.scaledImages.clear();
                ImageDB.this.updateDataId();
            }
        }.start();
    }

    static {
        ImageIO.setUseCache(false);
        nameLocalComparator = new Comparator<NameLocal>(){

            @Override
            public int compare(NameLocal o1, NameLocal o2) {
                if (o1 == o2) {
                    return 0;
                }
                int diff = o1.fileName.compareToIgnoreCase(o2.fileName);
                if (diff != 0) {
                    return diff > 0 ? 1 : -1;
                }
                if (o1.isLocal == o2.isLocal) {
                    return 0;
                }
                return o1.isLocal ? 1 : -1;
            }
        };
    }

    public static class FileFilterImageName
    implements FileFilter {
        private String baseImageName;

        public FileFilterImageName(String imageName) {
            this.baseImageName = Util.getBase(imageName);
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && !file.isHidden() && Util.getBase(file).equals(this.baseImageName) && !Util.getExtention(file).toLowerCase().equals("back");
        }
    }

    public class NameLocal {
        public String fileName;
        public boolean isLocal;
        public ImageIcon icon;

        public NameLocal(String fileName, boolean isLocal) {
            this.fileName = fileName;
            this.isLocal = isLocal;
        }
    }
}

