/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import misc.Log;
import misc.Util;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InseeDB {
    private ArrayList<Insee> cities = new ArrayList();

    public InseeDB(Node node) {
        this.parse(node);
    }

    public ArrayList<Insee> getCities(String pattern) {
        pattern = Util.removeAccent(pattern.toLowerCase().replaceAll("-", " "));
        ArrayList<Insee> result = new ArrayList<Insee>();
        for (Insee insee : this.cities) {
            if (Util.removeAccent(insee.name.toLowerCase().replaceAll("-", " ")).indexOf(pattern) < 0 && insee.code.indexOf(pattern) < 0) continue;
            result.add(insee);
        }
        return result;
    }

    public static InseeDB readDocument(URL url) {
        try {
            return InseeDB.readDocument(url.openStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static InseeDB readDocument(InputStream stream) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(stream);
            document.normalizeDocument();
            return new InseeDB(document.getFirstChild());
        }
        catch (Exception e) {
            Log.keepLastException("InseeDB::readDocument", e);
            throw new IllegalArgumentException("Not XML file input.");
        }
    }

    private void parse(Node node) {
        NodeList childrens = node.getChildNodes();
        for (int i = 0; i < childrens.getLength(); ++i) {
            try {
                Node child = childrens.item(i);
                NamedNodeMap allFacets = child.getAttributes();
                this.cities.add(new Insee(allFacets.getNamedItem("code").getNodeValue(), allFacets.getNamedItem("name").getNodeValue(), Double.parseDouble(allFacets.getNamedItem("lat").getNodeValue()), Double.parseDouble(allFacets.getNamedItem("long").getNodeValue())));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class Insee {
        public String code;
        public String name;
        public double latitude;
        public double longitude;

        public Insee(String code, String name, double latitude, double longitude) {
            this.code = code;
            this.name = name;
            this.latitude = latitude;
            this.longitude = longitude;
        }
    }
}

