/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.Acc;
import adecWatt.model.Editable;
import adecWatt.model.Embedded;
import adecWatt.model.Permanent;
import adecWatt.model.Prop;
import adecWatt.model.Unit;
import adecWatt.model.UnitNode;
import adecWatt.model.unit.NonWorkspace;
import adecWatt.model.unit.Workspace;
import adecWatt.model.xml.XmlPermanent;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import javax.swing.tree.TreeNode;
import misc.DimensionDouble;
import misc.Story;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Item<P extends XmlPermanent<T, A>, T extends Enum<?>, A extends Enum<?>>
extends Embedded<P, T, A, Workspace, Acc> {
    protected Workspace placeUnit;
    public static Comparator<Item> xPosComparator = new AxeItemComparator(0, 1, 2);
    public static Comparator<Item> yPosComparator = new AxeItemComparator(1, 0, 2);
    public static Comparator<Item> zPosComparator = new AxeItemComparator(2, 0, 1);
    public Hashtable<String, Point2D.Double> accCenter = new Hashtable();
    public Hashtable<String, DimensionDouble> accSize = new Hashtable();

    public Workspace getStoryUnit() {
        return (Workspace)this.container;
    }

    public Item(Workspace workspace, P xml) {
        super(workspace, xml);
        this.collectEmbedded();
    }

    public Item(String name, String placeName, Workspace workspace, NonWorkspace model) {
        super(name, placeName, workspace, model);
    }

    public Item(Workspace workspace, NonWorkspace model) {
        super(null, null, workspace, model);
    }

    public abstract Item clone(Workspace var1);

    @Override
    protected void updateId() {
        super.updateId();
        try {
            boolean localItem = ((Workspace)this.container).getId().equals(this.placeId);
            if (!localItem) {
                this.placeUnit = (Workspace)this.getAdecWatt().getPermanentDB().getUnitById(this.placeId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean onAcc(String accId, double theta, Point2D.Double realPos, double close) {
        try {
            double[] coord = new double[]{realPos.x, realPos.y};
            Point2D.Double accPos = this.accCenter.get(accId);
            DimensionDouble accSize = this.accSize.get(accId);
            AffineTransform at = new AffineTransform();
            at.rotate(theta);
            at.translate(-accPos.x, -accPos.y);
            at.transform(coord, 0, coord, 0, 1);
            double halfWidth = accSize.width / 2.0 + close;
            double halfHeight = accSize.height / 2.0 + close;
            if (coord[0] >= -halfWidth && coord[0] <= halfWidth && coord[1] >= -halfHeight && coord[1] <= halfHeight) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public ArrayList<Acc> findAccs(Point2D.Double realPos, double close) {
        ArrayList<Acc> result = new ArrayList<Acc>();
        double theta = Math.toRadians(-this.getThetaDegree());
        for (String accId : this.getEmbeddedIds()) {
            if (!this.onAcc(accId, theta, realPos, close)) continue;
            result.add((Acc)this.findEmbedded(accId));
        }
        return result;
    }

    @Override
    public <R> R parentAndModelWalk(String propName, Editable.ComputeProp<R> computeProp, boolean skipFirst) {
        R result = this.parentWalk(propName, computeProp, skipFirst);
        if (result != null) {
            return result;
        }
        try {
            boolean localItem = this.placeId.equals(((Workspace)this.getContainer()).getId());
            result = ((Item)this.placeUnit.findEmbedded(this.getId())).parentWalk(propName, computeProp, localItem);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result = this.getModel().parentWalk(propName, computeProp, false);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Element getXml(Node parent, Document document) {
        return super.getXml(parent, document);
    }

    @Override
    public boolean match(String text) {
        return super.match(text) || this.model.parentMatch(text);
    }

    @Override
    public void validateContainer(Story.Commands commands, String commandName) {
        if (((Workspace)this.container).getLocalEmbedded(this.getId()) == this) {
            return;
        }
        Story story = ((Workspace)this.container).story;
        Objects.requireNonNull(story);
        commands.add(new Story.Command(story, commandName){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }

            @Override
            public void exec() {
                ((Workspace)Item.this.container).addEmbedded(Item.this);
            }

            @Override
            public void undo() {
                ((Workspace)Item.this.container).removeEmbedded(Item.this);
            }

            @Override
            public void displayExec() {
                Item.this.updateView("NewItem");
            }

            @Override
            public void displayUndo() {
                Item.this.updateView("RemoveItem");
            }
        });
    }

    @Override
    public void storyChange(Story.Commands commands, ArrayList<Prop[]> changeProps) {
        this.storyChange(commands, true, this.ownProps, changeProps);
    }

    @Override
    public void storyTransform(Story.Commands commands, Collection<String> modifiers, Unit<?> permanent, String newName, ArrayList<Prop[]> transProps) {
        this.storyTransform(commands, null, modifiers, permanent, this.ownProps, transProps);
    }

    @Override
    public void updateView() {
        this.updateView("UpdateItem");
    }

    public void updateView(String msg) {
        Enumeration<TreeNode> e = ((Workspace)this.container).unitNode.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            Unit unit = ((UnitNode)e.nextElement()).getUnit();
            unit.stateNotifier.broadcastDisplay(msg, this);
        }
    }

    public boolean inside(Rectangle2D.Double selection) {
        try {
            Point2D.Double center = this.getPos();
            DimensionDouble size = Item.getRotSize(this.getSize(), this.getThetaDegree());
            double halfWidth = size.width / 2.0;
            double halfHeight = size.height / 2.0;
            return selection.x <= center.x - halfWidth && selection.x + selection.width >= center.x + halfWidth && selection.y <= center.y - halfHeight && selection.y + selection.height >= center.y + halfHeight;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isPosOutside(DimensionDouble inside) {
        Point2D.Double pos = this.getPos();
        DimensionDouble size = Item.getRotSize(this.getSize(), this.getThetaDegree());
        double halfWidth = size.width / 2.0;
        double halfHeight = size.height / 2.0;
        return pos.x < halfWidth || pos.y < halfHeight || pos.x > inside.width - halfWidth || pos.y > inside.height - halfHeight;
    }

    public static DimensionDouble getRotSize(DimensionDouble size, double thetaDegree) {
        if (thetaDegree == 0.0) {
            return size;
        }
        double[] bounds = Item.getShapeBounds(size, thetaDegree);
        return new DimensionDouble(Math.max(Math.abs(bounds[4] - bounds[0]), Math.abs(bounds[6] - bounds[2])), Math.max(Math.abs(bounds[5] - bounds[1]), Math.abs(bounds[7] - bounds[3])));
    }

    public double getCloseBound(Point2D.Double pos, double close, Point2D.Double result) {
        return Item.getCloseBound(this.getBounds(), pos, close, result);
    }

    public double[] getBounds() {
        return Item.getBounds(this.getPos(), this.getSize(), this.getThetaDegree());
    }

    public static Point2D.Double getPosInside(DimensionDouble inside, Point2D.Double pos, double thetaDegree, DimensionDouble refSize) {
        DimensionDouble size = Item.getRotSize(refSize, thetaDegree);
        double halfWidth = size.width / 2.0;
        double halfHeight = size.height / 2.0;
        return new Point2D.Double(Math.min(Math.max(pos.x, halfWidth), inside.width - halfWidth), Math.min(Math.max(pos.y, halfHeight), inside.height - halfHeight));
    }

    public static double getCloseBound(double[] bounds, Point2D.Double pos, double close, Point2D.Double result) {
        int x = 0;
        int y = 1;
        while (x < 18) {
            double d = pos.distance(bounds[x], bounds[y]);
            if (d < close) {
                close = d;
                result.x = bounds[x];
                result.y = bounds[y];
            }
            x += 2;
            y += 2;
        }
        return close;
    }

    public static double[] getBounds(Point2D.Double pos, Dimension2D size, double thetaDegree) {
        double halfWidth = size.getWidth() / 2.0;
        double halfHeight = size.getHeight() / 2.0;
        AffineTransform at = AffineTransform.getTranslateInstance(pos.x, pos.y);
        at.rotate(Math.toRadians(thetaDegree));
        double[] bounds = new double[]{-halfWidth, -halfHeight, -halfWidth, halfHeight, halfWidth, halfHeight, halfWidth, -halfHeight, -halfWidth, 0.0, 0.0, halfHeight, halfWidth, 0.0, 0.0, -halfHeight, 0.0, 0.0};
        at.transform(bounds, 0, bounds, 0, 9);
        return bounds;
    }

    public static double[] getShapeBounds(Dimension2D size, double thetaDegree) {
        double halfWidth = size.getWidth() / 2.0;
        double halfHeight = size.getHeight() / 2.0;
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(thetaDegree));
        double[] bounds = new double[]{-halfWidth, -halfHeight, -halfWidth, halfHeight, halfWidth, halfHeight, halfWidth, -halfHeight};
        at.transform(bounds, 0, bounds, 0, 4);
        return bounds;
    }

    public boolean containsClose(double[] coord, double close) {
        try {
            Point2D.Double center = this.getPos();
            DimensionDouble size = this.getSize();
            AffineTransform at = new AffineTransform();
            at.rotate(Math.toRadians(-this.getThetaDegree()));
            at.translate(-center.x, -center.y);
            at.transform(coord, 0, coord, 0, 1);
            double halfWidth = size.width / 2.0 + close;
            double halfHeight = size.height / 2.0 + close;
            return coord[0] >= -halfWidth && coord[0] <= halfWidth && coord[1] >= -halfHeight && coord[1] <= halfHeight;
        }
        catch (Exception e) {
            return false;
        }
    }

    public abstract void changeThetaDegree(double var1);

    public abstract void changeSize(DimensionDouble var1);

    public void changeRotSize(Point2D.Double pos, double thetaDegree, DimensionDouble size) {
        if (this.isSticky()) {
            return;
        }
        this.getLocalProp("pos", Permanent.PropTypeEnum.Cube).setPosition(pos);
        this.changeThetaDegree(thetaDegree);
        this.changeSize(size);
    }

    public void changePos(Point2D.Double pos) {
        if (this.isSticky()) {
            return;
        }
        this.getLocalProp("pos", Permanent.PropTypeEnum.Cube).setPosition(pos);
    }

    public String toString() {
        return this.getName();
    }

    public Point2D.Double getAccCenter(String accId) {
        return this.accCenter.get(accId);
    }

    public DimensionDouble getAccSize(String accId) {
        return this.accSize.get(accId);
    }

    public abstract void print(Graphics2D var1, Workspace var2, String var3);

    public abstract void print(Graphics2D var1, Workspace var2, Point2D var3, DimensionDouble var4, double var5);

    static class AxeItemComparator
    implements Comparator<Item> {
        int a;
        int b;
        int c;

        public AxeItemComparator(int a, int b, int c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        @Override
        public int compare(Item o1, Item o2) {
            double diff;
            if (o1 == o2) {
                return 0;
            }
            Double[] seekProp1 = new Double[]{null, null, null};
            Double[] seekProp2 = new Double[]{null, null, null};
            o1.getPartialProp("pos", seekProp1);
            o2.getPartialProp("pos", seekProp2);
            if (seekProp1[this.a] != seekProp2[this.a]) {
                if (seekProp1[this.a] == null) {
                    return 1;
                }
                if (seekProp2[this.a] == null) {
                    return -1;
                }
                diff = seekProp1[this.a] - seekProp2[this.a];
                if (diff != 0.0) {
                    return diff > 0.0 ? 1 : -1;
                }
            }
            if (seekProp1[this.b] != seekProp2[this.b]) {
                if (seekProp1[this.b] == null) {
                    return 1;
                }
                if (seekProp2[this.b] == null) {
                    return -1;
                }
                diff = seekProp1[this.b] - seekProp2[this.b];
                if (diff != 0.0) {
                    return diff > 0.0 ? 1 : -1;
                }
            }
            if (seekProp1[this.c] != seekProp2[this.c]) {
                if (seekProp1[this.c] == null) {
                    return 1;
                }
                if (seekProp2[this.c] == null) {
                    return -1;
                }
                diff = seekProp1[this.c] - seekProp2[this.c];
                if (diff != 0.0) {
                    return diff > 0.0 ? 1 : -1;
                }
            }
            return 0;
        }
    }
}

