/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.Acc;
import adecWatt.model.Circuits;
import adecWatt.model.Comp;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Patch {
    public TreeMap<String, Integer> lineConsumption = new TreeMap();
    public TreeMap<String, String> lineCircuit = new TreeMap(Circuits.lineComparator);
    public TreeMap<String, Integer> circuitConsumption = new TreeMap();
    public TreeMap<String, TreeSet<String>> circuitLines = new TreeMap(Circuits.lineComparator);
    public TreeSet<String> circuitless = new TreeSet();
    public TreeSet<String> unplug = new TreeSet<String>(Circuits.lineComparator);
    public TreeSet<String> shortcut = new TreeSet<String>(Circuits.lineComparator);

    private void addConsumption(TreeMap<String, Integer> map, String name, int value) {
        Integer oldValue = map.get(name);
        map.put(name, oldValue == null ? value : oldValue + value);
    }

    public Set<String> getLineKeys() {
        TreeSet<String> result = new TreeSet<String>(Circuits.lineComparator);
        result.addAll(this.lineCircuit.keySet());
        return result;
    }

    public Set<String> getCircuitKeys() {
        TreeSet<String> result = new TreeSet<String>(Circuits.lineComparator);
        result.addAll(this.circuitLines.keySet());
        return result;
    }

    public Patch(Circuits circuits) {
        block4: for (Comp lastComp : circuits.keySet()) {
            Circuits.Circuit circuit = circuits.get(lastComp);
            String lineName = lastComp.getLine();
            if (lineName == null) continue;
            TreeSet<String> circuitNames = circuit.names;
            int consumption = circuit.consumption;
            switch (circuitNames.size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    String circuitName = circuitNames.first();
                    this.addConsumption(this.lineConsumption, lineName, consumption);
                    this.lineCircuit.put(lineName, circuitName);
                    this.addConsumption(this.circuitConsumption, circuitName, consumption);
                    TreeSet<String> otherLines = this.circuitLines.get(circuitName);
                    if (otherLines == null) {
                        otherLines = new TreeSet<String>(Circuits.lineComparator);
                        this.circuitLines.put(circuitName, otherLines);
                    }
                    otherLines.add(lineName);
                    continue block4;
                }
            }
            this.lineCircuit.put(lineName, Circuits.SHORTCUT);
            for (String circuitName2 : circuitNames) {
                this.shortcut.add(circuitName2);
            }
        }
        for (Comp beginComp : circuits.getPlugedComps()) {
            block7: for (Acc beginAcc : beginComp.allPlugs) {
                String circuitName = beginAcc.getCircuit(beginComp);
                String compName = beginComp.getName();
                if (circuits.inLoop(beginAcc)) {
                    if (circuitName != null) {
                        this.unplug.add(circuitName);
                        continue;
                    }
                    this.circuitless.add(compName);
                    continue;
                }
                for (Comp lastComp : circuits.keySet()) {
                    Circuits.Circuit circuit = circuits.get(lastComp);
                    if (!circuit.nodes.contains(beginAcc)) continue;
                    if (lastComp.getLine() != null) continue block7;
                    if (circuitName != null) {
                        this.unplug.add(circuitName);
                        continue block7;
                    }
                    this.circuitless.add(compName);
                    continue block7;
                }
                if (circuitName != null) {
                    this.unplug.add(circuitName);
                    continue;
                }
                this.circuitless.add(compName);
            }
        }
    }
}

