/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.xml.XmlPermanent;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import misc.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Permanent<P extends XmlPermanent<T, A>, T extends Enum<?>, A extends Enum<?>> {
    public static final String Lock = "lock";
    public static final String Mandatory = "mandatory";
    public static final String Localized = "localized";
    public static final String NoMouse = "nomouse";
    public static final String Hidden = "hidden";
    public static final String Sticky = "sticky";
    public static final String Reserved = "reserved";
    public static final String Direct = "direct";
    public static final String NoSpin = "none";
    public static final String HorizontalSpin = "horizontal";
    public static final Collection<String> UnitModifiersSet = Arrays.asList("localized");
    public static final Collection<String> SegmModifiersSet = Arrays.asList("sticky", "hidden");
    public static final Collection<String> CompModifiersSet = Arrays.asList("sticky", "reserved", "hidden");
    public static final Collection<String> AccModifiersSet = Arrays.asList(new String[0]);
    public static final Collection<String> PropModifiersSet = Arrays.asList("lock", "mandatory", "localized", "hidden", "nomouse");
    public static final Collection<String> PropHiddenModifiersSet = Arrays.asList("lock");
    public static final Collection<String> PropNotHiddenModifiersSet = Arrays.asList("mandatory", "localized", "hidden", "nomouse");
    public static final Collection<String> PropSpinSet = Arrays.asList("none", "horizontal");
    protected P xmlPermanent;
    protected String name;
    protected Collection<String> modifiers;
    protected Collection<String> unknownModifiers;

    public abstract Collection<String> getModifiersSet();

    public abstract T getTypeToken();

    public abstract A getNameToken();

    public abstract A getModifierToken();

    public String getName() {
        return this.name;
    }

    public String getLocalName() {
        return this.isLocalized() ? Bundle.getUser(this.getName()) : this.getName();
    }

    public Collection<String> getModifiers() {
        return this.modifiers;
    }

    public String getModifiersString() {
        return Permanent.getModifiersString(this.modifiers);
    }

    public boolean isModifier(String modifierName) {
        return Permanent.isModifier(modifierName, this.modifiers);
    }

    public boolean isLocalized() {
        return this.isModifier(Localized);
    }

    public boolean isLock() {
        return this.isModifier(Lock);
    }

    public boolean isHidden() {
        return this.isModifier(Hidden);
    }

    public boolean isMandatory() {
        return this.isModifier(Mandatory);
    }

    public boolean isSticky() {
        return this.isModifier(Sticky);
    }

    public boolean isReserved() {
        return this.isModifier(Reserved);
    }

    public boolean isNoMouse() {
        return this.isModifier(NoMouse);
    }

    public boolean isDirect() {
        return this.isModifier(Direct);
    }

    protected Permanent() {
    }

    protected Permanent(P xmlPermanent) {
        this.initXmlAvantOwnProp(xmlPermanent);
    }

    protected void importFrom(Permanent<P, T, A> from) {
        if (this.unknownModifiers == null && from.unknownModifiers != null) {
            this.unknownModifiers = from.unknownModifiers;
        }
        if (from.modifiers != null) {
            if (this.modifiers != null) {
                this.modifiers.addAll(from.modifiers);
            } else {
                this.modifiers = new TreeSet<String>(from.modifiers);
            }
        }
    }

    protected void initXmlAvantOwnProp(P xmlPermanent) {
        this.xmlPermanent = xmlPermanent;
        this.name = ((XmlPermanent)xmlPermanent).getFacet(this.getNameToken());
        try {
            this.unknownModifiers = ((XmlPermanent)xmlPermanent).getSplitFacet(this.getModifierToken());
            this.modifiers = null;
            for (String token : this.unknownModifiers) {
                this.addModifier(token);
            }
            this.unknownModifiers.removeAll(this.modifiers);
            if (this.unknownModifiers.size() < 1) {
                this.unknownModifiers = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setModifiers(Collection<String> modifiers) {
        if (modifiers == null || modifiers.size() == 0) {
            this.modifiers = null;
            return;
        }
        this.modifiers = modifiers;
    }

    public void addModifier(String modifier) {
        if (modifier == null || modifier.isEmpty()) {
            return;
        }
        if (!this.getModifiersSet().contains(modifier)) {
            return;
        }
        if (this.modifiers == null) {
            this.modifiers = new TreeSet<String>();
        }
        this.modifiers.add(modifier);
    }

    public void removeModifier(String modifier) {
        if (this.modifiers == null || modifier == null || modifier.isEmpty()) {
            return;
        }
        this.modifiers.remove(modifier);
        if (this.modifiers.size() < 1) {
            this.modifiers = null;
        }
    }

    public static boolean isModifier(String modifierName, Collection<String> modifiers) {
        return modifiers != null && modifiers.contains(modifierName);
    }

    public static String getModifiersString(Collection<String> modifiers) {
        if (modifiers == null) {
            return "";
        }
        return String.join((CharSequence)"|", modifiers);
    }

    public Element getXml(Node parent, Document document) {
        Element child = this.xmlPermanent == null ? document.createElement(((Enum)this.getTypeToken()).toString().toLowerCase()) : ((XmlPermanent)this.xmlPermanent).getXml(document);
        parent.appendChild(child);
        XmlPermanent.putFacet(child, this.getNameToken(), this.name);
        XmlPermanent.putSplitFacet(child, this.getModifierToken(), new Collection[]{this.modifiers, this.unknownModifiers});
        return child;
    }

    public static enum PropAttrEnum {
        Name,
        Modifier,
        Multilabel,
        Spin,
        Choice,
        Rank;

    }

    public static enum AccAttrEnum {
        Name,
        Modifier,
        Model,
        Placeid;

    }

    public static enum CompAttrEnum {
        Name,
        Modifier,
        Model,
        Placeid,
        Available;

    }

    public static enum SegmAttrEnum {
        Name,
        Modifier,
        Model,
        Placeid;

    }

    public static enum UnitAttrEnum {
        Id,
        Name,
        Modifier,
        Parent,
        Author,
        Updated;

    }

    public static enum PropTypeEnum {
        Text,
        Article,
        Icon,
        Image,
        Preview,
        Enum,
        Building,
        City,
        Number,
        Square,
        Geo,
        Cube;

    }

    public static enum AccTypeEnum {
        Accessory;

    }

    public static enum CompTypeEnum {
        Component;

    }

    public static enum SegmTypeEnum {
        Segment;

    }

    public static enum UnitTypeEnum {
        Furniture,
        Information,
        Line,
        Accessory,
        Building,
        Lightplot;

    }
}

