/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.AdecWatt;
import adecWatt.model.ImageDB;
import adecWatt.model.Unit;
import adecWatt.model.UnitNode;
import adecWatt.model.User;
import adecWatt.model.unit.Building;
import adecWatt.model.xml.XmlUnit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import misc.Config;
import misc.Log;
import misc.Util;
import org.w3c.dom.Document;

public class PermanentDB {
    public static final File dataDir = Config.findDataDir();
    public static final String localToken = "local";
    public static final String serverToken = "server";
    public static final String cacheToken = "cache";
    public static final List<String> localRemoteDir = Arrays.asList("local", "server");
    public static final String lptExtention = "lpt";
    public static final String lpzExtention = "lpz";
    public static final String backExtention = "back";
    public static final String[] exportExtention = new String[]{"lpz"};
    private AdecWatt adecWatt;
    private ImageDB iconDB;
    private ImageDB imageDB;
    private String powerPlugId;
    private String powerSocketId;
    HashSet<Unit<?>> allUnit = new HashSet();
    Hashtable<String, Unit<?>> idUnit = new Hashtable();
    Hashtable<String, Unit<?>> namedRoots = new Hashtable();

    public String getPowerPlugId() {
        return this.powerPlugId;
    }

    public String getPowerSocketId() {
        return this.powerSocketId;
    }

    public ArrayList<Building> getAllBuildings() {
        ArrayList<Building> result = new ArrayList<Building>();
        Enumeration<TreeNode> enumUnitNode = this.getRootByName("building").getUnitNode().breadthFirstEnumeration();
        while (enumUnitNode.hasMoreElements()) {
            Building building = (Building)((UnitNode)enumUnitNode.nextElement()).getUnit();
            if (building.isUncompleted(null)) continue;
            result.add(building);
        }
        return result;
    }

    public PermanentDB(AdecWatt adecWatt) {
        this.adecWatt = adecWatt;
        this.iconDB = adecWatt.getIconDB();
        this.imageDB = adecWatt.getImageDB();
    }

    public boolean isReferedUnit(String unitId) {
        return this.idUnit.containsKey(unitId);
    }

    public Unit<?> getUnitById(String unitId) {
        return this.idUnit.get(unitId);
    }

    public Unit<?> getRootByName(String unitName) {
        return this.namedRoots.get(unitName);
    }

    public Set<String> getReferedIds() {
        return this.idUnit.keySet();
    }

    public boolean isModifiedUnit() {
        for (Unit<?> unit : this.allUnit) {
            if (!unit.story.isModified()) continue;
            return true;
        }
        return false;
    }

    public void reload() {
        this.powerPlugId = null;
        this.powerSocketId = null;
        this.allUnit.clear();
        this.idUnit.clear();
        this.namedRoots.clear();
        for (String string : localRemoteDir) {
            for (File file : PermanentDB.getAllXmlFiles(string)) {
                try {
                    if (file.length() == 0L) continue;
                    Log.writeLog("PermanentDB", "load " + string + "/" + file.getName());
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Unit<?> unit = Unit.getInstanceFromStream(this.adecWatt, fileInputStream, file, serverToken.equals(string) ? UnitLocation.Server : UnitLocation.Local);
                    fileInputStream.close();
                    if (this.isReferedUnit(unit.getId())) {
                        System.err.println(unit.getName() + " already recorded : skip " + file);
                        continue;
                    }
                    this.add(unit);
                }
                catch (Exception e) {
                    System.err.println("XXX: " + file + " error: " + e);
                    e.printStackTrace();
                }
            }
        }
        for (Unit unit : this.allUnit) {
            unit.updateXmlParent();
        }
    }

    public void newNamePlan(TreeMap<String, String> iconMap, TreeMap<String, String> imageMap) {
        HashSet visited = new HashSet();
        for (Unit<?> unit : this.allUnit) {
            unit.newNamePlan(visited, iconMap, imageMap);
        }
    }

    public void add(Unit<?> unit) {
        String unitId = unit.getId();
        try {
            this.allUnit.remove(this.idUnit.get(unitId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.allUnit.add(unit);
        this.idUnit.put(unitId, unit);
        this.adecWatt.getUser().updateDataId(unitId);
        if ("powerPlug".equals(unit.getName())) {
            this.powerPlugId = unitId;
        }
        if ("powerSocket".equals(unit.getName())) {
            this.powerSocketId = unitId;
        }
        unit.enableStory();
    }

    public void forget(Unit<?> unit) {
        this.adecWatt.broadcastDisplay("Close", unit);
        this.idUnit.remove(unit.getId());
        this.allUnit.remove(unit);
        unit.disableStory();
    }

    public Unit<?> reload(Unit<?> unit) {
        for (String srcDir : localRemoteDir) {
            try {
                File file = PermanentDB.getXmlFile(new File(dataDir, srcDir), unit.getFileName());
                FileInputStream fileInputStream = new FileInputStream(file);
                Unit<?> newUnit = Unit.getInstanceFromStream(this.adecWatt, fileInputStream, file, serverToken.equals(srcDir) ? UnitLocation.Server : UnitLocation.Local);
                fileInputStream.close();
                return newUnit;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public void remove(Unit<?> unit) {
        if (unit.file != null) {
            Util.backup(unit.file, Util.getExtention(unit.file), backExtention);
        }
        this.forget(unit);
    }

    public void renameVisitor(HashSet<Unit<?>> units) {
        TreeMap<String, String> translateMap = new TreeMap<String, String>();
        String pattern = String.format("%03d-", 1);
        User user = this.adecWatt.getUser();
        for (Unit<Object> unit : units) {
            String unitId = unit.getId();
            if (!unitId.startsWith(pattern)) continue;
            translateMap.put(unitId, user.getDataId());
        }
        if (translateMap.size() < 1) {
            return;
        }
        for (String unitId : translateMap.keySet()) {
            Unit<?> unit = this.idUnit.get(unitId);
            if (unit.file != null) {
                Util.backup(unit.file, Util.getExtention(unit.file), backExtention);
            }
            this.idUnit.remove(unitId);
            String newUnitId = translateMap.get(unitId);
            unit.changeId(newUnitId);
            this.idUnit.put(newUnitId, unit);
        }
        for (Unit<Object> unit : this.allUnit) {
            if (!unit.renameUnits(translateMap)) continue;
            unit.story.markNotSaved();
        }
    }

    public void promote(HashSet<Unit<?>> units) {
        if (units.size() == 0) {
            return;
        }
        for (Unit<?> unit : units) {
            unit.promote();
        }
        this.adecWatt.broadcastUpdate("UnitRoots");
    }

    public void renameImages(TreeMap<String, String> translateMap) {
        for (Unit<?> unit : this.allUnit) {
            if (!unit.renameImages(translateMap)) continue;
            unit.story.markNotSaved();
        }
    }

    public static final File getXmlFile(String name) {
        for (String srcDir : localRemoteDir) {
            try {
                File file = PermanentDB.getXmlFile(new File(dataDir, srcDir), name);
                if (file == null) continue;
                return file;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static final File getXmlFile(File dir, String name) {
        File test = new File(dir, name);
        if (test.exists()) {
            return test;
        }
        for (File subDir : PermanentDB.getSubDirs(dir)) {
            test = PermanentDB.getXmlFile(subDir, name);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    public static final File[] getXmlFiles(File dir) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && !file.isHidden() && PermanentDB.lptExtention.equals(Util.getExtention(file));
            }
        });
    }

    public static final File[] getSubDirs(File dir) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !file.isHidden();
            }
        });
    }

    public boolean isFileNameExists(String baseName) {
        for (String srcDir : localRemoteDir) {
            try {
                if (!this.isFileExists(new File(dataDir, srcDir), baseName)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public boolean isFileExists(File dir, String baseName) {
        for (File file : PermanentDB.getXmlFiles(dir)) {
            String fileName = file.getName();
            if (!fileName.startsWith(baseName) || !lptExtention.equals(fileName.substring(1 + baseName.length()))) continue;
            return true;
        }
        for (File subDir : PermanentDB.getSubDirs(dir)) {
            if (!this.isFileExists(subDir, baseName)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<File> getAllXmlFiles(String srcDir) {
        ArrayList<File> result = new ArrayList<File>();
        try {
            PermanentDB.getAllXmlFiles(new File(dataDir, srcDir), result);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void getAllXmlFiles(File dir, ArrayList<File> result) {
        for (File file : PermanentDB.getXmlFiles(dir)) {
            result.add(file);
        }
        for (File subDir : PermanentDB.getSubDirs(dir)) {
            PermanentDB.getAllXmlFiles(subDir, result);
        }
    }

    public static File getInputFile(String name) {
        for (String srcDir : localRemoteDir) {
            File file = new File(dataDir, srcDir + Config.FS + name);
            if (!file.exists() || !file.isFile()) continue;
            return file;
        }
        throw new IllegalArgumentException("Can't find input " + name + "!");
    }

    public static File getLocalFile(String name) {
        File file = new File(dataDir, localToken + Config.FS + name);
        file.getParentFile().mkdirs();
        return file;
    }

    public static File getRemoteFile(String name) {
        File file = new File(dataDir, serverToken + Config.FS + name);
        file.getParentFile().mkdirs();
        return file;
    }

    public static XmlUnit readXmlUnit(InputStream stream) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(stream);
            document.normalizeDocument();
            return new XmlUnit(document.getFirstChild());
        }
        catch (Exception e) {
            Log.keepLastException("PermanentDB::readDocument", e);
            throw new IllegalArgumentException("Not XML file input.");
        }
    }

    public static Document newDocument() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setXmlStandalone(true);
            return document;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void writeUnit(Unit<?> unit, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PermanentDB.writeUnit(unit, fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception e) {
            Log.keepLastException("PermanentDB::writeDocument", e);
        }
    }

    public static void writeUnit(Unit<?> unit, OutputStream stream) throws IOException, TransformerException {
        Document document = PermanentDB.newDocument();
        unit.getXml(document, document);
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(stream);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        xformer.transform(source, result);
        stream.flush();
    }

    public void addUnitZip(ZipOutputStream out, Unit<?> unit) throws IOException, TransformerException {
        if (unit == null) {
            return;
        }
        ZipEntry ze = new ZipEntry(unit.getSaveDir() + "/" + unit.getFileName());
        out.putNextEntry(ze);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PermanentDB.writeUnit(unit, stream);
        out.write(stream.toByteArray());
        out.closeEntry();
        out.flush();
    }

    public File getLastExport() {
        return Config.getFile("LastExport");
    }

    public File checkExportExtention(File file) {
        if (Util.getExtention(file) != null) {
            return file;
        }
        return new File(file.getParentFile(), Util.changeExtention(file.getName(), lpzExtention));
    }

    public void exportFile(Unit<?> unit, File file) {
        if (file == null) {
            return;
        }
        try {
            file = this.checkExportExtention(file);
            HashSet unitLinks = new HashSet();
            TreeSet<String> iconsLinks = new TreeSet<String>();
            TreeSet<String> imagesLinks = new TreeSet<String>();
            unitLinks.add(unit);
            unit.getLocalLink(new HashSet(), unitLinks, iconsLinks, imagesLinks);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream out = new ZipOutputStream(fileOutputStream);
            for (Unit<?> unit2 : unitLinks) {
                this.addUnitZip(out, unit2);
            }
            for (String iconName : iconsLinks) {
                this.iconDB.addImageZip(out, iconName);
            }
            for (String imageName : imagesLinks) {
                this.imageDB.addImageZip(out, imageName);
            }
            out.close();
            fileOutputStream.close();
            Config.setFile("LastExport", file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void importFile(File file) {
        if (file == null) {
            return;
        }
        try {
            ZipEntry ze;
            file = this.checkExportExtention(file);
            ArrayList newUnit = new ArrayList();
            byte[] tmp = new byte[0x100000];
            FileInputStream fileInputStream = new FileInputStream(file);
            ZipInputStream in = new ZipInputStream(fileInputStream);
            while ((ze = in.getNextEntry()) != null) {
                int nb;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((nb = in.read(tmp, 0, tmp.length)) >= 0) {
                    byteArrayOutputStream.write(tmp, 0, nb);
                }
                byteArrayOutputStream.flush();
                in.closeEntry();
                String[] path = ze.getName().split("/");
                String dirName = path[0];
                String fileName = path[1];
                String fileExtention = Util.getExtention(fileName);
                ByteArrayInputStream dataIn = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                if (this.iconDB.importFile(dirName, fileName, dataIn) || this.imageDB.importFile(dirName, fileName, dataIn)) continue;
                if (lptExtention.equals(fileExtention)) {
                    newUnit.add(Unit.getInstanceFromStream(this.adecWatt, dataIn, null, UnitLocation.Zip));
                    continue;
                }
                System.err.println("XXX pb: " + fileName);
            }
            fileInputStream.close();
            for (Unit unit : newUnit) {
                String unitId = unit.getId();
                if (this.isReferedUnit(unitId)) {
                    Unit<?> oldUnit = this.idUnit.get(unitId);
                    this.forget(oldUnit);
                    oldUnit.replace(unit);
                    continue;
                }
                this.add(unit);
            }
            for (Unit unit : newUnit) {
                unit.updateXmlParent();
                unit.story.markNotSaved();
            }
            this.adecWatt.broadcastUpdate("UnitRoots");
            Config.setFile("LastExport", file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum UnitLocation {
        Server,
        Local,
        Zip;

    }
}

