/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import misc.Util;

public class PreviewCache {
    public static final String[] imageExtentions;
    public static final List<String> imageExtentionsList;
    public static final FileFilter fileImageFilter;
    public static int thumbSide;
    public static Dimension thumbDim;
    public static final long maxSize = 0x100000L;
    private File dir;
    private Hashtable<File, Boolean> toCleanList = new Hashtable();

    public PreviewCache(File dir) {
        this.dir = dir;
    }

    public synchronized void prepareClean() {
        try {
            this.toCleanList.clear();
            for (File file : this.dir.listFiles(fileImageFilter)) {
                this.toCleanList.put(file, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void clean() {
        for (File file : this.toCleanList.keySet()) {
            if (!this.toCleanList.get(file).booleanValue()) continue;
            file.delete();
        }
        this.toCleanList.clear();
    }

    public synchronized void clean(String imageName) {
        new File(this.dir, Util.getBase(imageName) + ".png").delete();
    }

    public synchronized ImageIcon getIcon(File file) {
        if (file == null || file.length() > 0x100000L) {
            return null;
        }
        File cacheFile = new File(this.dir, Util.getBase(file) + ".png");
        if (cacheFile.exists() && cacheFile.lastModified() > file.lastModified()) {
            this.toCleanList.put(cacheFile, false);
            return new ImageIcon(cacheFile.getPath());
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage == null) {
                return null;
            }
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            if (width == 0 || height == 0) {
                return null;
            }
            Image image = null;
            if (width > height) {
                if (width > thumbSide) {
                    height = Math.max(1, height * thumbSide / width);
                    width = thumbSide;
                    image = bufferedImage.getScaledInstance(width, height, 1);
                }
            } else if (height > thumbSide) {
                width = Math.max(1, width * thumbSide / height);
                height = thumbSide;
                image = bufferedImage.getScaledInstance(width, height, 1);
            }
            if (image != null) {
                bufferedImage = new BufferedImage(width, height, 2);
                bufferedImage.createGraphics().drawImage(image, 0, 0, null);
            }
            try {
                this.dir.mkdirs();
                ImageIO.write((RenderedImage)bufferedImage, "png", cacheFile);
                this.toCleanList.put(cacheFile, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new ImageIcon(bufferedImage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        ImageIO.setUseCache(false);
        imageExtentions = new String[]{"gif", "jpg", "jpeg", "png", "tif", "tiff", "bmp"};
        imageExtentionsList = Arrays.asList(imageExtentions);
        fileImageFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                try {
                    return file.isFile() && !file.isHidden() && imageExtentionsList.contains(Util.getExtention(file).toLowerCase());
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        thumbSide = 40;
        thumbDim = new Dimension(thumbSide, thumbSide);
    }
}

