/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.Permanent;
import adecWatt.model.xml.XmlProp;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import misc.DimensionDouble;
import misc.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Prop
extends Permanent<XmlProp, Permanent.PropTypeEnum, Permanent.PropAttrEnum> {
    public static final String PropAngle = "angle";
    public static final String PropBegin = "begin";
    public static final String PropBlueprint = "blueprint";
    public static final String PropBlueprintPos = "blueprintPos";
    public static final String PropBlueprintSize = "blueprintSize";
    public static final String PropBlueprintVisibility = "blueprintVisibility";
    public static final String PropBuilding = "building";
    public static final String PropCircuit = "circuit";
    public static final String PropColor = "color";
    public static final String PropConnectedOn = "connectedOn";
    public static final String PropConnectedTo = "connectedTo";
    public static final String PropEnd = "end";
    public static final String PropIcon = "icon";
    public static final String PropLabelColor = "labelColor";
    public static final String PropLabelProp = "labelProp";
    public static final String PropLabelSize = "labelSize";
    public static final String PropLength = "length";
    public static final String PropLine = "line";
    public static final String PropLowIcon = "lowIcon";
    public static final String PropPos = "pos";
    public static final String PropPoster = "poster";
    public static final String PropRot = "rot";
    public static final String PropSize = "size";
    public static final String PropStyle = "style";
    public static final String PropTileSize = "tileSize";
    public static final String PropWatt = "watt";
    public static final String PropWidth = "width";
    public static final String PropMix = "MIX";
    public static final Double DoubleMix = Double.NaN;
    public static NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
    public static NumberFormat geoFormat = NumberFormat.getInstance(Locale.ENGLISH);
    private Permanent.PropTypeEnum type;
    public Integer rank;
    public String sValue;
    public Collection<String> enumChoice;
    public List<String> multiLabel;
    public boolean horizontalSpin;
    public Collection<String> unknownSpin;
    public int nbVal;
    public Double[] values;
    public static Comparator<Prop> propComparator;

    public static Permanent.PropTypeEnum toPropTypeEnum(String val) {
        return Permanent.PropTypeEnum.valueOf(Permanent.PropTypeEnum.class, Util.toCapital(val));
    }

    @Override
    public Collection<String> getModifiersSet() {
        return PropModifiersSet;
    }

    @Override
    public Permanent.PropTypeEnum getTypeToken() {
        return this.type;
    }

    @Override
    public Permanent.PropAttrEnum getNameToken() {
        return Permanent.PropAttrEnum.Name;
    }

    @Override
    public Permanent.PropAttrEnum getModifierToken() {
        return Permanent.PropAttrEnum.Modifier;
    }

    public void setType(Permanent.PropTypeEnum type) {
        this.type = type;
        switch (type) {
            case Icon: 
            case Image: 
            case Enum: 
            case Building: 
            case Text: 
            case Article: 
            case City: {
                this.nbVal = 0;
                break;
            }
            case Number: {
                this.nbVal = 1;
                break;
            }
            case Geo: 
            case Square: {
                this.nbVal = 2;
                break;
            }
            case Cube: {
                this.nbVal = 3;
                break;
            }
            default: {
                System.err.println("Prop::setType unknowed type:" + (Object)((Object)type));
            }
        }
    }

    public String getEnumString() {
        if (this.enumChoice == null) {
            return "";
        }
        return String.join((CharSequence)"|", this.enumChoice);
    }

    public String getLabelString() {
        if (this.multiLabel == null) {
            return "";
        }
        return String.join((CharSequence)"|", this.multiLabel);
    }

    public static boolean isSValue(Prop prop) {
        return prop != null && prop.sValue != null && !prop.sValue.isEmpty();
    }

    public Prop(XmlProp xmlProp) {
        super(xmlProp);
        if (this.name == null) {
            throw new IllegalArgumentException("Unknown XML unit has no name (" + this.xmlPermanent + ").");
        }
        this.setType((Permanent.PropTypeEnum)xmlProp.type);
        try {
            this.rank = new Integer(Integer.parseInt(xmlProp.getFacet(Permanent.PropAttrEnum.Rank)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.unknownSpin = xmlProp.getSplitFacet(Permanent.PropAttrEnum.Spin);
            if (this.unknownSpin != null) {
                if (this.unknownSpin.contains("horizontal")) {
                    this.horizontalSpin = true;
                    this.unknownSpin.remove("horizontal");
                }
                if (this.unknownSpin.contains("none")) {
                    this.horizontalSpin = false;
                    this.unknownSpin.remove("none");
                }
                if (this.unknownSpin.size() < 1) {
                    this.unknownSpin = null;
                }
            }
            this.enumChoice = xmlProp.getSplitFacet(Permanent.PropAttrEnum.Choice);
            this.multiLabel = xmlProp.getOrderedSplitFacet(Permanent.PropAttrEnum.Multilabel);
            this.setValue(xmlProp.getValue());
        }
        catch (Exception e) {
            System.err.println("XXX: " + (Object)((Object)this.getTypeToken()) + ":" + this.name + ":" + this.sValue);
            e.printStackTrace();
        }
    }

    public Prop(String name, Permanent.PropTypeEnum type) {
        this(name, type, null, new TreeSet<String>(), null, null);
    }

    public Prop(String name, Permanent.PropTypeEnum type, boolean horizontalSpin) {
        this(name, type);
        this.horizontalSpin = horizontalSpin;
    }

    public Prop(String name, Permanent.PropTypeEnum type, Integer rank, Collection<String> modifiers, Collection<String> enumChoice, List<String> multiLabel) {
        this.name = name;
        this.setType(type);
        if (modifiers != null && modifiers.size() > 0) {
            this.modifiers = modifiers;
        }
        this.rank = rank;
        this.enumChoice = enumChoice;
        this.multiLabel = multiLabel;
    }

    public Prop clone(boolean horizontalSpin) {
        Prop prop = this.clone();
        prop.horizontalSpin = horizontalSpin;
        return prop;
    }

    public Prop clone(String sValue) {
        Prop prop = this.clone();
        prop.setValue(sValue);
        return prop;
    }

    public Prop clone() {
        Prop result = new Prop(this.name, this.type);
        result.importFrom(this);
        return result;
    }

    protected void importFrom(Prop from) {
        super.importFrom(from);
        if (from.rank != null) {
            this.rank = from.rank;
        }
        this.horizontalSpin = from.horizontalSpin;
        if (from.unknownSpin != null) {
            this.unknownSpin = from.unknownSpin;
        }
        if (from.enumChoice != null && from.enumChoice.size() > 0) {
            this.enumChoice = new TreeSet<String>(from.enumChoice);
        }
        if (from.multiLabel != null && from.multiLabel.size() > 0) {
            this.multiLabel = new Vector<String>(from.multiLabel);
        }
        this.sValue = from.sValue;
        if (from.values != null) {
            this.values = Arrays.copyOf(from.values, from.values.length);
        }
    }

    public static ArrayList<Prop> getOrderedProps(Collection<Prop> props) {
        ArrayList<Prop> result = new ArrayList<Prop>(props);
        result.sort(propComparator);
        return result;
    }

    @Override
    public Element getXml(Node parent, Document document) {
        TreeSet<String> spin;
        Element child = super.getXml(parent, document);
        if (this.rank != null) {
            XmlProp.putFacet(child, Permanent.PropAttrEnum.Rank, "" + this.rank);
        }
        TreeSet<String> treeSet = spin = this.horizontalSpin ? new TreeSet<String>() : null;
        if (this.horizontalSpin) {
            spin.add("horizontal");
        }
        XmlProp.putSplitFacet(child, Permanent.PropAttrEnum.Spin, spin, this.unknownSpin);
        XmlProp.putSplitFacet(child, Permanent.PropAttrEnum.Choice, this.enumChoice);
        XmlProp.putSplitFacet(child, Permanent.PropAttrEnum.Multilabel, this.multiLabel);
        if (this.values != null) {
            this.valuesChange();
        }
        XmlProp.putValue(child, this.sValue);
        return child;
    }

    public void valuesChange() {
        this.sValue = this.tab2string(this.values, this.nbVal);
    }

    public void sValueChange() {
        this.values = Prop.string2tab(this.sValue, this.nbVal);
    }

    public Prop getApplyMixProp(Prop src, Prop parent) {
        if (this.nbVal == 0 || this.sValue == null || this.sValue == PropMix || this.sValue.isEmpty()) {
            return this;
        }
        Double[] tmp = new Double[this.nbVal];
        boolean noChange = true;
        for (int i = 0; i < this.nbVal; ++i) {
            if (this.values[i] == null) continue;
            if (this.values[i] == DoubleMix) {
                noChange = false;
                if (src == null || src.values == null || src.values[i] == null || parent != null && parent.values != null && src.values[i] == parent.values[i]) continue;
                tmp[i] = src.values[i];
                continue;
            }
            if (parent != null && this.values[i] == parent.values[i]) {
                noChange = this.values[i] == null;
                continue;
            }
            tmp[i] = this.values[i];
        }
        boolean nullValue = true;
        for (int i = 0; i < this.nbVal; ++i) {
            nullValue &= this.values[i] == null;
        }
        if (nullValue) {
            return this.clone(null);
        }
        if (noChange) {
            return this;
        }
        return this.clone(this.tab2string(tmp, this.nbVal));
    }

    public final String tab2string(Double[] values, int nbVal) {
        String result = "";
        String sep = "";
        if (values == null || nbVal < 1 || values == null) {
            return null;
        }
        if (values.length != nbVal) {
            System.err.println("coucou probl\u00c3\u00a8me de m\u00c3\u00a9tamorphose : " + values.length + " != " + nbVal + "\n");
        }
        boolean noVal = true;
        NumberFormat nf = this.type == Permanent.PropTypeEnum.Geo ? geoFormat : numberFormat;
        for (Double val : values) {
            result = result + sep;
            if (val != null) {
                result = result + nf.format(val).replace(",", ".");
                noVal = false;
            }
            sep = "|";
        }
        if (noVal) {
            return null;
        }
        return result;
    }

    public static final Double[] string2tab(String sValue, int nbVal) {
        if (nbVal < 1 || sValue == null || sValue == PropMix || sValue.isEmpty()) {
            return null;
        }
        String[] tmp = sValue.split("\\|");
        if (tmp.length < 1) {
            return null;
        }
        if (tmp.length > nbVal) {
            System.err.println("coucou probl\u00c3\u00a8me de m\u00c3\u00a9tamorphose : " + tmp.length + " != " + nbVal + "\n");
        }
        Double[] values = new Double[nbVal];
        for (int i = 0; i < nbVal && i < tmp.length; ++i) {
            if ("?".equals(tmp[i])) {
                values[i] = DoubleMix;
                continue;
            }
            if (tmp[i] == null || tmp[i].isEmpty()) continue;
            values[i] = Double.parseDouble(tmp[i].replace(",", "."));
        }
        return values;
    }

    public void setValue(String value) {
        if (value == null || value.isEmpty()) {
            value = null;
        }
        this.sValue = value;
        switch (this.getTypeToken()) {
            case Icon: 
            case Image: 
            case Enum: 
            case Building: 
            case Text: 
            case Article: 
            case City: {
                break;
            }
            case Number: 
            case Geo: 
            case Square: 
            case Cube: {
                this.sValueChange();
                break;
            }
            default: {
                System.err.println("coucou unknowed type:" + (Object)((Object)this.getTypeToken()));
            }
        }
    }

    public void setThetaDegree(double thetaDegree) {
        if (this.nbVal != 3) {
            System.err.println("coucou Prop.setThetaDegree: not cube!");
        }
        if (thetaDegree > 360.0 || thetaDegree < -360.0) {
            thetaDegree -= (double)((long)thetaDegree / 360L * 360L);
        }
        try {
            this.values[2] = thetaDegree;
        }
        catch (Exception e) {
            this.values = new Double[]{null, null, thetaDegree};
        }
        this.valuesChange();
    }

    public void setAngle(double angle) {
        if (this.nbVal != 1) {
            System.err.println("coucou Prop.setAngle: not number!");
        }
        try {
            this.values[0] = angle;
        }
        catch (Exception e) {
            this.values = new Double[]{angle};
        }
        this.valuesChange();
    }

    public void setLength(double length) {
        try {
            this.values[0] = length;
        }
        catch (Exception e) {
            this.values = new Double[]{length};
        }
        this.valuesChange();
    }

    public void setSize(DimensionDouble size) {
        if (this.nbVal != 3) {
            System.err.println("coucou Prop.setSize: not cube!");
        }
        try {
            this.values[0] = size.getWidth();
            this.values[1] = size.getHeight();
        }
        catch (Exception e) {
            this.values = new Double[]{size.getWidth(), size.getHeight(), null};
        }
        this.valuesChange();
    }

    public void setPosition(Point2D pos) {
        if (this.nbVal != 3) {
            System.err.println("coucou Prop.setPosition: not cube!");
        }
        try {
            this.values[0] = pos.getX();
            this.values[1] = pos.getY();
        }
        catch (Exception e) {
            this.values = new Double[]{pos.getX(), pos.getY(), null};
        }
        this.valuesChange();
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + this.name + " " + this.sValue + " " + this.rank;
    }

    static {
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setGroupingUsed(false);
        geoFormat.setMinimumFractionDigits(6);
        geoFormat.setGroupingUsed(false);
        propComparator = new Comparator<Prop>(){

            @Override
            public int compare(Prop o1, Prop o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1.rank != null && o2.rank != null) {
                    return o1.rank - o2.rank;
                }
                if (o1.rank == null && o2.rank == null) {
                    return o1.name.compareTo(o2.name);
                }
                return o1.rank == null ? 1 : -1;
            }
        };
    }
}

