/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.Editable;
import adecWatt.model.Item;
import adecWatt.model.Permanent;
import adecWatt.model.unit.NonWorkspace;
import adecWatt.model.unit.Workspace;
import adecWatt.model.xml.XmlSegm;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import misc.DimensionDouble;

public class Segm
extends Item<XmlSegm, Permanent.SegmTypeEnum, Permanent.SegmAttrEnum> {
    public static float[] plain = null;
    public static float[] dot = new float[]{1.0f, 1.0f};
    public static float[] dash = new float[]{3.0f, 3.0f};
    public static float[] dashdot = new float[]{3.0f, 4.0f, 1.0f, 4.0f};
    public static float[] dashdotdot = new float[]{3.0f, 4.0f, 1.0f, 1.0f, 1.0f, 4.0f};

    @Override
    public Collection<String> getModifiersSet() {
        return SegmModifiersSet;
    }

    @Override
    public Permanent.SegmTypeEnum getTypeToken() {
        return Permanent.SegmTypeEnum.Segment;
    }

    @Override
    public Permanent.SegmAttrEnum getNameToken() {
        return Permanent.SegmAttrEnum.Name;
    }

    @Override
    public Permanent.SegmAttrEnum getModifierToken() {
        return Permanent.SegmAttrEnum.Modifier;
    }

    @Override
    public Permanent.SegmAttrEnum getPlaceIdToken() {
        return Permanent.SegmAttrEnum.Placeid;
    }

    @Override
    public Permanent.SegmAttrEnum getModelToken() {
        return Permanent.SegmAttrEnum.Model;
    }

    @Override
    public Workspace getStoryUnit() {
        return (Workspace)this.container;
    }

    public Segm getLink(Editable<?, ?, ?, ?> workspace) {
        return new Segm(this.name, this.placeId, (Workspace)workspace, this.model);
    }

    public Segm(Workspace workspace, XmlSegm xmlSegm) {
        super(workspace, xmlSegm);
    }

    public Segm(String name, String placeName, Workspace workspace, NonWorkspace model) {
        super(name, placeName, workspace, model);
    }

    public Segm(Workspace workspace, NonWorkspace model) {
        super((String)null, (String)null, workspace, model);
    }

    @Override
    public Segm clone(Workspace workspace) {
        Segm result = new Segm(workspace, this.model);
        result.importFrom(this);
        return result;
    }

    @Override
    public DimensionDouble getSize() {
        return new DimensionDouble(this.getLength(), Math.max(this.getWidth(), this.getLabelSize()));
    }

    @Override
    public double getThetaDegree() {
        return this.getAngle();
    }

    @Override
    public void changeThetaDegree(double thetaDegree) {
        if (this.isSticky()) {
            return;
        }
        this.getLocalProp("angle", Permanent.PropTypeEnum.Number).setAngle(thetaDegree);
    }

    @Override
    public void changeSize(DimensionDouble size) {
        if (this.isSticky()) {
            return;
        }
        this.getLocalProp("length", Permanent.PropTypeEnum.Number).setLength(size.width);
    }

    @Override
    public void print(Graphics2D printGraphics, Workspace workspace, String plugId) {
        this.print(printGraphics, workspace, this.getPos(), new DimensionDouble(this.getLength(), this.getWidth()), this.getAngle());
    }

    @Override
    public void print(Graphics2D printGraphics, Workspace workspace, Point2D pos, DimensionDouble size, double thetaDegree) {
        double length = size.width;
        float width = (float)this.getWidth();
        Color color = this.getColor();
        Workspace.printLine(printGraphics, color, Segm.createStroke(this.getStyle(), width), pos, length, thetaDegree, Segm.createArrowStroke(width), Segm.createEnd(this.getBegin(), width), Segm.createEnd(this.getEnd(), width));
        Workspace.printText(printGraphics, this.getLabel(), this.getLabelColor(), pos, this.getSize(), thetaDegree);
    }

    public static float[] createScaleStyle(float[] tab, double width) {
        if (tab == null || width == 1.0) {
            return tab;
        }
        float[] result = new float[tab.length];
        for (int i = 0; i < tab.length; ++i) {
            result[i] = (float)((double)tab[i] * width);
        }
        return result;
    }

    public static float[] createStyleStroke(String style, double width) {
        try {
            switch (style) {
                case "dot": {
                    return Segm.createScaleStyle(dot, width);
                }
                case "dash": {
                    return Segm.createScaleStyle(dash, width);
                }
                case "dashdot": {
                    return Segm.createScaleStyle(dashdot, width);
                }
                case "dashdotdot": {
                    return Segm.createScaleStyle(dashdotdot, width);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Stroke createStroke(String style, float width) {
        return new BasicStroke(width, 0, 1, 1.0f, Segm.createStyleStroke(style, width), 0.0f);
    }

    public static Shape createEnd(String style, float width) {
        try {
            switch (style) {
                case "arrow": {
                    return Segm.createArrow(width);
                }
                case "dot": {
                    return Segm.createDot(width);
                }
                case "square": {
                    return Segm.createSquare(width);
                }
                case "stop": {
                    return Segm.createStop(width);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Stroke createArrowStroke(float width) {
        return new BasicStroke(width, 2, 0);
    }

    public static Shape createArrow(double width) {
        double barb = 4.0 * width;
        double angle = Math.toRadians(20.0);
        Path2D.Double path = new Path2D.Double();
        double x = -barb * Math.cos(angle);
        double y = barb * Math.sin(angle);
        path.moveTo(0.0, 0.0);
        path.lineTo(x, y);
        path.lineTo(-3.0 * width, 0.0);
        x = -barb * Math.cos(-angle);
        y = barb * Math.sin(-angle);
        path.lineTo(x, y);
        path.closePath();
        return path;
    }

    public static Shape createStop(double width) {
        double barb = 3.0 * width;
        Path2D.Double path = new Path2D.Double();
        path.moveTo(0.0, barb);
        path.lineTo(0.0, -barb);
        return path;
    }

    public static Shape createDot(double width) {
        double barb = 2.0 * width;
        return new Ellipse2D.Double(-width, -width, barb, barb);
    }

    public static Shape createSquare(double width) {
        double barb = 2.0 * width;
        return new Rectangle2D.Double(-width, -width, barb, barb);
    }
}

