/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.PermanentDB;
import adecWatt.model.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import misc.Config;
import misc.Log;
import misc.Util;

public class TagDB {
    public static final String lpiExtention = "lpi";
    private TreeSet<String> words = new TreeSet();
    private String dir;
    public ImgTag imgTag = new ImgTag();
    protected ImgTag[] localRemoteTag = new ImgTag[]{new ImgTag(), new ImgTag()};

    public static final File[] getLpiFiles(File dir) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                try {
                    return file.isFile() && !file.isHidden() && TagDB.lpiExtention.equals(Util.getExtention(file).toLowerCase());
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }

    public TagDB(String dir) {
        this.dir = dir;
    }

    public void reload() {
        this.words.clear();
        this.imgTag.clear();
        try {
            for (int i = 0; i < PermanentDB.localRemoteDir.size(); ++i) {
                this.localRemoteTag[i].clear();
                File tmpDir = new File(PermanentDB.dataDir, PermanentDB.localRemoteDir.get(i) + Config.FS + this.dir);
                if (!tmpDir.isDirectory()) continue;
                for (File file : TagDB.getLpiFiles(tmpDir)) {
                    this.localRemoteTag[i].readLpi(file);
                }
            }
            this.localRemoteTag[0].clean(this.localRemoteTag[1]);
            this.imgTag.merge(this.localRemoteTag[1]);
            this.imgTag.merge(this.localRemoteTag[0]);
        }
        catch (Exception e) {
            Log.keepLastException("ImageDB::reload", e);
        }
    }

    public Collection<String> getTags(String imageName) {
        return this.imgTag.getTags(imageName);
    }

    public void putTags(String imageName, Collection<String> imageTags) {
        if (!this.imgTag.addTags(imageName, imageTags)) {
            return;
        }
        try {
            if (new TreeSet<String>(imageTags).equals(this.localRemoteTag[1].getTags(imageName))) {
                this.localRemoteTag[0].addTags(imageName, null);
            } else {
                this.localRemoteTag[0].addTags(imageName, imageTags);
            }
            this.localRemoteTag[0].writeLpi("local", User.splitId(imageName)[0]);
        }
        catch (Exception e) {
            Log.keepLastException("ImageDB::putTags", e);
        }
    }

    public void promote(Collection<String> imageNames) {
        if (imageNames == null) {
            return;
        }
        TreeSet<Integer> ownerIds = new TreeSet<Integer>();
        for (String imageName : imageNames) {
            Collection<String> imageTags = this.localRemoteTag[0].getTags(imageName);
            if (imageTags == null) continue;
            this.localRemoteTag[1].addTags(imageName, imageTags);
            this.localRemoteTag[0].addTags(imageName, null);
            ownerIds.add(User.splitId(imageName)[0]);
        }
        Iterator<String> iterator = ownerIds.iterator();
        while (iterator.hasNext()) {
            int ownerId = (Integer)((Object)iterator.next());
            this.localRemoteTag[1].writeLpi("server", ownerId);
            this.localRemoteTag[0].writeLpi("local", ownerId);
        }
    }

    public void renameImages(TreeMap<String, String> translateMap) {
        for (int i = 0; i < PermanentDB.localRemoteDir.size(); ++i) {
            TreeSet<Integer> ownerIds = new TreeSet<Integer>();
            for (String oldImageName : translateMap.keySet()) {
                Collection<String> imageTags = this.localRemoteTag[i].getTags(oldImageName);
                if (imageTags == null) continue;
                String newImageName = translateMap.get(oldImageName);
                this.localRemoteTag[i].addTags(newImageName, imageTags);
                this.localRemoteTag[i].addTags(oldImageName, null);
                ownerIds.add(User.splitId(oldImageName)[0]);
                ownerIds.add(User.splitId(newImageName)[0]);
            }
            Iterator<String> iterator = ownerIds.iterator();
            while (iterator.hasNext()) {
                int ownerId = (Integer)((Object)iterator.next());
                this.localRemoteTag[i].writeLpi(PermanentDB.localRemoteDir.get(i), ownerId);
            }
        }
    }

    public TreeSet<String> cloneImageTags(Collection<String> imageTags) {
        TreeSet<String> result = new TreeSet<String>();
        for (String word : imageTags) {
            result.add(this.getWord(word));
        }
        return result;
    }

    public String getWord(String word) {
        if (word == null) {
            return null;
        }
        String floor = this.words.floor(word = word.toLowerCase());
        if (floor != null && floor.equals(word)) {
            return floor;
        }
        this.words.add(word);
        return word;
    }

    public class ImgTag {
        TreeMap<Integer, TreeMap<Integer, TreeSet<String>>> ids = new TreeMap();

        public int size() {
            return this.ids.size();
        }

        public void clear() {
            this.ids.clear();
        }

        public void merge(ImgTag others) {
            for (int ownerId : others.ids.keySet()) {
                TreeMap<Integer, TreeSet<String>> refImg = others.ids.get(ownerId);
                TreeMap<Integer, TreeSet<String>> idsImg = this.ids.get(ownerId);
                if (idsImg == null) {
                    idsImg = new TreeMap();
                    this.ids.put(ownerId, idsImg);
                }
                for (int imageId : refImg.keySet()) {
                    idsImg.put(imageId, TagDB.this.cloneImageTags((Collection<String>)refImg.get(imageId)));
                }
            }
        }

        public void clean(ImgTag ref) {
            for (int ownerId : this.ids.keySet()) {
                TreeMap<Integer, TreeSet<String>> refImg = ref.get(ownerId);
                if (refImg == null) continue;
                TreeMap<Integer, TreeSet<String>> idsImg = this.ids.get(ownerId);
                TreeSet<Integer> imgToRemove = new TreeSet<Integer>();
                for (int imageName : idsImg.keySet()) {
                    TreeSet<String> refNames = refImg.get(imageName);
                    if (refNames == null || !refNames.equals(idsImg.get(imageName))) continue;
                    imgToRemove.add(imageName);
                }
                if (imgToRemove.size() <= 0) continue;
                for (int imageName : imgToRemove) {
                    idsImg.remove(imageName);
                }
                this.writeLpi("local", ownerId);
            }
        }

        public void addTags(String line) {
            if (line == null || line.startsWith("#") || line.isEmpty()) {
                return;
            }
            int sepIdx = line.indexOf(":");
            String imageName = line.substring(0, sepIdx);
            String[] arg = line.substring(sepIdx + 1).split(":");
            this.addTags(imageName, Arrays.asList(arg));
        }

        public boolean addTags(String imageName, Collection<String> imageTags) {
            int[] w = User.splitId(imageName);
            int ownerId = w[0];
            int imgId = w[1];
            TreeSet<String> oldValues = null;
            try {
                oldValues = this.ids.get(ownerId).get(imgId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (imageTags == null || imageTags.size() == 0) {
                if (oldValues == null || oldValues.size() == 0) {
                    return false;
                }
                TreeMap<Integer, TreeSet<String>> custumBD = this.ids.get(ownerId);
                custumBD.remove(imgId);
                if (custumBD.size() == 0) {
                    this.ids.remove(ownerId);
                }
                return true;
            }
            if (imageTags.equals(oldValues)) {
                return false;
            }
            TreeMap<Integer, TreeSet<String>> custumBD = this.ids.get(ownerId);
            if (custumBD == null) {
                custumBD = new TreeMap();
                this.ids.put(ownerId, custumBD);
            }
            custumBD.put(imgId, TagDB.this.cloneImageTags(imageTags));
            return true;
        }

        public TreeMap<Integer, TreeSet<String>> get(int ownerId) {
            try {
                return this.ids.get(ownerId);
            }
            catch (Exception e) {
                return null;
            }
        }

        public Collection<String> getTags(String imageName) {
            try {
                int[] w = User.splitId(imageName);
                return this.ids.get(w[0]).get(w[1]);
            }
            catch (Exception e) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readLpi(File file) {
            int lineNb = 0;
            String line = null;
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                while (true) {
                    ++lineNb;
                    line = in.readLine();
                    if (line == null) {
                        break;
                    }
                    this.addTags(line);
                }
            }
            catch (Exception e) {
                Log.keepLastException("ImageDB::readLpi: " + file + ":" + lineNb + " <" + line + ">", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeLpi(String placeToken, int ownerId) {
            File file = new File(PermanentDB.dataDir, String.format("%s%03d.%s", placeToken + Config.FS + TagDB.this.dir + Config.FS, ownerId, TagDB.lpiExtention));
            Util.backup(file, TagDB.lpiExtention, "back");
            TreeMap<Integer, TreeSet<String>> custumBD = this.get(ownerId);
            if (custumBD == null || custumBD.size() < 1) {
                return;
            }
            file.getParentFile().mkdirs();
            file.setExecutable(false);
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileWriter(file));
                for (int imageId : custumBD.keySet()) {
                    TreeSet<String> imageTags = custumBD.get(imageId);
                    if (imageTags.size() < 1) continue;
                    out.print(User.getDataId(ownerId, imageId));
                    for (String tag : imageTags) {
                        out.print(":" + tag);
                    }
                    out.println();
                }
            }
            catch (Exception e) {
                Log.keepLastException("ImageDB::writeLpi", e);
            }
            finally {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

