/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.AdecWatt;
import adecWatt.model.Editable;
import adecWatt.model.Embedded;
import adecWatt.model.Permanent;
import adecWatt.model.PermanentDB;
import adecWatt.model.Prop;
import adecWatt.model.UnitNode;
import adecWatt.model.unit.Accessory;
import adecWatt.model.unit.Building;
import adecWatt.model.unit.Furniture;
import adecWatt.model.unit.Information;
import adecWatt.model.unit.Lightplot;
import adecWatt.model.unit.Line;
import adecWatt.model.xml.XmlUnit;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import misc.Bundle;
import misc.Config;
import misc.StateNotifier;
import misc.Story;
import misc.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Unit<E extends Embedded<?, ?, ?, ?, ?>>
extends Editable<XmlUnit, Permanent.UnitTypeEnum, Permanent.UnitAttrEnum, E> {
    public static final String BroadcastChangeBuilding = "ChangeBuilding";
    public static final String BroadcastChangePos = "ChangePos";
    public static final String BroadcastChangeRot = "ChangeRot";
    public static final String BroadcastChangeRotSize = "ChangeRotSize";
    public static final String BroadcastConnection = "Connection";
    public static final String BroadcastNewItem = "NewItem";
    public static final String BroadcastRemoveItem = "RemoveItem";
    public static final String BroadcastSetSelectionItems = "SetSelectionItems";
    public static final String BroadcastUpdateItem = "UpdateItem";
    public static final String BroadcastUpdatePermItem = "UpdatePermItem";
    PermanentDB.UnitLocation location;
    protected String id;
    protected File file;
    protected AdecWatt adecWatt;
    protected UnitNode<E> unitNode;
    private Permanent.UnitTypeEnum type;
    public StateNotifier stateNotifier = new StateNotifier();
    public Story story = new Story(this.stateNotifier);

    @Override
    public Collection<String> getModifiersSet() {
        return UnitModifiersSet;
    }

    @Override
    public Permanent.UnitTypeEnum getTypeToken() {
        return this.type;
    }

    public static Permanent.UnitAttrEnum getIdToken() {
        return Permanent.UnitAttrEnum.Id;
    }

    @Override
    public Permanent.UnitAttrEnum getNameToken() {
        return Permanent.UnitAttrEnum.Name;
    }

    @Override
    public Permanent.UnitAttrEnum getModifierToken() {
        return Permanent.UnitAttrEnum.Modifier;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getFileName() {
        return this.id + "." + "lpt";
    }

    public String getSaveDir() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    public PermanentDB.UnitLocation getLocation() {
        return this.location;
    }

    public boolean getRemote() {
        return this.location == PermanentDB.UnitLocation.Server;
    }

    @Override
    public AdecWatt getAdecWatt() {
        return this.adecWatt;
    }

    public Unit<E> getUnitRoot() {
        return ((UnitNode)this.unitNode.getRoot()).getUnit();
    }

    public UnitNode<E> getUnitNode() {
        return this.unitNode;
    }

    @Override
    public Unit<E> getDirectUnit() {
        return this;
    }

    @Override
    public Unit<E> getParentUnit() {
        return this.getParent();
    }

    @Override
    public Unit<E> getStoryUnit() {
        return this;
    }

    @Override
    public Editable<?, ?, ?, ?> getModel() {
        return null;
    }

    public Unit<E> getParent() {
        UnitNode parentNode = (UnitNode)this.unitNode.getParent();
        return parentNode == null ? null : parentNode.getUnit();
    }

    public ArrayList<Unit<E>> getChildren() {
        ArrayList result = new ArrayList();
        Enumeration<TreeNode> e = this.unitNode.children();
        while (e.hasMoreElements()) {
            result.add(((UnitNode)e.nextElement()).getUnit());
        }
        return result;
    }

    public boolean isDescendingFrom(String unitId) {
        if (unitId == null || unitId.isEmpty()) {
            return false;
        }
        Unit current = this;
        while (!unitId.equals(current.getId())) {
            UnitNode parent = (UnitNode)current.unitNode.getParent();
            if (parent == null) {
                return false;
            }
            current = parent.getUnit();
        }
        return true;
    }

    public ArrayList<Unit<E>> getAvailablePermanents(boolean isEmbedded, Editable<?, ?, ?, ?> editable) {
        ArrayList result = new ArrayList();
        Enumeration<TreeNode> e = ((UnitNode)this.unitNode.getRoot()).breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            Unit unit = ((UnitNode)e.nextElement()).getUnit();
            if (isEmbedded ? unit.isUncompleted(editable) : unit.getUnitNode().isNodeAncestor(this.unitNode) || unit == editable) continue;
            result.add(unit);
        }
        return result;
    }

    public boolean isUncompleted(Editable<?, ?, ?, ?> editable) {
        for (String propName : this.getOrderedPropsName()) {
            if (!Permanent.isModifier("mandatory", this.getPropModifiers(propName)) || this.getPropVal(propName) != null) continue;
            if (editable == null) {
                return true;
            }
            Prop prop = editable.getOwnProp(propName);
            if (prop != null && prop.sValue != null) continue;
            return true;
        }
        return false;
    }

    static final Unit<?> getInstanceFromStream(AdecWatt adecWatt, InputStream dataIn, File file, PermanentDB.UnitLocation location) {
        XmlUnit xmlUnit = PermanentDB.readXmlUnit(dataIn);
        String id = xmlUnit.getFacet(Unit.getIdToken());
        adecWatt.getUser().updateDataId(id);
        Unit<?> result = Unit.getInstance(adecWatt, (Permanent.UnitTypeEnum)xmlUnit.type, id);
        result.location = location;
        result.file = file;
        result.initXml(xmlUnit);
        return result;
    }

    public void getCopy(String name) {
        if (this.getParent() == null) {
            return;
        }
        Unit<?> result = Unit.getInstance(this.adecWatt, (Permanent.UnitTypeEnum)((XmlUnit)this.xmlPermanent).type, null);
        result.name = name;
        result.importFrom(this);
        this.adecWatt.getPermanentDB().add(result);
        this.adecWatt.broadcastDisplay("UpdateUnitTree", result.getParent());
    }

    public void getNewChild(String name) {
        Unit<?> result = Unit.getInstance(this.adecWatt, this.type, null);
        result.initChild(this, name);
        this.adecWatt.getPermanentDB().add(result);
        this.updateTree();
    }

    private static final Unit<?> getInstance(AdecWatt adecWatt, Permanent.UnitTypeEnum type, String id) {
        switch (type) {
            case Furniture: {
                return new Furniture(adecWatt, id);
            }
            case Information: {
                return new Information(adecWatt, id);
            }
            case Line: {
                return new Line(adecWatt, id);
            }
            case Accessory: {
                return new Accessory(adecWatt, id);
            }
            case Building: {
                return new Building(adecWatt, id);
            }
            case Lightplot: {
                return new Lightplot(adecWatt, id);
            }
        }
        throw new IllegalArgumentException("Can't find constructor for type (" + (Object)((Object)type) + ").");
    }

    protected Unit(AdecWatt adecWatt, String id) {
        this.adecWatt = adecWatt;
        if (id == null) {
            id = adecWatt.getUser().getDataId();
        }
        this.id = id;
        this.unitNode = new UnitNode(this);
        Bundle.addBundleObserver(this);
    }

    @Override
    protected void initXml(XmlUnit xmlUnit) {
        super.initXml(xmlUnit);
        if (this.name == null) {
            throw new IllegalArgumentException("Unknown XML unit has no name (" + this.xmlPermanent + ").");
        }
        this.type = (Permanent.UnitTypeEnum)xmlUnit.type;
    }

    protected void importFrom(Unit<E> from) {
        super.importFrom(from);
        this.location = PermanentDB.UnitLocation.Local;
        this.type = from.type;
        this.story.markNotSaved();
        Editable parent = from.getParent();
        if (parent != null) {
            ((Unit)parent).unitNode.add(this.unitNode);
        }
    }

    protected void initChild(Unit<?> unit, String name) {
        this.location = PermanentDB.UnitLocation.Local;
        this.type = unit.type;
        this.modifiers = unit.modifiers == null || unit.modifiers.size() < 1 ? null : new TreeSet(unit.modifiers);
        this.name = name;
        this.story.markNotSaved();
        unit.unitNode.add(this.unitNode);
    }

    public void updateXmlParent() {
        if (this.getParent() != null) {
            return;
        }
        String parentId = ((XmlUnit)this.xmlPermanent).getFacet(Permanent.UnitAttrEnum.Parent);
        if (parentId == null) {
            this.adecWatt.getPermanentDB().namedRoots.put(this.getName(), this);
            return;
        }
        Unit<?> parent = this.adecWatt.getPermanentDB().getUnitById(parentId);
        if (parent == null) {
            System.err.println("XXX Unit:updateXmlParent: " + parentId + " not loaded !");
            return;
        }
        parent.unitNode.add(this.unitNode);
        this.collectEmbedded();
    }

    public TreePath getPath() {
        ArrayList<UnitNode<E>> path = new ArrayList<UnitNode<E>>();
        for (Editable unit = this; unit != null; unit = unit.getParent()) {
            path.add(0, unit.unitNode);
        }
        return new TreePath(path.toArray());
    }

    public ArrayList<Unit<E>> search(String text) {
        ArrayList result = new ArrayList();
        Enumeration<TreeNode> e = ((UnitNode)this.unitNode.getRoot()).breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            Unit unit = ((UnitNode)e.nextElement()).getUnit();
            if (!unit.match(text)) continue;
            result.add(unit);
        }
        return result;
    }

    public void enableStory() {
        this.stateNotifier.addUpdateObserver(this.adecWatt, "Story");
    }

    public void disableStory() {
        this.stateNotifier.removeObserver(this.adecWatt);
    }

    public void replace(Unit<?> newUnit) {
        Editable parent = this.getParent();
        this.adecWatt.getPermanentDB().add(newUnit);
        if (parent != null) {
            ((Unit)parent).unitNode.remove(this.unitNode);
        }
        for (Unit<E> child : this.getChildren()) {
            newUnit.unitNode.add(child.unitNode);
        }
        this.adecWatt.broadcastDisplay("UnitStory", newUnit);
    }

    public void findPromote(HashSet<Unit<?>> unitLinks, TreeSet<String> iconsLinks, TreeSet<String> imagesLinks) {
        unitLinks.add(this);
        this.getLocalLink(new HashSet(), unitLinks, iconsLinks, imagesLinks);
    }

    public void changeId(String newId) {
        this.id = newId;
        this.story.markNotSaved();
    }

    public void remove() {
        PermanentDB permanentDB = this.adecWatt.getPermanentDB();
        Unit<?> newUnit = null;
        Editable parent = this.getParent();
        switch (this.location) {
            case Server: {
                return;
            }
            case Local: {
                permanentDB.remove(this);
                break;
            }
            case Zip: {
                permanentDB.forget(this);
            }
        }
        newUnit = permanentDB.reload(this);
        if (newUnit != null) {
            this.replace(newUnit);
            newUnit.updateXmlParent();
            if (parent != null) {
                this.adecWatt.broadcastDisplay("UpdateUnitTree", parent);
            } else {
                this.adecWatt.broadcastUpdate("UnitRoots");
            }
            this.updateView();
            return;
        }
        ((Unit)parent).unitNode.remove(this.unitNode);
        this.adecWatt.broadcastDisplay("UpdateUnitTree", parent);
    }

    public void updateBundle() {
    }

    @Override
    public void getLocalLink(HashSet<Editable<?, ?, ?, ?>> visited, HashSet<Unit<?>> unitLinks, TreeSet<String> iconsLinks, TreeSet<String> imagesLinks) {
        Editable parent;
        if (visited.contains(this)) {
            return;
        }
        super.getLocalLink(visited, unitLinks, iconsLinks, imagesLinks);
        if (!this.getRemote() || this.story.isModified()) {
            unitLinks.add(this);
        }
        if ((parent = this.getParent()) == null) {
            return;
        }
        ((Unit)parent).getLocalLink(visited, unitLinks, iconsLinks, imagesLinks);
    }

    public void save() {
        File file = PermanentDB.getLocalFile(this.getSaveDir() + Config.FS + this.getFileName());
        PermanentDB.writeUnit(this, file);
        this.location = PermanentDB.UnitLocation.Local;
        this.file = file;
        this.story.markSaved();
    }

    public void promote() {
        String fileName = this.getSaveDir() + Config.FS + this.getFileName();
        Util.backup(PermanentDB.getLocalFile(fileName), "lpt", "back");
        File remotefile = PermanentDB.getRemoteFile(fileName);
        PermanentDB.writeUnit(this, remotefile);
        this.file = remotefile;
        this.location = PermanentDB.UnitLocation.Server;
        this.story.markSaved();
    }

    @Override
    public Element getXml(Node parentXml, Document document) {
        Element child = super.getXml(parentXml, document);
        XmlUnit.putFacet(child, Permanent.UnitAttrEnum.Id, this.id);
        Editable parent = this.getParent();
        if (parent != null) {
            XmlUnit.putFacet(child, Permanent.UnitAttrEnum.Parent, ((Unit)parent).id);
        }
        return child;
    }

    @Override
    public void setParentUnit(Unit<?> parent) {
        UnitNode oldParentNode = (UnitNode)this.unitNode.getParent();
        if (oldParentNode == null || parent == null || oldParentNode == parent.unitNode) {
            return;
        }
        oldParentNode.remove(this.unitNode);
        parent.unitNode.add(this.unitNode);
    }

    public void updateTree() {
        this.adecWatt.broadcastDisplay("UpdateUnitTree", this);
    }

    @Override
    public void storyChange(Story.Commands commands, ArrayList<Prop[]> changeProps) {
        this.storyChange(commands, false, this.ownProps, changeProps);
    }

    @Override
    public void storyTransform(Story.Commands commands, Collection<String> modifiers, Unit<?> parent, String newName, ArrayList<Prop[]> transProps) {
        this.storyTransform(commands, newName, modifiers, parent, this.ownProps, transProps);
    }

    public String toString() {
        return this.getLocalName();
    }
}

