/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model;

import adecWatt.model.Permanent;
import adecWatt.model.Unit;
import java.util.HashSet;
import java.util.Hashtable;
import misc.Config;
import misc.StateNotifier;
import misc.Util;

public class User
extends StateNotifier {
    public static final int serverId = 0;
    public static final int visitorId = 1;
    public static final String BroadcastUserChangeProfil = "UserChangeProfil";
    public boolean connected = false;
    private String login;
    private String password;
    private int currentId;
    private int userId;
    private Hashtable<Integer, Integer> maxIds = new Hashtable();
    private HashSet<Role> roles = new HashSet();

    public static int updateRoles(HashSet<Role> roles, String rolesLine) {
        roles.clear();
        roles.add(Role.Visitor);
        try {
            String[] tokens = rolesLine.split("\\|");
            String id = tokens[0];
            for (String token : tokens = tokens[1].split(",")) {
                try {
                    roles.add(Role.valueOf(Role.class, token));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return Integer.parseInt(id);
        }
        catch (Exception e) {
            return 1;
        }
    }

    public HashSet<Role> getRoles() {
        return new HashSet<Role>(this.roles);
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public int getUserId() {
        return this.userId;
    }

    public boolean isVisitorId() {
        return this.userId == 1;
    }

    public boolean hasRole(Role ... someRoles) {
        for (Role role : someRoles) {
            if (!this.roles.contains((Object)role)) continue;
            return true;
        }
        return false;
    }

    public boolean isAdmin() {
        return this.hasRole(Role.Yoda);
    }

    public boolean isLinguist() {
        return this.hasRole(Role.Linguist) || this.isAdmin();
    }

    public boolean isDataStructuresManager() {
        return this.hasRole(Role.DataStructuresManager) || this.isAdmin();
    }

    public boolean isDataManager() {
        return this.hasRole(Role.DataManager) || this.isAdmin();
    }

    public boolean isEditor() {
        return this.hasRole(Role.StageManager) || this.hasRole(Role.Architect) || this.hasRole(Role.FurnitureManager) || this.isAdmin();
    }

    public boolean isEditor(Unit<?> unit) {
        try {
            if (this.isAdmin()) {
                return true;
            }
            switch (Permanent.UnitTypeEnum.valueOf(Permanent.UnitTypeEnum.class, Util.toCapital(unit.getUnitRoot().getName()))) {
                case Lightplot: {
                    return this.hasRole(Role.StageManager);
                }
                case Furniture: 
                case Information: 
                case Line: 
                case Accessory: {
                    return this.hasRole(Role.FurnitureManager);
                }
                case Building: {
                    return this.hasRole(Role.Architect);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void getConfig(Role role) {
        if (Config.getBoolean("Role" + (Object)((Object)role), false)) {
            this.roles.add(role);
        }
    }

    private void setConfig(Role role) {
        Config.setBoolean("Role" + (Object)((Object)role), this.roles.contains((Object)role));
    }

    public User() {
        this.currentId = this.userId = Config.getInt("UserId", 1);
        this.login = Config.getString("Login", "");
        this.roles.add(Role.Visitor);
        this.getConfig(Role.StageManager);
        this.getConfig(Role.Architect);
        this.getConfig(Role.FurnitureManager);
    }

    public void setLogin(String login) {
        this.login = login;
        Config.setString("Login", this.login);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRoles(HashSet<Role> roles) {
        this.roles = new HashSet<Role>(roles);
        this.roles.add(Role.Visitor);
        this.currentId = this.isDataManager() ? 0 : this.userId;
        this.setConfig(Role.StageManager);
        this.setConfig(Role.Architect);
        this.setConfig(Role.FurnitureManager);
        this.broadcastUpdate(BroadcastUserChangeProfil);
    }

    public void setUserId(int userId) {
        this.userId = userId;
        Config.setInt("UserId", userId);
        this.currentId = this.isDataManager() ? 0 : userId;
    }

    public static String getDataId(int ownerId, int serialId) {
        return String.format("%03d-%04d", ownerId, serialId);
    }

    public static int[] splitId(String id) {
        try {
            if (id == null) {
                return null;
            }
            int sepIdx = id.indexOf("-");
            int ownerId = Integer.parseInt(id.substring(0, sepIdx));
            int extIdx = id.indexOf(".", sepIdx);
            int value = Integer.parseInt(extIdx > 0 ? id.substring(sepIdx + 1, extIdx) : id.substring(sepIdx + 1));
            return new int[]{ownerId, value};
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDataId() {
        int maxId = 0;
        try {
            maxId = this.maxIds.get(this.currentId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.maxIds.put(this.currentId, ++maxId);
        return User.getDataId(this.currentId, maxId);
    }

    public void updateDataId(String id) {
        int[] ids = User.splitId(id);
        if (ids == null) {
            return;
        }
        int ownerId = ids[0];
        int value = ids[1];
        int maxId = 0;
        try {
            maxId = this.maxIds.get(ownerId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value > maxId) {
            this.maxIds.put(ownerId, value);
        }
    }

    public static enum Role {
        Visitor,
        StageManager,
        Architect,
        FurnitureManager,
        Linguist,
        DataStructuresManager,
        DataManager,
        Yoda;

    }
}

