/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model.unit;

import adecWatt.model.AdecWatt;
import adecWatt.model.Item;
import adecWatt.model.unit.Building;
import adecWatt.model.unit.Workspace;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Objects;
import misc.DimensionDouble;
import misc.ScaledImage;
import misc.Story;

public class Lightplot
extends Workspace {
    public Building getPattern() {
        return this.getBuilding();
    }

    @Override
    public DimensionDouble getRealSize() {
        return this.getBuilding().getSize();
    }

    @Override
    public ScaledImage getBlueprint() {
        return this.getBuilding().getBlueprint();
    }

    @Override
    public DimensionDouble getBlueprintSize() {
        return this.getBuilding().getBlueprintSize();
    }

    @Override
    public Point2D.Double getBlueprintPos() {
        return this.getBuilding().getBlueprintPos();
    }

    @Override
    public Double getBlueprintVisibility() {
        return this.getBuilding().getBlueprintVisibility();
    }

    public Lightplot(AdecWatt adecWatt, String id) {
        super(adecWatt, id);
    }

    public void storyChangeBuilding(final Building building) {
        final Building oldBuilding = this.getBuilding();
        if (oldBuilding == building) {
            return;
        }
        final Hashtable<Item, Point2D.Double> oldPos = this.getOutsideItem(building);
        final Hashtable<Item, Point2D.Double> newPos = this.getMoveInsideItem(building, oldPos);
        Story story = this.story;
        Objects.requireNonNull(story);
        this.story.add(new Story.Command(story, "ChangeBuilding"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }

            @Override
            public void exec() {
                Lightplot.this.moveItem(newPos);
                Lightplot.this.changeBuilding(building);
            }

            @Override
            public void undo() {
                Lightplot.this.changeBuilding(oldBuilding);
                Lightplot.this.moveItem(oldPos);
            }

            @Override
            public void display() {
                Lightplot.this.stateNotifier.broadcastUpdate("ChangeBuilding");
                Lightplot.this.stateNotifier.broadcastDisplay("ChangePos", oldPos.keySet().toArray());
            }
        });
    }

    private void changeBuilding(Building building) {
        this.getProp("building").setValue(building.getId());
    }

    private void moveItem(Hashtable<Item, Point2D.Double> items) {
        for (Item item : items.keySet()) {
            item.changePos(items.get(item));
        }
    }

    public Hashtable<Item, Point2D.Double> getOutsideItem(Building building) {
        Hashtable<Item, Point2D.Double> result = new Hashtable<Item, Point2D.Double>();
        DimensionDouble size = building.getRealSize();
        for (Item item : this.getInheritedEmbeddedValues()) {
            if (!item.isPosOutside(size)) continue;
            result.put(item, item.getPos());
        }
        return result;
    }

    public Hashtable<Item, Point2D.Double> getMoveInsideItem(Building building, Hashtable<Item, Point2D.Double> oldPos) {
        Hashtable<Item, Point2D.Double> result = new Hashtable<Item, Point2D.Double>();
        DimensionDouble size = building.getRealSize();
        for (Item item : oldPos.keySet()) {
            result.put(item, Item.getPosInside(size, oldPos.get(item), item.getThetaDegree(), item.getSize()));
        }
        return result;
    }
}

