/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model.unit;

import adecWatt.model.Acc;
import adecWatt.model.AdecWatt;
import adecWatt.model.Circuits;
import adecWatt.model.Comp;
import adecWatt.model.Editable;
import adecWatt.model.Embedded;
import adecWatt.model.Item;
import adecWatt.model.Patch;
import adecWatt.model.Prop;
import adecWatt.model.Segm;
import adecWatt.model.Unit;
import adecWatt.model.unit.Accessory;
import adecWatt.model.unit.Building;
import adecWatt.model.unit.NonWorkspace;
import adecWatt.model.xml.XmlComp;
import adecWatt.model.xml.XmlSegm;
import adecWatt.model.xml.XmlUnit;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import misc.DimensionDouble;
import misc.ScaledImage;
import misc.Story;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Workspace
extends Unit<Item<?, ?, ?>> {
    private float buildingOpacity = 0.5f;
    private float hiddenOpacity = 0.15f;
    protected HashSet<Comp> plugedComps = new HashSet();
    protected Hashtable<String, Item> namedItems = new Hashtable();
    protected Vector<Item> allItems;
    protected Vector<double[]> allBounds;

    public void setOpacity(float buildingOpacity) {
        this.buildingOpacity = buildingOpacity;
    }

    public float getOpacity() {
        return this.buildingOpacity;
    }

    public Workspace(AdecWatt adecWatt, String id) {
        super(adecWatt, id);
    }

    @Override
    public void collectEmbedded() {
        if (this.xmlPermanent == null) {
            return;
        }
        super.collectEmbedded();
        ArrayList<Item> items = new ArrayList<Item>();
        for (XmlSegm xmlSegm : ((XmlUnit)this.xmlPermanent).getSegms()) {
            items.add(new Segm(this, xmlSegm));
        }
        for (XmlComp xmlComp : ((XmlUnit)this.xmlPermanent).getComps()) {
            items.add(new Comp(this, xmlComp));
        }
        for (Item item : items) {
            item.fixName(true);
        }
    }

    @Override
    public void updateView() {
        this.adecWatt.broadcastDisplay("UpdateWorkspace", this);
        this.updateTree();
    }

    public void updateConnection() {
        this.adecWatt.broadcastDisplay("Connection", this);
    }

    public void updateSelection(List<Item> items) {
        this.adecWatt.broadcastDisplay("SetSelectionItems", this, items);
    }

    public Story.Command getDoSelection(Item item) {
        return this.getDoSelection(Arrays.asList(item));
    }

    public Story.Command getDoSelection(final List<Item> items) {
        Story story = this.story;
        Objects.requireNonNull(story);
        return new Story.Command(story, "SelectItem"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }

            @Override
            public void exec() {
                Workspace.this.updateSelection(items);
            }

            @Override
            public void undo() {
            }
        };
    }

    public Story.Command getUndoSelection(Item item) {
        return this.getUndoSelection(Arrays.asList(item));
    }

    public Story.Command getUndoSelection(final List<Item> items) {
        Story story = this.story;
        Objects.requireNonNull(story);
        return new Story.Command(story, "SelectItem"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }

            @Override
            public void exec() {
            }

            @Override
            public void undo() {
                Workspace.this.updateSelection(items);
            }
        };
    }

    public void storyAddComp(NonWorkspace model, Point2D.Double pos) {
        Comp comp = new Comp(this, model);
        if (comp.isSticky()) {
            return;
        }
        this.storyAddItem(comp, pos);
    }

    public void storyAddSegm(NonWorkspace model, Point2D.Double pos) {
        Segm segm = new Segm(this, model);
        if (segm.isSticky()) {
            return;
        }
        this.storyAddItem(segm, pos);
    }

    public void storyAddItem(Item item, Point2D.Double pos) {
        item.changePos(pos);
        Story story = this.story;
        Objects.requireNonNull(story);
        Story.Commands commands = new Story.Commands(story, "AddItem"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }
        };
        commands.add(this.getUndoSelection((List<Item>)null));
        item.validateContainer(commands, "AddItem");
        commands.add(this.getDoSelection(item));
        this.story.add(commands);
    }

    public void storyCloneItem(Item ref, Point2D.Double pos) {
        if (ref.isSticky()) {
            return;
        }
        Item item = ref.clone(this);
        item.changePos(pos);
        Story story = this.story;
        Objects.requireNonNull(story);
        Story.Commands commands = new Story.Commands(story, "CloneItem"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }
        };
        commands.add(this.getUndoSelection(ref));
        item.validateContainer(commands, "CloneItem");
        commands.add(this.getDoSelection(item));
        this.story.add(commands);
    }

    public void storyPasteItem(Vector<Item> sItem) {
        if (sItem == null) {
            return;
        }
        Vector<Item> preSelection = new Vector<Item>(sItem.size());
        for (Item ref : sItem) {
            if (ref.isSticky()) continue;
            preSelection.add(ref);
        }
        if (preSelection.size() < 1) {
            return;
        }
        DimensionDouble size = this.getRealSize();
        Story story = this.story;
        Objects.requireNonNull(story);
        Story.Commands commands = new Story.Commands(story, "PasteItem"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }
        };
        Vector<Item> postSelection = new Vector<Item>(preSelection.size());
        commands.add(this.getUndoSelection(preSelection));
        for (Item ref : preSelection) {
            Item item = ref.clone(this);
            Point2D.Double pos = item.getPos();
            item.changePos(Item.getPosInside(size, pos, item.getThetaDegree(), item.getSize()));
            postSelection.add(item);
            item.validateContainer(commands, "PasteItem");
        }
        commands.add(this.getDoSelection(postSelection));
        this.story.add(commands);
    }

    public Item storyGetCloseItem(Story.Commands commands, Item item) {
        Item closeItem = (Item)this.getLocalEmbedded(item.getId());
        if (closeItem != null) {
            return closeItem;
        }
        closeItem = this.getCloseEmbedded(item);
        closeItem.validateContainer(commands, "LinkItem");
        return closeItem;
    }

    public void storyHideShowItem(List<Item> sItem, final boolean hidden) {
        if (sItem == null) {
            return;
        }
        Story story = this.story;
        Objects.requireNonNull(story);
        Story.Commands commands = new Story.Commands(story, "HideItem"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }
        };
        Vector<Item> toHideShow = new Vector<Item>(sItem.size());
        for (Item ref : sItem) {
            if (ref.isHidden() == hidden) continue;
            toHideShow.add(this.storyGetCloseItem(commands, ref));
        }
        if (toHideShow.size() < 1) {
            return;
        }
        commands.add(this.getUndoSelection(toHideShow));
        for (final Item item : toHideShow) {
            Story story2 = this.story;
            Objects.requireNonNull(story2);
            commands.add(new Story.Command(story2, "HideItem"){
                {
                    Story story = x0;
                    Objects.requireNonNull(story);
                    super(story, arg0);
                }

                @Override
                public void exec() {
                    if (hidden) {
                        item.addModifier("hidden");
                    } else {
                        item.removeModifier("hidden");
                    }
                }

                @Override
                public void undo() {
                    if (hidden) {
                        item.removeModifier("hidden");
                    } else {
                        item.addModifier("hidden");
                    }
                }

                @Override
                public void display() {
                    item.updateView();
                }
            });
        }
        commands.add(this.getDoSelection((List<Item>)null));
        this.story.add(commands);
    }

    public void storyRemoveItems(List<Item> sItem) {
        if (sItem == null) {
            return;
        }
        Vector<Item> toRemove = new Vector<Item>(sItem.size());
        for (Item ref : sItem) {
            Item localItem = (Item)this.getLocalEmbedded(ref.getId());
            if (localItem == null || localItem.isSticky()) continue;
            toRemove.add(localItem);
        }
        if (toRemove.size() < 1) {
            return;
        }
        Story story = this.story;
        Objects.requireNonNull(story);
        Story.Commands commands = new Story.Commands(story, "RemoveItem"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }
        };
        commands.add(this.getUndoSelection(toRemove));
        for (final Item item : toRemove) {
            Story story2 = this.story;
            Objects.requireNonNull(story2);
            commands.add(new Story.Command(story2, "RemoveItem"){
                {
                    Story story = x0;
                    Objects.requireNonNull(story);
                    super(story, arg0);
                }

                @Override
                public void exec() {
                    Workspace.this.removeEmbedded(item);
                }

                @Override
                public void undo() {
                    Workspace.this.addEmbedded(item);
                }

                @Override
                public void displayExec() {
                    item.updateView("RemoveItem");
                }

                @Override
                public void displayUndo() {
                    item.updateView("NewItem");
                }
            });
        }
        commands.add(this.getDoSelection((List<Item>)null));
        this.story.add(commands);
    }

    public Acc storyGetCloseAcc(Story.Commands commands, Item item, Accessory accessory) {
        Acc acc = (Acc)item.findEmbeddedRootOf(accessory);
        if (acc == null) {
            return null;
        }
        Acc closeAcc = (Acc)item.getLocalEmbedded(acc.getId());
        if (closeAcc != null) {
            return closeAcc;
        }
        closeAcc = item.getCloseEmbedded(acc);
        closeAcc.validateContainer(commands, "LinkAcc");
        return closeAcc;
    }

    public void storyAddAcc(Item item, final Accessory accessory) {
        Story story = this.story;
        Objects.requireNonNull(story);
        Story.Commands commands = new Story.Commands(story, "AddAcc"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }
        };
        final Item localItem = this.storyGetCloseItem(commands, item);
        final Acc localAcc = this.storyGetCloseAcc(commands, localItem, accessory);
        if (localAcc == null) {
            return;
        }
        final NonWorkspace oldAccessoryModel = localAcc.getModel();
        if (accessory != oldAccessoryModel) {
            Story story2 = this.story;
            Objects.requireNonNull(story2);
            commands.add(new Story.Command(story2, "AddAcc"){
                {
                    Story story = x0;
                    Objects.requireNonNull(story);
                    super(story, arg0);
                }

                @Override
                public void exec() {
                    localAcc.setModel(accessory);
                }

                @Override
                public void undo() {
                    localAcc.setModel(oldAccessoryModel);
                }

                @Override
                public void display() {
                    localItem.updateView();
                }
            });
        }
        this.story.add(commands);
    }

    public void storyRemoveAcc(Acc acc) {
        final Item localItem = (Item)this.getLocalEmbedded(((Editable)acc.getContainer()).getId());
        if (localItem == null) {
            return;
        }
        final Acc oldAcc = (Acc)localItem.getLocalEmbedded(acc.getId());
        if (oldAcc == null) {
            return;
        }
        Story story = this.story;
        Objects.requireNonNull(story);
        this.story.add(new Story.Command(story, "RemoveAcc"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }

            @Override
            public void exec() {
                localItem.removeEmbedded(oldAcc);
            }

            @Override
            public void undo() {
                localItem.addEmbedded(oldAcc);
            }

            @Override
            public void display() {
                localItem.updateView();
            }
        });
    }

    public void storyConnect(Comp srcComp, Acc srcAcc, final String dstCompName, final String dstAccName) {
        Comp localComp = this.getCloseEmbedded(srcComp);
        final Acc localAcc = localComp.getCloseEmbedded(srcAcc);
        Story story = this.story;
        Objects.requireNonNull(story);
        Story.Commands commands = new Story.Commands(story, "ConnectAcc"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }
        };
        localAcc.validateContainer(commands, "LinkAcc");
        final String oldConnectedTo = localAcc.getConnectedTo();
        final Prop oldConnectedToProp = localAcc.getPropVal("connectedTo");
        final String oldConnectedOn = localAcc.getConnectedOn();
        final Prop oldConnectedOnProp = localAcc.getPropVal("connectedOn");
        Story story2 = this.story;
        Objects.requireNonNull(story2);
        commands.add(new Story.Command(story2, "ConnectAcc"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }

            @Override
            public void exec() {
                localAcc.changeConnectedTo(dstCompName);
                localAcc.changeConnectedOn(dstAccName);
            }

            @Override
            public void undo() {
                if (oldConnectedToProp == null) {
                    localAcc.removeOwnProp("connectedTo");
                } else {
                    localAcc.changeConnectedTo(oldConnectedTo);
                }
                if (oldConnectedOnProp == null) {
                    localAcc.removeOwnProp("connectedOn");
                } else {
                    localAcc.changeConnectedOn(oldConnectedOn);
                }
            }

            @Override
            public void display() {
                localAcc.updateView();
                Workspace.this.updateConnection();
            }
        });
        this.story.add(commands);
    }

    public void storyRotItem(Vector<Item> sItem, Vector<Double> thetas) {
        Story story = this.story;
        Objects.requireNonNull(story);
        Story.Commands commands = new Story.Commands(story, "RotItem"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }
        };
        final DimensionDouble size = this.getRealSize();
        int nbSelected = sItem.size();
        for (int i = 0; i < nbSelected; ++i) {
            double oldThetaDegree;
            final Item item = sItem.get(i);
            final double thetaDegree = thetas.get(i);
            if (thetaDegree == (oldThetaDegree = item.getThetaDegree())) continue;
            final Item localItem = this.storyGetCloseItem(commands, item);
            final Prop oldProp = item.getOwnProp("rot");
            final Point2D.Double pos = item.getPos();
            Story story2 = this.story;
            Objects.requireNonNull(story2);
            commands.add(new Story.Command(story2, "RotItem"){
                {
                    Story story = x0;
                    Objects.requireNonNull(story);
                    super(story, arg0);
                }

                @Override
                public void exec() {
                    localItem.changeThetaDegree(thetaDegree);
                    localItem.changePos(Item.getPosInside(size, pos, item.getThetaDegree(), item.getSize()));
                }

                @Override
                public void undo() {
                    if (oldProp == null) {
                        localItem.removeOwnProp("rot");
                    } else {
                        localItem.changeThetaDegree(oldThetaDegree);
                    }
                    localItem.changePos(pos);
                }

                @Override
                public void display() {
                    localItem.updateView("ChangePos");
                    localItem.updateView("ChangeRot");
                }
            });
        }
        this.story.add(commands);
    }

    public void storyMoveItem(Vector<Item> sItem, Vector<Point2D.Double> poss) {
        Story story = this.story;
        Objects.requireNonNull(story);
        Story.Commands commands = new Story.Commands(story, "MoveItem"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }
        };
        DimensionDouble size = this.getRealSize();
        int nbSelected = sItem.size();
        for (int i = 0; i < nbSelected; ++i) {
            Point2D.Double old;
            Item item = sItem.get(i);
            final Point2D.Double insidePos = Item.getPosInside(size, poss.get(i), item.getThetaDegree(), item.getSize());
            if (insidePos.equals(old = item.getPos())) {
                item.updateView("ChangePos");
                continue;
            }
            final Item localItem = this.storyGetCloseItem(commands, item);
            Story story2 = this.story;
            Objects.requireNonNull(story2);
            commands.add(new Story.Command(story2, "MoveItem"){
                {
                    Story story = x0;
                    Objects.requireNonNull(story);
                    super(story, arg0);
                }

                @Override
                public void exec() {
                    localItem.changePos(insidePos);
                }

                @Override
                public void undo() {
                    localItem.changePos(old);
                }

                @Override
                public void display() {
                    localItem.updateView("ChangePos");
                }
            });
        }
        this.story.add(commands);
    }

    public void storyRotResize(Item sItem, Point2D.Double sPos, final double sThetaDegree, final DimensionDouble sSize) {
        Story story = this.story;
        Objects.requireNonNull(story);
        Story.Commands commands = new Story.Commands(story, "RotResizeItem"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }
        };
        final Item localItem = this.storyGetCloseItem(commands, sItem);
        DimensionDouble size = this.getRealSize();
        final Point2D.Double oldPos = localItem.getPos();
        final DimensionDouble oldSize = localItem.getSize();
        final double oldThetaDegree = localItem.getThetaDegree();
        final Point2D.Double insidePos = Item.getPosInside(size, sPos, sThetaDegree, sSize);
        Story story2 = this.story;
        Objects.requireNonNull(story2);
        commands.add(new Story.Command(story2, "RotResizeItem"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }

            @Override
            public void exec() {
                localItem.changeRotSize(insidePos, sThetaDegree, sSize);
            }

            @Override
            public void undo() {
                localItem.changeRotSize(oldPos, oldThetaDegree, oldSize);
            }

            @Override
            public void display() {
                localItem.updateView("ChangeRotSize");
            }
        });
        this.story.add(commands);
    }

    public Line2D.Double getMagnetPoint(Point2D.Double pos, Point2D.Double onGrid, double close) {
        double minD = close;
        Point2D.Double minPos = new Point2D.Double();
        if (this.adecWatt.getHandleGlue()) {
            Point2D.Double closeHandle = (Point2D.Double)pos.clone();
            for (double[] bounds : this.allBounds) {
                minD = Item.getCloseBound(bounds, pos, minD, closeHandle);
            }
            if (minD < close) {
                pos.x = closeHandle.x;
                pos.y = closeHandle.y;
                return new Line2D.Double(pos, pos);
            }
        }
        if (this.adecWatt.getGridGlue() && onGrid.distance(pos) < close) {
            pos.x = onGrid.x;
            pos.y = onGrid.y;
        }
        if (this.adecWatt.getBoundGlue()) {
            boolean inSegment = this.adecWatt.getInSegmentGlue();
            double minL = close;
            Line2D.Double minLine = null;
            for (double[] bounds : this.allBounds) {
                double oldX = bounds[6];
                double oldY = bounds[7];
                int x = 0;
                int y = 1;
                while (x < 8) {
                    double d;
                    double d2 = oldX;
                    double d3 = oldY;
                    oldX = bounds[x];
                    oldY = bounds[y];
                    Line2D.Double line = new Line2D.Double(d2, d3, oldX, oldY);
                    double d4 = d = inSegment ? line.ptSegDist(pos) : line.ptLineDist(pos);
                    if (d < minL) {
                        minLine = line;
                        minL = d;
                    }
                    x += 2;
                    y += 2;
                }
            }
            if (minLine != null) {
                double xDelta = minLine.x2 - minLine.x1;
                double yDelta = minLine.y2 - minLine.y1;
                if (xDelta == 0.0 && yDelta == 0.0) {
                    return null;
                }
                double u = ((pos.x - minLine.x1) * xDelta + (pos.y - minLine.y1) * yDelta) / (xDelta * xDelta + yDelta * yDelta);
                if (inSegment) {
                    u = Math.min(1.0, Math.max(0.0, u));
                }
                Point2D.Double result = new Point2D.Double(minLine.x1 + u * xDelta, minLine.y1 + u * yDelta);
                pos.x = result.x;
                pos.y = result.y;
                return minLine;
            }
        }
        return null;
    }

    public void storySpaceItem(Vector<Item> items, boolean isHorizontal, Double spaceRequest) {
        double space;
        if (items == null || items.size() < 2) {
            return;
        }
        items.sort(isHorizontal ? Item.xPosComparator : Item.yPosComparator);
        double[][] axesValues = this.getAxesValues(items, isHorizontal);
        double minSpace = this.getMinSpace(axesValues[1]);
        int nbItems = items.size();
        double d = space = spaceRequest != null ? spaceRequest : (axesValues[0][nbItems - 1] - axesValues[0][0] - minSpace) / (double)(nbItems - 1);
        if (space < 0.0) {
            space = 0.0;
        }
        for (int i = 1; i < nbItems; ++i) {
            axesValues[0][i] = space + axesValues[0][i - 1] + (axesValues[1][i - 1] + axesValues[1][i]) / 2.0;
        }
        this.storyMoveItem(items, this.getPos(items, isHorizontal, axesValues[0]));
    }

    public void storyDistributeItem(Vector<Item> items, boolean isHorizontal, Double distribRequest) {
        if (items == null || items.size() < 2) {
            return;
        }
        items.sort(isHorizontal ? Item.xPosComparator : Item.yPosComparator);
        double[][] axesValues = this.getAxesValues(items, isHorizontal);
        int nbItems = items.size();
        double distrib = distribRequest != null ? distribRequest : (axesValues[0][nbItems - 1] - axesValues[0][0]) / (double)(nbItems - 1);
        double minDistrib = this.getMinDistribution(axesValues[1]);
        if (distrib < minDistrib) {
            distrib = minDistrib;
        }
        for (int i = 1; i < nbItems; ++i) {
            axesValues[0][i] = axesValues[0][i - 1] + distrib;
        }
        this.storyMoveItem(items, this.getPos(items, isHorizontal, axesValues[0]));
    }

    public void storyAlignItem(Vector<Item> items, Alignment alignment) {
        DimensionDouble size;
        Point2D.Double pos;
        if (items == null || items.size() < 2) {
            return;
        }
        int nbItems = items.size();
        Vector<Point2D.Double> poss = new Vector<Point2D.Double>(nbItems);
        double x = 0.0;
        double y = 0.0;
        switch (alignment) {
            case LEFT: {
                x = items.get((int)0).getPos().x;
                break;
            }
            case TOP: {
                y = items.get((int)0).getPos().y;
            }
        }
        for (Item item : items) {
            pos = item.getPos();
            size = Item.getRotSize(item.getSize(), item.getThetaDegree());
            switch (alignment) {
                case LEFT: {
                    x = Math.min(x, pos.x - size.width / 2.0);
                    break;
                }
                case CENTER: {
                    x += pos.x;
                    break;
                }
                case RIGHT: {
                    x = Math.max(x, pos.x + size.width / 2.0);
                    break;
                }
                case TOP: {
                    y = Math.min(y, pos.y - size.height / 2.0);
                    break;
                }
                case MIDDLE: {
                    y += pos.y;
                    break;
                }
                case BOTTOM: {
                    y = Math.max(y, pos.y + size.height / 2.0);
                }
            }
        }
        switch (alignment) {
            case CENTER: {
                x /= (double)nbItems;
                break;
            }
            case MIDDLE: {
                y /= (double)nbItems;
            }
        }
        for (Item item : items) {
            pos = item.getPos();
            size = Item.getRotSize(item.getSize(), item.getThetaDegree());
            switch (alignment) {
                case LEFT: {
                    poss.add(new Point2D.Double(x + size.width / 2.0, pos.y));
                    break;
                }
                case CENTER: {
                    poss.add(new Point2D.Double(x, pos.y));
                    break;
                }
                case RIGHT: {
                    poss.add(new Point2D.Double(x - size.width / 2.0, pos.y));
                    break;
                }
                case TOP: {
                    poss.add(new Point2D.Double(pos.x, y + size.height / 2.0));
                    break;
                }
                case MIDDLE: {
                    poss.add(new Point2D.Double(pos.x, y));
                    break;
                }
                case BOTTOM: {
                    poss.add(new Point2D.Double(pos.x, y - size.height / 2.0));
                }
            }
        }
        this.storyMoveItem(items, poss);
    }

    public double[][] getAxesValues(Vector<Item> items, boolean isHorizontal) {
        int nbItems = items.size();
        double[][] result = new double[2][nbItems];
        int i = 0;
        for (Item item : items) {
            Point2D.Double pos = item.getPos();
            DimensionDouble size = Item.getRotSize(item.getSize(), item.getThetaDegree());
            if (isHorizontal) {
                result[0][i] = pos.x;
                result[1][i] = size.width;
            } else {
                result[0][i] = pos.y;
                result[1][i] = size.height;
            }
            ++i;
        }
        return result;
    }

    public Vector<Point2D.Double> getPos(Vector<Item> items, boolean isHorizontal, double[] poss) {
        Vector<Point2D.Double> result = new Vector<Point2D.Double>();
        int i = 0;
        for (Item item : items) {
            Point2D.Double pos = item.getPos();
            result.add(isHorizontal ? new Point2D.Double(poss[i], pos.y) : new Point2D.Double(pos.x, poss[i]));
            ++i;
        }
        return result;
    }

    public double getMinDistribution(double[] widths) {
        double result = 0.0;
        for (int i = 1; i < widths.length; ++i) {
            result = Math.max(result, widths[i - 1] + widths[i]);
        }
        return result / 2.0;
    }

    public double getMinSpace(double[] widths) {
        double result = 0.0;
        for (int i = 0; i < widths.length; ++i) {
            result += widths[i];
        }
        return result -= (widths[0] + widths[widths.length - 1]) / 2.0;
    }

    @Override
    public Element getXml(Node parent, Document document) {
        Element child = super.getXml(parent, document);
        return child;
    }

    public Patch getPatch() {
        try {
            Circuits circuits = Circuits.getCircuits(this, this.getAdecWatt().getPermanentDB().getPowerPlugId());
            return new Patch(circuits);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Vector<Item> getAllItems() {
        return this.allItems;
    }

    public void addPlugedComps(Comp comp) {
        this.plugedComps.add(comp);
    }

    public boolean containsItem(String itemId) {
        return this.namedItems.containsKey(itemId) || this.embedded.containsKey(itemId);
    }

    public void print(Graphics2D printGraphics, double lineWidth, Collection<String> itemsNotToPrint, boolean printCircuit) {
        Composite defaultComposit = printGraphics.getComposite();
        AlphaComposite buildingComposit = ((AlphaComposite)defaultComposit).derive(this.buildingOpacity);
        AlphaComposite hiddenBuildingComposit = ((AlphaComposite)defaultComposit).derive(this.buildingOpacity * this.hiddenOpacity);
        AlphaComposite hiddenComposit = ((AlphaComposite)defaultComposit).derive(this.hiddenOpacity);
        this.printBlueprint(printGraphics);
        this.namedItems.clear();
        this.plugedComps.clear();
        for (Item item : this.getInheritedEmbeddedValues()) {
            this.namedItems.put(item.getId(), item);
        }
        Building building = this.getBuilding();
        Collection buildingItems = null;
        if (building != null) {
            buildingItems = building.getInheritedEmbeddedValues();
            for (Object item : buildingItems) {
                this.namedItems.putIfAbsent(((Embedded)item).getId(), (Item)item);
            }
        }
        this.allItems = new Vector<Item>(this.namedItems.values());
        this.allItems.sort(Item.zPosComparator);
        Vector<Item> itemsUsed = new Vector<Item>();
        for (Item item : this.allItems) {
            for (String accId : item.getEmbeddedIds()) {
                try {
                    itemsUsed.add(this.namedItems.get(((Editable)item.findEmbedded(accId)).getConnectedTo()));
                }
                catch (Exception exception) {}
            }
        }
        String plugId = this.adecWatt.getPermanentDB().getPowerPlugId();
        this.allBounds = new Vector(this.namedItems.size());
        for (Item item : this.allItems) {
            if (item.isReserved() || itemsNotToPrint != null && itemsNotToPrint.contains(item.getId())) continue;
            boolean isBuilding = buildingItems != null && buildingItems.contains(item);
            boolean isHidden = item.isHidden();
            if (!itemsUsed.contains(item)) {
                if (isHidden) {
                    printGraphics.setComposite(isBuilding ? hiddenBuildingComposit : hiddenComposit);
                } else if (isBuilding) {
                    printGraphics.setComposite(buildingComposit);
                }
            }
            try {
                this.allBounds.add(item.getBounds());
                item.print(printGraphics, this, plugId);
            }
            catch (Exception e) {
                System.err.println("Can't print <" + item.getId() + "> (" + item.getModel() + ")");
                continue;
            }
            if (!isBuilding && !isHidden) continue;
            printGraphics.setComposite(defaultComposit);
        }
        if (!printCircuit) {
            return;
        }
        HashMap<Acc, Comp> hashMap = new HashMap<Acc, Comp>();
        for (Comp beginComp : this.plugedComps) {
            for (Acc beginAcc : beginComp.allPlugs) {
                try {
                    Comp endComp = (Comp)this.namedItems.get(beginAcc.getConnectedTo());
                    if (endComp == null) continue;
                    hashMap.put(beginAcc, endComp);
                    Acc.printConnection(printGraphics, lineWidth, (Point2D)beginComp.getAccCenter(beginAcc.getId()), endComp.getAccCenter(beginAcc.getConnectedOn()));
                }
                catch (Exception endComp) {}
            }
        }
        Circuits circuits = new Circuits(hashMap, this.plugedComps);
        for (Comp plugedComp : this.plugedComps) {
            for (Acc acc : plugedComp.allPlugs) {
                Circuits.CircuitState circuitState = circuits.getState(plugedComp, acc);
                if (circuitState == null) continue;
                Point2D.Double c = plugedComp.getAccCenter(acc.getId());
                Acc.printCircuit(printGraphics, c, circuitState, 0.4);
            }
        }
    }

    public void printBlueprint(Graphics2D printGraphics) {
        ScaledImage scaledBlueprint = this.getBlueprint();
        if (scaledBlueprint == null) {
            return;
        }
        Double visible = this.getBlueprintVisibility();
        if (visible != null && visible <= 0.0) {
            return;
        }
        DimensionDouble blueprintSize = this.getBlueprintSize();
        if (blueprintSize == null) {
            blueprintSize = this.getRealSize();
        }
        Point2D.Double blueprintPos = null;
        try {
            blueprintPos = this.getBlueprintPos();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (blueprintPos == null) {
            blueprintPos = new Point2D.Double();
        }
        Workspace.printImage(printGraphics, scaledBlueprint, blueprintPos, blueprintSize, 0.0, null);
    }

    public ArrayList<Item> findItems(Point2D.Double realPos, double close) {
        ArrayList<Item> result = new ArrayList<Item>();
        double[] coord = new double[]{realPos.x, realPos.y};
        for (Item item : this.namedItems.values()) {
            coord[0] = realPos.x;
            coord[1] = realPos.y;
            if (!item.containsClose(coord, close)) continue;
            result.add(item);
        }
        return result;
    }

    public static void printImage(Graphics2D printGraphics, ScaledImage scaledImage, Point2D realPos, DimensionDouble realSize, double thetaDegree, Double[] tileSize) {
        Point2D.Double pos = new Point2D.Double(realPos.getX(), realPos.getY());
        DimensionDouble size = new DimensionDouble(realSize.getWidth(), realSize.getHeight());
        double theta = Math.toRadians(thetaDegree);
        Dimension tile = Item.getTile(tileSize, realSize);
        ScaledImage.ImageInfo imageInfo = scaledImage.newInfo2(size, theta);
        BufferedImage reference = scaledImage.reference;
        if (pos != null) {
            printGraphics.translate(((Point2D)pos).getX() + imageInfo.x, ((Point2D)pos).getY() + imageInfo.y);
        }
        if (ScaledImage.ONE_TILE.equals(tile)) {
            printGraphics.drawImage(reference, imageInfo.at, null);
        } else {
            double width = reference.getWidth();
            double height = reference.getHeight();
            double scaleX = 1.0 / (double)tile.width;
            double scaleY = 1.0 / (double)tile.height;
            double stepX = width / (double)tile.width;
            double stepY = height / (double)tile.height;
            for (int i = 0; i < tile.width; ++i) {
                for (int j = 0; j < tile.height; ++j) {
                    AffineTransform at = new AffineTransform(imageInfo.at);
                    at.translate((double)i * stepX, (double)j * stepY);
                    at.scale(scaleX, scaleY);
                    printGraphics.drawImage(reference, at, null);
                }
            }
        }
        if (pos != null) {
            printGraphics.translate(-((Point2D)pos).getX() - imageInfo.x, -((Point2D)pos).getY() - imageInfo.y);
        }
    }

    public static void printText(Graphics2D printGraphics, String label, Color color, Point2D realPos, DimensionDouble realSize) {
        double minSide = Math.min(realSize.width, realSize.height);
        Workspace.printText(printGraphics, label, color, realPos, new DimensionDouble(minSide, minSide), 0.0);
    }

    public static void printText(Graphics2D printGraphics, String label, Color color, Point2D realPos, DimensionDouble realSize, double thetaDegree) {
        if (label == null || "".equals(label)) {
            return;
        }
        AffineTransform af = printGraphics.getTransform();
        Font labelFont = Workspace.getLabelFont(label, printGraphics.getFont(), realSize, printGraphics);
        printGraphics.setFont(labelFont);
        Rectangle2D bounds = labelFont.getStringBounds(label, printGraphics.getFontRenderContext());
        double bottom = (double)labelFont.getSize2D() * 0.201298701299;
        Point2D.Double pos = new Point2D.Double(realPos.getX(), realPos.getY());
        printGraphics.translate(pos.getX(), pos.getY());
        printGraphics.rotate(Math.toRadians(thetaDegree));
        printGraphics.setColor(new Color(1.0f, 1.0f, 1.0f, 0.8f));
        printGraphics.draw(new Rectangle2D.Double(bounds.getX() - bounds.getWidth() / 2.0, bounds.getY(), bounds.getWidth(), bounds.getHeight()));
        printGraphics.setColor(color);
        printGraphics.drawString(label, (float)(-bounds.getWidth() / 2.0), (float)((double)(labelFont.getSize2D() / 2.0f) - bottom));
        printGraphics.setTransform(af);
    }

    public static Font getLabelFont(String labelText, Font labelFont, Dimension2D size, Graphics2D printGraphics) {
        if (labelText == null || labelText.isEmpty() || printGraphics == null) {
            return labelFont;
        }
        float height = (float)size.getHeight();
        labelFont = labelFont.deriveFont(height);
        int stringWidth = printGraphics.getFontMetrics(labelFont).stringWidth(labelText);
        float width = (float)size.getWidth();
        float newFontSize = height * width / (float)stringWidth;
        if (newFontSize < height) {
            labelFont = labelFont.deriveFont(newFontSize);
        }
        return labelFont;
    }

    public static void printLine(Graphics2D printGraphics, Paint paint, Stroke stroke, Point2D realPos, double length, double thetaDegree, Stroke arrowStroke, Shape arrowStart, Shape arrowEnd) {
        Paint prevPaint = printGraphics.getPaint();
        AffineTransform af = printGraphics.getTransform();
        Line2D.Double line = new Line2D.Double(-length / 2.0, 0.0, length / 2.0, 0.0);
        printGraphics.setStroke(stroke);
        printGraphics.setPaint(paint);
        printGraphics.translate(realPos.getX(), realPos.getY());
        printGraphics.rotate(Math.toRadians(thetaDegree));
        printGraphics.draw(line);
        printGraphics.setStroke(arrowStroke);
        if (arrowStart != null) {
            printGraphics.setTransform(af);
            printGraphics.translate(realPos.getX(), realPos.getY());
            printGraphics.rotate(Math.toRadians(thetaDegree));
            printGraphics.translate(-length / 2.0, 0.0);
            printGraphics.rotate(Math.toRadians(180.0));
            printGraphics.fill(arrowStart);
            printGraphics.draw(arrowStart);
        }
        if (arrowEnd != null) {
            printGraphics.setTransform(af);
            printGraphics.translate(realPos.getX(), realPos.getY());
            printGraphics.rotate(Math.toRadians(thetaDegree));
            printGraphics.translate(length / 2.0, 0.0);
            printGraphics.fill(arrowEnd);
            printGraphics.draw(arrowEnd);
        }
        printGraphics.setTransform(af);
        printGraphics.setPaint(prevPaint);
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT,
        TOP,
        MIDDLE,
        BOTTOM;

    }
}

