/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.model.xml;

import adecWatt.model.xml.XmlAcc;
import adecWatt.model.xml.XmlComp;
import adecWatt.model.xml.XmlProp;
import adecWatt.model.xml.XmlSegm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import misc.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlPermanent<T extends Enum<?>, A extends Enum<?>> {
    public T type;
    private Hashtable<A, String> facets = new Hashtable();
    private String value;
    ArrayList<Node> unknownAttr = new ArrayList();
    ArrayList<Node> unknownNodes = new ArrayList();

    public void parseNode(Node node, Class<T> nodeEnum, Class<A> attrEnum) {
        if (1 != node.getNodeType()) {
            throw new IllegalArgumentException("XML unit not a node (" + node + ").");
        }
        this.type = Enum.valueOf(nodeEnum, Util.toCapital(node.getNodeName()));
        NamedNodeMap allFacets = node.getAttributes();
        for (int i = 0; i < allFacets.getLength(); ++i) {
            Node facetNode = allFacets.item(i);
            try {
                if (facetNode.getNodeValue().isEmpty()) continue;
                this.facets.put(Enum.valueOf(attrEnum, Util.toCapital(facetNode.getNodeName())), facetNode.getNodeValue());
                continue;
            }
            catch (Exception e) {
                this.unknownAttr.add(facetNode);
            }
        }
        NodeList childrens = node.getChildNodes();
        for (int i = 0; i < childrens.getLength(); ++i) {
            Node child = childrens.item(i);
            if (XmlPermanent.isEmpty(child)) continue;
            if (XmlPermanent.isText(child)) {
                String val = child.getNodeValue().trim();
                if (this.value != null) {
                    this.value = this.value + " " + val;
                    continue;
                }
                this.value = val;
                continue;
            }
            this.unknownNodes.add(child);
        }
    }

    public static boolean isEmpty(Node node) {
        return 3 == node.getNodeType() && 0 == node.getChildNodes().getLength() && 0 == node.getNodeValue().trim().length() && (null == node.getAttributes() || 0 == node.getAttributes().getLength());
    }

    public static boolean isText(Node node) {
        return 3 == node.getNodeType() && 0 == node.getChildNodes().getLength() && (null == node.getAttributes() || 0 == node.getAttributes().getLength());
    }

    public String getValue() {
        String result = this.value;
        this.value = null;
        return result;
    }

    public String getFacet(A a) {
        return this.facets.remove(a);
    }

    public Collection<String> getSplitFacet(A a) {
        String result = this.facets.remove(a);
        if (result == null) {
            return null;
        }
        return new TreeSet<String>(Arrays.asList(result.toLowerCase().split("\\|")));
    }

    public List<String> getOrderedSplitFacet(A a) {
        String result = this.facets.remove(a);
        if (result == null) {
            return null;
        }
        return Arrays.asList(result.toLowerCase().split("\\|"));
    }

    public ArrayList<XmlProp> getProps() {
        ArrayList<XmlProp> xmlProps = new ArrayList<XmlProp>();
        Iterator<Node> it = this.unknownNodes.iterator();
        while (it.hasNext()) {
            Node node = it.next();
            try {
                xmlProps.add(new XmlProp(node));
                it.remove();
            }
            catch (Exception exception) {}
        }
        return xmlProps;
    }

    public ArrayList<XmlSegm> getSegms() {
        ArrayList<XmlSegm> xmlSegms = new ArrayList<XmlSegm>();
        Iterator<Node> it = this.unknownNodes.iterator();
        while (it.hasNext()) {
            Node node = it.next();
            try {
                xmlSegms.add(new XmlSegm(node));
                it.remove();
            }
            catch (Exception exception) {}
        }
        return xmlSegms;
    }

    public ArrayList<XmlComp> getComps() {
        ArrayList<XmlComp> xmlComps = new ArrayList<XmlComp>();
        Iterator<Node> it = this.unknownNodes.iterator();
        while (it.hasNext()) {
            Node node = it.next();
            try {
                xmlComps.add(new XmlComp(node));
                it.remove();
            }
            catch (Exception exception) {}
        }
        return xmlComps;
    }

    public ArrayList<XmlAcc> getAccs() {
        ArrayList<XmlAcc> xmlAccs = new ArrayList<XmlAcc>();
        Iterator<Node> it = this.unknownNodes.iterator();
        while (it.hasNext()) {
            Node node = it.next();
            try {
                xmlAccs.add(new XmlAcc(node));
                it.remove();
            }
            catch (Exception exception) {}
        }
        return xmlAccs;
    }

    public Element getXml(Document document) {
        Element element = document.createElement(((Enum)this.type).toString().toLowerCase());
        if (this.value != null) {
            element.appendChild(document.createTextNode(this.value));
        }
        for (Enum facet : this.facets.keySet()) {
            element.setAttribute(facet.toString().toLowerCase(), this.facets.get(facet));
        }
        for (Node subNode : this.unknownAttr) {
            element.setAttributeNode((Attr)document.importNode(subNode, true));
        }
        for (Node subNode : this.unknownNodes) {
            element.appendChild(document.importNode(subNode, true));
        }
        return element;
    }

    public static void putValue(Element element, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        element.appendChild(element.getOwnerDocument().createTextNode(value));
    }

    public static void putFacet(Element element, Enum<?> a, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        element.setAttribute(a.toString().toLowerCase(), value);
    }

    public static void putSplitFacet(Element element, Enum<?> a, Collection<String> ... tValues) {
        String result = "";
        String sep = "";
        for (Collection<String> values : tValues) {
            if (values == null || values.size() == 0) continue;
            result = result + sep + String.join((CharSequence)"|", values);
            sep = "|";
        }
        XmlPermanent.putFacet(element, a, result);
    }
}

