/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.AdecWatt;
import adecWatt.model.Permanent;
import adecWatt.model.Unit;
import adecWatt.model.UnitNode;
import adecWatt.model.User;
import adecWatt.model.unit.Accessory;
import adecWatt.model.unit.Building;
import adecWatt.model.unit.Lightplot;
import adecWatt.model.unit.NonWorkspace;
import adecWatt.model.unit.Workspace;
import adecWatt.view.JDragUnit;
import adecWatt.view.JScrollPaneWorkspace;
import adecWatt.view.JUnitPopup;
import adecWatt.view.JWorkspaceView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import misc.EasterEgg;
import misc.StateNotifier;
import misc.Util;

public class JAdecWatt
extends JPanel {
    public static final int space = 10;
    public static final String BroadcastChangeScale = "ChangeScale";
    public static final String BroadcastSelection = "Selection";
    public static final String BroadcastUnitStory = "UnitStory";
    public static final String BroadcastWorkspace = "Workspace";
    public StateNotifier stateNotifier = new StateNotifier();
    private AdecWatt adecWatt;
    public final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private JTabbedPane jTPStorage = new JTabbedPane();
    private JLabel background = new JLabel("", 0);
    private JTabbedPane jTPWorkspace = new JTabbedPane();
    private JTextArea jConsole = new JTextArea();
    private Workspace currentWorkspace;
    private Font localFont;
    private Font normalFont;
    private Font modifiedFont;
    Hashtable<Unit<?>, JTree> allJTree = new Hashtable();
    DefaultTreeCellRenderer xmlTreeRenderer = new DefaultTreeCellRenderer(){

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Unit unit = ((UnitNode)value).getUnit();
            this.setFont(unit.story.isModified() ? JAdecWatt.this.modifiedFont : (unit.getRemote() ? JAdecWatt.this.normalFont : JAdecWatt.this.localFont));
            this.setText(unit.getLocalName());
            this.setIcon(unit.getIcon(16));
            return this;
        }
    };
    JDragUnit selectedJDragUnit;
    Point mousePosOnJDragUnit;

    public AdecWatt getAdecWatt() {
        return this.adecWatt;
    }

    public JWorkspaceView<?> getCurrentJWorkspace() {
        try {
            return ((JScrollPaneWorkspace)this.jTPWorkspace.getComponentAt(this.jTPWorkspace.getSelectedIndex())).getJWorkspaceView();
        }
        catch (Exception e) {
            return null;
        }
    }

    public JWorkspaceView<?> getJWorkspace(Workspace workspace) {
        try {
            return this.getJScrollPaneWorkspace(workspace).getJWorkspaceView();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Workspace getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public void setCurrentWorkspace(Workspace workspace) {
        this.currentWorkspace = workspace;
        this.stateNotifier.broadcastUpdate(BroadcastWorkspace);
        this.adecWatt.broadcastUpdate("Title");
    }

    public JAdecWatt(AdecWatt adecWatt) {
        super(new BorderLayout());
        this.adecWatt = adecWatt;
        this.normalFont = this.getFont();
        this.modifiedFont = this.normalFont.deriveFont(1, this.normalFont.getSize());
        this.localFont = this.normalFont.deriveFont(2, this.normalFont.getSize());
        try {
            EasterEgg easterEgg = new EasterEgg("images/adecWatt-anim.gif");
            easterEgg.addPeriode("1220", "1231", "images/adecWatt-anim-noel.gif");
            easterEgg.addPeriode("0101", "0115", "images/adecWatt-anim-noel.gif");
            easterEgg.addPeriode("0504", "0512", "images/2024-festival-adec56.png");
            this.background.setIcon(Util.loadImageIcon("data", easterEgg.getValue()));
        }
        catch (Exception easterEgg) {
            // empty catch block
        }
        this.background.setLayout(new BorderLayout());
        this.background.add((Component)this.jTPWorkspace, "Center");
        this.jConsole.setPreferredSize(new Dimension(400, 50));
        JSplitPane tmp = Util.getJSplitPane(0, this.background, Util.getJScrollPane(this.jConsole));
        tmp.setResizeWeight(1.0);
        this.add((Component)Util.getJSplitPane(1, this.jTPStorage, tmp), "Center");
        adecWatt.addUpdateObserver(this, "UnitRoots");
        adecWatt.addMsgObserver(this, "Console", "UpdateWorkspace", "UpdateUnitTree");
        this.updateUnitRoots();
        this.jTPWorkspace.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    JAdecWatt.this.setCurrentWorkspace(((JScrollPaneWorkspace)JAdecWatt.this.jTPWorkspace.getSelectedComponent()).getWorkspace());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.jTPWorkspace.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int idx = JAdecWatt.this.jTPWorkspace.indexAtLocation(e.getX(), e.getY());
                if (idx < 0) {
                    JAdecWatt.this.stateNotifier.broadcastDisplay(JAdecWatt.BroadcastUnitStory, JAdecWatt.this.currentWorkspace);
                    return;
                }
                JAdecWatt.this.stateNotifier.broadcastDisplay(JAdecWatt.BroadcastUnitStory, ((JScrollPaneWorkspace)JAdecWatt.this.jTPWorkspace.getComponentAt(idx)).getWorkspace());
            }
        });
    }

    public void closeWorkspaces() {
        this.jTPWorkspace.removeAll();
        this.stateNotifier.broadcastUpdate(BroadcastWorkspace);
    }

    public void closeWorkspace(Workspace workspace) {
        JScrollPaneWorkspace jScrollPaneWorkspace = this.getJScrollPaneWorkspace(workspace);
        if (jScrollPaneWorkspace == null) {
            return;
        }
        this.jTPWorkspace.remove(jScrollPaneWorkspace);
        this.stateNotifier.broadcastUpdate(BroadcastWorkspace);
    }

    public void closeCurrentWorkspace() {
        this.jTPWorkspace.remove(this.jTPWorkspace.getSelectedComponent());
        this.stateNotifier.broadcastUpdate(BroadcastWorkspace);
    }

    public void searchUnit(String text) {
        for (Unit<?> rootUnit : this.allJTree.keySet()) {
            int row;
            JTree jTree = this.allJTree.get(rootUnit);
            jTree.clearSelection();
            if (text == null || text.isEmpty()) {
                for (row = jTree.getRowCount() - 1; row > 0; --row) {
                    jTree.collapseRow(row);
                }
                jTree.expandRow(0);
                jTree.scrollPathToVisible(rootUnit.getPath());
                continue;
            }
            for (row = jTree.getRowCount() - 1; row > 0; --row) {
                jTree.collapseRow(row);
            }
            for (Unit<?> unit : rootUnit.search(text)) {
                TreePath path = unit.getPath();
                jTree.expandPath(path);
                jTree.addSelectionPath(path);
                jTree.scrollPathToVisible(path);
            }
        }
    }

    public void searchComp(String text) {
        for (int i = 0; i < this.jTPWorkspace.getTabCount(); ++i) {
            ((JScrollPaneWorkspace)this.jTPWorkspace.getComponentAt(i)).getJWorkspaceView().setSelectedItemsBySearch(text);
        }
    }

    public void displayOrModify(Unit<?> unit) {
        this.adecWatt.broadcastDisplay(this.adecWatt.getUser().isEditor(unit) ? "ModifyUnit" : "DisplayUnit", Arrays.asList(unit));
    }

    public void updateUnitRoots() {
        this.closeWorkspaces();
        this.jTPStorage.removeAll();
        this.allJTree.clear();
        Hashtable<String, Unit<?>> namedRoots = this.adecWatt.getNamedRoots();
        TreeMap sortedRoots = new TreeMap();
        JScrollPane selectedStorage = null;
        for (Unit<?> unit : namedRoots.values()) {
            sortedRoots.put(unit.getLocalName(), unit);
        }
        for (String localName : sortedRoots.descendingKeySet()) {
            Unit unit = (Unit)sortedRoots.get(localName);
            final JTree jTree = new JTree(unit.getUnitNode(), false);
            this.allJTree.put(unit, jTree);
            jTree.setCellRenderer(this.xmlTreeRenderer);
            jTree.setToggleClickCount(0);
            jTree.setFocusable(false);
            JScrollPane currentStorage = Util.getJScrollPane(jTree);
            this.jTPStorage.add(localName, currentStorage);
            if ("building".equals(unit.getName())) {
                selectedStorage = currentStorage;
            }
            jTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int selRow = jTree.getRowForLocation(e.getX(), e.getY());
                    if (selRow < 0) {
                        return;
                    }
                    TreePath selPath = jTree.getPathForLocation(e.getX(), e.getY());
                    Unit unit = ((UnitNode)selPath.getLastPathComponent()).getUnit();
                    JAdecWatt.this.stateNotifier.broadcastDisplay(JAdecWatt.BroadcastUnitStory, unit);
                    if (e.getClickCount() == 2) {
                        e.consume();
                        switch (unit.getTypeToken()) {
                            case Furniture: 
                            case Information: 
                            case Line: 
                            case Accessory: {
                                JAdecWatt.this.displayOrModify(unit);
                                return;
                            }
                        }
                        if (unit.isUncompleted(null) || JAdecWatt.this.isWorkspaceContains(unit, true)) {
                            JAdecWatt.this.displayOrModify(unit);
                            return;
                        }
                        JAdecWatt.this.addWorkspace((Workspace)unit);
                        return;
                    }
                    if (SwingUtilities.isRightMouseButton(e)) {
                        new JUnitPopup(JAdecWatt.this.adecWatt, jTree, unit, e.getPoint());
                        return;
                    }
                    Point rowLocation = jTree.getRowBounds(selRow).getLocation();
                    User user = JAdecWatt.this.adecWatt.getUser();
                    if (!user.isDataStructuresManager() && !user.isEditor(unit) && unit.isUncompleted(null)) {
                        return;
                    }
                    JAdecWatt.this.startDragJDragUnit(new JDragUnit(unit), e, rowLocation);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    JAdecWatt.this.stopJDragUnit(e);
                }
            });
            jTree.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    JAdecWatt.this.dragJDragUnit(e);
                }
            });
        }
        try {
            this.jTPStorage.setSelectedComponent(selectedStorage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateUnit(Unit<?> unit, boolean structChange) {
        try {
            DefaultTreeModel model = (DefaultTreeModel)this.allJTree.get(unit.getUnitRoot()).getModel();
            if (structChange) {
                model.nodeStructureChanged(unit.getUnitNode());
            } else {
                model.nodeChanged(unit.getUnitNode());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addWorkspace(Workspace workspace) {
        if (this.isWorkspaceContains(workspace, true)) {
            return;
        }
        JScrollPaneWorkspace jScrollPaneWorkspace = new JScrollPaneWorkspace(JWorkspaceView.getInstance(this, workspace));
        this.jTPWorkspace.addTab(workspace.toString(), workspace.getIcon(16), jScrollPaneWorkspace);
        this.jTPWorkspace.setSelectedComponent(jScrollPaneWorkspace);
        this.stateNotifier.broadcastUpdate(BroadcastWorkspace);
    }

    public boolean hasWorkspace() {
        return this.jTPWorkspace.getTabCount() > 0;
    }

    public JScrollPaneWorkspace getJScrollPaneWorkspace(Unit<?> unit) {
        for (int i = 0; i < this.jTPWorkspace.getTabCount(); ++i) {
            JScrollPaneWorkspace jScrollPaneWorkspace = (JScrollPaneWorkspace)this.jTPWorkspace.getComponentAt(i);
            if (jScrollPaneWorkspace.getWorkspace() != unit) continue;
            return jScrollPaneWorkspace;
        }
        return null;
    }

    public boolean isWorkspaceContains(Unit<?> unit, boolean select) {
        JScrollPaneWorkspace jScrollPaneWorkspace = this.getJScrollPaneWorkspace(unit);
        if (jScrollPaneWorkspace == null) {
            return false;
        }
        if (select) {
            this.jTPWorkspace.setSelectedComponent(jScrollPaneWorkspace);
        }
        return true;
    }

    public void startDragJDragUnit(JDragUnit jDragUnit, MouseEvent e, Point rowLocation) {
        this.mousePosOnJDragUnit = e.getPoint();
        this.mousePosOnJDragUnit.translate(-rowLocation.x, -rowLocation.y);
        jDragUnit.setBackground(Color.lightGray);
        JRootPane jRootPane = this.getRootPane();
        Point absPos = jRootPane.getMousePosition(true);
        jDragUnit.setLocation(absPos.x - this.mousePosOnJDragUnit.x, absPos.y - this.mousePosOnJDragUnit.y);
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        if (this.selectedJDragUnit != null) {
            jLayeredPane.remove(this.selectedJDragUnit);
        }
        this.selectedJDragUnit = jDragUnit;
        jLayeredPane.add(jDragUnit);
        jLayeredPane.setLayer(jDragUnit, JLayeredPane.DRAG_LAYER);
        this.repaint();
    }

    public void dragJDragUnit(MouseEvent e) {
        if (this.selectedJDragUnit == null) {
            return;
        }
        Point absPos = this.getRootPane().getMousePosition(true);
        try {
            this.selectedJDragUnit.setLocation(absPos.x - this.mousePosOnJDragUnit.x, absPos.y - this.mousePosOnJDragUnit.y);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopJDragUnit(MouseEvent e) {
        if (this.selectedJDragUnit == null) {
            return;
        }
        this.selectedJDragUnit.setVisible(false);
        this.selectedJDragUnit.getParent().remove(this.selectedJDragUnit);
        boolean inWorkspace = false;
        JWorkspaceView jWorkspaceView = null;
        JTree jTree = null;
        try {
            Component component = this.findComponentAt(this.getMousePosition(true));
            Container parent = null;
            while (component != null) {
                parent = component.getParent();
                if (component == this.jTPWorkspace) {
                    inWorkspace = true;
                    break;
                }
                if (component instanceof JTree) {
                    jTree = (JTree)component;
                    break;
                }
                if (component instanceof JWorkspaceView) {
                    jWorkspaceView = (JWorkspaceView)component;
                    break;
                }
                component = parent;
            }
        }
        catch (Exception component) {
            // empty catch block
        }
        Unit<?> src = this.selectedJDragUnit.unit;
        this.selectedJDragUnit = null;
        if (jTree != null) {
            this.dropInJTree(src, jTree, e);
        } else if (!src.isUncompleted(null)) {
            if (jWorkspaceView != null) {
                this.dropInWorkspace(src, jWorkspaceView);
            } else if (inWorkspace) {
                this.dropInEmptySpace(src);
            }
        }
        this.repaint();
    }

    private void dropInJTree(Unit<?> src, JTree jTree, MouseEvent e) {
        User user = this.adecWatt.getUser();
        if (!user.isDataStructuresManager() && !user.isEditor(src)) {
            return;
        }
        int selRow = jTree.getRowForLocation(e.getX(), e.getY());
        if (selRow < 0) {
            return;
        }
        TreePath selPath = jTree.getPathForLocation(e.getX(), e.getY());
        Unit dst = ((UnitNode)selPath.getLastPathComponent()).getUnit();
        src.storyTransform(null, dst, null, null);
    }

    private void dropInEmptySpace(Unit<?> src) {
        switch (src.getTypeToken()) {
            case Furniture: 
            case Information: 
            case Line: 
            case Accessory: {
                return;
            }
            case Building: {
                this.addWorkspace((Building)src);
                break;
            }
            case Lightplot: {
                this.addWorkspace((Lightplot)src);
            }
        }
    }

    private void dropInWorkspace(Unit<?> src, JWorkspaceView<?> jWorkspaceView) {
        Object dst = jWorkspaceView.workspace;
        if (src == dst || src.isUncompleted(null)) {
            return;
        }
        if (src instanceof NonWorkspace && !this.adecWatt.getUser().isEditor((Unit<?>)dst)) {
            return;
        }
        switch (src.getTypeToken()) {
            case Furniture: 
            case Information: {
                jWorkspaceView.dropComp((NonWorkspace)src, jWorkspaceView.getMousePosition(true));
                return;
            }
            case Line: {
                jWorkspaceView.dropSegm((NonWorkspace)src, jWorkspaceView.getMousePosition(true));
                return;
            }
            case Accessory: {
                jWorkspaceView.dropAcc((Accessory)src, jWorkspaceView.getMousePosition(true));
                return;
            }
            case Building: {
                if (((Unit)dst).getTypeToken() == Permanent.UnitTypeEnum.Lightplot && this.adecWatt.getUser().isEditor((Unit<?>)dst)) {
                    ((Lightplot)dst).storyChangeBuilding((Building)src);
                    break;
                }
                this.addWorkspace((Building)src);
                break;
            }
            case Lightplot: {
                if (((Unit)dst).getTypeToken() == Permanent.UnitTypeEnum.Building && this.adecWatt.getUser().isEditor(src)) {
                    if (!this.isWorkspaceContains(src, true)) {
                        this.addWorkspace((Lightplot)src);
                    }
                    ((Lightplot)src).storyChangeBuilding((Building)dst);
                    break;
                }
                this.addWorkspace((Lightplot)src);
            }
        }
    }

    public void displayUpdateUnitTree(Object ... objects) {
        Unit unit = (Unit)objects[0];
        this.updateUnit(unit, true);
    }

    public void displayUpdateWorkspace(Object ... objects) {
        Workspace workspace = (Workspace)objects[0];
        JScrollPaneWorkspace jScrollPaneWorkspace = this.getJScrollPaneWorkspace(workspace);
        if (jScrollPaneWorkspace == null) {
            return;
        }
        Workspace currentWorkspace = this.currentWorkspace;
        this.closeWorkspace(workspace);
        this.addWorkspace(workspace);
        this.setCurrentWorkspace(currentWorkspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayConsole(Object ... objects) {
        JTextArea jTextArea = this.jConsole;
        synchronized (jTextArea) {
            this.jConsole.invalidate();
            String message = (String)objects[0];
            this.jConsole.append(message);
            this.jConsole.validate();
            this.jConsole.repaint();
        }
    }
}

