/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.AdecWatt;
import adecWatt.model.Editable;
import adecWatt.model.PermanentDB;
import adecWatt.model.Unit;
import adecWatt.model.User;
import adecWatt.model.unit.Workspace;
import adecWatt.view.JEditable;
import adecWatt.view.JPatch;
import adecWatt.view.JTransform;
import adecWatt.view.JUser;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.filechooser.FileNameExtensionFilter;
import misc.Bundle;
import misc.Config;
import misc.ImagePreview;
import misc.OwnFrame;
import misc.RemoteUpdateManager;
import misc.Util;

public class JAdecWattDialog
implements SwingConstants {
    OwnFrame controller;
    private Hashtable<Editable<?, ?, ?, ?>, JDialog> currentDisplays = new Hashtable();

    public OwnFrame getOwnFrame() {
        return this.controller;
    }

    public JAdecWattDialog(OwnFrame controller) {
        this.controller = controller;
    }

    public void todo() {
        JOptionPane.showMessageDialog(this.controller.getJFrame(), "TODO !\n Oui, cette fonction n'est pas encore r\u00e9alis\u00e9 :-(");
    }

    public String getSimpleMessage(String msg, String value) {
        return JOptionPane.showInputDialog(this.controller.getJFrame(), msg, value);
    }

    public void magnetPolicies(AdecWatt adecWatt) {
        JPanel content = Util.getGridBagPanel();
        JCheckBox jHandleCD = Util.addCheckIcon("HandleGlue", null, adecWatt.getHandleGlue(), content, Util.GBC);
        Util.addLabel("HandleGlue", 2, content, Util.GBCNL);
        JCheckBox jBoundCB = Util.addCheckIcon("BoundGlue", null, adecWatt.getBoundGlue(), content, Util.GBC);
        Util.addLabel("BoundGlue", 2, content, Util.GBCNL);
        JCheckBox jGridCB = Util.addCheckIcon("GridGlue", null, adecWatt.getGridGlue(), content, Util.GBC);
        Util.addLabel("GridGlue", 2, content, Util.GBCNL);
        JCheckBox jInSegCB = Util.addCheckIcon("InSegmentGlue", null, adecWatt.getInSegmentGlue(), content, Util.GBC);
        Util.addLabel("InSegmentGlue", 2, content, Util.GBCNL);
        if (JOptionPane.showConfirmDialog(this.controller.getJFrame(), content, Bundle.getTitle("MagnetPolicies"), 0) != 0) {
            return;
        }
        adecWatt.setHandleGlue(jHandleCD.isSelected());
        adecWatt.setBoundGlue(jBoundCB.isSelected());
        adecWatt.setGridGlue(jGridCB.isSelected());
        adecWatt.setInSegmentGlue(jInSegCB.isSelected());
    }

    public void patch(Workspace workspace) {
        JPatch content = new JPatch(workspace.getPatch());
        JDialog jDialog = this.removeDisplay(workspace);
        boolean center = false;
        if (jDialog == null) {
            center = true;
            jDialog = new JDialog(this.controller.getJFrame(), "Patch " + workspace.getLocalName(), false);
        }
        Container container = jDialog.getContentPane();
        container.removeAll();
        container.add((Component)content, "Center");
        this.addDisplay(workspace, jDialog, center);
    }

    public JDialog removeDisplay(Editable<?, ?, ?, ?> editable) {
        try {
            JDialog jDialog = this.currentDisplays.get(editable);
            jDialog.setVisible(false);
            this.currentDisplays.remove(editable);
            return jDialog;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void removeAllDisplay() {
        for (Editable<?, ?, ?, ?> editable : this.currentDisplays.keySet()) {
            this.currentDisplays.get(editable).setVisible(false);
        }
        this.currentDisplays.clear();
    }

    private void addDisplay(final Editable<?, ?, ?, ?> editable, JDialog jDialog, boolean center) {
        this.currentDisplays.put(editable, jDialog);
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JAdecWattDialog.this.removeDisplay(editable);
            }
        });
        jDialog.pack();
        if (center) {
            jDialog.setLocation((int)this.controller.getJFrame().getLocation().getX() - (jDialog.getWidth() - this.controller.getJFrame().getWidth()) / 2, (int)this.controller.getJFrame().getLocation().getY() - (jDialog.getHeight() - this.controller.getJFrame().getHeight()) / 2);
        }
        jDialog.setVisible(true);
        jDialog.toFront();
    }

    public void display(boolean edit, List<Editable<?, ?, ?, ?>> editables) {
        Editable<?, ?, ?, ?> editable = editables.get(0);
        JDialog jDialog = this.removeDisplay(editable);
        JEditable jEditable = new JEditable(editables);
        JPanel content = jEditable.getDislay(edit);
        if (!edit) {
            boolean center = false;
            if (jDialog == null) {
                center = true;
                jDialog = new JDialog(this.controller.getJFrame(), editable.getLocalName(), false);
            }
            Container container = jDialog.getContentPane();
            container.removeAll();
            container.add((Component)content, "Center");
            this.addDisplay(editable, jDialog, center);
            return;
        }
        if (JOptionPane.showConfirmDialog(this.controller.getJFrame(), content, Bundle.getTitle("Edit"), 0) != 0) {
            return;
        }
        jEditable.confirmChange();
        jEditable.confirmBundle();
    }

    public void transform(Editable<?, ?, ?, ?> editable) {
        JTransform jTransform = new JTransform(editable);
        do {
            if (JOptionPane.showConfirmDialog(this.controller.getJFrame(), jTransform, Bundle.getTitle("Transform"), 0) == 0) continue;
            return;
        } while (!jTransform.valideChange());
        jTransform.confirmChange();
    }

    public boolean validation(String message, String name, PermanentDB.UnitLocation location) {
        return JOptionPane.showConfirmDialog(this.controller.getJFrame(), MessageFormat.format(Bundle.getMessage(message), new Object[]{name, location}), null, 0) == 0;
    }

    public boolean validation(String message, String name, PermanentDB.UnitLocation location, HashSet<Unit<?>> units, TreeSet<String> icons, TreeSet<String> images) {
        JPanel msgPanel = Util.getGridBagPanel();
        Util.addComponent(new JLabel(MessageFormat.format(Bundle.getMessage(message), new Object[]{name, location})), msgPanel, Util.GBCNL);
        Util.addLabel("Units", 2, msgPanel, Util.GBC);
        Util.addLabel("Icons", 2, msgPanel, Util.GBC);
        Util.addLabel("Images", 2, msgPanel, Util.GBCNL);
        Vector<String> unitsVector = new Vector<String>();
        for (Unit<?> unit : units) {
            unitsVector.add(unit.toString());
        }
        if (icons.size() == 0) {
            icons = new TreeSet<String>(Arrays.asList("            "));
        }
        if (images.size() == 0) {
            images = new TreeSet<String>(Arrays.asList("            "));
        }
        Util.addComponent(Util.getJScrollPane(new JList(unitsVector)), msgPanel, Util.GBC);
        Util.addComponent(Util.getJScrollPane(new JList<String>(new Vector<String>(icons))), msgPanel, Util.GBC);
        Util.addComponent(Util.getJScrollPane(new JList<String>(new Vector<String>(images))), msgPanel, Util.GBCNL);
        return JOptionPane.showConfirmDialog(this.controller.getJFrame(), msgPanel, null, 0) == 0;
    }

    public String getName(String answer) {
        return JOptionPane.showInputDialog(this.controller.getJFrame(), Bundle.getMessage("GiveName"), answer);
    }

    public Double getSpace() {
        String answer = JOptionPane.showInputDialog(this.controller.getJFrame(), Bundle.getMessage("GiveSpace"), "");
        if (answer == null) {
            return -1.0;
        }
        try {
            return Double.parseDouble(answer.replace(",", "."));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void checkAdmin(User user, RemoteUpdateManager remoteUpdateManager) {
        JUser jUser = new JUser(user, remoteUpdateManager);
        switch (JOptionPane.showConfirmDialog(this.controller.getJFrame(), jUser, Bundle.getTitle("ChangeRole"), 1, 2)) {
            case 0: {
                jUser.confirm();
                return;
            }
            case 1: {
                return;
            }
        }
    }

    public boolean abortModification() {
        return JOptionPane.showConfirmDialog(this.controller.getJFrame(), Bundle.getMessage("QuitJAdecWatt"), Bundle.getTitle("AdecWattStillRunning"), 1, 2) == 0;
    }

    public File getChooseOpenFile(File lastFile) {
        JFileChooser jFileChooser = new JFileChooser(Config.getString("ExportDirName", "data/export"));
        jFileChooser.setFileFilter(new FileNameExtensionFilter(Bundle.getLabel("ExportFilter"), PermanentDB.exportExtention));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setAccessory(new ImagePreview(jFileChooser, 0x100000L));
        if (lastFile != null) {
            jFileChooser.setSelectedFile(lastFile);
        }
        if (jFileChooser.showOpenDialog(this.controller.getJFrame()) != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        Config.setFile("ExportDirName", file.getParentFile());
        return file;
    }

    public File getChooseSaveFile(File lastFile) {
        JFileChooser jFileChooser = new JFileChooser(Config.getString("ExportDirName", "data/export"));
        jFileChooser.setFileFilter(new FileNameExtensionFilter(Bundle.getLabel("ExportFilter"), PermanentDB.exportExtention));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setAccessory(new ImagePreview(jFileChooser, 0x100000L));
        if (lastFile != null) {
            jFileChooser.setSelectedFile(lastFile);
        }
        if (jFileChooser.showSaveDialog(this.controller.getJFrame()) != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        Config.setFile("ExportDirName", file.getParentFile());
        return file;
    }
}

