/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.Comp;
import adecWatt.model.Item;
import adecWatt.view.JItem;
import adecWatt.view.JWorkspaceView;
import java.awt.Color;
import java.awt.Dimension;
import misc.ScaledImage;

public class JComp
extends JItem {
    public Comp comp;
    protected boolean isLow;
    protected ScaledImage scaledImage;
    protected Dimension tile = ScaledImage.ONE_TILE;

    @Override
    public Item<?, ?, ?> getItem() {
        return this.comp;
    }

    public boolean isLow() {
        return this.isLow;
    }

    public ScaledImage getScaledImage() {
        return this.scaledImage;
    }

    public JComp(JWorkspaceView<?> jWorkspaceView, Comp comp) {
        super(jWorkspaceView, comp);
    }

    @Override
    public void setItem(Item item) {
        if (item == null) {
            return;
        }
        this.comp = (Comp)item;
        this.scaledImage = this.comp.getIcon();
        this.setCurrentThetaDegree(this.comp.getThetaDegree());
        this.updateLevel();
        this.setCurrentSize();
        this.setCurrentPos();
    }

    @Override
    public void setScale() {
        this.tile = Comp.getTile(this.comp.getTileSize(), this.comp.getSize());
        super.setScale();
    }

    public void updateLevel() {
        Color compColor;
        if (this.comp.getLevel() <= 0.3 == this.isLow) {
            return;
        }
        boolean bl = this.isLow = !this.isLow;
        if (!this.isLow) {
            this.scaledImage = this.comp.getIcon();
            return;
        }
        ScaledImage scaledLowImage = this.comp.getLowIcon();
        if (scaledLowImage != null) {
            this.scaledImage = scaledLowImage;
        }
        if ((compColor = this.comp.getColor()) != null) {
            this.scaledImage = this.comp.getAdecWatt().getIconDB().getColoredScaledImages(this.scaledImage, compColor);
        }
    }

    @Override
    public void updateIcon() {
        if (this.currentPos == null || this.currentSize == null) {
            return;
        }
        this.tile = Comp.getTile(this.comp.getTileSize(), this.currentSize);
        this.updateLevel();
        super.updateIcon();
    }
}

