/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.Editable;
import adecWatt.model.Permanent;
import adecWatt.model.Prop;
import adecWatt.model.Unit;
import adecWatt.view.JDefLabel;
import adecWatt.view.JStringSet;
import adecWatt.view.JTransform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import misc.Bundle;
import misc.Util;

public class JDefPropTable
extends JPanel
implements ActionListener {
    public static final String actionUp = "Up";
    public static final String actionDown = "Down";
    public static final String actionSetEnum = "SetEnum";
    public static final String actionAdd = "Add";
    public static final String actionRemove = "Remove";
    public static final List<String> leftDefPropActionsNames = Arrays.asList("Up", "Down", "SetEnum", "Add");
    public static final List<String> rightDefPropActionsNames = Arrays.asList("Remove");
    public static final Hashtable<String, Method> actionsMethod = Util.collectMethod(JDefPropTable.class, leftDefPropActionsNames, rightDefPropActionsNames);
    private String[] tabExtraNames = new String[]{Bundle.getLabel("Type"), Bundle.getLabel("Property")};
    private JTransform jTransform;
    private Vector<PropShadow> objectData = new Vector();
    private JTable jTableObject;
    private JScrollPane jScrollPane;
    private JButton setEnum;
    public JTextField jNewPropName = new JTextField(16);
    private boolean admin;
    private Collection<String> modifiersSet;
    private int modifiersSetSize;
    private TableObjectModel dataObjectModel;

    @Override
    public void actionPerformed(ActionEvent e) {
        Util.actionPerformed(actionsMethod, e, this);
    }

    public Vector<PropShadow> getObjectData() {
        return this.objectData;
    }

    public JDefPropTable(JTransform jTransform, Editable<?, ?, ?, ?> editable) {
        super(new BorderLayout());
        this.jTransform = jTransform;
        this.admin = jTransform.isAdmin();
        this.modifiersSet = this.admin ? Permanent.PropModifiersSet : Permanent.PropNotHiddenModifiersSet;
        this.modifiersSetSize = this.modifiersSet.size();
        this.dataObjectModel = new TableObjectModel();
        for (Prop prop : editable.getOrderedOwnProps()) {
            if (editable.getParentProp(prop.getName()) != null && prop.enumChoice == null && (prop.getModifiers() == null || prop.getModifiersString().equals(Prop.getModifiersString(editable.getParentPropModifiers(prop.getName()))))) continue;
            Collection<String> parentModifiers = editable.getParentPropModifiers(prop.getName());
            this.objectData.add(new PropShadow(prop.getName(), prop, parentModifiers));
        }
        this.jTableObject = new JTable(this.dataObjectModel){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                int idx = JDefPropTable.this.jTableObject.getSelectedRow();
                JDefPropTable.this.updateSetEnum(idx < 0 ? null : (PropShadow)JDefPropTable.this.objectData.elementAt(idx));
            }
        };
        this.jTableObject.getTableHeader().setReorderingAllowed(true);
        this.jTableObject.setShowHorizontalLines(false);
        this.jTableObject.setShowVerticalLines(false);
        this.jTableObject.setRowSelectionAllowed(true);
        this.jTableObject.setColumnSelectionAllowed(false);
        this.jTableObject.setRowHeight(24);
        this.jTableObject.setSelectionMode(0);
        int columnIdx = 0;
        for (String modifier : this.modifiersSet) {
            CheckIconEditorRenderer editor = new CheckIconEditorRenderer(modifier);
            TableColumn tableColumn = this.jTableObject.getColumnModel().getColumn(columnIdx);
            tableColumn.setCellRenderer(editor);
            tableColumn.setCellEditor(editor);
            tableColumn.setMaxWidth(24);
            ++columnIdx;
        }
        EnumEditorRenderer enumEditorRenderer = new EnumEditorRenderer(Permanent.PropTypeEnum.class);
        TableColumn tableColumn = this.jTableObject.getColumnModel().getColumn(columnIdx);
        tableColumn.setCellRenderer(enumEditorRenderer);
        tableColumn.setCellEditor(enumEditorRenderer);
        this.jScrollPane = Util.getJScrollPane(this.jTableObject);
        this.add((Component)this.jScrollPane, "Center");
        this.dataObjectModel.revalidate(-1);
        JPanel propCmdPanel = new JPanel(new BorderLayout());
        JPanel leftPropCmdPanel = new JPanel();
        Util.addIconButton(leftDefPropActionsNames, (ActionListener)this, (Container)leftPropCmdPanel);
        propCmdPanel.add((Component)leftPropCmdPanel, "West");
        propCmdPanel.add((Component)this.jNewPropName, "Center");
        propCmdPanel.add((Component)Util.newIconButton(actionRemove, (ActionListener)this), "East");
        this.add((Component)propCmdPanel, "South");
        Hashtable<String, AbstractButton> buttons = Util.collectButtons(null, leftPropCmdPanel);
        Util.collectButtons(buttons, propCmdPanel);
        for (AbstractButton button : buttons.values()) {
            Util.unBoxButton(button);
        }
        this.setEnum = (JButton)buttons.get(actionSetEnum);
        this.updateSetEnum(null);
    }

    public void actionUp() {
        this.dataObjectModel.move(-1);
    }

    public void actionDown() {
        this.dataObjectModel.move(1);
    }

    public void actionSetEnum() {
        this.dataObjectModel.setEnum();
    }

    public void actionAdd() {
        String propName = this.jNewPropName.getText();
        if (this.dataObjectModel.contains(propName)) {
            return;
        }
        this.dataObjectModel.addRow(propName);
        this.jNewPropName.setText("");
    }

    public void actionRemove() {
        this.dataObjectModel.removeRow();
    }

    public void updateSetEnum(PropShadow prop) {
        boolean enable = false;
        try {
            switch (Permanent.PropTypeEnum.values()[prop.jType.getSelectedIndex()]) {
                case Enum: {
                    enable = true;
                    break;
                }
                case Square: 
                case Geo: 
                case Cube: {
                    enable = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setEnum.setEnabled(enable);
    }

    public class TableObjectModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return JDefPropTable.this.modifiersSetSize + JDefPropTable.this.tabExtraNames.length;
        }

        @Override
        public int getRowCount() {
            return JDefPropTable.this.objectData.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= JDefPropTable.this.objectData.size()) {
                return null;
            }
            PropShadow prop = (PropShadow)JDefPropTable.this.objectData.elementAt(row);
            if (column < JDefPropTable.this.modifiersSetSize) {
                return prop.jModifiers.get(column);
            }
            switch (column - JDefPropTable.this.modifiersSetSize) {
                case 0: {
                    return prop.jType;
                }
                case 1: {
                    return prop.propName;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            if (column < JDefPropTable.this.modifiersSetSize) {
                return "";
            }
            return JDefPropTable.this.tabExtraNames[column - JDefPropTable.this.modifiersSetSize];
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column < JDefPropTable.this.modifiersSetSize) {
                return JCheckBox.class;
            }
            switch (column - JDefPropTable.this.modifiersSetSize) {
                case 0: {
                    return JComboBox.class;
                }
                case 1: {
                    return String.class;
                }
            }
            throw new IllegalArgumentException("Column 0 >= " + column + " > " + (JDefPropTable.this.modifiersSetSize + 2));
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            PropShadow prop = (PropShadow)JDefPropTable.this.objectData.elementAt(row);
            if (prop == null) {
                return false;
            }
            return !JDefPropTable.this.jTransform.isLock(prop.propName) || JDefPropTable.this.admin;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            PropShadow prop = (PropShadow)JDefPropTable.this.objectData.elementAt(row);
            if (column < JDefPropTable.this.modifiersSetSize) {
                prop.jModifiers.get(column).setSelected((Boolean)aValue);
                return;
            }
            switch (column - JDefPropTable.this.modifiersSetSize) {
                case 0: {
                    prop.jType.setSelectedItem((String)aValue);
                    JDefPropTable.this.updateSetEnum(prop);
                    return;
                }
                case 1: {
                    prop.propName = (String)aValue;
                    return;
                }
            }
        }

        public void revalidate(int idx) {
            if (JDefPropTable.this.jTableObject == null) {
                return;
            }
            JDefPropTable.this.jTableObject.revalidate();
            JDefPropTable.this.jTableObject.getSelectionModel().clearSelection();
            Dimension preferredSize = new Dimension(JDefPropTable.this.jTableObject.getPreferredSize());
            preferredSize.height += 40;
            JDefPropTable.this.jScrollPane.setPreferredSize(preferredSize);
            Util.packWindow(JDefPropTable.this.jScrollPane);
            if (idx < 0) {
                return;
            }
            JDefPropTable.this.jTableObject.getSelectionModel().setLeadSelectionIndex(idx);
        }

        public boolean contains(String propName) {
            for (PropShadow prop : JDefPropTable.this.objectData) {
                if (!prop.propName.equals(propName)) continue;
                return true;
            }
            return false;
        }

        public void addRow(String propName) {
            JDefPropTable.this.objectData.add(new PropShadow(propName, null, null));
            this.revalidate(JDefPropTable.this.objectData.size() - 1);
        }

        public void removeRow() {
            int idx = JDefPropTable.this.jTableObject.getSelectedRow();
            if (idx < 0) {
                return;
            }
            Prop prop = ((PropShadow)((JDefPropTable)JDefPropTable.this).objectData.get((int)idx)).prop;
            if (prop != null && prop.isLock() && !JDefPropTable.this.admin) {
                return;
            }
            JDefPropTable.this.objectData.remove(idx);
            if (idx == JDefPropTable.this.objectData.size()) {
                --idx;
            }
            this.revalidate(idx);
        }

        public void move(int delta) {
            int idx = JDefPropTable.this.jTableObject.getSelectedRow();
            if (idx < 0) {
                return;
            }
            int mod = JDefPropTable.this.objectData.size();
            PropShadow old = (PropShadow)JDefPropTable.this.objectData.remove(idx);
            if ((idx = (idx + delta + mod) % mod) == JDefPropTable.this.objectData.size()) {
                JDefPropTable.this.objectData.add(old);
            } else {
                JDefPropTable.this.objectData.add(idx, old);
            }
            this.revalidate(idx);
        }

        public void setEnum() {
            int idx = JDefPropTable.this.jTableObject.getSelectedRow();
            if (idx < 0) {
                return;
            }
            int nbLabel = 0;
            switch (Permanent.PropTypeEnum.values()[((PropShadow)((JDefPropTable)JDefPropTable.this).objectData.elementAt((int)idx)).jType.getSelectedIndex()]) {
                case Enum: {
                    JStringSet jStringSet = ((PropShadow)((JDefPropTable)JDefPropTable.this).objectData.elementAt((int)idx)).jStringSet;
                    jStringSet.init();
                    if (JOptionPane.showConfirmDialog(JDefPropTable.this, jStringSet, null, 0) != 0) {
                        return;
                    }
                    jStringSet.confirm();
                    return;
                }
                case Square: 
                case Geo: {
                    nbLabel = 2;
                    break;
                }
                case Cube: {
                    nbLabel = 3;
                    break;
                }
                default: {
                    return;
                }
            }
            JDefLabel jDefLabel = ((PropShadow)((JDefPropTable)JDefPropTable.this).objectData.elementAt((int)idx)).jDefLabel;
            jDefLabel.initLabels(nbLabel);
            if (JOptionPane.showConfirmDialog(JDefPropTable.this, jDefLabel, null, 0) != 0) {
                return;
            }
            jDefLabel.confirmLabels();
        }
    }

    public class PropShadow {
        String propName;
        Prop prop;
        Collection<String> oldModifiers;
        Collection<String> parentModifiers;
        ArrayList<JCheckBox> jModifiers;
        JComboBox<String> jType;
        JStringSet jStringSet;
        JDefLabel jDefLabel;

        public PropShadow(String propName, Prop prop, Collection<String> parentModifiers) {
            this.propName = propName;
            this.prop = prop;
            Collection<String> collection = this.oldModifiers = prop == null ? null : prop.getModifiers();
            if (parentModifiers != null && parentModifiers.size() > 0) {
                this.parentModifiers = parentModifiers;
            }
            this.jType = Util.newEnum(Permanent.PropTypeEnum.class, Permanent.PropTypeEnum.Text);
            if (prop != null) {
                this.oldModifiers = prop.getModifiers();
                this.jType.setSelectedIndex(prop.getTypeToken().ordinal());
            } else {
                try {
                    Unit<?> parent = JDefPropTable.this.jTransform.getPermanent().getDirectUnit();
                    this.oldModifiers = parent.getPropModifiers(propName);
                    this.jType.setSelectedIndex(parent.getProp(propName).getTypeToken().ordinal());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.jModifiers = JTransform.getJModifiers(JDefPropTable.this.modifiersSet, this.oldModifiers, JDefPropTable.this.jTransform.isLock(propName) && !JDefPropTable.this.admin);
            this.jStringSet = new JStringSet(prop == null ? null : prop.enumChoice);
            this.jDefLabel = new JDefLabel(prop == null ? null : prop.multiLabel);
        }

        public Collection<String> getModifiers() {
            Collection<String> modifiers = JTransform.getModifiers(this.jModifiers, this.oldModifiers, JDefPropTable.this.admin, Permanent.PropHiddenModifiersSet);
            if (modifiers == null || this.parentModifiers == null) {
                return modifiers;
            }
            if (Permanent.getModifiersString(this.parentModifiers).equals(Permanent.getModifiersString(modifiers))) {
                return null;
            }
            return modifiers;
        }
    }

    public class CheckIconEditorRenderer
    extends DefaultCellEditor
    implements TableCellRenderer {
        public CheckIconEditorRenderer(String action) {
            super(Util.newCheckIcon(Util.toCapital(action), null));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JCheckBox)this.editorComponent).setSelected(((JCheckBox)value).isSelected());
            return this.editorComponent;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            PropShadow prop = (PropShadow)JDefPropTable.this.objectData.elementAt(row);
            JCheckBox jCheckBox = prop.jModifiers.get(Util.viewToModel(table, column));
            if (jCheckBox == null) {
                return null;
            }
            jCheckBox.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            jCheckBox.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            jCheckBox.setSelected(((JCheckBox)value).isSelected());
            return jCheckBox;
        }
    }

    public class EnumEditorRenderer
    extends DefaultCellEditor
    implements TableCellRenderer {
        public EnumEditorRenderer(Class<? extends Enum<?>> enumClass) {
            super(Util.newEnum(enumClass, null));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JComboBox)this.editorComponent).setSelectedIndex(((JComboBox)value).getSelectedIndex());
            return this.editorComponent;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComboBox<String> jCombobox = ((PropShadow)((JDefPropTable)JDefPropTable.this).objectData.elementAt((int)row)).jType;
            jCombobox.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            jCombobox.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            jCombobox.setSelectedItem(((JComboBox)value).getSelectedIndex());
            return jCombobox;
        }
    }
}

