/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.AdecWatt;
import adecWatt.model.Editable;
import adecWatt.model.Permanent;
import adecWatt.model.Prop;
import adecWatt.model.Unit;
import adecWatt.model.unit.Workspace;
import adecWatt.view.JProp;
import adecWatt.view.PrintWorkspace;
import adecWatt.view.jProp.JPropGeo;
import adecWatt.view.jProp.JPropIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;
import misc.Bundle;
import misc.LocalizedUserLabel;
import misc.ScaledImage;
import misc.Story;
import misc.Util;

public class JEditable
implements SwingConstants {
    public static final int previewSize = 800;
    private Unit<?> storyUnit;
    private HashSet<Editable<?, ?, ?, ?>> editableSet = new HashSet();
    private boolean linguist;
    private JTabbedPane jTabbedPane = new JTabbedPane();
    private JPanel jPropList = Util.getGridBagPanel();
    protected LocalizedUserLabel localizedUserLabel;
    private ArrayList<LocalizedUserLabel> localizedTabName = new ArrayList();
    private JPropGeo firstGeo;
    ArrayList<JProp> allProps = new ArrayList();

    public boolean isLinguist() {
        return this.linguist;
    }

    public AdecWatt getAdecWatt() {
        return this.storyUnit.getAdecWatt();
    }

    public void addLocalizedUserLabel(LocalizedUserLabel localizedUserLabel) {
        this.localizedTabName.add(localizedUserLabel);
    }

    public String getId() {
        if (this.editableSet.size() > 1) {
            return "MIX";
        }
        Iterator<Editable<?, ?, ?, ?>> iterator = this.editableSet.iterator();
        if (iterator.hasNext()) {
            Editable<?, ?, ?, ?> editable = iterator.next();
            return editable.getId();
        }
        return null;
    }

    public String getModelName() {
        String result = null;
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            try {
                String model = editable.getModel().getLocalName();
                if (result == null) {
                    result = model;
                    continue;
                }
                if (result.equals(model)) continue;
                return "MIX";
            }
            catch (Exception e) {
                return null;
            }
        }
        return result;
    }

    public String getName() {
        if (this.editableSet.size() > 1) {
            return "MIX";
        }
        Iterator<Editable<?, ?, ?, ?>> iterator = this.editableSet.iterator();
        if (iterator.hasNext()) {
            Editable<?, ?, ?, ?> editable = iterator.next();
            return editable.getName();
        }
        return null;
    }

    public List<String> getOrderedPropsName() {
        ArrayList<String> result = null;
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            ArrayList<String> tmp = editable.getOrderedPropsName();
            if (tmp == null) continue;
            if (result == null) {
                result = tmp;
                continue;
            }
            result.retainAll(tmp);
        }
        return result;
    }

    public Permanent.PropTypeEnum getTypeToken(String propName) {
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            Prop type = editable.getProp(propName);
            if (type == null) continue;
            return type.getTypeToken();
        }
        return null;
    }

    public int getNbVal(String propName) {
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            Prop type = editable.getProp(propName);
            if (type == null) continue;
            return type.nbVal;
        }
        return 0;
    }

    public List<String> getPropLabel(String propName) {
        List<String> result = null;
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            List<String> tmp = editable.getPropLabel(propName);
            if (result == null) {
                result = tmp;
                continue;
            }
            if (result.equals(tmp)) continue;
            return null;
        }
        return result;
    }

    public Collection<String> getPropEnumChoice(String propName) {
        Collection<String> result = null;
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            Collection<String> tmp = editable.getPropEnumChoice(propName);
            if (result == null) {
                result = tmp;
                continue;
            }
            if (result.equals(tmp)) continue;
            return null;
        }
        return result;
    }

    public boolean getPropHidden(String propName) {
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            if (editable.getPropHidden(propName)) continue;
            return false;
        }
        return true;
    }

    public boolean getPropLocalized(String propName) {
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            if (!editable.getPropLocalized(propName)) continue;
            return true;
        }
        return false;
    }

    public boolean getPropHorizontalSpin(String propName, boolean skipFirst) {
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            if (!editable.getPropHorizontalSpin(propName, skipFirst)) continue;
            return true;
        }
        return false;
    }

    public String getPropValue(String propName, boolean skipFirst) {
        String result = null;
        boolean nullExist = false;
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            try {
                String tmp = editable.getPropVal((String)propName, (boolean)skipFirst).sValue;
                if (tmp == null) {
                    if (result != null) {
                        return "MIX";
                    }
                    nullExist = true;
                    continue;
                }
                if (result == null) {
                    if (nullExist) {
                        return "MIX";
                    }
                    result = tmp;
                    continue;
                }
                if (result.equals(tmp)) continue;
                return "MIX";
            }
            catch (Exception e) {
                if (!skipFirst && editable.getProp(propName) == null) {
                    return "MIX";
                }
                nullExist = true;
            }
        }
        if (result != null && nullExist) {
            return "MIX";
        }
        return result;
    }

    public Double[] getPartialPropValue(String propName, int nbVal, boolean skipFirst) {
        Double[] result = null;
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            Double[] tmp = new Double[nbVal];
            editable.getPartialProp(propName, tmp, skipFirst);
            if (result == null) {
                result = tmp;
                continue;
            }
            int nbMix = 0;
            for (int i = 0; i < result.length; ++i) {
                if (result[i] == Prop.DoubleMix) {
                    ++nbMix;
                    continue;
                }
                if (result[i] == tmp[i] || result[i] != null && result[i].equals(tmp[i])) continue;
                result[i] = Prop.DoubleMix;
                ++nbMix;
            }
            if (nbMix != result.length) continue;
            return result;
        }
        return result;
    }

    public ScaledImage getPreview() {
        try {
            return new ScaledImage(PrintWorkspace.getIcon((Workspace)this.storyUnit, 800, true));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setFirstGeo(JPropGeo firstGeo) {
        if (this.firstGeo == null) {
            this.firstGeo = firstGeo;
        }
    }

    public void plotCity(double latitude, double longitude) {
        if (this.firstGeo == null) {
            return;
        }
        this.firstGeo.setGeo(latitude, longitude);
    }

    public void toFront(Component c) {
        this.jTabbedPane.setSelectedComponent(c);
    }

    public JEditable(List<Editable<?, ?, ?, ?>> editables) {
        for (Editable<?, ?, ?, ?> editable : editables) {
            Unit<?> storyUnit = editable.getStoryUnit();
            if (this.storyUnit != null && storyUnit != this.storyUnit) {
                throw new IllegalArgumentException("Can't managed heterogenous unit");
            }
            this.storyUnit = storyUnit;
            this.editableSet.add(editable);
        }
        if (this.storyUnit == null) {
            throw new IllegalArgumentException("Can't managed no unit");
        }
        this.linguist = this.getAdecWatt().getUser().isLinguist();
    }

    public JPanel getDislay(boolean edit) {
        JPanel jDisplay = new JPanel(new BorderLayout());
        JPanel right = new JPanel();
        jDisplay.add((Component)right, "East");
        right.add(this.jPropList);
        String editableId = this.getId();
        String modelName = this.getModelName();
        modelName = modelName == null || modelName == "MIX" ? "" : " (" + modelName + ")";
        JLabel jLabelId = new JLabel((editableId == "MIX" ? Bundle.getMessage("MixId") : editableId) + modelName);
        jLabelId.setForeground(Color.GRAY);
        Util.addComponent(jLabelId, this.jPropList, Util.GBCNL);
        JPropIcon jPropIcon = new JPropIcon("icon", this);
        String editableName = this.getName();
        JLabel jLabelName = null;
        if (editableName == "MIX") {
            jLabelName = new JLabel(Bundle.getMessage("MixName"));
        } else {
            this.localizedUserLabel = new LocalizedUserLabel(editableName, this.storyUnit.isLocalized(), this.linguist);
            jLabelName = this.localizedUserLabel.getJLabel();
        }
        jLabelName.setHorizontalTextPosition(4);
        this.allProps.add(jPropIcon);
        Util.addComponent(jPropIcon.getMainIcon(edit), this.jPropList, Util.GBC);
        Util.addComponent(jLabelName, this.jPropList, Util.GBCNL);
        for (String propName : this.getOrderedPropsName()) {
            try {
                if ("icon".equals(propName)) continue;
                JProp jProp = JProp.getJProp(propName, this);
                this.allProps.add(jProp);
                jProp.display(edit, this.jPropList, this.jTabbedPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.jTabbedPane.getTabCount() > 0) {
            jDisplay.add((Component)this.jTabbedPane, "Center");
        }
        if (this.linguist) {
            this.jTabbedPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int idx = JEditable.this.jTabbedPane.indexAtLocation(e.getX(), e.getY());
                    if (idx < 0) {
                        return;
                    }
                    LocalizedUserLabel localizedUserLabel = (LocalizedUserLabel)JEditable.this.localizedTabName.get(idx);
                    localizedUserLabel.mousePressed(e);
                    JEditable.this.jTabbedPane.setTitleAt(idx, localizedUserLabel.getCurrentLabel());
                }
            });
        }
        return jDisplay;
    }

    public boolean valideChange() {
        return true;
    }

    public void confirmBundle() {
        String newLabel;
        if (!this.getAdecWatt().getUser().isLinguist()) {
            return;
        }
        if (this.localizedUserLabel != null && (newLabel = this.localizedUserLabel.getNewLabel()) != null) {
            Bundle.setUser("AdecWattUser", this.getName(), newLabel);
        }
        for (JProp jProp : this.allProps) {
            jProp.confirmBundle();
        }
        Bundle.save("AdecWattUser");
    }

    public void updateStoryView() {
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            editable.updateView();
        }
    }

    public void confirmChange() {
        Story story = this.storyUnit.story;
        Objects.requireNonNull(story);
        Story.Commands commands = new Story.Commands(story, "Edit"){
            {
                Story story = x0;
                Objects.requireNonNull(story);
                super(story, arg0);
            }

            @Override
            public void display() {
                JEditable.this.updateStoryView();
            }
        };
        for (Editable<?, ?, ?, ?> editable : this.editableSet) {
            ArrayList<Prop[]> changeProps = new ArrayList<Prop[]>();
            for (JProp jProp : this.allProps) {
                String propName = jProp.getPropName();
                Prop[] props = new Prop[]{editable.getProp(propName), editable.getParentPropVal(propName), editable.getOwnProp(propName), null};
                jProp.getChange(props);
                changeProps.add(props);
            }
            editable.storyChange(commands, changeProps);
        }
        this.storyUnit.story.add(commands);
    }
}

