/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.Comp;
import adecWatt.model.Item;
import adecWatt.model.Segm;
import adecWatt.model.unit.Workspace;
import adecWatt.view.JComp;
import adecWatt.view.JSegm;
import adecWatt.view.JWorkspaceView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import misc.DimensionDouble;
import misc.Log;

public abstract class JItem
extends JLabel {
    protected ItemMouseAdapter itemMouseAdapter = new ItemMouseAdapter();
    protected JWorkspaceView<?> jWorkspaceView;
    protected double currentThetaDegree;
    protected Point2D.Double currentPos;
    protected DimensionDouble currentSize;
    protected double[] currentBounds = null;

    public abstract Item getItem();

    public abstract void setItem(Item var1);

    public JWorkspaceView<?> getJWorkspaceView() {
        return this.jWorkspaceView;
    }

    public Point2D.Double getCurrentPos() {
        return this.currentPos;
    }

    public DimensionDouble getCurrentSize() {
        return this.currentSize;
    }

    public double getCurrentThetaDegree() {
        return this.currentThetaDegree;
    }

    public double[] getCurrentBounds() {
        return this.currentBounds;
    }

    public static JItem getNewJItem(JWorkspaceView<?> jWorkspaceView, Item item) {
        if (item instanceof Comp) {
            return new JComp(jWorkspaceView, (Comp)item);
        }
        if (item instanceof Segm) {
            return new JSegm(jWorkspaceView, (Segm)item);
        }
        throw new IllegalArgumentException("Bad item type (" + item + ")!");
    }

    public JItem(JWorkspaceView<?> jWorkspaceView, Item item) {
        try {
            this.jWorkspaceView = jWorkspaceView;
            this.setItem(item);
            this.setCurrentSize();
            this.updateIcon();
            this.addMouseListener(this.itemMouseAdapter);
            this.addMouseMotionListener(this.itemMouseAdapter);
        }
        catch (Exception e) {
            Log.keepLastException("JItem (" + this.getItem() + ") :", e);
        }
    }

    public void setCurrentPos(Point2D.Double currentPos) {
        this.currentPos = currentPos;
        this.updateBounds();
        this.updateLocation();
    }

    public void setCurrentSize(DimensionDouble size) {
        this.currentSize = size;
        this.updateBounds();
        this.updateIcon();
    }

    public void setCurrentThetaDegree(double currentThetaDegree) {
        this.currentThetaDegree = currentThetaDegree;
        this.updateBounds();
        this.updateIcon();
    }

    public void setCurrentSize(Point2D.Double pos, DimensionDouble size) {
        this.setCurrentGeo(pos, this.getItem().getThetaDegree(), size);
    }

    public void setCurrentGeoDelta(Point2D.Double pos, double deltaTheta, DimensionDouble size) {
        this.setCurrentGeo(pos, Math.toDegrees(Math.toRadians(this.currentThetaDegree) + deltaTheta), size);
    }

    private void setCurrentGeo(Point2D.Double pos, double thetaDegree, DimensionDouble size) {
        this.currentPos = pos;
        this.currentSize = size;
        this.currentThetaDegree = thetaDegree;
        this.updateBounds();
        this.updateIcon();
    }

    public void setCurrentPos() {
        this.setCurrentPos(this.getItem().getPos());
    }

    public void setCurrentSize() {
        this.setCurrentSize(this.getItem().getSize());
    }

    public void setCurrentThetaDegree() {
        this.setCurrentThetaDegree(this.getItem().getThetaDegree());
    }

    public void setScale() {
        this.updateIcon();
    }

    public void updateLocation() {
        if (this.currentPos == null) {
            return;
        }
        Point pos = this.jWorkspaceView.scaleModelToView(this.currentPos);
        pos.x -= this.getWidth() / 2;
        pos.y -= this.getHeight() / 2;
        this.setLocation(pos);
        this.jWorkspaceView.setLayer(this, this.jWorkspaceView.levelModelToView(this.getItem().getLevel()));
    }

    public void cap(Point relPos) {
        Dimension size = this.getSize();
        this.setCurrentThetaDegree(Math.toDegrees(1.5707963267948966 + Math.atan2(relPos.y - size.height / 2, relPos.x - size.width / 2)));
    }

    public void rotation(MouseEvent e) {
        this.cap(e.getPoint());
    }

    public void dragItem(DimensionDouble delta) {
        this.setCurrentPos(new Point2D.Double(this.currentPos.x + delta.width, this.currentPos.y + delta.height));
    }

    public void updateIcon() {
        if (this.currentPos == null || this.currentSize == null) {
            return;
        }
        double scale = this.jWorkspaceView.getScale();
        Item item = this.getItem();
        DimensionDouble size = Item.getRotSize(new DimensionDouble(this.currentSize.width * scale, this.currentSize.height * scale), this.currentThetaDegree);
        BufferedImage image = new BufferedImage(Math.max(1, (int)size.width), Math.max(1, (int)size.height), 2);
        DimensionDouble currentRotSize = Item.getRotSize(this.currentSize, this.currentThetaDegree);
        Point2D.Double halfCurrentRotSize = new Point2D.Double(currentRotSize.width / 2.0, currentRotSize.height / 2.0);
        Graphics2D printGraphics = (Graphics2D)image.getGraphics();
        printGraphics.scale(scale, scale);
        item.print(printGraphics, (Workspace)this.jWorkspaceView.getWorkspace(), halfCurrentRotSize, this.currentSize, this.currentThetaDegree);
        this.setIcon(new ImageIcon(image));
        this.setSize(this.getPreferredSize());
        this.updateLocation();
    }

    public void updateBounds() {
        if (this.currentPos == null || this.currentSize == null) {
            return;
        }
        this.currentBounds = Item.getBounds(this.currentPos, this.currentSize, this.currentThetaDegree);
    }

    public class ItemMouseAdapter
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            JItem.this.jWorkspaceView.mouseClicked(SwingUtilities.convertMouseEvent(JItem.this, e, JItem.this.jWorkspaceView));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MouseEvent ec = SwingUtilities.convertMouseEvent(JItem.this, e, JItem.this.jWorkspaceView);
            JItem.this.jWorkspaceView.mousePressed(ec);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JItem.this.jWorkspaceView.mouseReleased(SwingUtilities.convertMouseEvent(JItem.this, e, JItem.this.jWorkspaceView));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JItem.this.jWorkspaceView.mouseDragged(SwingUtilities.convertMouseEvent(JItem.this, e, JItem.this.jWorkspaceView));
        }
    }
}

