/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.unit.Workspace;
import adecWatt.view.JItem;
import adecWatt.view.JItemPopup;
import adecWatt.view.JWorkspaceView;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import misc.DimensionDouble;
import misc.Util;

public class JItemHandler {
    public static final ImageIcon handlerImage = Util.loadActionIcon("handler");
    public JWorkspaceView<?> jWorkspaceView;
    public JLabel jSelectionPane;
    public JItem jItem;
    public HandlerSet corners;
    public HandlerSet sides;
    public boolean lineSelection;
    Point mousePosOnItem;
    int selectedIndex;
    double oposedX;
    double oposedY;
    DimensionDouble currentSize;
    double currentDiagonalLength;

    public JItemHandler(JWorkspaceView<?> jWorkspaceView, JLabel jSelectionPane, JItem jItem, boolean lineSelection) {
        this.jWorkspaceView = jWorkspaceView;
        this.jSelectionPane = jSelectionPane;
        this.jItem = jItem;
        this.lineSelection = lineSelection;
        if (!lineSelection) {
            this.corners = new HandlerSet(true);
        }
        this.sides = new HandlerSet(false);
    }

    public void setCurrentBounds(double[] bounds) {
        if (this.corners != null) {
            this.corners.setCurrentBounds(bounds);
        }
        this.sides.setCurrentBounds(bounds);
    }

    class HandlerSet {
        public boolean cornerSelection;
        public double[] x = new double[4];
        public double[] y = new double[4];
        public JLabel[] handlers = new JLabel[4];

        public HandlerSet(boolean cornerSelection) {
            this.cornerSelection = cornerSelection;
            for (int i = 0; i < 4; ++i) {
                if (i % 2 != 0 && JItemHandler.this.lineSelection) continue;
                final JLabel handler = new JLabel(handlerImage);
                final int index = i;
                this.handlers[i] = handler;
                handler.setSize(8, 8);
                MouseAdapter mouseAdapter = new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (SwingUtilities.isRightMouseButton(e)) {
                            new JItemPopup(JItemHandler.this.jWorkspaceView, JItemHandler.this.jItem.getItem(), SwingUtilities.convertPoint(handler, e.getPoint(), JItemHandler.this.jWorkspaceView));
                            return;
                        }
                        JItemHandler.this.selectedIndex = index;
                        JItemHandler.this.oposedX = HandlerSet.this.x[(index + 2) % 4];
                        JItemHandler.this.oposedY = HandlerSet.this.y[(index + 2) % 4];
                        JItemHandler.this.currentSize = JItemHandler.this.jItem.getCurrentSize();
                        JItemHandler.this.currentDiagonalLength = Math.sqrt(JItemHandler.this.currentSize.width * JItemHandler.this.currentSize.width + JItemHandler.this.currentSize.height * JItemHandler.this.currentSize.height);
                        JItemHandler.this.mousePosOnItem = e.getPoint();
                    }

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        if (JItemHandler.this.jWorkspaceView.notEditable()) {
                            return;
                        }
                        HandlerSet.this.dragHandler(e);
                        JItemHandler.this.jWorkspaceView.updateSelectionLayer();
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (JItemHandler.this.jWorkspaceView.notEditable()) {
                            return;
                        }
                        JItemHandler.this.jWorkspaceView.storyRotResizeItem(JItemHandler.this.jItem);
                    }
                };
                handler.addMouseListener(mouseAdapter);
                handler.addMouseMotionListener(mouseAdapter);
            }
        }

        public void setCurrentBounds(double[] bounds) {
            int k;
            int j;
            int i;
            if (this.cornerSelection) {
                i = 0;
                j = 1;
                for (k = 0; k < 4; ++k) {
                    this.x[k] = bounds[i];
                    this.y[k] = bounds[j];
                    i += 2;
                    j += 2;
                }
            } else {
                i = 8;
                j = 9;
                for (k = 0; k < 4; ++k) {
                    this.x[k] = bounds[i];
                    this.y[k] = bounds[j];
                    i += 2;
                    j += 2;
                }
            }
            double scale = JItemHandler.this.jWorkspaceView.getScale();
            for (k = 0; k < 4; ++k) {
                JLabel handler = this.handlers[k];
                if (handler == null) continue;
                handler.setLocation((int)(this.x[k] * scale - 4.0), (int)(this.y[k] * scale - 4.0));
                JItemHandler.this.jWorkspaceView.recordJLabel(handler);
            }
        }

        public void dragHandler(MouseEvent e) {
            double scale = JItemHandler.this.jWorkspaceView.getScale();
            Point newPos = e.getPoint();
            double newX = this.x[JItemHandler.this.selectedIndex] + (double)(newPos.x - JItemHandler.this.mousePosOnItem.x) / scale;
            double newY = this.y[JItemHandler.this.selectedIndex] + (double)(newPos.y - JItemHandler.this.mousePosOnItem.y) / scale;
            Point2D.Double closePos = new Point2D.Double(newX, newY);
            JItemHandler.this.jWorkspaceView.setSelectedBound(e.isControlDown() ? null : ((Workspace)JItemHandler.this.jWorkspaceView.getWorkspace()).getMagnetPoint(closePos, JWorkspaceView.onGrid(closePos), 10.0 / scale));
            Point2D.Double newItemCenter = new Point2D.Double((JItemHandler.this.oposedX + closePos.x) / 2.0, (JItemHandler.this.oposedY + closePos.y) / 2.0);
            DimensionDouble newItemSize = null;
            if (e.isShiftDown()) {
                double currentTheta = Math.toRadians(JItemHandler.this.jItem.getCurrentThetaDegree());
                double[] reverse = new double[]{closePos.x - newItemCenter.x, closePos.y - newItemCenter.y};
                AffineTransform.getRotateInstance(-currentTheta).transform(reverse, 0, reverse, 0, 1);
                newItemSize = new DimensionDouble(Math.max(1.0 / scale, Math.abs(reverse[0] * 2.0)), Math.max(1.0 / scale, Math.abs(reverse[1] * 2.0)));
                if (!this.cornerSelection) {
                    if (JItemHandler.this.selectedIndex % 2 == 0) {
                        newItemSize.height = JItemHandler.this.currentSize.height;
                        reverse[1] = 0.0;
                    } else {
                        newItemSize.width = JItemHandler.this.currentSize.width;
                        reverse[0] = 0.0;
                    }
                    AffineTransform.getRotateInstance(currentTheta).transform(reverse, 0, reverse, 0, 1);
                    newItemCenter.x = JItemHandler.this.oposedX + reverse[0];
                    newItemCenter.y = JItemHandler.this.oposedY + reverse[1];
                }
                JItemHandler.this.jItem.setCurrentSize(newItemCenter, newItemSize);
                return;
            }
            if (this.cornerSelection) {
                double rate = Math.sqrt((closePos.x - JItemHandler.this.oposedX) * (closePos.x - JItemHandler.this.oposedX) + (closePos.y - JItemHandler.this.oposedY) * (closePos.y - JItemHandler.this.oposedY)) / JItemHandler.this.currentDiagonalLength;
                newItemSize = new DimensionDouble(JItemHandler.this.currentSize.width * rate, JItemHandler.this.currentSize.height * rate);
            } else {
                double length = Math.sqrt((closePos.x - JItemHandler.this.oposedX) * (closePos.x - JItemHandler.this.oposedX) + (closePos.y - JItemHandler.this.oposedY) * (closePos.y - JItemHandler.this.oposedY));
                newItemSize = JItemHandler.this.selectedIndex % 2 == 0 ? new DimensionDouble(length, JItemHandler.this.currentSize.height) : new DimensionDouble(JItemHandler.this.currentSize.width, length);
            }
            double deltaTheta = Math.atan2(closePos.y - JItemHandler.this.oposedY, closePos.x - JItemHandler.this.oposedX) - Math.atan2(this.y[JItemHandler.this.selectedIndex] - JItemHandler.this.oposedY, this.x[JItemHandler.this.selectedIndex] - JItemHandler.this.oposedX);
            JItemHandler.this.jItem.setCurrentGeoDelta(newItemCenter, deltaTheta, newItemSize);
        }
    }
}

