/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.Item;
import adecWatt.view.JItem;
import adecWatt.view.JWorkspaceView;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class JOverlapItemPopup
extends JPopupMenu {
    JWorkspaceView<?> jWorkspaceView;
    MouseEvent mouseEvent;

    public JOverlapItemPopup(JWorkspaceView<?> jWorkspaceView, MouseEvent mouseEvent) {
        this.jWorkspaceView = jWorkspaceView;
        this.mouseEvent = mouseEvent;
        Point pos = mouseEvent.getPoint();
        if (jWorkspaceView.selectedAcc != null) {
            Point2D.Double realPos = jWorkspaceView.scaleViewToModel(new Point(pos.x, pos.y));
            if (jWorkspaceView.selectedAcc.contains(realPos, 2.0 / jWorkspaceView.scale)) {
                return;
            }
        }
        ArrayList<Item> overlapItems = jWorkspaceView.findItems(pos);
        if (mouseEvent.getID() == 501 && !mouseEvent.isShiftDown() && !SwingUtilities.isRightMouseButton(mouseEvent) && jWorkspaceView.selectedItems.size() > 0) {
            for (JItem jItem : jWorkspaceView.selectedItems.values()) {
                if (!overlapItems.contains(jItem.getItem())) continue;
                jWorkspaceView.startDrag(jItem.getItem(), mouseEvent.getPoint());
                return;
            }
        }
        switch (overlapItems.size()) {
            case 0: {
                this.select(null);
                return;
            }
            case 1: {
                this.select(overlapItems.get(0));
                return;
            }
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent) && jWorkspaceView.selectedItems.size() > 0 && jWorkspaceView.performPopup(mouseEvent)) {
            return;
        }
        for (final Item item : overlapItems) {
            JMenuItem menuItem = new JMenuItem(item.getName(), item.getParentUnit().getIcon(16));
            menuItem.setActionCommand(item.getName());
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOverlapItemPopup.this.select(item);
                }
            });
            this.add(menuItem);
        }
        jWorkspaceView.noDrag();
        this.show(jWorkspaceView, pos.x, pos.y);
    }

    public void select(Item item) {
        switch (this.mouseEvent.getID()) {
            case 501: {
                if (SwingUtilities.isRightMouseButton(this.mouseEvent)) {
                    if (this.jWorkspaceView.performPopup(this.mouseEvent)) {
                        return;
                    }
                    this.jWorkspaceView.performSelection(item, this.mouseEvent);
                    this.jWorkspaceView.performPopup(this.mouseEvent);
                    return;
                }
                this.jWorkspaceView.performSelection(item, this.mouseEvent);
                break;
            }
            case 500: {
                if (this.mouseEvent.getClickCount() <= 1) break;
                if (this.jWorkspaceView.selectedItems.size() < 1) {
                    this.jWorkspaceView.setSelectedItems(item);
                }
                ArrayList<Item> param = new ArrayList<Item>();
                for (JItem jItem : this.jWorkspaceView.selectedItems.values()) {
                    param.add(jItem.getItem());
                }
                this.jWorkspaceView.adecWatt.broadcastDisplay("DisplayItem", param);
                return;
            }
        }
    }
}

