/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.Circuits;
import adecWatt.model.Patch;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import misc.Bundle;
import misc.Util;

public class JPatch
extends JPanel
implements SwingConstants {
    public static Border groupBorder = BorderFactory.createEtchedBorder(1);

    public JPatch(Patch patch) {
        JPanel content = Util.getGridBagPanel();
        this.add(Util.getJScrollPane(content));
        Util.addComponent(new JInfo(Util.newLabel("Circuit", 4), Util.newLabel("Line", 4), Util.newLabel("Watt", 4)), content, Util.GBC);
        if (patch != null) {
            for (String circuitName : patch.circuitLines.keySet()) {
                String lineNames = "";
                String sep = "";
                for (String name : patch.circuitLines.get(circuitName)) {
                    lineNames = lineNames + sep + name;
                    sep = ", ";
                }
                Util.addComponent(new JInfo(new JLabel(circuitName, 0), new JLabel(lineNames, 0), new JLabel(Util.toNumIn10Units(patch.circuitConsumption.get(circuitName).intValue()), 0)), content, Util.GBC);
            }
        }
        Util.addComponent(new JLabel(), content, Util.GBCNL);
        Util.addComponent(new JInfo(Util.newLabel("Line", 4), Util.newLabel("Circuit", 4), Util.newLabel("Watt", 4)), content, Util.GBC);
        if (patch != null) {
            for (String lineName : patch.getLineKeys()) {
                String circuitName = patch.lineCircuit.get(lineName);
                JLabel consumption = null;
                if (Circuits.SHORTCUT == circuitName) {
                    circuitName = Bundle.getLabel(Circuits.SHORTCUT);
                    consumption = new JLabel("");
                } else {
                    consumption = new JLabel(Util.toNumIn10Units(patch.lineConsumption.get(lineName).intValue()), 0);
                }
                Util.addComponent(new JInfo(new JLabel(lineName, 0), new JLabel(circuitName, 0), consumption), content, Util.GBC);
            }
        }
        Util.addComponent(new JLabel(), content, Util.GBCNL);
        Util.addComponent(new JInfo(Util.newLabel(Circuits.UNPLUG, 4)), content, Util.GBC);
        if (patch != null) {
            for (String circuitName : patch.unplug) {
                Util.addComponent(new JInfo(new JLabel(circuitName, 0)), content, Util.GBC);
            }
        }
        Util.addComponent(new JLabel(), content, Util.GBCNL);
        Util.addComponent(new JInfo(Util.newLabel(Circuits.SHORTCUT, 4)), content, Util.GBC);
        if (patch != null) {
            for (String circuitName : patch.shortcut) {
                Util.addComponent(new JInfo(new JLabel(circuitName, 0)), content, Util.GBC);
            }
        }
        Util.addComponent(new JLabel(), content, Util.GBCNL);
        Util.addComponent(new JInfo(Util.newLabel(Circuits.CIRCUITLESS, 4)), content, Util.GBC);
        if (patch != null) {
            for (String compName : patch.circuitless) {
                Util.addComponent(new JInfo(new JLabel(compName, 0)), content, Util.GBC);
            }
        }
        Util.addComponent(new JLabel(), content, Util.GBCNL);
    }

    public static class JInfo
    extends JPanel {
        public JInfo(Component line1, Component line2, Component line3) {
            super(new GridLayout(3, 1));
            this.add(line1);
            this.add(line2);
            this.add(line3);
            this.setBorder(groupBorder);
        }

        public JInfo(Component line1, Component line2) {
            super(new GridLayout(2, 1));
            this.add(line1);
            this.add(line2);
            this.setBorder(groupBorder);
        }

        public JInfo(Component line) {
            super(new GridLayout(1, 1));
            this.add(line);
            this.setBorder(groupBorder);
        }
    }
}

