/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.view.JZones;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import misc.Config;
import misc.DimensionDouble;
import misc.Util;

public class JPreviewImp
extends JPanel
implements ActionListener {
    public static final String actionPortrait = "Portrait";
    public static final String actionLandscape = "Landscape";
    public static final String actionAddZone = "AddZone";
    public static final String actionAddPoster = "AddPoster";
    public static final String actionAddPatch = "AddPatch";
    public static final String actionRemoveZone = "RemoveZone";
    public static final String actionTurnLeft = "TurnLeft";
    public static final String actionTurnRight = "TurnRight";
    public static final String actionCircuit = "Circuit";
    public static final List<String> previewButtonsNames = Arrays.asList("AddZone", "AddPoster", "AddPatch", "RemoveZone", "TurnLeft", "TurnRight");
    public static final List<String> previewActionsNames = Arrays.asList("AddZone", "AddPoster", "AddPatch", "RemoveZone", "TurnLeft", "TurnRight", "Circuit");
    public static final Hashtable<String, Method> actionsMethod = Util.collectMethod(JPreviewImp.class, previewActionsNames);
    JSplitPane jSplitPane;
    JZones workspace;
    JZones preview;
    HashSet<JZones.Zone> noPrintCircuit = new HashSet();
    JCheckBox jCheckBoxCircuit;
    BufferedImage workspaceImage;
    BufferedImage workspaceImageNoCircuit;
    BufferedImage posterImage;
    BufferedImage patchImage;
    public static final Color[] rainbow;
    int rainbowIndex = -1;

    @Override
    public void actionPerformed(ActionEvent e) {
        Util.actionPerformed(actionsMethod, e, this);
    }

    public void actionPortrait() {
        this.setLandscape(false);
    }

    public void actionLandscape() {
        this.setLandscape(true);
    }

    public void actionAddZone() {
        Color color = this.getColor();
        JZones.Zone selectedZone = this.preview.getSelectedZone();
        JZones.Zone newZone = selectedZone != null && selectedZone.getPair() != null ? this.workspace.addZone(color, selectedZone.getPair().getRectangle()) : this.workspace.addZone(color);
        this.preview.addZone(newZone, null);
        this.preview.selectLastZone();
        this.actionCircuit();
    }

    public void actionAddPoster() {
        if (this.posterImage == null) {
            return;
        }
        Color color = this.getColor();
        this.preview.addZone(color, this.posterImage);
        this.preview.selectLastZone();
    }

    public void actionAddPatch() {
        if (this.patchImage == null) {
            return;
        }
        Color color = this.getColor();
        this.preview.addZone(color, this.patchImage);
        this.preview.selectLastZone();
    }

    public void actionRemoveZone() {
        JZones.Zone selectedZone = this.preview.getSelectedZone();
        if (selectedZone == null) {
            return;
        }
        this.preview.removeZone(selectedZone);
        this.workspace.removeZone(selectedZone.getPair());
    }

    public void actionTurnLeft() {
        this.preview.turnZoneLeft();
    }

    public void actionTurnRight() {
        this.preview.turnZoneRight();
    }

    public void actionCircuit() {
        JZones.Zone selectedZone = this.preview.getSelectedZone();
        if (selectedZone == null || !selectedZone.hasPair() || this.workspaceImageNoCircuit == null) {
            return;
        }
        boolean printCircuit = this.jCheckBoxCircuit.isSelected();
        if (printCircuit) {
            this.noPrintCircuit.remove(selectedZone);
            selectedZone.setImage(this.workspaceImage);
        } else {
            this.noPrintCircuit.add(selectedZone);
            selectedZone.setImage(this.workspaceImageNoCircuit);
        }
    }

    public void updateCircuit(JZones.Zone selectedZone) {
        if (selectedZone == null || !selectedZone.hasPair() || this.workspaceImageNoCircuit == null) {
            return;
        }
        this.jCheckBoxCircuit.setSelected(!this.noPrintCircuit.contains(selectedZone));
    }

    public JPreviewImp(DimensionDouble workspaceSize, DimensionDouble pageSize, BufferedImage workspaceImage, BufferedImage workspaceImageNoCircuit, BufferedImage posterImage, BufferedImage patchImage, int maxSide) {
        this(new JZones(workspaceSize, maxSide), new JZones(pageSize, maxSide));
        this.workspaceImage = workspaceImage;
        this.workspaceImageNoCircuit = workspaceImageNoCircuit;
        this.posterImage = posterImage;
        this.patchImage = patchImage;
        this.workspace.setBackground(workspaceImage);
    }

    public JPreviewImp(DimensionDouble workspaceSize, DimensionDouble pageSize, int maxSide) {
        this(new JZones(pageSize, maxSide), new JZones(workspaceSize, maxSide));
    }

    private JPreviewImp(JZones workspace, JZones preview) {
        super(new BorderLayout());
        this.preview = preview;
        this.workspace = workspace;
        preview.setCornerSelection(false);
        preview.setCreateZone(false);
        this.jSplitPane = Util.getJSplitPane(1, this.getJZonesFrame(workspace), this.getJZonesFrame(preview));
        this.add((Component)this.jSplitPane, "Center");
        workspace.stateNotifier.addUpdateObserver(this, "SelectedLocationChange", "SelectedRateChange");
        workspace.stateNotifier.addMsgObserver(this, "CreateZone", "SelectedChange");
        preview.stateNotifier.addMsgObserver(this, "SelectedChange");
        JPanel menuBar = new JPanel();
        menuBar.setLayout(new BoxLayout(menuBar, 0));
        Util.addIconButton(previewButtonsNames, (ActionListener)this, (Container)menuBar);
        this.jCheckBoxCircuit = Util.newCheckIcon(actionCircuit, this, true);
        menuBar.add(this.jCheckBoxCircuit);
        Util.unBoxButton(menuBar);
        this.add((Component)menuBar, "North");
    }

    public JPanel getJZonesFrame(JZones jZones) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)Util.getJScrollPane(jZones), "Center");
        jPanel.add((Component)new JZones.SizeSlider(jZones), "South");
        return jPanel;
    }

    public Color getColor() {
        this.rainbowIndex = (this.rainbowIndex + 1) % rainbow.length;
        return rainbow[this.rainbowIndex];
    }

    public void displayCreateZone(Object ... objects) {
        if (objects[0] == null) {
            return;
        }
        Rectangle2D.Double area = (Rectangle2D.Double)objects[0];
        Color color = this.getColor();
        this.preview.addZone(this.workspace.addZone(color, area), null);
        this.preview.selectLastZone();
        this.actionCircuit();
    }

    public void displaySelectedChange(Object ... objects) {
        if (objects[0] == null) {
            return;
        }
        JZones src = (JZones)objects[0];
        JZones.Zone selectZone = (JZones.Zone)objects[1];
        if (selectZone == null) {
            JZones dst = src == this.workspace ? this.preview : this.workspace;
            dst.selectZoneQuiet(null);
            return;
        }
        if (src == this.preview) {
            this.updateCircuit(selectZone);
            this.workspace.selectZoneQuiet(selectZone.getPair());
            return;
        }
        JZones.Zone pair = this.preview.findPair(selectZone);
        this.updateCircuit(pair);
        this.preview.selectZoneQuiet(pair);
    }

    public void updateSelectedRateChange() {
        JZones.Zone selectedZone = this.preview.getSelectedZone();
        if (selectedZone == null) {
            return;
        }
        selectedZone.updatePairRate();
    }

    public void updateSelectedLocationChange() {
        this.preview.repaint();
    }

    public void setLandscape(boolean landscape) {
        double currentPrevRate = this.preview.getScale();
        double currentWorkRate = this.workspace.getScale();
        if (!this.preview.setLandscape(landscape)) {
            return;
        }
        this.preview.resetScale();
        this.workspace.resetScale();
        Util.packWindow(this);
        this.preview.setScale(currentPrevRate);
        this.workspace.setScale(currentWorkRate);
    }

    public static void main(String[] args) {
        try {
            Config.setPWD(JPreviewImp.class);
            BufferedImage workspaceImage = ImageIO.read(new File("/home/felix/perso/adecWatt/ws/exemplePrint.png"));
            DimensionDouble pageSize = new DimensionDouble(21.0, 29.7);
            DimensionDouble workspaceSize = new DimensionDouble(25.0, 34.0);
            int maxSide = 200;
            JPreviewImp jPreviewImp = new JPreviewImp(workspaceSize, pageSize, workspaceImage, null, workspaceImage, workspaceImage, maxSide);
            Util.newJFrame("test", jPreviewImp, true);
            jPreviewImp.actionAddZone();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        int nbColors = 7;
        rainbow = new Color[nbColors];
        for (int i = 0; i < nbColors; ++i) {
            JPreviewImp.rainbow[i] = new Color(Color.HSBtoRGB((float)i / (float)nbColors, 1.0f, 1.0f));
        }
    }
}

