/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.AdecWatt;
import adecWatt.model.ImageDB;
import adecWatt.model.Permanent;
import adecWatt.model.PermanentDB;
import adecWatt.model.Prop;
import adecWatt.view.JEditable;
import adecWatt.view.jProp.JPropText;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import misc.Bundle;
import misc.LocalizedUserLabel;
import misc.Util;

public abstract class JProp {
    public static final String AdecWattUser = "AdecWattUser";
    public static final int defaultImageWidth = 256;
    public static final int defaultImageHeight = 512;
    public static Color textFgColor = Color.black;
    public static Color textBgColor = Color.white;
    public static Color noValueFgColor = Color.darkGray;
    public static Color noValueBgColor = Color.lightGray;
    public static Color badValueColor = Color.red;
    public Border defaultBorder = null;
    public Border badValueBorder = new LineBorder(badValueColor);
    protected JEditable jEditable;
    protected AdecWatt adecWatt;
    protected PermanentDB permanentDB;
    protected ImageDB iconDB;
    protected ImageDB imageDB;
    protected String propName;
    protected Permanent.PropTypeEnum type;
    protected int nbVal;
    protected Collection<String> enumChoice;
    protected boolean hidden;
    protected String ownValue;
    protected String parentValue;
    protected String lastValue;
    protected Double[] ownValues;
    protected Double[] parentValues;
    protected Double[] lastValues;
    protected boolean horizontalSpin;
    protected boolean parentHorizontalSpin;
    protected LocalizedUserLabel localizedUserLabel;
    protected LocalizedUserLabel[] localizedUserMultiLabels;

    protected static JLabel getMsgLabel(String msg) {
        JLabel unknown = new JLabel(msg);
        unknown.setForeground(noValueFgColor);
        unknown.setBackground(noValueBgColor);
        unknown.setOpaque(true);
        return unknown;
    }

    public static JLabel getUnknownLabel() {
        return JProp.getMsgLabel("?");
    }

    public static JLabel getEmptyLabel() {
        return JProp.getMsgLabel("_");
    }

    public static JProp getJProp(String propName, JEditable jEditable) {
        Permanent.PropTypeEnum type = jEditable.getTypeToken(propName);
        try {
            return (JProp)ClassLoader.getSystemClassLoader().loadClass(JPropText.class.getPackage().getName() + ".JProp" + (Object)((Object)type)).getConstructor(String.class, JEditable.class).newInstance(propName, jEditable);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't find constructor for type (" + (Object)((Object)type) + ").");
        }
    }

    public ImageDB getIconDB() {
        return this.iconDB;
    }

    public ImageDB getImageDB() {
        return this.imageDB;
    }

    public String getLastValue() {
        return this.lastValue;
    }

    public String getPropName() {
        return this.propName;
    }

    public boolean getHorizontalSpin() {
        return this.horizontalSpin;
    }

    protected void updateView() {
    }

    protected abstract void displayByType(boolean var1, JPanel var2, JTabbedPane var3);

    protected JProp(String propName, JEditable jEditable) {
        this.jEditable = jEditable;
        this.adecWatt = jEditable.getAdecWatt();
        this.permanentDB = this.adecWatt.getPermanentDB();
        this.iconDB = this.adecWatt.getIconDB();
        this.imageDB = this.adecWatt.getImageDB();
        this.propName = propName;
        this.type = jEditable.getTypeToken(propName);
        this.nbVal = jEditable.getNbVal(propName);
        this.enumChoice = jEditable.getPropEnumChoice(propName);
        this.lastValue = this.ownValue = jEditable.getPropValue(propName, false);
        this.parentValue = jEditable.getPropValue(propName, true);
        if (this.nbVal > 0) {
            this.ownValues = jEditable.getPartialPropValue(propName, this.nbVal, false);
            this.parentValues = jEditable.getPartialPropValue(propName, this.nbVal, true);
            this.lastValues = this.ownValues;
        }
        this.hidden = jEditable.getPropHidden(propName);
        this.parentHorizontalSpin = jEditable.getPropHorizontalSpin(propName, true);
        this.horizontalSpin = jEditable.getPropHorizontalSpin(propName, false) ^ this.parentHorizontalSpin;
        if (this.ownValue == null) {
            this.lastValue = this.ownValue = this.parentValue;
            this.ownValues = this.parentValues;
            this.lastValues = this.parentValues;
            this.horizontalSpin = this.parentHorizontalSpin;
        }
        boolean isLocalized = jEditable.getPropLocalized(propName);
        boolean linguist = jEditable.isLinguist();
        this.localizedUserLabel = new LocalizedUserLabel(propName, isLocalized, linguist);
        List<String> multiLabel = jEditable.getPropLabel(propName);
        if (multiLabel == null) {
            return;
        }
        this.localizedUserMultiLabels = new LocalizedUserLabel[multiLabel.size()];
        for (int i = 0; i < this.localizedUserMultiLabels.length; ++i) {
            this.localizedUserMultiLabels[i] = new LocalizedUserLabel(multiLabel.get(i), isLocalized, linguist);
            JLabel result = this.localizedUserMultiLabels[i].getJLabel();
            Font defaultFont = result.getFont();
            result.setFont(new Font(defaultFont.getName(), 0, defaultFont.getSize() * 3 / 4));
        }
    }

    public void display(boolean edit, JPanel jPropList, JTabbedPane jTabbedPane) {
        if (!edit && (this.hidden || this.lastValue == null) && this.type != Permanent.PropTypeEnum.Preview) {
            return;
        }
        this.displayByType(edit, jPropList, jTabbedPane);
    }

    public void setUnchange(JTextComponent jTextComponent, boolean unchange) {
        if (unchange) {
            jTextComponent.setText("");
            jTextComponent.setForeground(noValueFgColor);
            jTextComponent.setBackground(noValueBgColor);
        } else {
            jTextComponent.setForeground(textFgColor);
            jTextComponent.setBackground(textBgColor);
        }
    }

    public void setChangeListener(final JTextComponent jTextComponent) {
        final Document document = jTextComponent.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                document.removeDocumentListener(this);
                JProp.this.setUnchange(jTextComponent, false);
                document.addDocumentListener(this);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }
        });
        jTextComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                new JPopupMenu(){
                    {
                        Util.addMenuItem("Unchange", new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                JProp.this.setUnchange(jTextComponent, true);
                            }
                        }, (Container)this);
                        Point pos = e.getPoint();
                        this.show(jTextComponent, pos.x, pos.y);
                    }
                };
            }
        });
    }

    public void removeVal() {
        if (this.lastValue == this.parentValue) {
            return;
        }
        this.lastValue = this.parentValue;
        this.lastValues = this.parentValues;
        this.updateView();
    }

    public void unchangeVal() {
        this.lastValue = "MIX";
        this.lastValues = Prop.string2tab(this.lastValue, this.nbVal);
        this.updateView();
    }

    public void setSpin(boolean horizontalSpin) {
        this.horizontalSpin = horizontalSpin;
        this.updateView();
    }

    public void setVal(String newVal) {
        if (newVal == null | newVal.isEmpty()) {
            this.removeVal();
            return;
        }
        if (this.lastValue != null && newVal.equals(this.lastValue)) {
            return;
        }
        this.lastValue = newVal;
        this.lastValues = Prop.string2tab(this.lastValue, this.nbVal);
        this.updateView();
    }

    public void getChange(Prop[] props) {
        boolean newHorizontalSpin;
        this.lastValue = this.getLastValue();
        if (this.lastValue != null && this.lastValue.isEmpty()) {
            this.lastValue = null;
        }
        if (!(newHorizontalSpin = this.horizontalSpin ^ this.parentHorizontalSpin)) {
            if (this.lastValue == null && props[2] == null || this.lastValue != null && props[2] != null && this.lastValue.equals(props[2].sValue)) {
                props[3] = props[2];
                return;
            }
            if (this.lastValue == null && props[2] != null) {
                props[3] = props[1];
                return;
            }
        }
        props[3] = new Prop(this.propName, this.type, this.horizontalSpin);
        props[3].setValue(this.lastValue);
    }

    public void confirmBundle() {
        String newLabel = this.localizedUserLabel.getNewLabel();
        if (newLabel != null) {
            Bundle.setUser(AdecWattUser, this.localizedUserLabel.getLabel(), newLabel);
        }
        if (this.localizedUserMultiLabels == null) {
            return;
        }
        for (int i = 0; i < this.localizedUserMultiLabels.length; ++i) {
            newLabel = this.localizedUserMultiLabels[i].getNewLabel();
            if (newLabel == null) continue;
            Bundle.setUser(AdecWattUser, this.localizedUserMultiLabels[i].getLabel(), newLabel);
        }
    }
}

