/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.unit.Workspace;
import adecWatt.view.JWorkspaceView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import misc.DimensionDouble;

public class JScrollPaneWorkspace
extends JScrollPane {
    public static final boolean HORIZONTAL = true;
    public static final boolean VERTICAL = false;
    public static final int SIZE = 16;
    public static final Color BG = Color.LIGHT_GRAY;
    public static final int TICK_LENGTH = 5;
    private JWorkspaceView<?> jWorkspaceView;
    private JRule horizontalJRule = new JRule(true);
    private JRule verticalJRule = new JRule(false);

    public JWorkspaceView<?> getJWorkspaceView() {
        return this.jWorkspaceView;
    }

    public Workspace getWorkspace() {
        return this.jWorkspaceView.getWorkspace();
    }

    public JScrollPaneWorkspace(JWorkspaceView<?> jWorkspaceView) {
        super(jWorkspaceView, 20, 30);
        this.jWorkspaceView = jWorkspaceView;
        this.setColumnHeaderView(this.horizontalJRule);
        this.setRowHeaderView(this.verticalJRule);
    }

    void updateScale() {
        this.horizontalJRule.repaint();
        this.verticalJRule.repaint();
    }

    public class JRule
    extends JComponent {
        public boolean horizontal;

        public JRule(boolean horizontal) {
            this.horizontal = horizontal;
            this.setPreferredSize(new Dimension(16, 16));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Rectangle viewRect = JScrollPaneWorkspace.this.getViewport().getViewRect();
            double scale = JScrollPaneWorkspace.this.jWorkspaceView.getScale();
            DimensionDouble realSize = JScrollPaneWorkspace.this.jWorkspaceView.getRealSize();
            int minTick = (int)Math.round((double)(this.horizontal ? viewRect.x : viewRect.y) / scale);
            int maxTick = (int)Math.round(Math.min(this.horizontal ? realSize.width : realSize.height, (double)(this.horizontal ? viewRect.x + viewRect.width : viewRect.y + viewRect.height) / scale));
            Rectangle drawHere = g.getClipBounds();
            g.setColor(BG);
            g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
            g.setFont(new Font("SansSerif", 0, 8));
            g.setColor(Color.black);
            for (int i = minTick; i <= maxTick; ++i) {
                int p = (int)((double)i * scale - (double)(this.horizontal ? viewRect.x : viewRect.y));
                if (this.horizontal) {
                    g.drawLine(p, 15, p, 10);
                } else {
                    g.drawLine(15, p, 10, p);
                }
                String text = Integer.toString(i);
                if (i == 0) {
                    text = text + "m";
                    if (this.horizontal) {
                        g.drawString(text, p + 2, 8);
                        continue;
                    }
                    g.drawString(text, 1, p + 10);
                    continue;
                }
                if (this.horizontal) {
                    g.drawString(text, p - 3, 8);
                    continue;
                }
                g.drawString(text, 0, p + 3);
            }
        }
    }
}

