/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import misc.Util;

public class JStringSet
extends JPanel {
    public static final String actionAdd = "Add";
    public static final String actionRemove = "Remove";
    private Vector<String> refList = new Vector();
    private Vector<String> list = new Vector();
    private JList<String> jList = new JList();
    private JTextField jTextField = new JTextField(8);

    public Collection<String> getSet() {
        if (this.list.size() < 1) {
            return null;
        }
        return this.list;
    }

    public JStringSet(Collection<String> enumChoice) {
        super(new BorderLayout());
        this.jTextField.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                JStringSet.this.jTextField.requestFocusInWindow();
            }
        });
        this.jTextField.addFocusListener(new FocusListener(){
            private boolean isFirstTime = true;

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (this.isFirstTime) {
                    JStringSet.this.jTextField.requestFocusInWindow();
                    this.isFirstTime = false;
                }
            }
        });
        this.jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JStringSet.this.jTextField.setText((String)JStringSet.this.jList.getSelectedValue());
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)Util.newIconButton(actionAdd, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JStringSet.this.actionAdd();
            }
        }), "West");
        jPanel.add((Component)this.jTextField, "Center");
        jPanel.add((Component)Util.newIconButton(actionRemove, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JStringSet.this.actionRemove();
            }
        }), "East");
        this.add((Component)jPanel, "South");
        this.add((Component)Util.getJScrollPane(this.jList), "Center");
        Util.unBoxButton(jPanel);
        if (enumChoice == null) {
            return;
        }
        this.refList.addAll(enumChoice);
        Collections.sort(this.refList);
        this.list.addAll(this.refList);
    }

    public void init() {
        this.list.clear();
        this.list.addAll(this.refList);
        this.updateList();
    }

    public void confirm() {
        this.actionAdd();
        this.refList.clear();
        this.refList.addAll(this.list);
    }

    public void updateList() {
        this.jList.setListData(this.list);
        this.jList.revalidate();
    }

    public void actionAdd() {
        String value = this.jTextField.getText();
        this.jTextField.setText("");
        if (value == null || value.isEmpty()) {
            return;
        }
        if (this.list.contains(value)) {
            return;
        }
        this.list.addElement(value);
        Collections.sort(this.list);
        this.updateList();
        this.jList.setSelectedValue(null, false);
    }

    public void actionRemove() {
        int selection = this.jList.getSelectedIndex();
        if (selection < 0) {
            return;
        }
        this.list.removeElementAt(selection);
        this.updateList();
        if (selection >= this.list.size()) {
            --selection;
        }
        this.jList.setSelectedIndex(selection);
    }
}

