/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.Editable;
import adecWatt.model.Embedded;
import adecWatt.model.Permanent;
import adecWatt.model.Prop;
import adecWatt.model.Unit;
import adecWatt.view.JDefPropTable;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import misc.Util;

public class JTransform
extends JPanel {
    private Editable<?, ?, ?, ?> editable;
    private Unit<?> root;
    private boolean isRoot;
    private boolean isEmbedded;
    private ArrayList<JCheckBox> jModifiers;
    private ArrayList<Unit<?>> permanents;
    private JComboBox<String> jPermanents;
    private JTextField jName;
    private JDefPropTable jDefPropTable;
    private boolean admin;

    public static ArrayList<JCheckBox> getJModifiers(Collection<String> modifiersSet, Collection<String> modifiers, boolean isLock) {
        ArrayList<JCheckBox> result = new ArrayList<JCheckBox>();
        for (String modifier : modifiersSet) {
            JCheckBox button = Util.newCheckIcon(Util.toCapital(modifier), null);
            if (modifiers != null && modifiers.contains(modifier)) {
                button.setSelected(true);
            }
            Util.unBoxButton(button);
            result.add(button);
        }
        if (isLock) {
            for (JCheckBox button : result) {
                button.setEnabled(false);
            }
        }
        return result;
    }

    public static Collection<String> getModifiers(ArrayList<JCheckBox> buttons, Collection<String> oldModifiers, boolean admin, Collection<String> hiddenModifiers) {
        TreeSet<String> modifiers = new TreeSet<String>();
        for (JCheckBox button : buttons) {
            if (!button.isSelected()) continue;
            modifiers.add(button.getActionCommand().toLowerCase());
        }
        if (!admin && oldModifiers != null) {
            for (String modifier : hiddenModifiers) {
                if (!oldModifiers.contains(modifier)) continue;
                modifiers.add(modifier);
            }
        }
        return modifiers.size() < 1 ? null : modifiers;
    }

    public boolean isLock(String propName) {
        return this.editable.getDirectUnit().getPropLock(propName);
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public JTransform(Editable<?, ?, ?, ?> editable) {
        super(new GridBagLayout());
        this.editable = editable;
        this.root = editable.getDirectUnit().getUnitRoot();
        this.isRoot = this.root == editable;
        this.isEmbedded = editable instanceof Embedded;
        this.admin = editable.getDirectUnit().getAdecWatt().getUser().isAdmin();
        this.setAvailablePermanents();
        this.jName = new JTextField(editable.getName(), 16);
        this.jDefPropTable = new JDefPropTable(this, editable);
        if (!this.isEmbedded) {
            this.jModifiers = JTransform.getJModifiers(editable.getModifiersSet(), editable.getModifiers(), editable.isLock());
            JPanel jDisplayModifiers = new JPanel();
            for (JCheckBox jModifier : this.jModifiers) {
                jDisplayModifiers.add(jModifier);
            }
            Util.addComponent(jDisplayModifiers, this, Util.GBC);
        }
        if (this.isRoot) {
            Util.addComponent(this.jName, this, Util.GBCNL);
        } else {
            Util.addComponent(this.jPermanents, this, this.isEmbedded ? Util.GBCNL : Util.GBC);
            if (!this.isEmbedded) {
                Util.addComponent(this.jName, this, Util.GBCNL);
            }
        }
        Util.addComponent(Util.getJScrollPane(this.jDefPropTable), this, Util.GBCNL);
    }

    public void setAvailablePermanents() {
        if (this.isRoot) {
            return;
        }
        this.permanents = this.editable.getDirectUnit().getAvailablePermanents(this.isEmbedded, this.editable);
        this.jPermanents = new JComboBox();
        for (Unit<?> unit : this.permanents) {
            this.jPermanents.addItem(unit.getLocalName());
        }
        this.jPermanents.setSelectedIndex(this.permanents.indexOf(this.editable.getParentUnit()));
    }

    public boolean valideChange() {
        if (!this.jDefPropTable.jNewPropName.getText().isEmpty()) {
            return false;
        }
        TreeSet<String> propNames = new TreeSet<String>();
        for (JDefPropTable.PropShadow defProp : this.jDefPropTable.getObjectData()) {
            String propName = defProp.propName;
            if (propName == null || propName.isEmpty() || propNames.contains(propName)) {
                return false;
            }
            propNames.add(propName);
        }
        return true;
    }

    public void confirmChange() {
        ArrayList<Prop[]> transProps = new ArrayList<Prop[]>();
        int rank = 0;
        for (JDefPropTable.PropShadow defProp : this.jDefPropTable.getObjectData()) {
            transProps.add(new Prop[]{defProp.prop, new Prop(defProp.propName, Permanent.PropTypeEnum.values()[defProp.jType.getSelectedIndex()], new Integer(rank++), defProp.getModifiers(), defProp.jStringSet.getSet(), defProp.jDefLabel.getLabels())});
        }
        Collection<String> newModifiers = this.jModifiers == null ? null : JTransform.getModifiers(this.jModifiers, null, this.admin, null);
        this.editable.storyTransform(newModifiers, this.getPermanent(), this.jName.getText(), transProps);
    }

    public Unit<?> getPermanent() {
        return this.isRoot ? null : this.permanents.get(this.jPermanents.getSelectedIndex());
    }
}

