/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.AdecWatt;
import adecWatt.model.Unit;
import adecWatt.model.User;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import misc.Util;

public class JUnitPopup
extends JPopupMenu {
    public JUnitPopup(final AdecWatt adecWatt, JTree jTree, final Unit<?> unit, Point pos) {
        User user = adecWatt.getUser();
        boolean editor = user.isEditor(unit);
        final List<Unit> selectedUnits = Arrays.asList(unit);
        Util.addMenuItem("DisplayUnit", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                adecWatt.broadcastDisplay("DisplayUnit", selectedUnits);
            }
        }, (Container)this);
        if (editor) {
            Util.addMenuItem("ModifyUnit", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    adecWatt.broadcastDisplay("ModifyUnit", selectedUnits);
                }
            }, (Container)this);
        }
        if (editor && unit.getParent() != null) {
            Util.addMenuItem("RenameUnit", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    adecWatt.broadcastDisplay("RenameUnit", selectedUnits);
                }
            }, (Container)this);
        }
        if (user.isDataStructuresManager()) {
            Util.addMenuItem("TransformUnit", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    adecWatt.broadcastDisplay("TransformUnit", unit);
                }
            }, (Container)this);
        }
        if (editor) {
            if (unit.getParent() != null) {
                Util.addMenuItem("CopyUnit", new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        adecWatt.broadcastDisplay("CopyUnit", unit);
                    }
                }, (Container)this);
            }
            Util.addMenuItem("NewUnit", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    adecWatt.broadcastDisplay("NewUnit", unit);
                }
            }, (Container)this);
        }
        if (!(unit.getRemote() && !unit.story.isModified() || user.isVisitorId())) {
            Util.addMenuItem("PromoteUnit", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    adecWatt.broadcastDisplay("PromoteUnit", unit);
                }
            }, (Container)this);
        }
        if (!unit.getRemote()) {
            Util.addMenuItem("RemoveUnit", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    adecWatt.broadcastDisplay("RemoveUnit", unit);
                }
            }, (Container)this);
        }
        this.show(jTree, pos.x, pos.y);
    }
}

