/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.User;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import misc.Bundle;
import misc.RemoteUpdate;
import misc.RemoteUpdateManager;
import misc.Util;

public class JUser
extends JPanel {
    private User user;
    private HashSet<User.Role> roles;
    private Hashtable<User.Role, JCheckBox> rolesCB = new Hashtable();
    private JTextField loginTF;
    private JPasswordField passwordTF;
    private JTextField idTF;

    public JUser(User user, final RemoteUpdateManager remoteUpdateManager) {
        super(new BorderLayout());
        this.user = user;
        this.loginTF = new JTextField(user.getLogin());
        this.passwordTF = new JPasswordField(user.getPassword());
        this.idTF = new JTextField("" + user.getUserId());
        this.roles = user.getRoles();
        JPanel form = Util.getGridBagPanel();
        Util.addLabelFields(form, "Login", this.loginTF);
        Util.addLabelFields(form, "Password", this.passwordTF);
        Util.addButton("Connection", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteUpdate remoteUpdate = remoteUpdateManager.getRemoteUpdate();
                remoteUpdate.logoutDokuwiki();
                char[] pass = JUser.this.passwordTF.getPassword();
                remoteUpdate.loginDokuwiki(JUser.this.loginTF.getText(), "" + new String(pass));
                String newRoles = remoteUpdate.getRoles(JUser.this.loginTF.getText());
                if (newRoles == null) {
                    remoteUpdateManager.setConnected(false);
                    JOptionPane.showMessageDialog(JUser.this, Bundle.getMessage("ConnectionFailed"));
                    return;
                }
                remoteUpdateManager.setConnected(true);
                JUser.this.idTF.setText("" + User.updateRoles(JUser.this.roles, newRoles));
                for (User.Role role : User.Role.values()) {
                    ((JCheckBox)JUser.this.rolesCB.get((Object)role)).setSelected(JUser.this.roles.contains((Object)role));
                }
                JOptionPane.showMessageDialog(JUser.this, Bundle.getMessage("ConnectionSucceeded"));
            }
        }, form, Util.GBCNL);
        int idx = 0;
        for (final User.Role role : User.Role.values()) {
            if (idx++ == 5) {
                Util.addComponent(new JTextArea(Bundle.getMessage("ChangeRole")), form, Util.GBCNL);
                Util.addLabelFields(form, "Id", this.idTF);
            }
            JCheckBox jCheckBox = Util.addCheckButton(role.toString(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((JCheckBox)e.getSource()).isSelected()) {
                        JUser.this.roles.add(role);
                    } else {
                        JUser.this.roles.remove((Object)role);
                    }
                }
            }, form, Util.GBCNL);
            jCheckBox.setSelected(this.roles.contains((Object)role));
            this.rolesCB.put(role, jCheckBox);
        }
        this.add((Component)form, "Center");
    }

    public void confirm() {
        this.user.setLogin(this.loginTF.getText());
        this.user.setPassword(new String(this.passwordTF.getPassword()));
        this.user.setUserId(Integer.parseInt(this.idTF.getText()));
        this.user.setRoles(this.roles);
    }
}

