/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.Editable;
import adecWatt.model.unit.Workspace;
import adecWatt.view.JAdecWatt;
import adecWatt.view.JWorkspaceView;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import misc.Bundle;

public class JWorkspaceSlidersToolBar
extends JToolBar
implements ChangeListener {
    JWorkspaceView<?> jWorkspaceView;
    JPanel jSet = new JPanel();
    JSlider jScale = new JSlider(0, 200, 100);
    JSlider jOpacity = new JSlider(0, 200, 100);

    public JWorkspaceSlidersToolBar(JAdecWatt jAdecWatt) {
        super("Slider");
        this.add(this.jSet);
        this.jScale.setMajorTickSpacing(50);
        this.jScale.setMinorTickSpacing(10);
        this.jSet.add(this.jScale);
        this.jSet.add(this.jOpacity);
        this.setJWorkspaceView(null);
        this.jScale.addChangeListener(this);
        this.jOpacity.addChangeListener(this);
        jAdecWatt.stateNotifier.addUpdateObserver(this, "ChangeScale");
        this.jScale.setToolTipText(Bundle.getAction("Scale"));
        this.jOpacity.setToolTipText(Bundle.getAction("Crossfades"));
    }

    @Override
    public void setOrientation(int o) {
        if (this.jScale != null) {
            this.jScale.setOrientation(o);
            this.jOpacity.setOrientation(o);
            this.jSet.setLayout(new BoxLayout(this.jSet, o == 0 ? 1 : 0));
        }
        super.setOrientation(o);
    }

    public void setJWorkspaceView(JWorkspaceView<?> jWorkspaceView) {
        this.jWorkspaceView = jWorkspaceView;
        if (jWorkspaceView == null) {
            this.jScale.setEnabled(false);
            this.jOpacity.setEnabled(false);
            this.jOpacity.setValue(100);
        } else {
            this.jScale.setEnabled(true);
            if (((Editable)jWorkspaceView.workspace).getBuilding() != null) {
                this.jOpacity.setEnabled(true);
                this.jOpacity.setValue((int)(((Workspace)jWorkspaceView.workspace).getOpacity() * 200.0f));
            } else {
                this.jOpacity.setValue(100);
            }
        }
        this.updateChangeScale();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.jWorkspaceView == null) {
            return;
        }
        if (e.getSource() == this.jScale) {
            this.jWorkspaceView.setScale(Math.pow(10.0, (double)this.jScale.getValue() / 100.0 - 1.0) * this.jWorkspaceView.getInitScale());
            return;
        }
        ((Workspace)this.jWorkspaceView.workspace).setOpacity((float)this.jOpacity.getValue() / 200.0f);
        this.jWorkspaceView.repaint();
    }

    public void updateChangeScale() {
        if (this.jWorkspaceView == null) {
            this.jScale.setValue(100);
            return;
        }
        this.jScale.removeChangeListener(this);
        this.jScale.setValue((int)(100.0 * (Math.log10(this.jWorkspaceView.getScale() / this.jWorkspaceView.getInitScale()) + 1.0)));
        this.jScale.addChangeListener(this);
    }
}

