/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.Acc;
import adecWatt.model.AdecWatt;
import adecWatt.model.Comp;
import adecWatt.model.Editable;
import adecWatt.model.ImageDB;
import adecWatt.model.Item;
import adecWatt.model.PermanentDB;
import adecWatt.model.Unit;
import adecWatt.model.UnitNode;
import adecWatt.model.User;
import adecWatt.model.unit.Accessory;
import adecWatt.model.unit.Building;
import adecWatt.model.unit.Lightplot;
import adecWatt.model.unit.NonWorkspace;
import adecWatt.model.unit.Workspace;
import adecWatt.view.JAcc;
import adecWatt.view.JAccPopup;
import adecWatt.view.JAdecWatt;
import adecWatt.view.JBuildingView;
import adecWatt.view.JComp;
import adecWatt.view.JItem;
import adecWatt.view.JItemHandler;
import adecWatt.view.JItemPopup;
import adecWatt.view.JLightplotView;
import adecWatt.view.JOverlapItemPopup;
import adecWatt.view.JScrollPaneWorkspace;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import misc.DimensionDouble;

public class JWorkspaceView<T extends Workspace>
extends JLayeredPane {
    public static final int closePixelsBounds = 10;
    public static final int closePixelsAccs = 2;
    public static final int closePixelsItems = 4;
    static final double gridStep = 0.1;
    public static final Color noColor = new Color(255, 255, 255, 0);
    public static final Color selectionColor = new Color(0, 255, 0, 64);
    public static final Color selectionBoundColor = new Color(0, 0, 255, 96);
    protected double scale = 1.0;
    protected double minScale = 1.0;
    protected double maxScale = 1.0;
    protected double initScale = 1.0;
    protected double scaleStep = 1.0;
    protected JAdecWatt jAdecWatt;
    protected AdecWatt adecWatt;
    protected User user;
    protected PermanentDB permanentDB;
    protected ImageDB iconDB;
    protected T workspace;
    protected DimensionDouble realSize;
    protected Rectangle2D.Double backgroundShape;
    protected Dimension currentSize;
    protected JLabel jSelectionPane;
    protected Graphics2D selectionGraphics;
    protected Item lastSelectedItem;
    protected Hashtable<String, JItem> selectedItems = new Hashtable();
    protected int lastSelectedAccId;
    protected JAcc selectedAcc;
    MouseAdapter workspaceViewMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            JWorkspaceView.this.mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JWorkspaceView.this.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JWorkspaceView.this.mouseReleased(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JWorkspaceView.this.mouseDragged(e);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            JWorkspaceView.this.jAdecWatt.setCurrentWorkspace((Workspace)JWorkspaceView.this.workspace);
            try {
                if (0 != (e.getModifiersEx() & 0x41)) {
                    JWorkspaceView.this.scrollView(true, e.getWheelRotation());
                } else if (0 != (e.getModifiersEx() & 0x82)) {
                    JWorkspaceView.this.changeScale(e.getPoint(), e.getWheelRotation());
                } else {
                    JWorkspaceView.this.scrollView(false, e.getWheelRotation());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    Point zoneSelectionStart;
    Point zoneSelectionEnd;
    Line2D.Double selectedBound;
    protected Hashtable<JItem, JItemHandler> selectedJItemHandlers = new Hashtable();
    protected ArrayList<JLabel> newJLabel = new ArrayList();
    Point firstClick;
    Point lastClick;
    Point2D.Double refHandle;
    DimensionDouble handleOff;

    public JAdecWatt getJAdecWatt() {
        return this.jAdecWatt;
    }

    public AdecWatt getAdecWatt() {
        return this.adecWatt;
    }

    public PermanentDB getPermanentDB() {
        return this.permanentDB;
    }

    public ImageDB getIconDB() {
        return this.iconDB;
    }

    public T getWorkspace() {
        return this.workspace;
    }

    public double getScale() {
        return this.scale;
    }

    public double getInitScale() {
        return this.initScale;
    }

    public DimensionDouble getRealSize() {
        return this.realSize;
    }

    public boolean notEditable() {
        return !this.user.isEditor((Unit<?>)this.workspace);
    }

    public boolean isSelected(Item item) {
        return this.selectedItems.containsKey(item.getId());
    }

    public boolean isSticky(Item item) {
        if (!((Editable)this.workspace).getInheritedEmbedded().contains(item) || item.isReserved()) {
            return true;
        }
        return item.isSticky();
    }

    private JScrollPaneWorkspace getJScrollPaneWorkspace() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JScrollPaneWorkspace)) continue;
            return (JScrollPaneWorkspace)parent;
        }
        return null;
    }

    public static JWorkspaceView<?> getInstance(JAdecWatt jAdecWatt, Workspace workspace) {
        switch (workspace.getTypeToken()) {
            case Furniture: 
            case Information: 
            case Line: 
            case Accessory: {
                throw new IllegalArgumentException("Can't find workspace view for type " + (Object)((Object)workspace.getTypeToken()) + ".");
            }
            case Building: {
                return new JBuildingView(jAdecWatt, (Building)workspace);
            }
            case Lightplot: {
                return new JLightplotView(jAdecWatt, (Lightplot)workspace);
            }
        }
        throw new IllegalArgumentException("Can't find constructor for type " + (Object)((Object)workspace.getTypeToken()) + ".");
    }

    protected JWorkspaceView(JAdecWatt jAdecWatt, T workspace) {
        this.jAdecWatt = jAdecWatt;
        this.workspace = workspace;
        this.adecWatt = jAdecWatt.getAdecWatt();
        this.user = this.adecWatt.getUser();
        this.permanentDB = this.adecWatt.getPermanentDB();
        this.iconDB = this.adecWatt.getIconDB();
        this.realSize = ((Editable)workspace).getRealSize();
        this.backgroundShape = new Rectangle2D.Double(0.0, 0.0, this.realSize.width, this.realSize.height);
        this.jSelectionPane = this.createJLabelLayer(1001);
        this.initScale();
        this.addMouseListener(this.workspaceViewMouseAdapter);
        this.addMouseMotionListener(this.workspaceViewMouseAdapter);
        this.addMouseWheelListener(this.workspaceViewMouseAdapter);
        ((Workspace)workspace).stateNotifier.addUpdateObserver(this, "Story");
        this.adecWatt.addMsgObserver(this, "SetSelectionItems");
        ((Workspace)workspace).stateNotifier.addMsgObserver(this, "NewItem", "RemoveItem", "UpdateItem", "UpdatePermItem", "ChangeRotSize", "ChangePos", "ChangeRot");
    }

    private JLabel createJLabelLayer(int layer) {
        JLabel result = new JLabel();
        result.setLocation(0, 0);
        this.add(result);
        this.setLayer(result, layer);
        return result;
    }

    private Graphics2D createGraphicsLayer(JLabel layer) {
        BufferedImage image = new BufferedImage(this.currentSize.width, this.currentSize.height, 2);
        layer.setIcon(new ImageIcon(image));
        layer.setSize(this.currentSize);
        return image.createGraphics();
    }

    public ArrayList<Item> findItems(Point pos) {
        return ((Workspace)this.workspace).findItems(this.scaleViewToModel(pos), 4.0 / this.scale);
    }

    public Hashtable<Item, ArrayList<Acc>> findAccs(Point pos, Item<?, ?, ?> item) {
        Hashtable<Item, ArrayList<Acc>> result = new Hashtable<Item, ArrayList<Acc>>();
        if (item == null) {
            return result;
        }
        Point2D.Double realPos = this.scaleViewToModel(new Point(pos.x, pos.y));
        ArrayList<Acc> accs = item.findAccs(realPos, 2.0 / this.scale);
        if (accs.size() > 0) {
            result.put(item, accs);
        }
        return result;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform iat = g2.getTransform();
        Shape clip = g2.getClip();
        g2.scale(this.scale, this.scale);
        g2.setColor(Color.WHITE);
        g2.fill(this.backgroundShape);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke((float)(1.0 / this.scale)));
        g2.draw(this.backgroundShape);
        ((Workspace)this.workspace).print(g2, this.scale, this.selectedItems.keySet(), true);
        g2.setTransform(iat);
        g2.setClip(clip);
        this.paintChildren(g);
    }

    public void mouseClicked(MouseEvent e) {
        this.requestFocusInWindow();
        this.jAdecWatt.setCurrentWorkspace((Workspace)this.workspace);
        if (this.selectedAcc != null) {
            this.adecWatt.broadcastDisplay("DisplayAcc", this.selectedAcc.getAcc());
            return;
        }
        new JOverlapItemPopup(this, e);
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
        this.jAdecWatt.setCurrentWorkspace((Workspace)this.workspace);
        if (e.isControlDown()) {
            this.rotation(e);
            return;
        }
        new JOverlapItemPopup(this, e);
    }

    protected boolean performPopup(MouseEvent e) {
        if (this.selectedAcc != null) {
            new JAccPopup(this, this.selectedAcc.getItem(), this.selectedAcc.getAcc(), e.getPoint());
            return true;
        }
        if (this.selectedItems.size() > 0) {
            new JItemPopup(this, this.selectedItems.values().iterator().next().getItem(), e.getPoint());
            return true;
        }
        return false;
    }

    public void noDrag() {
        this.refHandle = null;
        this.handleOff = null;
    }

    public void startDrag(Item<?, ?, ?> item, Point mPos) {
        this.firstClick = this.lastClick = mPos;
        this.selectionRefHandle(item, mPos);
    }

    public void performSelection(Item<?, ?, ?> item, MouseEvent e) {
        Point mPos = e.getPoint();
        this.setSelectedAcc();
        if (item == null) {
            this.startsZoneSelection(e);
            return;
        }
        Hashtable<Item, ArrayList<Acc>> overlapAccs = this.findAccs(mPos, item);
        if (overlapAccs.size() > 0) {
            this.firstClick = this.lastClick = mPos;
            this.lastSelectedAccId = (this.lastSelectedAccId + 1) % this.nbOverlapAccs(overlapAccs);
            this.setSelectedAcc(overlapAccs, this.lastSelectedAccId);
            return;
        }
        this.lastSelectedAccId = -1;
        if (e.isShiftDown()) {
            this.invertItemSelection(item);
            if (this.selectedItems.size() < 1) {
                this.noDrag();
            }
            return;
        }
        this.startDrag(item, mPos);
        this.setSelectedItems(item);
    }

    public void selectionRefHandle(Item item, Point mPos) {
        Point2D.Double firstModelClick = new Point2D.Double((double)mPos.x / this.scale, (double)mPos.y / this.scale);
        this.refHandle = (Point2D.Double)firstModelClick.clone();
        item.getCloseBound(firstModelClick, Double.MAX_VALUE, this.refHandle);
        this.handleOff = new DimensionDouble(this.refHandle.x - firstModelClick.x, this.refHandle.y - firstModelClick.y);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.selectedAcc != null) {
            this.dropAcc(e);
            return;
        }
        if (this.zoneSelectionStart != null) {
            this.endsZoneSelection(e);
            return;
        }
        if (e.isControlDown() && this.refHandle == null) {
            this.rotation(e);
            this.storyRotSelectedComp();
            return;
        }
        this.storyMoveSelectedItem(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.selectedAcc != null) {
            this.dragAcc(e);
            return;
        }
        if (this.zoneSelectionStart != null) {
            this.extendsZoneSelection(e);
            return;
        }
        if (e.isControlDown() && this.refHandle == null) {
            this.rotation(e);
            return;
        }
        this.dragItems(e);
    }

    public void startsZoneSelection(MouseEvent e) {
        this.removeAllSelectedItems();
        this.zoneSelectionEnd = this.zoneSelectionStart = e.getPoint();
        this.updateSelection();
    }

    public void extendsZoneSelection(MouseEvent e) {
        this.zoneSelectionEnd = e.getPoint();
        this.updateSelectionLayer();
    }

    public void endsZoneSelection(MouseEvent e) {
        this.removeAllSelectedItems();
        this.zoneSelectionEnd = e.getPoint();
        Point2D.Double realStart = this.scaleViewToModel(this.zoneSelectionStart);
        Rectangle2D.Double selectedZone = new Rectangle2D.Double(realStart.x, realStart.y, 0.0, 0.0);
        selectedZone.add(this.scaleViewToModel(this.zoneSelectionEnd));
        for (Item item : ((Workspace)this.workspace).getAllItems()) {
            if (this.isSticky(item) || !item.inside(selectedZone)) continue;
            this.addSelectedItem(item);
        }
        this.zoneSelectionStart = null;
        this.zoneSelectionEnd = null;
        this.updateSelection();
    }

    protected void setSelectedBound(Line2D.Double selectedBound) {
        this.selectedBound = selectedBound;
    }

    protected void removeAllSelectedItems() {
        for (JItem jItem : this.selectedItems.values()) {
            this.remove(jItem);
        }
        this.selectedItems.clear();
        this.selectedBound = null;
        this.selectedJItemHandlers.clear();
    }

    protected boolean removeSelectedItem(Item item) {
        this.selectedBound = null;
        JItem jItem = this.selectedItems.remove(item.getId());
        if (jItem == null) {
            return false;
        }
        this.remove(jItem);
        return true;
    }

    protected void addSelectedItem(Item item) {
        String itemId = item.getId();
        if (this.selectedItems.containsKey(itemId)) {
            return;
        }
        JItem jItem = JItem.getNewJItem(this, item);
        this.selectedItems.put(itemId, jItem);
        this.add(jItem);
        this.setLayer(jItem, this.levelModelToView(item.getLevel()));
    }

    public void setSelectedItemsBySearch(String text) {
        this.removeAllSelectedItems();
        if (text != null && !text.isEmpty()) {
            for (Item item : ((Workspace)this.workspace).getAllItems()) {
                try {
                    if (!item.match(text)) continue;
                    this.addSelectedItem(item);
                }
                catch (Exception exception) {}
            }
        }
        this.updateSelection();
    }

    public void selectAllItems() {
        this.removeAllSelectedItems();
        for (Item item : ((Workspace)this.workspace).getAllItems()) {
            if (this.isSticky(item)) continue;
            this.addSelectedItem(item);
        }
        this.updateSelection();
    }

    public void setSelectedItems() {
        this.removeAllSelectedItems();
        this.updateSelection();
    }

    public void setSelectedItems(List<Item> items) {
        this.removeAllSelectedItems();
        if (items == null) {
            return;
        }
        for (Item item : items) {
            if (this.isSticky(item)) continue;
            this.addSelectedItem(item);
        }
        this.updateSelection();
    }

    public void setSelectedItems(Item item) {
        this.removeAllSelectedItems();
        if (item != null) {
            this.addSelectedItem(item);
        }
        this.lastSelectedItem = item;
        this.updateSelection();
    }

    public void invertItemSelection(Item item) {
        JItem jItem = this.selectedItems.remove(item.getId());
        if (jItem == null) {
            this.addSelectedItem(item);
        } else {
            this.remove(jItem);
        }
        this.updateSelection();
    }

    public void updateSelection() {
        this.jAdecWatt.stateNotifier.broadcastUpdate("Selection");
        this.updateSelectionLayer();
    }

    public int getNbSelectedItems() {
        int result = 0;
        for (String itemId : this.selectedItems.keySet()) {
            if (!((Workspace)this.workspace).containsItem(itemId)) continue;
            ++result;
        }
        return result;
    }

    public Vector<Item> getSelectedItems() {
        int nbSelected = this.selectedItems.size();
        Vector<Item> items = new Vector<Item>(nbSelected);
        if (nbSelected < 1) {
            return items;
        }
        for (String itemId : this.selectedItems.keySet()) {
            if (!((Workspace)this.workspace).containsItem(itemId)) continue;
            items.add(this.selectedItems.get(itemId).getItem());
        }
        return items;
    }

    protected int nbOverlapAccs(Hashtable<Item, ArrayList<Acc>> overlapAccs) {
        int result = 0;
        for (ArrayList<Acc> accs : overlapAccs.values()) {
            result += accs.size();
        }
        return result;
    }

    protected void setSelectedAcc() {
        if (this.selectedAcc == null) {
            return;
        }
        this.lastClick = null;
        this.firstClick = null;
        this.remove(this.selectedAcc);
        this.selectedAcc = null;
        this.updateSelection();
    }

    protected void setSelectedAcc(Hashtable<Item, ArrayList<Acc>> overlapAccs, int idx) {
        for (Item item : overlapAccs.keySet()) {
            ArrayList<Acc> accs = overlapAccs.get(item);
            int size = accs.size();
            if (idx >= size) {
                idx -= size;
                continue;
            }
            this.selectedAcc = new JAcc(this, item, accs.get(idx));
            this.add(this.selectedAcc);
            this.setLayer(this.selectedAcc, this.levelModelToView(item.getLevel()));
        }
        this.updateSelection();
    }

    public void recordJLabel(JLabel jLabel) {
        this.newJLabel.add(jLabel);
    }

    public void updateSelectionLayer() {
        AffineTransform af = this.selectionGraphics.getTransform();
        this.jSelectionPane.invalidate();
        this.newJLabel.clear();
        this.selectionGraphics.setBackground(noColor);
        this.selectionGraphics.clearRect(0, 0, this.currentSize.width, this.currentSize.height);
        this.selectionGraphics.setColor(selectionColor);
        if (this.zoneSelectionStart != null) {
            int x = Math.min(this.zoneSelectionStart.x, this.zoneSelectionEnd.x);
            int y = Math.min(this.zoneSelectionStart.y, this.zoneSelectionEnd.y);
            int width = Math.abs(this.zoneSelectionEnd.x - this.zoneSelectionStart.x);
            int height = Math.abs(this.zoneSelectionEnd.y - this.zoneSelectionStart.y);
            this.selectionGraphics.fillRect(x, y, width, height);
        }
        if (this.selectedAcc != null) {
            Item item = this.selectedAcc.getItem();
            Acc acc = this.selectedAcc.getAcc();
            String accId = acc.getId();
            DimensionDouble accSize = item.getAccSize(accId);
            double halfWidth = accSize.width * this.scale / 2.0;
            double halfHeight = accSize.height * this.scale / 2.0;
            AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(item.getThetaDegree()));
            double[] bounds = new double[]{-halfWidth, -halfHeight, -halfWidth, halfHeight, halfWidth, halfHeight, halfWidth, -halfHeight};
            at.transform(bounds, 0, bounds, 0, 4);
            Point accPos = this.selectedAcc.getLocation();
            int[] x = new int[4];
            int[] y = new int[4];
            for (int i = 0; i < 4; ++i) {
                x[i] = (int)bounds[2 * i] + accPos.x + 8;
                y[i] = (int)bounds[2 * i + 1] + accPos.y + 8;
            }
            this.selectionGraphics.fillPolygon(x, y, 4);
        }
        for (String itemId : this.selectedItems.keySet()) {
            if (!((Workspace)this.workspace).containsItem(itemId)) continue;
            try {
                JItem jItem = this.selectedItems.get(itemId);
                Item item = jItem.getItem();
                double[] bounds = jItem.getCurrentBounds();
                if (bounds == null) continue;
                int[] x = new int[4];
                int[] y = new int[4];
                int i = 0;
                int j = 1;
                for (int k = 0; k < 4; ++k) {
                    x[k] = (int)(bounds[i] * this.scale);
                    y[k] = (int)(bounds[j] * this.scale);
                    i += 2;
                    j += 2;
                }
                this.selectionGraphics.fillPolygon(x, y, 4);
                if (item.getPropNoMouse("size")) continue;
                JItemHandler handler = this.selectedJItemHandlers.get(jItem);
                if (handler == null) {
                    handler = new JItemHandler(this, this.jSelectionPane, jItem, !(jItem instanceof JComp));
                    this.selectedJItemHandlers.put(jItem, handler);
                }
                handler.setCurrentBounds(bounds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Component component : this.jSelectionPane.getComponents()) {
            if (this.newJLabel.contains(component)) continue;
            this.jSelectionPane.remove(component);
        }
        for (JLabel label : this.newJLabel) {
            if (this.jSelectionPane.isAncestorOf(label)) continue;
            this.jSelectionPane.add(label);
        }
        this.selectionGraphics.scale(this.scale, this.scale);
        if (this.selectedBound != null) {
            this.selectionGraphics.setPaint(selectionBoundColor);
            this.selectionGraphics.setStroke(new BasicStroke(20.0f / (float)this.scale, 1, 1, 1.0f));
            if (this.selectedBound.x1 == this.selectedBound.x2 && this.selectedBound.y1 == this.selectedBound.y2) {
                double r = 4.0 / this.scale;
                double dr = r + r;
                Ellipse2D.Double disc = new Ellipse2D.Double(this.selectedBound.x1 - r, this.selectedBound.y1 - r, dr, dr);
                this.selectionGraphics.draw(disc);
            } else {
                this.selectionGraphics.draw(this.selectedBound);
            }
        }
        this.selectionGraphics.setTransform(af);
        this.jSelectionPane.repaint();
        this.jSelectionPane.validate();
    }

    public void scrollView(boolean horizontal, int delta) {
        JScrollPaneWorkspace jScrollPaneWorkspace = this.getJScrollPaneWorkspace();
        JScrollBar jScrollBar = horizontal ? jScrollPaneWorkspace.getHorizontalScrollBar() : jScrollPaneWorkspace.getVerticalScrollBar();
        int min = jScrollBar.getMinimum();
        int max = jScrollBar.getMaximum();
        int step = (max - min) / 10;
        jScrollBar.setValue(Math.min(max, Math.max(min, jScrollBar.getValue() + delta * step)));
        jScrollPaneWorkspace.updateScale();
    }

    public void changeScale(Point mousePos, int delta) {
        JViewport jViewport = this.getJScrollPaneWorkspace().getViewport();
        Point viewPosA = jViewport.getViewPosition();
        Point2D.Double realPos = this.scaleViewToModel(mousePos);
        this.setScale(delta < 0 ? this.scale + this.scaleStep : this.scale - this.scaleStep);
        Point viewPosB = this.scaleModelToView(realPos);
        viewPosB.translate(-mousePos.x + viewPosA.x, -mousePos.y + viewPosA.y);
        if (viewPosB.x < 0) {
            viewPosB.x = 0;
        }
        if (viewPosB.y < 0) {
            viewPosB.y = 0;
        }
        jViewport.setViewPosition(viewPosB);
    }

    public void initScale() {
        this.initScale = Math.rint(Math.min((double)this.jAdecWatt.screenSize.width / this.realSize.getWidth(), (double)this.jAdecWatt.screenSize.height / this.realSize.getHeight()));
        this.minScale = this.initScale / 10.0;
        this.maxScale = this.initScale * 10.0;
        this.scaleStep = this.minScale / 2.0;
        this.setScale(this.initScale);
    }

    public void setScale(double scale) {
        this.scale = scale = Math.rint(Math.max(this.minScale, Math.min(this.maxScale, scale)));
        this.currentSize = this.scaleModelToView(this.realSize);
        this.setPreferredSize(this.currentSize);
        this.selectionGraphics = this.createGraphicsLayer(this.jSelectionPane);
        for (JItem jItem : this.selectedItems.values()) {
            jItem.setScale();
        }
        this.updateSelectionLayer();
        this.repaint();
        this.jAdecWatt.stateNotifier.broadcastUpdate("ChangeScale");
        JScrollPaneWorkspace jScrollPaneWorkspace = this.getJScrollPaneWorkspace();
        if (jScrollPaneWorkspace == null) {
            return;
        }
        jScrollPaneWorkspace.updateScale();
    }

    public int levelModelToView(double level) {
        return (int)(level * 10.0);
    }

    public Point2D.Double scaleViewToModel(Point pos) {
        return new Point2D.Double((double)pos.x / this.scale, (double)pos.y / this.scale);
    }

    public DimensionDouble scaleViewToModel(Dimension size) {
        return new DimensionDouble((double)size.width / this.scale, (double)size.height / this.scale);
    }

    public Point scaleModelToView(Point2D pos) {
        return new Point((int)(pos.getX() * this.scale), (int)(pos.getY() * this.scale));
    }

    public Dimension scaleModelToView(DimensionDouble size) {
        return new Dimension((int)(size.getWidth() * this.scale), (int)(size.getHeight() * this.scale));
    }

    public void rotation(MouseEvent e) {
        if (this.notEditable()) {
            return;
        }
        for (String itemId : this.selectedItems.keySet()) {
            if (!((Workspace)this.workspace).containsItem(itemId)) continue;
            try {
                JComp jComp = (JComp)this.selectedItems.get(itemId);
                if (jComp.comp.getPropNoMouse("rot")) continue;
                jComp.rotation(SwingUtilities.convertMouseEvent(this, e, jComp));
            }
            catch (Exception exception) {}
        }
        this.updateSelectionLayer();
    }

    public void dragItems(MouseEvent e) {
        if (this.notEditable() || this.firstClick == null || this.handleOff == null) {
            return;
        }
        Point newPos = e.getPoint();
        Point2D.Double newModelPos = new Point2D.Double((double)newPos.x / this.scale + this.handleOff.width, (double)newPos.y / this.scale + this.handleOff.height);
        this.setSelectedBound(e.isControlDown() ? null : ((Workspace)this.workspace).getMagnetPoint(newModelPos, JWorkspaceView.onGrid(newModelPos), 10.0 / this.scale));
        this.lastClick = newPos;
        DimensionDouble delta = new DimensionDouble(newModelPos.x - this.refHandle.x, newModelPos.y - this.refHandle.y);
        this.refHandle = newModelPos;
        for (String itemId : this.selectedItems.keySet()) {
            JItem jItem;
            if (!((Workspace)this.workspace).containsItem(itemId) || (jItem = this.selectedItems.get(itemId)).getItem().getPropNoMouse("pos")) continue;
            jItem.dragItem(delta);
        }
        this.updateSelectionLayer();
    }

    public void dragAcc(MouseEvent e) {
        if (this.notEditable() || this.lastClick == null) {
            return;
        }
        Point newPos = e.getPoint();
        Dimension delta = new Dimension(newPos.x - this.lastClick.x, newPos.y - this.lastClick.y);
        this.lastClick = newPos;
        this.selectedAcc.dragAcc(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropAcc(MouseEvent e) {
        if (this.notEditable()) {
            return;
        }
        try {
            Point2D.Double realPos = this.scaleViewToModel(e.getPoint());
            ArrayList<Item> dstItems = ((Workspace)this.workspace).findItems(realPos, 4.0 / this.scale);
            PermanentDB permanentDB = this.adecWatt.getPermanentDB();
            if (this.selectedAcc.getAcc().getDirectUnit().isDescendingFrom(permanentDB.getPowerPlugId())) {
                if (dstItems.size() < 1) {
                    this.eraseAcc(this.selectedAcc.getAcc());
                    return;
                }
                ArrayList<Acc> dstAccs = dstItems.get(0).findAccs(realPos, 2.0 / this.scale);
                Acc dstAcc = dstAccs.size() < 1 ? null : dstAccs.get(0);
                try {
                    this.storyConnect((Comp)this.selectedAcc.getItem(), this.selectedAcc.getAcc(), (Comp)dstItems.get(0), dstAcc, permanentDB.getPowerSocketId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (dstItems.size() < 1) {
                this.eraseAcc(this.selectedAcc.getAcc());
                return;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            this.setSelectedAcc();
        }
    }

    public void dropAcc(Accessory accessory, Point pos) {
        if (this.notEditable() || accessory == null) {
            return;
        }
        ArrayList<Item> overlapItems = this.findItems(pos);
        if (overlapItems.size() < 1) {
            return;
        }
        ((Workspace)this.workspace).storyAddAcc(overlapItems.get(0), accessory);
    }

    public static Point2D.Double onGrid(Point2D.Double pos) {
        return new Point2D.Double(0.1 * Math.rint(pos.x / 0.1), 0.1 * Math.rint(pos.y / 0.1));
    }

    public void dropSegm(NonWorkspace model, Point mPos) {
        ((Workspace)this.workspace).storyAddSegm(model, JWorkspaceView.onGrid(this.scaleViewToModel(mPos)));
    }

    public void dropComp(NonWorkspace model, Point mPos) {
        ((Workspace)this.workspace).storyAddComp(model, JWorkspaceView.onGrid(this.scaleViewToModel(mPos)));
    }

    public void eraseAcc(Acc acc) {
        ((Workspace)this.workspace).storyRemoveAcc(acc);
    }

    public void cloneItem(Item item, Point pos) {
        ((Workspace)this.workspace).storyCloneItem(item, this.scaleViewToModel(pos));
    }

    public void hideShowItem(List<Item> items, boolean hidden) {
        ((Workspace)this.workspace).storyHideShowItem(items, hidden);
    }

    public void eraseItem(List<Item> items) {
        ((Workspace)this.workspace).storyRemoveItems(items);
    }

    public void storyRotSelectedComp() {
        if (this.notEditable()) {
            return;
        }
        int nbSelected = this.selectedItems.size();
        if (nbSelected < 1) {
            return;
        }
        Vector<Item> items = new Vector<Item>(nbSelected);
        Vector<Double> thetas = new Vector<Double>(nbSelected);
        for (String itemId : this.selectedItems.keySet()) {
            Item item;
            if (!((Workspace)this.workspace).containsItem(itemId) || (item = this.selectedItems.get(itemId).getItem()).getPropNoMouse("rot")) continue;
            items.add(item);
            thetas.add(this.selectedItems.get(itemId).getCurrentThetaDegree());
        }
        ((Workspace)this.workspace).storyRotItem(items, thetas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storyMoveSelectedItem(MouseEvent e) {
        if (this.notEditable()) {
            return;
        }
        try {
            if (this.firstClick == null || this.firstClick.equals(e.getPoint())) {
                return;
            }
            int nbSelected = this.selectedItems.size();
            if (nbSelected < 1) {
                return;
            }
            Vector<Item> items = new Vector<Item>(nbSelected);
            Vector<Point2D.Double> poss = new Vector<Point2D.Double>(nbSelected);
            for (String itemId : this.selectedItems.keySet()) {
                Item item;
                if (!((Workspace)this.workspace).containsItem(itemId) || (item = this.selectedItems.get(itemId).getItem()).getPropNoMouse("pos")) continue;
                items.add(item);
                poss.add(this.selectedItems.get(itemId).getCurrentPos());
            }
            ((Workspace)this.workspace).storyMoveItem(items, poss);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            this.noDrag();
        }
    }

    public void storyRotResizeItem(JItem jItem) {
        if (this.notEditable()) {
            return;
        }
        ((Workspace)this.workspace).storyRotResize(jItem.getItem(), jItem.getCurrentPos(), jItem.getCurrentThetaDegree(), jItem.getCurrentSize());
    }

    public void storyConnect(Comp srcComp, Acc srcAcc, Comp dstComp, Acc dstAcc, String dstModelId) {
        if (this.notEditable()) {
            return;
        }
        if (dstAcc == null) {
            dstAcc = (Acc)dstComp.findEmbeddedBaseOn(dstModelId);
        }
        if (dstAcc == null || !dstAcc.getDirectUnit().isDescendingFrom(dstModelId)) {
            return;
        }
        ((Workspace)this.workspace).storyConnect(srcComp, srcAcc, dstComp.getId(), dstAcc.getId());
    }

    public void updateStory() {
        this.updateSelection();
    }

    public void displaySetSelectionItems(Object ... objects) {
        this.setSelectedItems((List)objects[1]);
    }

    public void displayNewItem(Object ... objects) {
        this.updateSelection();
        this.repaint();
    }

    public void displayRemoveItem(Object ... objects) {
        this.updateSelection();
        this.repaint();
    }

    public void displayUpdateItem(Object ... objects) {
        try {
            Item item = (Item)objects[0];
            this.selectedItems.get(item.getId()).setItem(item);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    public void displayUpdatePermItem(Object ... objects) {
        NonWorkspace permItem = (NonWorkspace)objects[0];
        UnitNode ancestor = permItem.getUnitNode();
        boolean repaint = false;
        for (Item item : ((Workspace)this.workspace).getAllItems()) {
            if (!item.getModel().getUnitNode().isNodeAncestor(ancestor)) continue;
            repaint = true;
            break;
        }
        if (!repaint) {
            return;
        }
        this.repaint();
    }

    public void displayChangePos(Object ... objects) {
        for (Object obj : objects) {
            JItem jItem = this.updateJItem(obj);
            if (jItem == null) continue;
            jItem.setCurrentPos();
        }
    }

    public void displayChangeRotSize(Object ... objects) {
        for (Object obj : objects) {
            JItem jItem = this.updateJItem(obj);
            if (jItem == null) continue;
            jItem.setCurrentSize();
        }
    }

    public void displayChangeRot(Object ... objects) {
        for (Object obj : objects) {
            JItem jItem = this.updateJItem(obj);
            if (jItem == null) {
                return;
            }
            try {
                jItem.setCurrentThetaDegree();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private JItem updateJItem(Object obj) {
        Item item = (Item)obj;
        JItem jItem = this.selectedItems.get(item.getId());
        if (jItem == null) {
            return null;
        }
        jItem.setItem(item);
        return jItem;
    }
}

