/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import misc.DimensionDouble;
import misc.StateNotifier;
import misc.Util;

public class JZones
extends JLayeredPane {
    public static final int minPixels = 10;
    public static final String BroadcastSelectedLocationChange = "SelectedLocationChange";
    public static final String BroadcastSelectedRateChange = "SelectedRateChange";
    public static final String BroadcastSelectedChange = "SelectedChange";
    public static final String BroadcastCreateZone = "CreateZone";
    public static final String BroadcastChangeScale = "ChangeScale";
    public static final Color defineColor = new Color(128, 128, 128, 64);
    public StateNotifier stateNotifier = new StateNotifier();
    private DimensionDouble realSize;
    private Rectangle2D.Double backgroundShape;
    private double rate;
    private double scale = 1.0;
    private double initScale = 1.0;
    private double minScale = 1.0;
    private double maxScale = 1.0;
    private double scaleStep = 1.0;
    private double minSide;
    private BufferedImage background;
    private AffineTransform bgat;
    ArrayList<Zone> zones = new ArrayList();
    private JZoneHandler jZoneHandler;
    private boolean cornerSelection;
    private boolean createZone = true;
    private Zone selectedZone;
    private Point defineSelectionStart;
    private Point defineSelectionEnd;
    private MouseAdapter jZonesMouseAdapter = new MouseAdapter(){
        Point2D.Double mousePosOnZone;

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                JZones.this.selectZone(null);
                return;
            }
            Point2D.Double posInPage = JZones.this.scaleViewToModel(e.getPoint());
            ArrayList<Zone> overlap = new ArrayList<Zone>();
            for (Zone zone : JZones.this.zones) {
                if (!zone.rectangle.contains(posInPage.x, posInPage.y)) continue;
                overlap.add(zone);
            }
            if (overlap.size() < 1) {
                JZones.this.selectZone(null);
                JZones.this.defineSelectionStart = (JZones.this.defineSelectionEnd = e.getPoint());
                return;
            }
            JZones.this.selectZone((Zone)overlap.get((JZones.this.zones.indexOf(JZones.this.selectedZone) + 1) % overlap.size()));
            this.mousePosOnZone = posInPage;
            this.mousePosOnZone.x -= ((Zone)((JZones)JZones.this).selectedZone).rectangle.x;
            this.mousePosOnZone.y -= ((Zone)((JZones)JZones.this).selectedZone).rectangle.y;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!JZones.this.createZone || JZones.this.defineSelectionStart == null) {
                return;
            }
            Rectangle selection = new Rectangle(JZones.this.defineSelectionStart);
            selection.add(JZones.this.defineSelectionEnd);
            JZones.this.defineSelectionStart = (JZones.this.defineSelectionEnd = null);
            Point2D.Double start = JZones.this.scaleViewToModel(selection.getLocation());
            DimensionDouble dim = JZones.this.scaleViewToModel(selection.getSize());
            Rectangle2D.Double area = new Rectangle2D.Double(start.x, start.y, dim.width, dim.height);
            if (area.width > JZones.this.minSide && area.height > JZones.this.minSide) {
                JZones.this.stateNotifier.broadcastDisplay(JZones.BroadcastCreateZone, area);
            }
            JZones.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (JZones.this.defineSelectionStart != null) {
                JZones.this.defineSelectionEnd = e.getPoint();
                JZones.this.repaint();
            }
            if (JZones.this.selectedZone == null) {
                return;
            }
            Point2D.Double posInPage = JZones.this.scaleViewToModel(e.getPoint());
            JZones.this.selectedZone.setLocation(posInPage.x - this.mousePosOnZone.x, posInPage.y - this.mousePosOnZone.y);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            try {
                if (0 != (e.getModifiersEx() & 0x41)) {
                    JZones.this.scrollView(true, e.getWheelRotation());
                } else if (0 != (e.getModifiersEx() & 0x82)) {
                    JZones.this.changeScale(e.getPoint(), e.getWheelRotation());
                } else {
                    JZones.this.scrollView(false, e.getWheelRotation());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    public static final ImageIcon handlerImage = Util.loadActionIcon("handler");

    public DimensionDouble getRealSize() {
        return this.realSize;
    }

    public double getScale() {
        return this.scale;
    }

    public Rectangle2D.Double getMaxRate(double rate) {
        double width = this.realSize.width;
        double height = this.realSize.height;
        if (rate != 0.0 && rate != this.rate) {
            if (rate < this.rate) {
                width = rate * height;
            } else {
                height = width / rate;
            }
        }
        return new Rectangle2D.Double(0.0, 0.0, width, height);
    }

    public void setCornerSelection(boolean cornerSelection) {
        if (this.cornerSelection == cornerSelection) {
            return;
        }
        this.cornerSelection = cornerSelection;
        if (this.jZoneHandler != null) {
            this.jZoneHandler.setVisible(false);
        }
        this.jZoneHandler = new JZoneHandler(cornerSelection);
    }

    public void setCreateZone(boolean createZone) {
        this.createZone = createZone;
        this.repaint();
    }

    public boolean setLandscape(boolean landscape) {
        if (this.rate > 1.0 == landscape) {
            return false;
        }
        this.realSize = new DimensionDouble(this.realSize.height, this.realSize.width);
        this.backgroundShape = new Rectangle2D.Double(0.0, 0.0, this.realSize.width, this.realSize.height);
        this.rate = this.realSize.width / this.realSize.height;
        for (Zone zone : this.zones) {
            zone.fitLandscape();
        }
        this.repaint();
        return true;
    }

    public void setCenterScale(double scale) {
        JViewport jViewport = this.getJScrollPane().getViewport();
        Rectangle prevView = jViewport.getViewRect();
        Point2D.Double realCenter = this.scaleViewToModel(new Point(prevView.x + prevView.width / 2, prevView.y + prevView.height / 2));
        this.setScale(scale);
        Rectangle nextView = jViewport.getViewRect();
        Point viewCenter = this.scaleModelToView(realCenter);
        viewCenter.translate(-nextView.width / 2, -nextView.height / 2);
        if (viewCenter.x < 0) {
            viewCenter.x = 0;
        }
        if (viewCenter.y < 0) {
            viewCenter.y = 0;
        }
        jViewport.setViewPosition(viewCenter);
    }

    public void resetScale() {
        this.setScale(this.initScale);
    }

    public void setScale(double scale) {
        this.scale = scale = Math.max(this.minScale, Math.min(this.maxScale, scale));
        this.minSide = 10.0 / scale;
        this.setPreferredSize(this.scaleModelToView(this.realSize));
        if (this.selectedZone != null) {
            this.jZoneHandler.updateRectangle(this.selectedZone.rectangle);
        }
        if (this.background != null) {
            this.bgat = AffineTransform.getScaleInstance(this.realSize.width / (double)this.background.getWidth(), this.realSize.height / (double)this.background.getHeight());
        }
        this.repaint();
        this.stateNotifier.broadcastUpdate(BroadcastChangeScale);
    }

    public void setBackground(BufferedImage background) {
        this.background = background;
        this.setScale(this.scale);
    }

    public JZones(DimensionDouble realSize, int maxSide) {
        this.realSize = realSize;
        this.setCornerSelection(true);
        this.backgroundShape = new Rectangle2D.Double(0.0, 0.0, realSize.width, realSize.height);
        this.rate = realSize.width / realSize.height;
        if (maxSide > 0) {
            this.initScale = (double)maxSide / Math.max(realSize.getWidth(), realSize.getHeight());
        }
        this.scale = this.initScale;
        this.minScale = this.initScale / 10.0;
        this.maxScale = this.initScale * 10.0;
        this.scaleStep = this.minScale / 2.0;
        this.addMouseListener(this.jZonesMouseAdapter);
        this.addMouseMotionListener(this.jZonesMouseAdapter);
        this.addMouseWheelListener(this.jZonesMouseAdapter);
        this.setScale(this.scale);
    }

    public Zone addZone(Color color) {
        return this.addZone(new Zone(this.getMaxRate(0.0), color, null));
    }

    public Zone addZone(Color color, Rectangle2D.Double rectangle) {
        return this.addZone(new Zone(rectangle, color, null));
    }

    public Zone addZone(Color color, BufferedImage image) {
        return this.addZone(new Zone(this.getMaxRate((double)image.getWidth() / (double)image.getHeight()), color, image));
    }

    public Zone addZone(Zone pair, BufferedImage image) {
        return this.addZone(new Zone(this.getMaxRate(((Zone)pair).rectangle.width / ((Zone)pair).rectangle.height), pair, image));
    }

    public Zone addZone(Zone zone) {
        this.zones.add(zone);
        this.repaint();
        return zone;
    }

    public void turnZoneLeft() {
        if (this.selectedZone == null) {
            return;
        }
        this.selectedZone.turnLeft();
    }

    public void turnZoneRight() {
        if (this.selectedZone == null) {
            return;
        }
        this.selectedZone.turnRight();
    }

    public void removeZone(Zone zone) {
        if (zone == null) {
            return;
        }
        if (this.selectedZone == zone) {
            this.selectZone(null);
        }
        this.zones.remove(zone);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform iat = g2.getTransform();
        Shape clip = g2.getClip();
        g2.scale(this.scale, this.scale);
        g2.setColor(Color.WHITE);
        g2.fill(this.backgroundShape);
        if (this.background != null) {
            g2.drawImage(this.background, this.bgat, null);
        }
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke((float)(1.0 / this.scale)));
        g2.draw(this.backgroundShape);
        for (Zone zone : this.zones) {
            if (zone.pair == null && zone.image == null) continue;
            double refBgScale = zone.pair == null ? 1.0 : ((Zone)zone).pair.getRealSize().width / (double)zone.image.getWidth();
            g2.setTransform(iat);
            g2.setClip(clip);
            g2.scale(this.scale, this.scale);
            zone.projection(g2);
            AffineTransform bat = new AffineTransform();
            bat.scale(refBgScale, refBgScale);
            g2.drawImage(zone.image, bat, null);
        }
        g2.setTransform(iat);
        g2.setClip(clip);
        g2.scale(this.scale, this.scale);
        for (Zone zone : this.zones) {
            Color color = zone.color;
            Color aColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 64);
            g2.setColor(aColor);
            g2.fill(zone.rectangle);
        }
        g2.setTransform(iat);
        g2.setColor(defineColor);
        if (this.createZone && this.defineSelectionStart != null) {
            Rectangle selection = new Rectangle(this.defineSelectionStart);
            selection.add(this.defineSelectionEnd);
            g2.fill(selection);
        }
        this.paintChildren(g);
    }

    public DimensionDouble scaleViewToModel(Dimension size) {
        return new DimensionDouble((double)size.width / this.scale, (double)size.height / this.scale);
    }

    public Dimension scaleModelToView(DimensionDouble size) {
        return new Dimension((int)(size.getWidth() * this.scale), (int)(size.getHeight() * this.scale));
    }

    public Point2D.Double scaleViewToModel(Point pos) {
        return new Point2D.Double((double)pos.x / this.scale, (double)pos.y / this.scale);
    }

    public Point scaleModelToView(Point2D pos) {
        return new Point((int)(pos.getX() * this.scale), (int)(pos.getY() * this.scale));
    }

    private JScrollPane getJScrollPane() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JScrollPane)) continue;
            return (JScrollPane)parent;
        }
        return null;
    }

    public void scrollView(boolean horizontal, int delta) {
        JScrollPane jScrollPane = this.getJScrollPane();
        JScrollBar jScrollBar = horizontal ? jScrollPane.getHorizontalScrollBar() : jScrollPane.getVerticalScrollBar();
        int min = jScrollBar.getMinimum();
        int max = jScrollBar.getMaximum();
        int step = (max - min) / 10;
        jScrollBar.setValue(Math.min(max, Math.max(min, jScrollBar.getValue() + delta * step)));
    }

    public void changeScale(Point mousePos, int delta) {
        JViewport jViewport = this.getJScrollPane().getViewport();
        Point viewPosA = jViewport.getViewPosition();
        Point2D.Double realPos = this.scaleViewToModel(mousePos);
        this.setScale(delta < 0 ? this.scale + this.scaleStep : this.scale - this.scaleStep);
        Point viewPosB = this.scaleModelToView(realPos);
        viewPosB.translate(-mousePos.x + viewPosA.x, -mousePos.y + viewPosA.y);
        if (viewPosB.x < 0) {
            viewPosB.x = 0;
        }
        if (viewPosB.y < 0) {
            viewPosB.y = 0;
        }
        jViewport.setViewPosition(viewPosB);
    }

    public Zone getSelectedZone() {
        return this.selectedZone;
    }

    public void selectLastZone() {
        if (this.zones.size() < 0) {
            return;
        }
        this.selectZone(this.zones.get(this.zones.size() - 1));
    }

    public void selectZone(Zone zone) {
        if (this.selectedZone == zone) {
            return;
        }
        this.selectZoneQuiet(zone);
        this.stateNotifier.broadcastDisplay(BroadcastSelectedChange, this, zone);
    }

    public Zone findPair(Zone pair) {
        if (pair == null) {
            return null;
        }
        for (Zone zone : this.zones) {
            if (zone.pair != pair) continue;
            return zone;
        }
        return null;
    }

    public void selectZoneQuiet(Zone zone) {
        this.selectedZone = zone;
        if (this.selectedZone != null) {
            this.jZoneHandler.updateRectangle(this.selectedZone.rectangle);
        }
        this.jZoneHandler.setVisible(this.selectedZone != null);
    }

    public class JZoneHandler {
        private boolean cornerSelection;
        private double[] x = new double[4];
        private double[] y = new double[4];
        private JLabel[] handlers = new JLabel[4];
        private double oposedX;
        private double oposedY;

        public JZoneHandler(final boolean cornerSelection) {
            this.cornerSelection = cornerSelection;
            for (int i = 0; i < 4; ++i) {
                JLabel handler = new JLabel(handlerImage);
                final int index = i;
                this.handlers[i] = handler;
                handler.setSize(8, 8);
                MouseAdapter mouseAdapter = new MouseAdapter(){
                    Point mousePosOnHandler;

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (SwingUtilities.isRightMouseButton(e)) {
                            JZones.this.selectZone(null);
                            return;
                        }
                        JZoneHandler.this.oposedX = JZoneHandler.this.x[(index + 2) % 4];
                        JZoneHandler.this.oposedY = JZoneHandler.this.y[(index + 2) % 4];
                        this.mousePosOnHandler = e.getPoint();
                    }

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        Point deltaMousePos = e.getPoint();
                        deltaMousePos.x -= this.mousePosOnHandler.x;
                        deltaMousePos.y -= this.mousePosOnHandler.y;
                        Point2D.Double deltaInPage = JZones.this.scaleViewToModel(deltaMousePos);
                        double newX = Math.max(0.0, Math.min(((JZones)JZones.this).realSize.width, JZoneHandler.this.x[index] + deltaInPage.x));
                        double newY = Math.max(0.0, Math.min(((JZones)JZones.this).realSize.height, JZoneHandler.this.y[index] + deltaInPage.y));
                        if (cornerSelection) {
                            double cx = (JZoneHandler.this.oposedX + newX) / 2.0;
                            double cy = (JZoneHandler.this.oposedY + newY) / 2.0;
                            double width = Math.abs(JZoneHandler.this.oposedX - newX);
                            double height = Math.abs(JZoneHandler.this.oposedY - newY);
                            JZones.this.selectedZone.setBounds(cx - width / 2.0, cy - height / 2.0, width, height);
                            return;
                        }
                        Rectangle2D.Double rectangle = JZones.this.selectedZone.rectangle;
                        double rate = rectangle.width / rectangle.height;
                        if (index % 2 == 0) {
                            double height = Math.max(JZones.this.minSide, index == 0 ? JZoneHandler.this.oposedY - newY : newY - JZoneHandler.this.oposedY);
                            double width = Math.max(JZones.this.minSide, Math.min(rate * height, Math.min(JZoneHandler.this.x[0], ((JZones)JZones.this).realSize.width - JZoneHandler.this.x[0]) * 2.0));
                            height = width / rate;
                            JZones.this.selectedZone.setBounds(JZoneHandler.this.x[0] - width / 2.0, index == 0 ? JZoneHandler.this.y[2] - height : JZoneHandler.this.y[0], width, height);
                        } else {
                            double width = Math.max(JZones.this.minSide, index == 3 ? JZoneHandler.this.oposedX - newX : newX - JZoneHandler.this.oposedX);
                            double height = Math.max(JZones.this.minSide, Math.min(width / rate, Math.min(JZoneHandler.this.y[1], ((JZones)JZones.this).realSize.height - JZoneHandler.this.y[1]) * 2.0));
                            width = rate * height;
                            JZones.this.selectedZone.setBounds(index == 3 ? JZoneHandler.this.x[1] - width : JZoneHandler.this.x[3], JZoneHandler.this.y[1] - height / 2.0, width, height);
                        }
                    }
                };
                handler.addMouseListener(mouseAdapter);
                handler.addMouseMotionListener(mouseAdapter);
                JZones.this.add(handler);
                JZones.this.setLayer(handler, 10 + i);
                handler.setVisible(false);
            }
        }

        public void updateRectangle(Rectangle2D.Double rectangle) {
            if (this.cornerSelection) {
                this.x[0] = this.x[3] = rectangle.x;
                this.y[0] = this.y[1] = rectangle.y;
                this.x[1] = this.x[2] = rectangle.x + rectangle.width;
                this.y[2] = this.y[3] = rectangle.y + rectangle.height;
            } else {
                this.x[3] = rectangle.x;
                this.x[0] = this.x[2] = rectangle.x + rectangle.width / 2.0;
                this.x[1] = rectangle.x + rectangle.width;
                this.y[0] = rectangle.y;
                this.y[1] = this.y[3] = rectangle.y + rectangle.height / 2.0;
                this.y[2] = rectangle.y + rectangle.height;
            }
            for (int i = 0; i < 4; ++i) {
                this.handlers[i].setLocation((int)(this.x[i] * JZones.this.scale - 4.0), (int)(this.y[i] * JZones.this.scale - 4.0));
            }
        }

        public void setVisible(boolean visible) {
            for (int i = 0; i < 4; ++i) {
                this.handlers[i].setVisible(visible);
            }
        }
    }

    public class Zone {
        private Rectangle2D.Double rectangle;
        private Color color;
        private int rotation;
        private Zone pair;
        private BufferedImage image;
        Rectangle2D.Double imageRectangle;

        public Zone(Rectangle2D.Double rectangle, Color color, BufferedImage image) {
            this.rectangle = new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.color = color;
            this.setImage(image);
        }

        public Zone(Rectangle2D.Double rectangle, Zone pair, BufferedImage image) {
            this.rectangle = new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.color = pair.color;
            this.pair = pair;
            this.setImage(image);
        }

        public boolean hasPair() {
            return this.pair != null;
        }

        public Zone getPair() {
            return this.pair;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public DimensionDouble getRealSize() {
            return JZones.this.realSize;
        }

        public Rectangle2D.Double getRectangle() {
            return this.rectangle;
        }

        public int getRotation() {
            return this.rotation;
        }

        public void turnLeft() {
            this.setRotation(this.rotation + 1);
        }

        public void turnRight() {
            this.setRotation(this.rotation - 1);
        }

        public void setImage(BufferedImage image) {
            this.image = image;
            this.imageRectangle = null;
            if (image == null) {
                return;
            }
            this.imageRectangle = new Rectangle2D.Double(0.0, 0.0, image.getWidth(), image.getHeight());
            JZones.this.repaint();
        }

        public void drawImage(Graphics2D g2) {
            if (this.image == null) {
                return;
            }
            g2.drawImage(this.image, new AffineTransform(), null);
        }

        public double getScale() {
            return this.rotation % 2 == 1 ? this.rectangle.width / this.pair.rectangle.height : this.rectangle.width / this.pair.rectangle.width;
        }

        private void setRotation(int rotation) {
            rotation += 4;
            if (this.rotation == (rotation %= 4)) {
                return;
            }
            if ((this.rotation + rotation) % 2 == 1) {
                double tmp = this.rectangle.width;
                this.rectangle.width = this.rectangle.height;
                this.rectangle.height = tmp;
                this.fitLandscape();
            } else if (JZones.this.selectedZone == this) {
                JZones.this.jZoneHandler.updateRectangle(this.rectangle);
            }
            this.rotation = rotation;
            JZones.this.repaint();
        }

        public void updatePairRate() {
            if (this.pair == null) {
                return;
            }
            double rate = this.pair.rectangle.width / this.pair.rectangle.height;
            if (this.rotation % 2 == 1) {
                rate = 1.0 / rate;
            }
            this.setRate(rate);
        }

        private void setRate(double rate) {
            double width = this.rectangle.width;
            double height = this.rectangle.height;
            double prevRate = width / height;
            if (prevRate == rate) {
                return;
            }
            double maxWidth = ((JZones)JZones.this).realSize.width - this.rectangle.x;
            double maxHeight = ((JZones)JZones.this).realSize.height - this.rectangle.y;
            if (prevRate > 1.0) {
                height = width / rate;
                if (height > maxHeight) {
                    height = maxHeight;
                    width = rate * height;
                }
            } else {
                width = rate * height;
                if (width > maxWidth) {
                    width = maxWidth;
                    height = width / rate;
                }
            }
            this.setBounds(this.rectangle.x, this.rectangle.y, width, height);
        }

        public void setLocation(double x, double y) {
            x = Math.max(0.0, Math.min(((JZones)JZones.this).realSize.width - this.rectangle.width, x));
            y = Math.max(0.0, Math.min(((JZones)JZones.this).realSize.height - this.rectangle.height, y));
            this.rectangle.x = x;
            this.rectangle.y = y;
            if (JZones.this.selectedZone == this) {
                JZones.this.jZoneHandler.updateRectangle(this.rectangle);
            }
            JZones.this.repaint();
            JZones.this.stateNotifier.broadcastUpdate(JZones.BroadcastSelectedLocationChange);
        }

        public void setBounds(double x, double y, double width, double height) {
            this.rectangle.width = Math.max(JZones.this.minSide, Math.min(((JZones)JZones.this).realSize.width, width));
            this.rectangle.height = Math.max(JZones.this.minSide, Math.min(((JZones)JZones.this).realSize.height, height));
            this.setLocation(x, y);
            JZones.this.stateNotifier.broadcastUpdate(JZones.BroadcastSelectedRateChange);
        }

        public void fitLandscape() {
            double rate = this.rectangle.width / this.rectangle.height;
            if (this.rectangle.width > ((JZones)JZones.this).realSize.width) {
                this.rectangle.width = ((JZones)JZones.this).realSize.width;
                this.rectangle.height = this.rectangle.width / rate;
            }
            if (this.rectangle.height > ((JZones)JZones.this).realSize.height) {
                this.rectangle.height = ((JZones)JZones.this).realSize.height;
                this.rectangle.width = rate * this.rectangle.height;
            }
            this.rectangle.x = Math.min(this.rectangle.x, ((JZones)JZones.this).realSize.width - this.rectangle.width);
            this.rectangle.y = Math.min(this.rectangle.y, ((JZones)JZones.this).realSize.height - this.rectangle.height);
            if (JZones.this.selectedZone == this) {
                JZones.this.jZoneHandler.updateRectangle(this.rectangle);
            }
        }

        public void projection(Graphics2D g2) {
            Rectangle2D.Double refRectangle = this.pair == null ? this.imageRectangle : this.pair.rectangle;
            double copyScale = this.rotation % 2 == 1 ? this.rectangle.width / refRectangle.height : this.rectangle.width / refRectangle.width;
            double theta = Math.PI * (double)this.rotation / 2.0;
            double halfWidth = refRectangle.width / 2.0;
            double halfHeight = refRectangle.height / 2.0;
            g2.clip(this.rectangle);
            g2.translate(this.rectangle.x, this.rectangle.y);
            g2.scale(copyScale, copyScale);
            if (this.rotation % 2 == 1) {
                g2.translate(halfHeight, halfWidth);
            } else {
                g2.translate(halfWidth, halfHeight);
            }
            g2.rotate(-theta);
            g2.translate(-halfWidth, -halfHeight);
            g2.translate(-refRectangle.x, -refRectangle.y);
        }
    }

    public class SizeSlider
    extends JSlider
    implements ChangeListener {
        public SizeSlider() {
            super(0, 200, 100);
            this.setMajorTickSpacing(50);
            this.setMinorTickSpacing(10);
            this.setPaintTicks(true);
            this.setSnapToTicks(true);
            this.addChangeListener(this);
            JZones.this.stateNotifier.addUpdateObserver(this, JZones.BroadcastChangeScale);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JZones.this.setCenterScale(Math.pow(10.0, (double)this.getValue() / 100.0 - 1.0) * JZones.this.initScale);
        }

        public void updateChangeScale() {
            this.removeChangeListener(this);
            this.setValue((int)(100.0 * (Math.log10(JZones.this.scale / JZones.this.initScale) + 1.0)));
            this.addChangeListener(this);
        }
    }
}

