/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view;

import adecWatt.model.unit.Workspace;
import adecWatt.view.JPatch;
import adecWatt.view.JPreviewImp;
import adecWatt.view.JZones;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import misc.Bundle;
import misc.DimensionDouble;
import misc.Log;
import misc.OwnFrame;

public class PrintWorkspace
implements Printable {
    public static final int formatScale = 20;
    public static final int labelSpace = 4;
    private Workspace workspace;
    private Image printPage;
    private BufferedImage workspaceImage;
    private BufferedImage workspaceImageNoCircuit;
    private BufferedImage posterImage;
    private BufferedImage patchImage;
    private JPanel patchJPanel;
    private OwnFrame controller;
    ArrayList<JPreviewImp> jPreviewImpPtr;
    boolean canceled;

    public static void print(OwnFrame controller, PrinterJob printer, Workspace workspace) {
        ArrayList<JPreviewImp> jPreviewImpPtr = new ArrayList<JPreviewImp>();
        try {
            PrintWorkspace printWorkspace = new PrintWorkspace(workspace);
            printWorkspace.resetPrint(controller, jPreviewImpPtr);
            printer.setPrintable(printWorkspace);
            printer.print();
            if (printWorkspace.canceled) {
                printer.cancel();
                return;
            }
            return;
        }
        catch (Throwable t) {
            Log.keepLastException("Printworkspace::print", t);
            return;
        }
    }

    public PrintWorkspace(Workspace workspace) {
        this.workspace = workspace;
        this.workspaceImage = PrintWorkspace.getIcon(workspace, 800, true);
        this.workspaceImageNoCircuit = PrintWorkspace.getIcon(workspace, 800, false);
        try {
            this.posterImage = workspace.getIconImage((String)"poster").reference;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.patchJPanel = new JPatch(workspace.getPatch());
            JFrame jFrame = new JFrame();
            jFrame.setVisible(false);
            jFrame.getContentPane().add((Component)this.patchJPanel, "Center");
            jFrame.pack();
            this.patchImage = new BufferedImage(this.patchJPanel.getWidth(), this.patchJPanel.getHeight(), 2);
            this.patchJPanel.paint(this.patchImage.getGraphics());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetPrint(OwnFrame controller, ArrayList<JPreviewImp> jPreviewImpPtr) {
        this.controller = controller;
        this.jPreviewImpPtr = jPreviewImpPtr;
    }

    @Override
    public synchronized int print(Graphics g1, PageFormat pf, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        if (this.jPreviewImpPtr.size() < 1) {
            JPreviewImp jPreviewImp = new JPreviewImp(this.workspace.getRealSize(), new DimensionDouble(pf.getImageableWidth(), pf.getImageableHeight()), this.workspaceImage, this.workspaceImageNoCircuit, this.posterImage, this.patchImage, 400);
            this.jPreviewImpPtr.add(jPreviewImp);
            if (JOptionPane.showConfirmDialog(this.controller.getJFrame(), jPreviewImp, Bundle.getTitle("Layout"), 0) != 0) {
                this.canceled = true;
                return 1;
            }
        }
        Graphics2D printGraphics = (Graphics2D)g1;
        printGraphics.translate((int)pf.getImageableX() + 1, (int)pf.getImageableY());
        this.print(printGraphics, 1.0, this.jPreviewImpPtr.get(0));
        return 0;
    }

    public void print(Graphics2D printGraphics, double lineWidth, JPreviewImp jPreviewImp) {
        if (jPreviewImp.preview.zones.size() < 1) {
            DimensionDouble printSize = jPreviewImp.preview.getRealSize();
            DimensionDouble realSize = jPreviewImp.workspace.getRealSize();
            double scale = Math.min(printSize.width / realSize.width, printSize.height / realSize.height);
            printGraphics.scale(scale, scale);
            this.workspace.print(printGraphics, lineWidth * scale, null, true);
            return;
        }
        AffineTransform iat = printGraphics.getTransform();
        Shape clip = printGraphics.getClip();
        for (JZones.Zone zone : jPreviewImp.preview.zones) {
            printGraphics.setTransform(iat);
            printGraphics.setClip(clip);
            zone.projection(printGraphics);
            if (zone.hasPair()) {
                this.workspace.print(printGraphics, lineWidth * zone.getScale(), null, !jPreviewImp.noPrintCircuit.contains(zone));
                continue;
            }
            if (zone.getImage() == this.patchImage) {
                this.patchJPanel.paint(printGraphics);
                continue;
            }
            zone.drawImage(printGraphics);
        }
    }

    public static BufferedImage getIcon(Workspace workspace, int maxSide, boolean printCircuit) {
        DimensionDouble realSize = workspace.getRealSize();
        double rate = realSize.width / realSize.height;
        int width = maxSide;
        int height = maxSide;
        if (rate > 1.0) {
            height = (int)((double)width / rate);
        } else {
            width = (int)(rate * (double)height);
        }
        BufferedImage result = new BufferedImage(width, height, 2);
        Graphics2D printGraphics = (Graphics2D)result.getGraphics();
        printGraphics.setColor(Color.WHITE);
        printGraphics.fillRect(0, 0, width, height);
        double printScale = Math.min((double)width / realSize.width, (double)height / realSize.height);
        printGraphics.scale(printScale, printScale);
        workspace.print(printGraphics, printScale, null, printCircuit);
        return result;
    }
}

