/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view.jProp;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;

public class JAutoComboBox
extends JComboBox<String> {
    private JTextComponent editor;
    private final Filter filter;

    public JTextComponent getEditorComponent() {
        return this.editor;
    }

    public JAutoComboBox(Filter filter) {
        this.filter = filter;
        this.setEditable(true);
        this.editor = (JTextComponent)this.getEditor().getEditorComponent();
        this.updateFilter();
        this.editor.setFocusable(true);
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent key) {
                switch (key.getKeyCode()) {
                    case 10: {
                        JAutoComboBox.this.hidePopup();
                        return;
                    }
                }
                if (key.getKeyChar() == '\uffff') {
                    return;
                }
                JAutoComboBox.this.updateFilter();
            }
        });
    }

    private boolean needUpdate(Vector<String> founds) {
        int nbItems = this.getItemCount();
        if (founds == null) {
            return nbItems != 0;
        }
        if (nbItems != founds.size()) {
            return true;
        }
        int i = 0;
        for (String val : founds) {
            if (val.equals(this.getItemAt(i))) continue;
            return true;
        }
        return false;
    }

    public void updateFilter() {
        String text = this.editor.getText();
        Vector<String> founds = this.filter.match(text);
        if (this.needUpdate(founds)) {
            if (founds == null) {
                this.removeAllItems();
            } else {
                this.setModel(new DefaultComboBoxModel<String>(founds));
            }
        }
        this.setSelectedIndex(-1);
        this.editor.setText(text);
        try {
            if (founds != null && founds.size() > 0) {
                this.showPopup();
            } else {
                this.hidePopup();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface Filter {
        public Vector<String> match(String var1);
    }
}

