/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view.jProp;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class JFilePreview
extends JComponent {
    public static int maxInSide = 100;
    public static int border = 5;
    public static int maxOutSide = maxInSide + 2 * border;
    public static Dimension previewDim = new Dimension(maxOutSide, maxOutSide);
    protected ImageIcon thumbnail = null;
    protected long maxSize;

    public JFilePreview(long maxSize) {
        this.maxSize = maxSize;
        this.setPreferredSize(previewDim);
    }

    public void setFile(File file, boolean horizontalSpin) {
        this.thumbnail = JFilePreview.getIcon(file, maxInSide, this.maxSize);
        if (this.thumbnail != null && horizontalSpin) {
            int width = this.thumbnail.getIconWidth();
            int height = this.thumbnail.getIconHeight();
            AffineTransform at = AffineTransform.getScaleInstance(horizontalSpin ? -1.0 : 1.0, 1.0);
            at.translate(horizontalSpin ? (double)(-width) : 0.0, 0.0);
            BufferedImage image = new BufferedImage(width, height, 2);
            image.createGraphics().drawImage(this.thumbnail.getImage(), at, null);
            this.thumbnail = new ImageIcon(image);
        }
        this.repaint();
    }

    public static ImageIcon getIcon(File file, int thumbSide, long maxSize) {
        if (file == null || maxSize > 0L && file.length() > maxSize) {
            return null;
        }
        ImageIcon tmpIcon = new ImageIcon(file.getPath());
        if (tmpIcon == null) {
            return null;
        }
        if (tmpIcon.getIconWidth() > tmpIcon.getIconHeight()) {
            if (tmpIcon.getIconWidth() > thumbSide) {
                tmpIcon = new ImageIcon(tmpIcon.getImage().getScaledInstance(thumbSide, -1, 1));
            }
        } else if (tmpIcon.getIconHeight() > thumbSide) {
            tmpIcon = new ImageIcon(tmpIcon.getImage().getScaledInstance(-1, thumbSide, 1));
        }
        return tmpIcon;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.thumbnail == null) {
            return;
        }
        int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
        int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
        this.thumbnail.paintIcon(this, g, x, y);
    }
}

