/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view.jProp;

import adecWatt.model.ImageDB;
import adecWatt.model.PreviewCache;
import adecWatt.view.JProp;
import adecWatt.view.JStringSet;
import adecWatt.view.jProp.JFilePreview;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import misc.Bundle;
import misc.Config;
import misc.ImagePreview;
import misc.Util;

public class JImagePopup
extends JPopupMenu
implements ActionListener {
    public static final String actionTag = "Tag";
    public static final String actionAdd = "Add";
    public static final String actionUpdate = "Update";
    public static final String actionRemove = "Remove";
    public static final String actionValidate = "Validate";
    public static final String actionHorizontalSpin = "HorizontalSpin";
    public static final String actionFilter = "Filter";
    public static final String actionNoFilter = "NoFilter";
    public static final Vector<String> emptyTag = new Vector();
    public static final List<String> popupActionsNames = Arrays.asList("RemoveImage", "ChangeImage", "Unchange");
    public static final List<String> iconActionsNames = Arrays.asList("Tag", "Add", "Update", "Remove", "Validate");
    public static final Hashtable<String, Method> actionsMethod = Util.collectMethod(JImagePopup.class, popupActionsNames, iconActionsNames);
    public static int thumbSide = 40;
    public static Dimension thumbDim = new Dimension(thumbSide, thumbSide);
    public static final int MAX_FILE_PREVIEW = 0x100000;
    public static final int MAX_COL = 10;
    public static final int MAX_VISIBLE_LINE = 5;
    public static final int horizontalThickness = 2;
    public static final int verticalThickness = 4;
    public static final int selectedThickness = 1;
    public static Color selectionForeground = new Color(99, 130, 191);
    public static Color selectionBackground = new Color(184, 207, 229);
    public static Color standardBackground = new Color(238, 238, 238);
    public static final Border emptyBorder = BorderFactory.createEmptyBorder(2, 4, 2, 4);
    public static final Border selectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(selectionForeground, 1), BorderFactory.createEmptyBorder(1, 3, 1, 3));
    public static final Dimension DIM_AREA = new Dimension(12 + 10 * (thumbSide + 2), 14 + 5 * (thumbSide + 4));
    ImageDB imageDB;
    boolean horizontalSpin;
    int nbImages;
    Vector<HighlightFile> nameList;
    JFilePreview preview = new JFilePreview(0x100000L);
    JLabel previewId = new JLabel(" ", 0);
    JList<String> previewTags = new JList<String>(emptyTag);
    JPanel selectionPanel;
    JViewport filesViewPort;
    JPanel filesPanel;
    JProp jProp;
    JLabel refLabel;
    JTextField filterTF = new JTextField("", 16);
    JTextField noFilterTF = new JTextField("", 16);
    Vector<ImageDB.NameLocal> namesLocals;
    Font localFont;
    Font normalFont;
    JProgressBar progressBar;
    int cursorIndex = -1;
    int minSelection;
    int maxSelection;
    int nbSelection;
    int beginSelection;
    int lastSelection;
    public static JFileChooser jFileChooser = new JFileChooser(Config.getString("ImageDirName", ""));

    @Override
    public void actionPerformed(ActionEvent e) {
        Util.actionPerformed(actionsMethod, e, this);
    }

    public JImagePopup(JLabel jLabel, Point pos, final JProp jProp, ImageDB imageDB) {
        this.imageDB = imageDB;
        this.jProp = jProp;
        this.refLabel = jLabel;
        Util.addMenuItem(popupActionsNames, (ActionListener)this, (Container)this);
        this.show(jLabel, pos.x, pos.y);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                JImagePopup.this.doFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }
        };
        this.filterTF.getDocument().addDocumentListener(documentListener);
        this.noFilterTF.getDocument().addDocumentListener(documentListener);
        new Thread(){

            @Override
            public void run() {
                JImagePopup.this.updateNamesLocals();
                JImagePopup.this.doFilter();
                if (JImagePopup.this.nbSelection > 0) {
                    return;
                }
                try {
                    JImagePopup.this.setSelection(jProp.getLastValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JImagePopup.this.updatePreview();
            }
        }.start();
        this.previewTags.setForeground(Color.GRAY);
        this.previewTags.setBackground(this.getBackground());
        this.previewId.setForeground(Color.GRAY);
        this.normalFont = this.getFont();
        this.localFont = this.normalFont.deriveFont(2, this.normalFont.getSize());
        this.selectionPanel = Util.getGridBagPanel();
        this.horizontalSpin = jProp.getHorizontalSpin();
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        JPanel cmdLine = new JPanel();
        Util.addIconButton(iconActionsNames, (ActionListener)this, (Container)cmdLine);
        cmdLine.add(Util.newCheckIcon(actionHorizontalSpin, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JImagePopup.this.horizontalSpin = ((JCheckBox)e.getSource()).isSelected();
                JImagePopup.this.updatePreview();
            }
        }, this.horizontalSpin));
        Util.addIconButton(actionFilter, null, (Container)cmdLine);
        cmdLine.add(this.filterTF);
        Util.addIconButton(actionNoFilter, null, (Container)cmdLine);
        cmdLine.add(this.noFilterTF);
        Util.unBoxButton(cmdLine);
        this.filesPanel = new JPanel(null);
        JPanel filesPanel2 = new JPanel();
        filesPanel2.add(this.filesPanel);
        JScrollPane filesScrollPane = Util.getJScrollPane(filesPanel2);
        filesPanel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                JImagePopup.this.selectionPanel.requestFocusInWindow();
                JImagePopup.this.clearSelection();
                JImagePopup.this.updatePreview();
            }
        });
        filesScrollPane.setPreferredSize(DIM_AREA);
        this.filesViewPort = filesScrollPane.getViewport();
        JScrollPane tagsScrollPane = Util.getJScrollPane(this.previewTags);
        tagsScrollPane.setPreferredSize(JFilePreview.previewDim);
        JPanel side = new JPanel(new BorderLayout());
        side.add((Component)this.previewId, "North");
        side.add((Component)this.preview, "Center");
        side.add((Component)tagsScrollPane, "South");
        Util.addComponent(filesScrollPane, this.selectionPanel, Util.GBC);
        Util.addComponent(side, this.selectionPanel, Util.GBCNL);
        Util.addComponent(this.progressBar, this.selectionPanel, Util.GBCNL);
        Util.addComponent(cmdLine, this.selectionPanel, Util.GBCNL);
        this.selectionPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 65: {
                        if (e.isControlDown()) {
                            JImagePopup.this.selectRange(0, JImagePopup.this.nbImages - 1);
                            JImagePopup.this.setCursorIndex(JImagePopup.this.lastSelection);
                        }
                        return;
                    }
                    case 36: {
                        JImagePopup.this.setCursorIndex(0);
                        return;
                    }
                    case 35: {
                        JImagePopup.this.setCursorIndex(JImagePopup.this.nbImages - 1);
                        return;
                    }
                }
                if (JImagePopup.this.cursorIndex < 0 || JImagePopup.this.cursorIndex > JImagePopup.this.nbImages - 1) {
                    return;
                }
                int nextCursorIndex = JImagePopup.this.cursorIndex;
                switch (e.getKeyCode()) {
                    case 32: {
                        if (e.isControlDown()) {
                            JImagePopup.this.nameList.get(JImagePopup.this.cursorIndex).toggleSelection();
                        } else {
                            JImagePopup.this.setSelection(JImagePopup.this.cursorIndex, true);
                        }
                        return;
                    }
                    case 38: 
                    case 224: {
                        nextCursorIndex -= 10;
                        break;
                    }
                    case 40: 
                    case 225: {
                        nextCursorIndex += 10;
                        break;
                    }
                    case 37: 
                    case 226: {
                        --nextCursorIndex;
                        break;
                    }
                    case 39: 
                    case 227: {
                        ++nextCursorIndex;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (nextCursorIndex == JImagePopup.this.cursorIndex || nextCursorIndex < 0 || nextCursorIndex > JImagePopup.this.nbImages - 1) {
                    return;
                }
                JImagePopup.this.setCursorIndex(nextCursorIndex);
                if (e.isShiftDown()) {
                    JImagePopup.this.selectRange(JImagePopup.this.beginSelection, nextCursorIndex);
                } else {
                    JImagePopup.this.beginSelection = JImagePopup.this.lastSelection = nextCursorIndex;
                }
            }
        });
    }

    public void chooseIconImage(JLabel attach) {
        this.updatePreview();
        if (JOptionPane.showConfirmDialog(attach, this.selectionPanel, Bundle.getTitle("SelectImage"), 0) != 0 || this.nbSelection < 1) {
            return;
        }
        this.jProp.setSpin(this.horizontalSpin);
        this.jProp.setVal(Util.getBase(this.nameList.get((int)this.minSelection).nameLocal.fileName));
    }

    private String splitFilter(String pattern, TreeSet<String> set) {
        String part = null;
        for (String word : pattern.toLowerCase().split("\\s")) {
            if (part != null) {
                set.add(part);
                part = null;
            }
            if (word.isEmpty()) continue;
            part = word;
        }
        return part;
    }

    public synchronized void doFilter() {
        TreeSet<String> setToKeep = new TreeSet<String>();
        String partToKeep = this.splitFilter(this.filterTF.getText(), setToKeep);
        boolean noTag = this.filterTF.getText().length() > 0 && partToKeep == null && setToKeep.size() < 1;
        TreeSet<String> setToForget = new TreeSet<String>();
        String partToForget = this.splitFilter(this.noFilterTF.getText(), setToForget);
        Vector<ImageDB.NameLocal> result = new Vector<ImageDB.NameLocal>(this.namesLocals.size());
        for (ImageDB.NameLocal namesLocal : this.namesLocals) {
            Collection<String> tags = this.imageDB.getTags(namesLocal.fileName);
            if (noTag && tags != null || partToKeep != null && !Util.containsPart(partToKeep, tags) || setToKeep.size() > 0 && !Util.containsOne(setToKeep, tags) || partToForget != null && Util.containsPart(partToForget, tags) || setToForget.size() > 0 && Util.containsOne(setToForget, tags)) continue;
            result.add(namesLocal);
        }
        this.setFilesPanel(result);
    }

    public void setFilesPanel(Vector<ImageDB.NameLocal> namesLocals) {
        this.filesViewPort.invalidate();
        this.nbSelection = 0;
        this.lastSelection = 0;
        this.beginSelection = 0;
        this.cursorIndex = -1;
        this.nbImages = namesLocals.size();
        this.nameList = new Vector(this.nbImages);
        for (ImageDB.NameLocal nameLocal : namesLocals) {
            this.nameList.add(new HighlightFile(nameLocal));
        }
        this.filesPanel.removeAll();
        GridLayout gridLayout = new GridLayout(0, 10);
        this.filesPanel.setLayout(gridLayout);
        int i = 0;
        while (i < this.nbImages) {
            HighlightFile highlightFile = this.nameList.get(i);
            highlightFile.index = i++;
            this.filesPanel.add(highlightFile);
        }
        this.selectionPanel.setFocusable(true);
        this.filesViewPort.setViewPosition(new Point(0, 0));
        this.filesViewPort.repaint();
        this.filesViewPort.validate();
    }

    public void clearSelection() {
        this.setCursorIndex(-1);
        if (this.nbSelection > 0) {
            for (int i = this.minSelection; i <= this.maxSelection; ++i) {
                this.nameList.get(i).setSelection(false);
            }
        }
        this.lastSelection = 0;
        this.beginSelection = 0;
        this.maxSelection = 0;
        this.minSelection = 0;
        this.nbSelection = 0;
    }

    public void setCursorIndex(int newVal) {
        if (this.cursorIndex == newVal) {
            return;
        }
        if (this.cursorIndex >= 0) {
            this.nameList.get(this.cursorIndex).borderSelection(false);
        }
        this.cursorIndex = newVal;
        if (this.cursorIndex < 0) {
            return;
        }
        HighlightFile hf = this.nameList.get(this.cursorIndex);
        hf.borderSelection(true);
        hf.checkVisible();
    }

    public synchronized void setSelection(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        name = Util.getBase(name);
        for (int i = 0; i < this.nbImages; ++i) {
            if (!name.equals(Util.getBase(this.nameList.get((int)i).nameLocal.fileName))) continue;
            this.setSelection(i, true);
            return;
        }
    }

    public void setSelection(int index, boolean clearSelection) {
        if (clearSelection) {
            this.clearSelection();
        }
        this.setCursorIndex(index);
        if (index < 0 || index >= this.nbImages) {
            return;
        }
        this.addSelection(index);
        this.beginSelection = this.lastSelection = index;
    }

    public void selectRange(int start, int stop) {
        HighlightFile name;
        int i;
        int minRange = Integer.min(start, stop);
        int maxRange = Integer.max(start, stop);
        int minOldRange = Integer.min(this.beginSelection, this.lastSelection);
        int maxOldRange = Integer.max(this.beginSelection, this.lastSelection);
        this.beginSelection = start;
        this.lastSelection = stop;
        if (this.nbSelection > 0) {
            for (i = minOldRange; i <= maxOldRange; ++i) {
                name = this.nameList.get(i);
                if (name == null || !name.isSelected) continue;
                name.setSelection(false);
                --this.nbSelection;
            }
        }
        for (i = minRange; i <= maxRange; ++i) {
            name = this.nameList.get(i);
            if (name == null || name.isSelected) continue;
            this.nameList.get(i).setSelection(true);
            ++this.nbSelection;
        }
        if (this.nbSelection > 0) {
            this.minSelection = Math.min(this.minSelection, minRange);
            this.maxSelection = Math.max(this.maxSelection, maxRange);
        }
        this.updateMinMax();
        this.updatePreview();
    }

    public void addSelection(int index) {
        HighlightFile name = this.nameList.get(index);
        if (name == null) {
            return;
        }
        name.setSelection(true);
        name.checkVisible();
        if (this.nbSelection > 0) {
            this.minSelection = Math.min(this.minSelection, index);
            this.maxSelection = Math.max(this.maxSelection, index);
        } else {
            this.minSelection = this.maxSelection = index;
        }
        ++this.nbSelection;
        this.updatePreview();
    }

    public void removeSelection(int index) {
        HighlightFile name = this.nameList.get(index);
        if (name == null) {
            return;
        }
        name.setSelection(false);
        --this.nbSelection;
        this.updateMinMax();
        this.updatePreview();
    }

    public void updateMinMax() {
        int i;
        if (this.nbSelection < 1) {
            return;
        }
        for (i = this.minSelection; i <= this.maxSelection; ++i) {
            if (!this.nameList.get((int)i).isSelected) continue;
            this.minSelection = i;
            break;
        }
        for (i = this.maxSelection; i >= this.minSelection; --i) {
            if (!this.nameList.get((int)i).isSelected) continue;
            this.maxSelection = i;
            break;
        }
        if (this.cursorIndex < this.minSelection) {
            this.nameList.get(this.minSelection).checkVisible();
        }
        if (this.cursorIndex > this.maxSelection) {
            this.nameList.get(this.maxSelection).checkVisible();
        }
    }

    public void updatePreview() {
        if (this.nbSelection < 1) {
            this.preview.setFile(null, false);
            this.previewId.setText("");
            this.previewTags.setListData(emptyTag);
            Util.packWindow(this.previewTags);
            return;
        }
        this.nameList.get(this.minSelection).preview();
    }

    public void updateNamesLocals() {
        this.namesLocals = this.imageDB.listImage();
        this.progressBar.setStringPainted(true);
        this.progressBar.setMaximum(this.namesLocals.size());
        this.progressBar.setValue(0);
        int done = 0;
        PreviewCache previewCache = this.imageDB.previewCache;
        previewCache.prepareClean();
        for (ImageDB.NameLocal nameLocal : this.namesLocals) {
            nameLocal.icon = previewCache.getIcon(this.imageDB.getFile(nameLocal.fileName, nameLocal.isLocal));
            this.progressBar.setValue(++done);
        }
        previewCache.clean();
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(false);
    }

    public void actionRemoveImage() {
        this.jProp.removeVal();
    }

    public void actionChangeImage() {
        this.chooseIconImage(this.refLabel);
    }

    public void actionUnchange() {
        this.jProp.unchangeVal();
    }

    public void actionTag() {
        try {
            if (this.nbSelection < 1) {
                return;
            }
            String imageName = Util.getBase(this.nameList.get((int)this.minSelection).nameLocal.fileName);
            JStringSet jStringSet = new JStringSet(this.imageDB.getTags(imageName));
            jStringSet.init();
            if (JOptionPane.showConfirmDialog(this.refLabel, jStringSet, null, 0) != 0) {
                return;
            }
            jStringSet.confirm();
            this.imageDB.putTags(imageName, jStringSet.getSet());
            this.doFilter();
            this.setSelection(imageName);
        }
        finally {
            this.selectionPanel.requestFocusInWindow();
        }
    }

    public boolean chooseFile() {
        jFileChooser.setFileFilter(new FileNameExtensionFilter(Bundle.getLabel("ImageFilter"), PreviewCache.imageExtentions));
        jFileChooser.setAccessory(new ImagePreview(jFileChooser, 0x100000L));
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showOpenDialog(this.selectionPanel) != 0) {
            return false;
        }
        Config.setFile("ImageDirName", jFileChooser.getSelectedFile().getParentFile());
        return true;
    }

    public void actionAdd() {
        jFileChooser.setMultiSelectionEnabled(true);
        if (!this.chooseFile()) {
            return;
        }
        String last = null;
        for (File file : jFileChooser.getSelectedFiles()) {
            last = this.imageDB.addImage(file);
        }
        this.updateNamesLocals();
        this.doFilter();
        this.setSelection(last);
    }

    public void actionUpdate() {
        if (this.nbSelection != 1) {
            return;
        }
        jFileChooser.setMultiSelectionEnabled(false);
        if (!this.chooseFile()) {
            return;
        }
        String newImageName = this.imageDB.updateImage(this.nameList.get((int)this.minSelection).nameLocal, jFileChooser.getSelectedFile());
        this.updateNamesLocals();
        this.doFilter();
        this.setSelection(newImageName);
    }

    public void actionRemove() {
        if (this.nbSelection < 1) {
            return;
        }
        boolean removed = false;
        TreeSet<String> selectedNames = new TreeSet<String>();
        for (int i = this.minSelection; i <= this.maxSelection; ++i) {
            HighlightFile highlightFile = this.nameList.get(i);
            if (!highlightFile.isSelected || !highlightFile.nameLocal.isLocal) continue;
            this.imageDB.removeImage(highlightFile.nameLocal.fileName);
            removed = true;
            selectedNames.add(highlightFile.nameLocal.fileName);
        }
        if (!removed) {
            return;
        }
        this.updateNamesLocals();
        this.doFilter();
        for (String string : selectedNames) {
            this.setSelection(string);
        }
    }

    public void actionValidate() {
        if (this.nbSelection < 1) {
            return;
        }
        TreeSet<String> imageNames = new TreeSet<String>();
        TreeSet<String> imageTagNames = new TreeSet<String>();
        for (int i = this.minSelection; i <= this.maxSelection; ++i) {
            HighlightFile name = this.nameList.get(i);
            if (!name.isSelected) continue;
            imageTagNames.add(name.nameLocal.fileName);
            if (!name.nameLocal.isLocal) continue;
            imageNames.add(name.nameLocal.fileName);
        }
        this.imageDB.promoteTag(imageTagNames);
        if (imageNames.size() == 0) {
            return;
        }
        System.err.println("coucou actionValidate:" + imageNames);
        this.imageDB.renameVisitor(imageNames);
        this.imageDB.promote(imageNames);
        this.updateNamesLocals();
        this.doFilter();
    }

    class HighlightFile
    extends JLabel {
        public int index;
        public ImageDB.NameLocal nameLocal;
        public boolean isSelected;

        public HighlightFile(ImageDB.NameLocal nameLocal) {
            super(nameLocal.icon, 0);
            this.setMinimumSize(thumbDim);
            this.setPreferredSize(thumbDim);
            this.setSize(thumbDim);
            this.nameLocal = nameLocal;
            this.setFont(nameLocal.isLocal ? JImagePopup.this.localFont : JImagePopup.this.normalFont);
            this.setBorder(emptyBorder);
            this.setOpaque(true);
            this.setBackground(standardBackground);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    JImagePopup.this.selectionPanel.requestFocusInWindow();
                    JImagePopup.this.setCursorIndex(HighlightFile.this.index);
                    if (e.isControlDown()) {
                        JImagePopup.this.beginSelection = HighlightFile.this.index;
                        JImagePopup.this.lastSelection = HighlightFile.this.index;
                        HighlightFile.this.toggleSelection();
                        return;
                    }
                    if (e.isShiftDown()) {
                        JImagePopup.this.selectRange(JImagePopup.this.beginSelection, HighlightFile.this.index);
                        return;
                    }
                    JImagePopup.this.setSelection(HighlightFile.this.index, true);
                }
            });
        }

        public void toggleSelection() {
            if (this.isSelected) {
                JImagePopup.this.removeSelection(this.index);
            } else {
                JImagePopup.this.addSelection(this.index);
            }
        }

        public void borderSelection(boolean isSelected) {
            this.setBorder(isSelected ? selectedBorder : emptyBorder);
        }

        public void setSelection(boolean isSelected) {
            this.setBackground(isSelected ? selectionBackground : standardBackground);
            this.isSelected = isSelected;
        }

        public void preview() {
            JImagePopup.this.preview.setFile(JImagePopup.this.imageDB.getFile(this.nameLocal.fileName, this.nameLocal.isLocal), JImagePopup.this.horizontalSpin);
            JImagePopup.this.previewId.setText(Util.getBase(this.nameLocal.fileName));
            JImagePopup.this.previewTags.setListData(emptyTag);
            Collection<String> tags = JImagePopup.this.imageDB.getTags(this.nameLocal.fileName);
            if (tags == null) {
                Util.packWindow(JImagePopup.this.previewTags);
                return;
            }
            JImagePopup.this.previewTags.setListData(new Vector<String>(tags));
            Util.packWindow(JImagePopup.this.previewTags);
        }

        public void checkVisible() {
            Rectangle nameBounds = this.getBounds();
            Rectangle viewBounds = JImagePopup.this.filesViewPort.getViewRect();
            if (!viewBounds.contains(nameBounds)) {
                JImagePopup.this.filesViewPort.setViewPosition(new Point(0, nameBounds.y));
            }
        }
    }
}

