/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view.jProp;

import adecWatt.model.ImageDB;
import adecWatt.view.JEditable;
import adecWatt.view.JProp;
import adecWatt.view.jProp.JImagePopup;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import misc.ScaledImage;
import misc.Util;

public abstract class JPImage
extends JProp {
    protected JLabel jImage = new JLabel();
    protected ScaledImage scaledImage;
    protected ImageDB rightDB;

    public JPImage(String propName, JEditable jEditable) {
        super(propName, jEditable);
        this.jImage.setHorizontalAlignment(0);
    }

    @Override
    protected void updateView() {
        this.setImage();
        Util.packWindow(this.jImage);
    }

    protected abstract ImageIcon getFitImage();

    protected void setImage() {
        this.scaledImage = null;
        if (this.lastValue == null) {
            this.jImage.setIcon(Util.loadActionIcon("EmptyIcon"));
            return;
        }
        if (this.lastValue == "MIX") {
            this.jImage.setIcon(Util.loadActionIcon("MixIcon"));
            return;
        }
        this.scaledImage = this.rightDB.getImage(this.lastValue, this.horizontalSpin);
        if (this.scaledImage == null) {
            this.jImage.setIcon(Util.loadActionIcon("BreakIcon"));
            return;
        }
        this.jImage.setIcon(this.getFitImage());
    }

    protected void setPopup() {
        this.jImage.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                System.err.flush();
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                new JImagePopup(JPImage.this.jImage, e.getPoint(), JPImage.this, JPImage.this.rightDB);
            }
        });
    }
}

