/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view.jProp;

import adecWatt.model.Prop;
import adecWatt.view.JEditable;
import adecWatt.view.jProp.JPLabel;
import java.text.NumberFormat;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public abstract class JPMultiValues
extends JPLabel {
    protected NumberFormat getNumberFormat() {
        return Prop.numberFormat;
    }

    public JPMultiValues(String propName, JEditable jEditable) {
        super(propName, jEditable);
    }

    @Override
    protected boolean verify(JTextComponent editor) {
        editor.setBorder(this.defaultBorder);
        String txt = editor.getText();
        if (txt.isEmpty()) {
            return true;
        }
        try {
            Float.parseFloat(txt.replace(",", "."));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            editor.setBorder(this.badValueBorder);
            return false;
        }
    }

    @Override
    protected JComponent getEditor() {
        JPanel jPanel = new JPanel();
        this.editors = new JTextField[this.nbVal];
        for (int i = 0; i < this.nbVal; ++i) {
            if (this.localizedUserMultiLabels != null && this.localizedUserMultiLabels.length > i) {
                jPanel.add(this.localizedUserMultiLabels[i].getJLabel());
            }
            final JTextField editor = new JTextField(this.lastValues == null || this.lastValues[i] == null ? "" : this.getNumberFormat().format(this.lastValues[i]), 6);
            this.editors[i] = editor;
            this.defaultBorder = editor.getBorder();
            boolean unchange = this.lastValues != null && this.lastValues[i] != null && this.lastValues[i] == Prop.DoubleMix;
            this.setUnchange(editor, unchange);
            this.setChangeListener(editor);
            this.editors[i].setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    return JPMultiValues.this.verify(editor);
                }
            });
            jPanel.add(this.editors[i]);
        }
        return jPanel;
    }

    @Override
    protected JComponent getValue() {
        if (this.lastValues == null) {
            return null;
        }
        JPanel jPanel = new JPanel();
        boolean noVal = true;
        for (int i = 0; i < this.lastValues.length; ++i) {
            if (this.localizedUserMultiLabels != null && this.localizedUserMultiLabels.length > i) {
                jPanel.add(this.localizedUserMultiLabels[i].getJLabel());
            }
            if (this.lastValues[i] == null) {
                jPanel.add(JPMultiValues.getEmptyLabel());
                continue;
            }
            noVal = false;
            jPanel.add(this.lastValues[i] == Prop.DoubleMix ? JPMultiValues.getUnknownLabel() : new JLabel(this.getNumberFormat().format(this.lastValues[i])));
        }
        return noVal ? null : jPanel;
    }

    @Override
    public String getLastValue() {
        if (this.unchanged.size() >= this.nbVal) {
            return "MIX";
        }
        String newVal = "";
        String sep = "";
        boolean noVal = true;
        for (int i = 0; i < this.nbVal; ++i) {
            newVal = newVal + sep;
            sep = "|";
            if (this.unchanged.contains(this.editors[i])) {
                newVal = newVal + "?";
                noVal = false;
                continue;
            }
            String val = this.editors[i].getText().replace(",", ".");
            if (val.isEmpty()) continue;
            try {
                double dVal = Double.parseDouble(val);
                if (this.parentValues != null && this.parentValues[i] != null && this.parentValues[i] == dVal) continue;
                newVal = newVal + this.getNumberFormat().format(dVal).replace(",", ".");
                noVal = false;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (noVal) {
            newVal = "";
        }
        return newVal;
    }
}

