/*
 * Decompiled with CFR 0.152.
 */
package adecWatt.view.jProp;

import adecWatt.model.unit.Building;
import adecWatt.view.JEditable;
import adecWatt.view.jProp.JAutoComboBox;
import adecWatt.view.jProp.JPLabel;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public class JPropBuilding
extends JPLabel
implements JAutoComboBox.Filter {
    protected ArrayList<Building> allBuidings;
    protected ArrayList<String> allBuidingsName;
    protected Vector<Building> matchBuidings;
    protected JAutoComboBox choice;

    public JPropBuilding(String propName, JEditable jEditable) {
        super(propName, jEditable);
    }

    @Override
    public Vector<String> match(String value) {
        value = value.toLowerCase();
        Vector<String> founds = new Vector<String>();
        this.matchBuidings.clear();
        if (this.allBuidings != null) {
            for (Building building : this.allBuidings) {
                if (!building.parentMatch(value)) continue;
                founds.add(building.getLocalName());
                this.matchBuidings.add(building);
            }
        }
        return founds;
    }

    @Override
    protected boolean verify(JTextComponent editor) {
        if (editor == null || this.allBuidingsName == null) {
            return false;
        }
        boolean result = this.allBuidingsName.contains(editor.getText());
        editor.setBorder(result ? this.defaultBorder : this.badValueBorder);
        return result;
    }

    @Override
    protected JComponent getValue() {
        if (this.lastValue == null) {
            return null;
        }
        if (this.lastValue == "MIX") {
            return JPropBuilding.getUnknownLabel();
        }
        try {
            return new JLabel(this.permanentDB.getUnitById(this.lastValue).getName());
        }
        catch (Exception e) {
            return JPropBuilding.getMsgLabel(this.lastValue);
        }
    }

    @Override
    protected JComponent getEditor() {
        this.allBuidings = this.permanentDB.getAllBuildings();
        int index = -1;
        if (this.allBuidings != null) {
            this.allBuidingsName = new ArrayList(this.allBuidings.size());
            for (Building building : this.allBuidings) {
                if (this.lastValue != null && building.getId().equals(this.lastValue)) {
                    index = this.allBuidingsName.size();
                }
                this.allBuidingsName.add(building.getLocalName());
            }
        } else {
            this.allBuidingsName = new ArrayList(0);
        }
        this.matchBuidings = new Vector(this.allBuidingsName.size());
        this.choice = new JAutoComboBox(this);
        JTextComponent editor = this.choice.getEditorComponent();
        this.defaultBorder = editor.getBorder();
        this.editors = new JTextComponent[]{editor};
        this.setChangeListener(editor);
        if (index >= 0) {
            this.choice.setSelectedIndex(index);
        }
        return this.choice;
    }

    @Override
    public String getLastValue() {
        String val = "";
        int index = this.choice.getSelectedIndex();
        if (index >= 0) {
            val = this.matchBuidings.get(index).getId();
        }
        if (this.unchanged.size() > 0) {
            val = "MIX";
        }
        return val;
    }
}

